/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.connector.CatalogHandle;
import io.trino.execution.RemoteTask;
import io.trino.execution.scheduler.BucketNodeMap;
import io.trino.execution.scheduler.NodeSelector;
import io.trino.execution.scheduler.NodeSelectorFactory;
import io.trino.execution.scheduler.SplitPlacementResult;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Split;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class TestingNodeSelectorFactory
implements NodeSelectorFactory {
    private final InternalNode currentNode;
    private final Supplier<Map<InternalNode, List<CatalogHandle>>> nodesSupplier;

    public TestingNodeSelectorFactory(InternalNode currentNode, Supplier<Map<InternalNode, List<CatalogHandle>>> nodesSupplier) {
        this.currentNode = Objects.requireNonNull(currentNode, "currentNode is null");
        this.nodesSupplier = Objects.requireNonNull(nodesSupplier, "nodesSupplier is null");
    }

    public NodeSelector createNodeSelector(Session session, Optional<CatalogHandle> catalogName) {
        return new TestingNodeSelector(this.currentNode, TestingNodeSelectorFactory.createNodesSupplierForCatalog(catalogName, this.nodesSupplier));
    }

    private static Supplier<List<InternalNode>> createNodesSupplierForCatalog(Optional<CatalogHandle> catalogNameOptional, Supplier<Map<InternalNode, List<CatalogHandle>>> nodesSupplier) {
        return () -> {
            Map allNodes = (Map)nodesSupplier.get();
            if (catalogNameOptional.isEmpty()) {
                return ImmutableList.copyOf(allNodes.keySet());
            }
            CatalogHandle catalogHandle = (CatalogHandle)catalogNameOptional.get();
            return (List)allNodes.entrySet().stream().filter(entry -> ((List)entry.getValue()).contains(catalogHandle)).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
        };
    }

    private static class TestingNodeSelector
    implements NodeSelector {
        private final InternalNode currentNode;
        private final Supplier<List<InternalNode>> nodesSupplier;

        private TestingNodeSelector(InternalNode currentNode, Supplier<List<InternalNode>> nodesSupplier) {
            this.currentNode = Objects.requireNonNull(currentNode, "currentNode is null");
            this.nodesSupplier = Objects.requireNonNull(nodesSupplier, "nodesSupplier is null");
        }

        public void lockDownNodes() {
            throw new UnsupportedOperationException();
        }

        public List<InternalNode> allNodes() {
            return ImmutableList.copyOf((Collection)this.nodesSupplier.get());
        }

        public InternalNode selectCurrentNode() {
            return this.currentNode;
        }

        public List<InternalNode> selectRandomNodes(int limit, Set<InternalNode> excludedNodes) {
            return (List)this.allNodes().stream().filter(node -> !excludedNodes.contains(node)).limit(limit).collect(ImmutableList.toImmutableList());
        }

        public SplitPlacementResult computeAssignments(Set<Split> splits, List<RemoteTask> existingTasks) {
            throw new UnsupportedOperationException();
        }

        public SplitPlacementResult computeAssignments(Set<Split> splits, List<RemoteTask> existingTasks, BucketNodeMap bucketNodeMap) {
            throw new UnsupportedOperationException();
        }
    }

    public static class TestingNodeSupplier
    implements Supplier<Map<InternalNode, List<CatalogHandle>>> {
        private final Map<InternalNode, List<CatalogHandle>> nodes = new ConcurrentHashMap<InternalNode, List<CatalogHandle>>();

        public static TestingNodeSupplier create() {
            return new TestingNodeSupplier();
        }

        public static TestingNodeSupplier create(Map<InternalNode, List<CatalogHandle>> nodes) {
            TestingNodeSupplier testingNodeSupplier = new TestingNodeSupplier();
            nodes.forEach(testingNodeSupplier::addNode);
            return testingNodeSupplier;
        }

        private TestingNodeSupplier() {
        }

        public void addNode(InternalNode node, List<CatalogHandle> catalogs) {
            this.nodes.put(node, catalogs);
        }

        public void removeNode(InternalNode node) {
            this.nodes.remove(node);
        }

        @Override
        public Map<InternalNode, List<CatalogHandle>> get() {
            return this.nodes;
        }
    }
}

