/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.execution.TaskId;
import io.trino.execution.TaskInfo;
import io.trino.execution.TaskState;
import io.trino.execution.TaskStatus;
import io.trino.execution.buffer.BufferState;
import io.trino.execution.buffer.OutputBufferInfo;
import io.trino.memory.KillTarget;
import io.trino.memory.LeastWastedEffortTaskLowMemoryKiller;
import io.trino.memory.LowMemoryKiller;
import io.trino.memory.LowMemoryKillerTestingUtils;
import io.trino.operator.TaskStats;
import io.trino.testing.assertions.Assert;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.testng.annotations.Test;

public class TestLeastWastedEffortTaskLowMemoryKiller {
    private final LowMemoryKiller lowMemoryKiller = new LeastWastedEffortTaskLowMemoryKiller();

    @Test
    public void testMemoryPoolHasNoReservation() {
        int memoryPool = 12;
        ImmutableMap queries = ImmutableMap.builder().put((Object)"q_1", (Object)ImmutableMap.of((Object)"n1", (Object)0L, (Object)"n2", (Object)0L, (Object)"n3", (Object)0L, (Object)"n4", (Object)0L, (Object)"n5", (Object)0L)).buildOrThrow();
        Assert.assertEquals((Object)this.lowMemoryKiller.chooseTargetToKill(LowMemoryKillerTestingUtils.toRunningQueryInfoList((Map<String, Map<String, Long>>)queries), LowMemoryKillerTestingUtils.toNodeMemoryInfoList(memoryPool, (Map<String, Map<String, Long>>)queries)), Optional.empty());
    }

    @Test
    public void testMemoryPoolNotBlocked() {
        int memoryPool = 12;
        ImmutableMap queries = ImmutableMap.builder().put((Object)"q_1", (Object)ImmutableMap.of((Object)"n1", (Object)0L, (Object)"n2", (Object)6L, (Object)"n3", (Object)0L, (Object)"n4", (Object)0L, (Object)"n5", (Object)0L)).put((Object)"q_2", (Object)ImmutableMap.of((Object)"n1", (Object)3L, (Object)"n2", (Object)5L, (Object)"n3", (Object)2L, (Object)"n4", (Object)4L, (Object)"n5", (Object)0L)).buildOrThrow();
        Assert.assertEquals((Object)this.lowMemoryKiller.chooseTargetToKill(LowMemoryKillerTestingUtils.toRunningQueryInfoList((Map<String, Map<String, Long>>)queries), LowMemoryKillerTestingUtils.toNodeMemoryInfoList(memoryPool, (Map<String, Map<String, Long>>)queries)), Optional.empty());
    }

    @Test
    public void testWillNotKillTaskForQueryWithoutTaskRetriesEnabled() {
        int memoryPool = 5;
        ImmutableMap queries = ImmutableMap.builder().put((Object)"q_1", (Object)ImmutableMap.of((Object)"n1", (Object)0L, (Object)"n2", (Object)0L, (Object)"n3", (Object)2L)).put((Object)"q_2", (Object)ImmutableMap.of((Object)"n1", (Object)3L, (Object)"n2", (Object)5L, (Object)"n3", (Object)2L)).buildOrThrow();
        ImmutableMap tasks = ImmutableMap.builder().put((Object)"q_1", (Object)ImmutableMap.of((Object)"n3", (Object)ImmutableMap.of((Object)1, (Object)5L))).put((Object)"q_2", (Object)ImmutableMap.of((Object)"n1", (Object)ImmutableMap.of((Object)1, (Object)1L, (Object)2, (Object)2L), (Object)"n2", (Object)ImmutableMap.of((Object)3, (Object)3L, (Object)4, (Object)1L, (Object)5, (Object)1L), (Object)"n3", (Object)ImmutableMap.of((Object)6, (Object)2L))).buildOrThrow();
        Assert.assertEquals((Object)this.lowMemoryKiller.chooseTargetToKill(LowMemoryKillerTestingUtils.toRunningQueryInfoList((Map<String, Map<String, Long>>)queries), LowMemoryKillerTestingUtils.toNodeMemoryInfoList(memoryPool, (Map<String, Map<String, Long>>)queries, (Map<String, Map<String, Map<Integer, Long>>>)tasks)), Optional.empty());
    }

    @Test
    public void testKillsBiggestTasksIfAllExecuteSameTime() {
        this.testKillsBiggestTasksIfAllExecuteSameTime(new Duration(0.0, TimeUnit.SECONDS), new Duration(0.0, TimeUnit.SECONDS));
        this.testKillsBiggestTasksIfAllExecuteSameTime(new Duration(1.0, TimeUnit.SECONDS), new Duration(1.0, TimeUnit.SECONDS));
        this.testKillsBiggestTasksIfAllExecuteSameTime(new Duration(1000.0, TimeUnit.SECONDS), new Duration(1000.0, TimeUnit.SECONDS));
    }

    private void testKillsBiggestTasksIfAllExecuteSameTime(Duration scheduledTime, Duration blockedTime) {
        int memoryPool = 12;
        ImmutableMap queries = ImmutableMap.builder().put((Object)"q_1", (Object)ImmutableMap.of((Object)"n1", (Object)0L, (Object)"n2", (Object)8L, (Object)"n3", (Object)0L, (Object)"n4", (Object)0L, (Object)"n5", (Object)0L)).put((Object)"q_2", (Object)ImmutableMap.of((Object)"n1", (Object)3L, (Object)"n2", (Object)5L, (Object)"n3", (Object)2L, (Object)"n4", (Object)4L, (Object)"n5", (Object)0L)).put((Object)"q_3", (Object)ImmutableMap.of((Object)"n1", (Object)0L, (Object)"n2", (Object)0L, (Object)"n3", (Object)11L, (Object)"n4", (Object)0L, (Object)"n5", (Object)0L)).buildOrThrow();
        ImmutableMap tasks = ImmutableMap.builder().put((Object)"q_1", (Object)ImmutableMap.of((Object)"n2", (Object)ImmutableMap.of((Object)1, (Object)8L))).put((Object)"q_2", (Object)ImmutableMap.of((Object)"n1", (Object)ImmutableMap.of((Object)1, (Object)1L, (Object)2, (Object)3L), (Object)"n2", (Object)ImmutableMap.of((Object)3, (Object)3L, (Object)4, (Object)1L, (Object)5, (Object)1L), (Object)"n3", (Object)ImmutableMap.of((Object)6, (Object)2L), (Object)"n4", (Object)ImmutableMap.of((Object)7, (Object)2L, (Object)8, (Object)2L), (Object)"n5", (Object)ImmutableMap.of())).put((Object)"q_3", (Object)ImmutableMap.of((Object)"n3", (Object)ImmutableMap.of((Object)1, (Object)11L))).buildOrThrow();
        ImmutableMap taskInfos = scheduledTime.toMillis() == 0L && blockedTime.toMillis() == 0L ? ImmutableMap.of() : ImmutableMap.of((Object)"q_1", (Object)ImmutableMap.of((Object)1, (Object)TestLeastWastedEffortTaskLowMemoryKiller.buildTaskInfo(LowMemoryKillerTestingUtils.taskId("q_1", 1), TaskState.RUNNING, scheduledTime, blockedTime)), (Object)"q_2", (Object)ImmutableMap.of((Object)1, (Object)TestLeastWastedEffortTaskLowMemoryKiller.buildTaskInfo(LowMemoryKillerTestingUtils.taskId("q_2", 1), TaskState.RUNNING, scheduledTime, blockedTime), (Object)2, (Object)TestLeastWastedEffortTaskLowMemoryKiller.buildTaskInfo(LowMemoryKillerTestingUtils.taskId("q_2", 2), TaskState.RUNNING, scheduledTime, blockedTime), (Object)3, (Object)TestLeastWastedEffortTaskLowMemoryKiller.buildTaskInfo(LowMemoryKillerTestingUtils.taskId("q_2", 3), TaskState.RUNNING, scheduledTime, blockedTime), (Object)4, (Object)TestLeastWastedEffortTaskLowMemoryKiller.buildTaskInfo(LowMemoryKillerTestingUtils.taskId("q_2", 4), TaskState.RUNNING, scheduledTime, blockedTime), (Object)5, (Object)TestLeastWastedEffortTaskLowMemoryKiller.buildTaskInfo(LowMemoryKillerTestingUtils.taskId("q_2", 5), TaskState.RUNNING, scheduledTime, blockedTime), (Object)6, (Object)TestLeastWastedEffortTaskLowMemoryKiller.buildTaskInfo(LowMemoryKillerTestingUtils.taskId("q_2", 6), TaskState.RUNNING, scheduledTime, blockedTime), (Object)7, (Object)TestLeastWastedEffortTaskLowMemoryKiller.buildTaskInfo(LowMemoryKillerTestingUtils.taskId("q_2", 7), TaskState.RUNNING, scheduledTime, blockedTime), (Object)8, (Object)TestLeastWastedEffortTaskLowMemoryKiller.buildTaskInfo(LowMemoryKillerTestingUtils.taskId("q_2", 8), TaskState.RUNNING, scheduledTime, blockedTime)));
        Assert.assertEquals((Object)this.lowMemoryKiller.chooseTargetToKill(LowMemoryKillerTestingUtils.toRunningQueryInfoList((Map<String, Map<String, Long>>)queries, (Set<String>)ImmutableSet.of((Object)"q_1", (Object)"q_2"), (Map<String, Map<Integer, TaskInfo>>)taskInfos), LowMemoryKillerTestingUtils.toNodeMemoryInfoList(memoryPool, (Map<String, Map<String, Long>>)queries, (Map<String, Map<String, Map<Integer, Long>>>)tasks)), Optional.of(KillTarget.selectedTasks((Set)ImmutableSet.of((Object)LowMemoryKillerTestingUtils.taskId("q_1", 1), (Object)LowMemoryKillerTestingUtils.taskId("q_2", 6)))));
    }

    @Test
    public void testKillsSmallerTaskIfWastedEffortRatioIsBetter() {
        int memoryPool = 8;
        ImmutableMap queries = ImmutableMap.builder().put((Object)"q_1", (Object)ImmutableMap.of((Object)"n1", (Object)3L, (Object)"n2", (Object)8L)).put((Object)"q_2", (Object)ImmutableMap.of((Object)"n1", (Object)7L, (Object)"n2", (Object)2L)).buildOrThrow();
        ImmutableMap tasks = ImmutableMap.builder().put((Object)"q_1", (Object)ImmutableMap.of((Object)"n1", (Object)ImmutableMap.of((Object)1, (Object)3L), (Object)"n2", (Object)ImmutableMap.of((Object)2, (Object)8L))).put((Object)"q_2", (Object)ImmutableMap.of((Object)"n1", (Object)ImmutableMap.of((Object)1, (Object)1L, (Object)2, (Object)6L), (Object)"n2", (Object)ImmutableMap.of((Object)3, (Object)2L))).buildOrThrow();
        ImmutableMap taskInfos = ImmutableMap.of((Object)"q_1", (Object)ImmutableMap.of((Object)1, (Object)TestLeastWastedEffortTaskLowMemoryKiller.buildTaskInfo(LowMemoryKillerTestingUtils.taskId("q_1", 1), TaskState.RUNNING, new Duration(30.0, TimeUnit.SECONDS), new Duration(30.0, TimeUnit.SECONDS)), (Object)2, (Object)TestLeastWastedEffortTaskLowMemoryKiller.buildTaskInfo(LowMemoryKillerTestingUtils.taskId("q_1", 2), TaskState.RUNNING, new Duration(400.0, TimeUnit.SECONDS), new Duration(200.0, TimeUnit.SECONDS))), (Object)"q_2", (Object)ImmutableMap.of((Object)1, (Object)TestLeastWastedEffortTaskLowMemoryKiller.buildTaskInfo(LowMemoryKillerTestingUtils.taskId("q_2", 1), TaskState.RUNNING, new Duration(30.0, TimeUnit.SECONDS), new Duration(30.0, TimeUnit.SECONDS)), (Object)2, (Object)TestLeastWastedEffortTaskLowMemoryKiller.buildTaskInfo(LowMemoryKillerTestingUtils.taskId("q_2", 2), TaskState.RUNNING, new Duration(100.0, TimeUnit.SECONDS), new Duration(100.0, TimeUnit.SECONDS)), (Object)3, (Object)TestLeastWastedEffortTaskLowMemoryKiller.buildTaskInfo(LowMemoryKillerTestingUtils.taskId("q_2", 3), TaskState.RUNNING, new Duration(30.0, TimeUnit.SECONDS), new Duration(30.0, TimeUnit.SECONDS))));
        Assert.assertEquals((Object)this.lowMemoryKiller.chooseTargetToKill(LowMemoryKillerTestingUtils.toRunningQueryInfoList((Map<String, Map<String, Long>>)queries, (Set<String>)ImmutableSet.of((Object)"q_1", (Object)"q_2"), (Map<String, Map<Integer, TaskInfo>>)taskInfos), LowMemoryKillerTestingUtils.toNodeMemoryInfoList(memoryPool, (Map<String, Map<String, Long>>)queries, (Map<String, Map<String, Map<Integer, Long>>>)tasks)), Optional.of(KillTarget.selectedTasks((Set)ImmutableSet.of((Object)LowMemoryKillerTestingUtils.taskId("q_1", 1), (Object)LowMemoryKillerTestingUtils.taskId("q_2", 3)))));
    }

    private static TaskInfo buildTaskInfo(TaskId taskId, TaskState state, Duration scheduledTime, Duration blockedTime) {
        return new TaskInfo(new TaskStatus(taskId, "task-instance-id", 0L, state, URI.create("fake://task/" + taskId + "/node/some_node"), "some_node", (List)ImmutableList.of(), 0, 0, false, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), DataSize.of((long)0L, (DataSize.Unit)DataSize.Unit.MEGABYTE), 0L, Duration.valueOf((String)"0s"), 0L, 1L, 1L), DateTime.now(), new OutputBufferInfo("TESTING", BufferState.FINISHED, false, false, 0L, 0L, 0L, 0L, (List)ImmutableList.of()), (Set)ImmutableSet.of(), new TaskStats(DateTime.now(), null, null, null, null, new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), 0, 0, 0, 0L, 0, 0, 0L, 0, 0, 0.0, DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), scheduledTime, new Duration(0.0, TimeUnit.MILLISECONDS), blockedTime, false, (Set)ImmutableSet.of(), DataSize.ofBytes((long)0L), 0L, new Duration(0.0, TimeUnit.MILLISECONDS), DataSize.ofBytes((long)0L), 0L, DataSize.ofBytes((long)0L), 0L, DataSize.ofBytes((long)0L), 0L, new Duration(0.0, TimeUnit.MILLISECONDS), DataSize.ofBytes((long)0L), 0L, new Duration(0.0, TimeUnit.MILLISECONDS), DataSize.ofBytes((long)0L), 0, new Duration(0.0, TimeUnit.MILLISECONDS), (List)ImmutableList.of()), Optional.empty(), false);
    }
}

