/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.memory.KillTarget;
import io.trino.memory.LowMemoryKiller;
import io.trino.memory.LowMemoryKillerTestingUtils;
import io.trino.memory.TotalReservationOnBlockedNodesTaskLowMemoryKiller;
import io.trino.testing.assertions.Assert;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.annotations.Test;

public class TestTotalReservationOnBlockedNodesTaskLowMemoryKiller {
    private final LowMemoryKiller lowMemoryKiller = new TotalReservationOnBlockedNodesTaskLowMemoryKiller();

    @Test
    public void testMemoryPoolHasNoReservation() {
        int memoryPool = 12;
        ImmutableMap queries = ImmutableMap.builder().put((Object)"q_1", (Object)ImmutableMap.of((Object)"n1", (Object)0L, (Object)"n2", (Object)0L, (Object)"n3", (Object)0L, (Object)"n4", (Object)0L, (Object)"n5", (Object)0L)).buildOrThrow();
        Assert.assertEquals((Object)this.lowMemoryKiller.chooseTargetToKill(LowMemoryKillerTestingUtils.toRunningQueryInfoList((Map<String, Map<String, Long>>)queries), LowMemoryKillerTestingUtils.toNodeMemoryInfoList(memoryPool, (Map<String, Map<String, Long>>)queries)), Optional.empty());
    }

    @Test
    public void testMemoryPoolNotBlocked() {
        int memoryPool = 12;
        ImmutableMap queries = ImmutableMap.builder().put((Object)"q_1", (Object)ImmutableMap.of((Object)"n1", (Object)0L, (Object)"n2", (Object)6L, (Object)"n3", (Object)0L, (Object)"n4", (Object)0L, (Object)"n5", (Object)0L)).put((Object)"q_2", (Object)ImmutableMap.of((Object)"n1", (Object)3L, (Object)"n2", (Object)5L, (Object)"n3", (Object)2L, (Object)"n4", (Object)4L, (Object)"n5", (Object)0L)).buildOrThrow();
        Assert.assertEquals((Object)this.lowMemoryKiller.chooseTargetToKill(LowMemoryKillerTestingUtils.toRunningQueryInfoList((Map<String, Map<String, Long>>)queries), LowMemoryKillerTestingUtils.toNodeMemoryInfoList(memoryPool, (Map<String, Map<String, Long>>)queries)), Optional.empty());
    }

    @Test
    public void testWillNotKillTaskForQueryWithoutTaskRetriesEnabled() {
        int memoryPool = 5;
        ImmutableMap queries = ImmutableMap.builder().put((Object)"q_1", (Object)ImmutableMap.of((Object)"n1", (Object)0L, (Object)"n2", (Object)0L, (Object)"n3", (Object)2L)).put((Object)"q_2", (Object)ImmutableMap.of((Object)"n1", (Object)3L, (Object)"n2", (Object)5L, (Object)"n3", (Object)2L)).buildOrThrow();
        ImmutableMap tasks = ImmutableMap.builder().put((Object)"q_1", (Object)ImmutableMap.of((Object)"n3", (Object)ImmutableMap.of((Object)1, (Object)5L))).put((Object)"q_2", (Object)ImmutableMap.of((Object)"n1", (Object)ImmutableMap.of((Object)1, (Object)1L, (Object)2, (Object)2L), (Object)"n2", (Object)ImmutableMap.of((Object)3, (Object)3L, (Object)4, (Object)1L, (Object)5, (Object)1L), (Object)"n3", (Object)ImmutableMap.of((Object)6, (Object)2L))).buildOrThrow();
        Assert.assertEquals((Object)this.lowMemoryKiller.chooseTargetToKill(LowMemoryKillerTestingUtils.toRunningQueryInfoList((Map<String, Map<String, Long>>)queries), LowMemoryKillerTestingUtils.toNodeMemoryInfoList(memoryPool, (Map<String, Map<String, Long>>)queries, (Map<String, Map<String, Map<Integer, Long>>>)tasks)), Optional.empty());
    }

    @Test
    public void testPreferKillingTasks() {
        int memoryPool = 12;
        ImmutableMap queries = ImmutableMap.builder().put((Object)"q_1", (Object)ImmutableMap.of((Object)"n1", (Object)0L, (Object)"n2", (Object)8L, (Object)"n3", (Object)0L, (Object)"n4", (Object)0L, (Object)"n5", (Object)0L)).put((Object)"q_2", (Object)ImmutableMap.of((Object)"n1", (Object)3L, (Object)"n2", (Object)5L, (Object)"n3", (Object)2L, (Object)"n4", (Object)4L, (Object)"n5", (Object)0L)).put((Object)"q_3", (Object)ImmutableMap.of((Object)"n1", (Object)0L, (Object)"n2", (Object)0L, (Object)"n3", (Object)11L, (Object)"n4", (Object)0L, (Object)"n5", (Object)0L)).buildOrThrow();
        ImmutableMap tasks = ImmutableMap.builder().put((Object)"q_2", (Object)ImmutableMap.of((Object)"n1", (Object)ImmutableMap.of((Object)1, (Object)1L, (Object)2, (Object)3L), (Object)"n2", (Object)ImmutableMap.of((Object)3, (Object)3L, (Object)4, (Object)1L, (Object)5, (Object)1L), (Object)"n3", (Object)ImmutableMap.of((Object)6, (Object)2L), (Object)"n4", (Object)ImmutableMap.of((Object)7, (Object)2L, (Object)8, (Object)2L), (Object)"n5", (Object)ImmutableMap.of())).buildOrThrow();
        Assert.assertEquals((Object)this.lowMemoryKiller.chooseTargetToKill(LowMemoryKillerTestingUtils.toRunningQueryInfoList((Map<String, Map<String, Long>>)queries, (Set<String>)ImmutableSet.of((Object)"q_2")), LowMemoryKillerTestingUtils.toNodeMemoryInfoList(memoryPool, (Map<String, Map<String, Long>>)queries, (Map<String, Map<String, Map<Integer, Long>>>)tasks)), Optional.of(KillTarget.selectedTasks((Set)ImmutableSet.of((Object)LowMemoryKillerTestingUtils.taskId("q_2", 3), (Object)LowMemoryKillerTestingUtils.taskId("q_2", 6)))));
    }

    @Test
    public void testKillsBiggestTasks() {
        int memoryPool = 12;
        ImmutableMap queries = ImmutableMap.builder().put((Object)"q_1", (Object)ImmutableMap.of((Object)"n1", (Object)0L, (Object)"n2", (Object)8L, (Object)"n3", (Object)0L, (Object)"n4", (Object)0L, (Object)"n5", (Object)0L)).put((Object)"q_2", (Object)ImmutableMap.of((Object)"n1", (Object)3L, (Object)"n2", (Object)5L, (Object)"n3", (Object)2L, (Object)"n4", (Object)4L, (Object)"n5", (Object)0L)).put((Object)"q_3", (Object)ImmutableMap.of((Object)"n1", (Object)0L, (Object)"n2", (Object)0L, (Object)"n3", (Object)11L, (Object)"n4", (Object)0L, (Object)"n5", (Object)0L)).buildOrThrow();
        ImmutableMap tasks = ImmutableMap.builder().put((Object)"q_1", (Object)ImmutableMap.of((Object)"n2", (Object)ImmutableMap.of((Object)1, (Object)8L))).put((Object)"q_2", (Object)ImmutableMap.of((Object)"n1", (Object)ImmutableMap.of((Object)1, (Object)1L, (Object)2, (Object)3L), (Object)"n2", (Object)ImmutableMap.of((Object)3, (Object)3L, (Object)4, (Object)1L, (Object)5, (Object)1L), (Object)"n3", (Object)ImmutableMap.of((Object)6, (Object)2L), (Object)"n4", (Object)ImmutableMap.of((Object)7, (Object)2L, (Object)8, (Object)2L), (Object)"n5", (Object)ImmutableMap.of())).put((Object)"q_3", (Object)ImmutableMap.of((Object)"n3", (Object)ImmutableMap.of((Object)1, (Object)11L))).buildOrThrow();
        Assert.assertEquals((Object)this.lowMemoryKiller.chooseTargetToKill(LowMemoryKillerTestingUtils.toRunningQueryInfoList((Map<String, Map<String, Long>>)queries, (Set<String>)ImmutableSet.of((Object)"q_1", (Object)"q_2")), LowMemoryKillerTestingUtils.toNodeMemoryInfoList(memoryPool, (Map<String, Map<String, Long>>)queries, (Map<String, Map<String, Map<Integer, Long>>>)tasks)), Optional.of(KillTarget.selectedTasks((Set)ImmutableSet.of((Object)LowMemoryKillerTestingUtils.taskId("q_1", 1), (Object)LowMemoryKillerTestingUtils.taskId("q_2", 6)))));
    }
}

