/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.Slice;
import io.trino.Session;
import io.trino.connector.CatalogHandle;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.AnalyzeMetadata;
import io.trino.metadata.AnalyzeTableHandle;
import io.trino.metadata.CatalogInfo;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.InsertTableHandle;
import io.trino.metadata.MaterializedViewDefinition;
import io.trino.metadata.MergeHandle;
import io.trino.metadata.Metadata;
import io.trino.metadata.OperatorNotFoundException;
import io.trino.metadata.OutputTableHandle;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.ResolvedIndex;
import io.trino.metadata.TableExecuteHandle;
import io.trino.metadata.TableFunctionHandle;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableLayout;
import io.trino.metadata.TableMetadata;
import io.trino.metadata.TableProperties;
import io.trino.metadata.TableSchema;
import io.trino.metadata.TableVersion;
import io.trino.metadata.ViewDefinition;
import io.trino.metadata.ViewInfo;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.AggregationApplicationResult;
import io.trino.spi.connector.BeginTableExecuteResult;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.JoinApplicationResult;
import io.trino.spi.connector.JoinCondition;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.LimitApplicationResult;
import io.trino.spi.connector.MaterializedViewFreshness;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.RowChangeParadigm;
import io.trino.spi.connector.SampleApplicationResult;
import io.trino.spi.connector.SampleType;
import io.trino.spi.connector.SortItem;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableColumnsMetadata;
import io.trino.spi.connector.TableFunctionApplicationResult;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.connector.TopNApplicationResult;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.function.OperatorType;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.GrantInfo;
import io.trino.spi.security.Identity;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.statistics.TableStatisticsMetadata;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.tree.QualifiedName;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;

public class CountingAccessMetadata
implements Metadata {
    private final Metadata delegate;
    private final ConcurrentHashMultiset<Methods> methodInvocations = ConcurrentHashMultiset.create();

    public CountingAccessMetadata(Metadata delegate) {
        this.delegate = delegate;
    }

    public Multiset<Methods> getMethodInvocations() {
        return ImmutableMultiset.copyOf(this.methodInvocations);
    }

    public void resetCounters() {
        this.methodInvocations.clear();
    }

    public Set<ConnectorCapabilities> getConnectorCapabilities(Session session, CatalogHandle catalogHandle) {
        return this.delegate.getConnectorCapabilities(session, catalogHandle);
    }

    public boolean catalogExists(Session session, String catalogName) {
        return this.delegate.catalogExists(session, catalogName);
    }

    public boolean schemaExists(Session session, CatalogSchemaName schema) {
        return this.delegate.schemaExists(session, schema);
    }

    public List<String> listSchemaNames(Session session, String catalogName) {
        return this.delegate.listSchemaNames(session, catalogName);
    }

    public Optional<TableHandle> getTableHandle(Session session, QualifiedObjectName tableName) {
        return this.delegate.getTableHandle(session, tableName);
    }

    public Optional<SystemTable> getSystemTable(Session session, QualifiedObjectName tableName) {
        return this.delegate.getSystemTable(session, tableName);
    }

    public Optional<TableExecuteHandle> getTableHandleForExecute(Session session, TableHandle tableHandle, String procedureName, Map<String, Object> executeProperties) {
        return this.delegate.getTableHandleForExecute(session, tableHandle, procedureName, executeProperties);
    }

    public Optional<TableLayout> getLayoutForTableExecute(Session session, TableExecuteHandle tableExecuteHandle) {
        return this.delegate.getLayoutForTableExecute(session, tableExecuteHandle);
    }

    public BeginTableExecuteResult<TableExecuteHandle, TableHandle> beginTableExecute(Session session, TableExecuteHandle handle, TableHandle updatedSourceTableHandle) {
        return this.delegate.beginTableExecute(session, handle, updatedSourceTableHandle);
    }

    public void finishTableExecute(Session session, TableExecuteHandle handle, Collection<Slice> fragments, List<Object> tableExecuteState) {
        this.delegate.finishTableExecute(session, handle, fragments, tableExecuteState);
    }

    public void executeTableExecute(Session session, TableExecuteHandle handle) {
        this.delegate.executeTableExecute(session, handle);
    }

    public TableProperties getTableProperties(Session session, TableHandle handle) {
        return this.delegate.getTableProperties(session, handle);
    }

    public TableHandle makeCompatiblePartitioning(Session session, TableHandle table, PartitioningHandle partitioningHandle) {
        return this.delegate.makeCompatiblePartitioning(session, table, partitioningHandle);
    }

    public Optional<PartitioningHandle> getCommonPartitioning(Session session, PartitioningHandle left, PartitioningHandle right) {
        return this.delegate.getCommonPartitioning(session, left, right);
    }

    public Optional<Object> getInfo(Session session, TableHandle handle) {
        return this.delegate.getInfo(session, handle);
    }

    public TableSchema getTableSchema(Session session, TableHandle tableHandle) {
        return this.delegate.getTableSchema(session, tableHandle);
    }

    public TableMetadata getTableMetadata(Session session, TableHandle tableHandle) {
        return this.delegate.getTableMetadata(session, tableHandle);
    }

    public TableStatistics getTableStatistics(Session session, TableHandle tableHandle) {
        this.methodInvocations.add((Object)Methods.GET_TABLE_STATISTICS);
        return this.delegate.getTableStatistics(session, tableHandle);
    }

    public List<QualifiedObjectName> listTables(Session session, QualifiedTablePrefix prefix) {
        return this.delegate.listTables(session, prefix);
    }

    public Map<String, ColumnHandle> getColumnHandles(Session session, TableHandle tableHandle) {
        return this.delegate.getColumnHandles(session, tableHandle);
    }

    public ColumnMetadata getColumnMetadata(Session session, TableHandle tableHandle, ColumnHandle columnHandle) {
        return this.delegate.getColumnMetadata(session, tableHandle, columnHandle);
    }

    public List<TableColumnsMetadata> listTableColumns(Session session, QualifiedTablePrefix prefix) {
        return this.delegate.listTableColumns(session, prefix);
    }

    public void createSchema(Session session, CatalogSchemaName schema, Map<String, Object> properties, TrinoPrincipal principal) {
        this.delegate.createSchema(session, schema, properties, principal);
    }

    public void dropSchema(Session session, CatalogSchemaName schema) {
        this.delegate.dropSchema(session, schema);
    }

    public void renameSchema(Session session, CatalogSchemaName source, String target) {
        this.delegate.renameSchema(session, source, target);
    }

    public void setSchemaAuthorization(Session session, CatalogSchemaName source, TrinoPrincipal principal) {
        this.delegate.setSchemaAuthorization(session, source, principal);
    }

    public void createTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        this.delegate.createTable(session, catalogName, tableMetadata, ignoreExisting);
    }

    public void renameTable(Session session, TableHandle tableHandle, QualifiedObjectName newTableName) {
        this.delegate.renameTable(session, tableHandle, newTableName);
    }

    public void setTableProperties(Session session, TableHandle tableHandle, Map<String, Optional<Object>> properties) {
        this.delegate.setTableProperties(session, tableHandle, properties);
    }

    public void setTableComment(Session session, TableHandle tableHandle, Optional<String> comment) {
        this.delegate.setTableComment(session, tableHandle, comment);
    }

    public void setViewComment(Session session, QualifiedObjectName viewName, Optional<String> comment) {
        this.delegate.setViewComment(session, viewName, comment);
    }

    public void setColumnComment(Session session, TableHandle tableHandle, ColumnHandle column, Optional<String> comment) {
        this.delegate.setColumnComment(session, tableHandle, column, comment);
    }

    public void renameColumn(Session session, TableHandle tableHandle, ColumnHandle source, String target) {
        this.delegate.renameColumn(session, tableHandle, source, target);
    }

    public void addColumn(Session session, TableHandle tableHandle, ColumnMetadata column) {
        this.delegate.addColumn(session, tableHandle, column);
    }

    public void setTableAuthorization(Session session, CatalogSchemaTableName table, TrinoPrincipal principal) {
        this.delegate.setTableAuthorization(session, table, principal);
    }

    public void dropColumn(Session session, TableHandle tableHandle, ColumnHandle column) {
        this.delegate.dropColumn(session, tableHandle, column);
    }

    public void dropTable(Session session, TableHandle tableHandle) {
        this.delegate.dropTable(session, tableHandle);
    }

    public void truncateTable(Session session, TableHandle tableHandle) {
        this.delegate.truncateTable(session, tableHandle);
    }

    public Optional<TableLayout> getNewTableLayout(Session session, String catalogName, ConnectorTableMetadata tableMetadata) {
        return this.delegate.getNewTableLayout(session, catalogName, tableMetadata);
    }

    public OutputTableHandle beginCreateTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata, Optional<TableLayout> layout) {
        return this.delegate.beginCreateTable(session, catalogName, tableMetadata, layout);
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(Session session, OutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return this.delegate.finishCreateTable(session, tableHandle, fragments, computedStatistics);
    }

    public Optional<TableLayout> getInsertLayout(Session session, TableHandle target) {
        return this.delegate.getInsertLayout(session, target);
    }

    public TableStatisticsMetadata getStatisticsCollectionMetadataForWrite(Session session, CatalogHandle catalogHandle, ConnectorTableMetadata tableMetadata) {
        return this.delegate.getStatisticsCollectionMetadataForWrite(session, catalogHandle, tableMetadata);
    }

    public AnalyzeMetadata getStatisticsCollectionMetadata(Session session, TableHandle tableHandle, Map<String, Object> analyzeProperties) {
        return this.delegate.getStatisticsCollectionMetadata(session, tableHandle, analyzeProperties);
    }

    public AnalyzeTableHandle beginStatisticsCollection(Session session, TableHandle tableHandle) {
        return this.delegate.beginStatisticsCollection(session, tableHandle);
    }

    public void finishStatisticsCollection(Session session, AnalyzeTableHandle tableHandle, Collection<ComputedStatistics> computedStatistics) {
        this.delegate.finishStatisticsCollection(session, tableHandle, computedStatistics);
    }

    public void cleanupQuery(Session session) {
        this.delegate.cleanupQuery(session);
    }

    public InsertTableHandle beginInsert(Session session, TableHandle tableHandle, List<ColumnHandle> columns) {
        return this.delegate.beginInsert(session, tableHandle, columns);
    }

    public boolean supportsMissingColumnsOnInsert(Session session, TableHandle tableHandle) {
        return this.delegate.supportsMissingColumnsOnInsert(session, tableHandle);
    }

    public Optional<ConnectorOutputMetadata> finishInsert(Session session, InsertTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return this.delegate.finishInsert(session, tableHandle, fragments, computedStatistics);
    }

    public boolean delegateMaterializedViewRefreshToConnector(Session session, QualifiedObjectName viewName) {
        return this.delegate.delegateMaterializedViewRefreshToConnector(session, viewName);
    }

    public ListenableFuture<Void> refreshMaterializedView(Session session, QualifiedObjectName viewName) {
        return this.delegate.refreshMaterializedView(session, viewName);
    }

    public InsertTableHandle beginRefreshMaterializedView(Session session, TableHandle tableHandle, List<TableHandle> sourceTableHandles) {
        return this.delegate.beginRefreshMaterializedView(session, tableHandle, sourceTableHandles);
    }

    public Optional<ConnectorOutputMetadata> finishRefreshMaterializedView(Session session, TableHandle tableHandle, InsertTableHandle insertTableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics, List<TableHandle> sourceTableHandles) {
        return this.delegate.finishRefreshMaterializedView(session, tableHandle, insertTableHandle, fragments, computedStatistics, sourceTableHandles);
    }

    public ColumnHandle getDeleteRowIdColumnHandle(Session session, TableHandle tableHandle) {
        return this.delegate.getDeleteRowIdColumnHandle(session, tableHandle);
    }

    public ColumnHandle getUpdateRowIdColumnHandle(Session session, TableHandle tableHandle, List<ColumnHandle> updatedColumns) {
        return this.delegate.getUpdateRowIdColumnHandle(session, tableHandle, updatedColumns);
    }

    public Optional<TableHandle> applyDelete(Session session, TableHandle tableHandle) {
        return this.delegate.applyDelete(session, tableHandle);
    }

    public OptionalLong executeDelete(Session session, TableHandle tableHandle) {
        return this.delegate.executeDelete(session, tableHandle);
    }

    public TableHandle beginDelete(Session session, TableHandle tableHandle) {
        return this.delegate.beginDelete(session, tableHandle);
    }

    public void finishDelete(Session session, TableHandle tableHandle, Collection<Slice> fragments) {
        this.delegate.finishDelete(session, tableHandle, fragments);
    }

    public TableHandle beginUpdate(Session session, TableHandle tableHandle, List<ColumnHandle> updatedColumns) {
        return this.delegate.beginUpdate(session, tableHandle, updatedColumns);
    }

    public void finishUpdate(Session session, TableHandle tableHandle, Collection<Slice> fragments) {
        this.delegate.finishUpdate(session, tableHandle, fragments);
    }

    public RowChangeParadigm getRowChangeParadigm(Session session, TableHandle tableHandle) {
        return this.delegate.getRowChangeParadigm(session, tableHandle);
    }

    public ColumnHandle getMergeRowIdColumnHandle(Session session, TableHandle tableHandle) {
        return this.delegate.getMergeRowIdColumnHandle(session, tableHandle);
    }

    public Optional<PartitioningHandle> getUpdateLayout(Session session, TableHandle tableHandle) {
        return this.delegate.getUpdateLayout(session, tableHandle);
    }

    public MergeHandle beginMerge(Session session, TableHandle tableHandle) {
        return this.delegate.beginMerge(session, tableHandle);
    }

    public void finishMerge(Session session, MergeHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        this.delegate.finishMerge(session, tableHandle, fragments, computedStatistics);
    }

    public Optional<CatalogHandle> getCatalogHandle(Session session, String catalogName) {
        return this.delegate.getCatalogHandle(session, catalogName);
    }

    public List<CatalogInfo> listCatalogs(Session session) {
        return this.delegate.listCatalogs(session);
    }

    public List<QualifiedObjectName> listViews(Session session, QualifiedTablePrefix prefix) {
        return this.delegate.listViews(session, prefix);
    }

    public Map<QualifiedObjectName, ViewInfo> getViews(Session session, QualifiedTablePrefix prefix) {
        return this.delegate.getViews(session, prefix);
    }

    public boolean isView(Session session, QualifiedObjectName viewName) {
        return this.delegate.isView(session, viewName);
    }

    public Optional<ViewDefinition> getView(Session session, QualifiedObjectName viewName) {
        return this.delegate.getView(session, viewName);
    }

    public Map<String, Object> getSchemaProperties(Session session, CatalogSchemaName schemaName) {
        return this.delegate.getSchemaProperties(session, schemaName);
    }

    public Optional<TrinoPrincipal> getSchemaOwner(Session session, CatalogSchemaName schemaName) {
        return this.delegate.getSchemaOwner(session, schemaName);
    }

    public void createView(Session session, QualifiedObjectName viewName, ViewDefinition definition, boolean replace) {
        this.delegate.createView(session, viewName, definition, replace);
    }

    public void renameView(Session session, QualifiedObjectName existingViewName, QualifiedObjectName newViewName) {
        this.delegate.renameView(session, existingViewName, newViewName);
    }

    public void setViewAuthorization(Session session, CatalogSchemaTableName view, TrinoPrincipal principal) {
        this.delegate.setViewAuthorization(session, view, principal);
    }

    public void dropView(Session session, QualifiedObjectName viewName) {
        this.delegate.dropView(session, viewName);
    }

    public Optional<ResolvedIndex> resolveIndex(Session session, TableHandle tableHandle, Set<ColumnHandle> indexableColumns, Set<ColumnHandle> outputColumns, TupleDomain<ColumnHandle> tupleDomain) {
        return this.delegate.resolveIndex(session, tableHandle, indexableColumns, outputColumns, tupleDomain);
    }

    public Optional<LimitApplicationResult<TableHandle>> applyLimit(Session session, TableHandle table, long limit) {
        return this.delegate.applyLimit(session, table, limit);
    }

    public Optional<ConstraintApplicationResult<TableHandle>> applyFilter(Session session, TableHandle table, Constraint constraint) {
        return this.delegate.applyFilter(session, table, constraint);
    }

    public Optional<ProjectionApplicationResult<TableHandle>> applyProjection(Session session, TableHandle table, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        return this.delegate.applyProjection(session, table, projections, assignments);
    }

    public Optional<SampleApplicationResult<TableHandle>> applySample(Session session, TableHandle table, SampleType sampleType, double sampleRatio) {
        return this.delegate.applySample(session, table, sampleType, sampleRatio);
    }

    public Optional<AggregationApplicationResult<TableHandle>> applyAggregation(Session session, TableHandle table, List<AggregateFunction> aggregations, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        return this.delegate.applyAggregation(session, table, aggregations, assignments, groupingSets);
    }

    public Optional<JoinApplicationResult<TableHandle>> applyJoin(Session session, JoinType joinType, TableHandle left, TableHandle right, List<JoinCondition> joinConditions, Map<String, ColumnHandle> leftAssignments, Map<String, ColumnHandle> rightAssignments, JoinStatistics statistics) {
        return this.delegate.applyJoin(session, joinType, left, right, joinConditions, leftAssignments, rightAssignments, statistics);
    }

    public Optional<TopNApplicationResult<TableHandle>> applyTopN(Session session, TableHandle handle, long topNCount, List<SortItem> sortItems, Map<String, ColumnHandle> assignments) {
        return this.delegate.applyTopN(session, handle, topNCount, sortItems, assignments);
    }

    public Optional<TableFunctionApplicationResult<TableHandle>> applyTableFunction(Session session, TableFunctionHandle handle) {
        return this.delegate.applyTableFunction(session, handle);
    }

    public void validateScan(Session session, TableHandle table) {
        this.delegate.validateScan(session, table);
    }

    public boolean isCatalogManagedSecurity(Session session, String catalog) {
        return this.delegate.isCatalogManagedSecurity(session, catalog);
    }

    public boolean roleExists(Session session, String role, Optional<String> catalog) {
        return this.delegate.roleExists(session, role, catalog);
    }

    public void createRole(Session session, String role, Optional<TrinoPrincipal> grantor, Optional<String> catalog) {
        this.delegate.createRole(session, role, grantor, catalog);
    }

    public void dropRole(Session session, String role, Optional<String> catalog) {
        this.delegate.dropRole(session, role, catalog);
    }

    public Set<String> listRoles(Session session, Optional<String> catalog) {
        return this.delegate.listRoles(session, catalog);
    }

    public Set<RoleGrant> listAllRoleGrants(Session session, Optional<String> catalog, Optional<Set<String>> roles, Optional<Set<String>> grantees, OptionalLong limit) {
        return this.delegate.listAllRoleGrants(session, catalog, roles, grantees, limit);
    }

    public Set<RoleGrant> listRoleGrants(Session session, Optional<String> catalog, TrinoPrincipal principal) {
        return this.delegate.listRoleGrants(session, catalog, principal);
    }

    public void grantRoles(Session session, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor, Optional<String> catalog) {
        this.delegate.grantRoles(session, roles, grantees, adminOption, grantor, catalog);
    }

    public void revokeRoles(Session session, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor, Optional<String> catalog) {
        this.delegate.revokeRoles(session, roles, grantees, adminOption, grantor, catalog);
    }

    public Set<RoleGrant> listApplicableRoles(Session session, TrinoPrincipal principal, Optional<String> catalog) {
        return this.delegate.listApplicableRoles(session, principal, catalog);
    }

    public Set<String> listEnabledRoles(Identity identity) {
        return this.delegate.listEnabledRoles(identity);
    }

    public Set<String> listEnabledRoles(Session session, String catalog) {
        return this.delegate.listEnabledRoles(session, catalog);
    }

    public void grantSchemaPrivileges(Session session, CatalogSchemaName schemaName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        this.delegate.grantSchemaPrivileges(session, schemaName, privileges, grantee, grantOption);
    }

    public void denySchemaPrivileges(Session session, CatalogSchemaName schemaName, Set<Privilege> privileges, TrinoPrincipal grantee) {
        this.delegate.denySchemaPrivileges(session, schemaName, privileges, grantee);
    }

    public void revokeSchemaPrivileges(Session session, CatalogSchemaName schemaName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        this.delegate.revokeSchemaPrivileges(session, schemaName, privileges, grantee, grantOption);
    }

    public void grantTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        this.delegate.grantTablePrivileges(session, tableName, privileges, grantee, grantOption);
    }

    public void denyTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, TrinoPrincipal grantee) {
        this.delegate.denyTablePrivileges(session, tableName, privileges, grantee);
    }

    public void revokeTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        this.delegate.revokeTablePrivileges(session, tableName, privileges, grantee, grantOption);
    }

    public List<GrantInfo> listTablePrivileges(Session session, QualifiedTablePrefix prefix) {
        return this.delegate.listTablePrivileges(session, prefix);
    }

    public Collection<FunctionMetadata> listFunctions(Session session) {
        return this.delegate.listFunctions(session);
    }

    public ResolvedFunction decodeFunction(QualifiedName name) {
        return this.delegate.decodeFunction(name);
    }

    public ResolvedFunction resolveFunction(Session session, QualifiedName name, List<TypeSignatureProvider> parameterTypes) {
        return this.delegate.resolveFunction(session, name, parameterTypes);
    }

    public ResolvedFunction resolveOperator(Session session, OperatorType operatorType, List<? extends Type> argumentTypes) throws OperatorNotFoundException {
        return this.delegate.resolveOperator(session, operatorType, argumentTypes);
    }

    public ResolvedFunction getCoercion(Session session, Type fromType, Type toType) {
        return this.delegate.getCoercion(session, fromType, toType);
    }

    public ResolvedFunction getCoercion(Session session, OperatorType operatorType, Type fromType, Type toType) {
        return this.delegate.getCoercion(session, operatorType, fromType, toType);
    }

    public ResolvedFunction getCoercion(Session session, QualifiedName name, Type fromType, Type toType) {
        return this.delegate.getCoercion(session, name, fromType, toType);
    }

    public boolean isAggregationFunction(Session session, QualifiedName name) {
        return this.delegate.isAggregationFunction(session, name);
    }

    public FunctionMetadata getFunctionMetadata(Session session, ResolvedFunction resolvedFunction) {
        return this.delegate.getFunctionMetadata(session, resolvedFunction);
    }

    public AggregationFunctionMetadata getAggregationFunctionMetadata(Session session, ResolvedFunction resolvedFunction) {
        return this.delegate.getAggregationFunctionMetadata(session, resolvedFunction);
    }

    public void createMaterializedView(Session session, QualifiedObjectName viewName, MaterializedViewDefinition definition, boolean replace, boolean ignoreExisting) {
        this.delegate.createMaterializedView(session, viewName, definition, replace, ignoreExisting);
    }

    public void dropMaterializedView(Session session, QualifiedObjectName viewName) {
        this.delegate.dropMaterializedView(session, viewName);
    }

    public List<QualifiedObjectName> listMaterializedViews(Session session, QualifiedTablePrefix prefix) {
        return this.delegate.listMaterializedViews(session, prefix);
    }

    public Map<QualifiedObjectName, ViewInfo> getMaterializedViews(Session session, QualifiedTablePrefix prefix) {
        return this.delegate.getMaterializedViews(session, prefix);
    }

    public boolean isMaterializedView(Session session, QualifiedObjectName viewName) {
        return this.delegate.isMaterializedView(session, viewName);
    }

    public Optional<MaterializedViewDefinition> getMaterializedView(Session session, QualifiedObjectName viewName) {
        return this.delegate.getMaterializedView(session, viewName);
    }

    public MaterializedViewFreshness getMaterializedViewFreshness(Session session, QualifiedObjectName name) {
        return this.delegate.getMaterializedViewFreshness(session, name);
    }

    public void renameMaterializedView(Session session, QualifiedObjectName existingViewName, QualifiedObjectName newViewName) {
        this.delegate.renameMaterializedView(session, existingViewName, newViewName);
    }

    public void setMaterializedViewProperties(Session session, QualifiedObjectName viewName, Map<String, Optional<Object>> properties) {
        this.delegate.setMaterializedViewProperties(session, viewName, properties);
    }

    public Optional<TableScanRedirectApplicationResult> applyTableScanRedirect(Session session, TableHandle tableHandle) {
        return this.delegate.applyTableScanRedirect(session, tableHandle);
    }

    public RedirectionAwareTableHandle getRedirectionAwareTableHandle(Session session, QualifiedObjectName tableName) {
        return this.delegate.getRedirectionAwareTableHandle(session, tableName);
    }

    public RedirectionAwareTableHandle getRedirectionAwareTableHandle(Session session, QualifiedObjectName tableName, Optional<TableVersion> startVersion, Optional<TableVersion> endVersion) {
        return this.delegate.getRedirectionAwareTableHandle(session, tableName, startVersion, endVersion);
    }

    public boolean supportsReportingWrittenBytes(Session session, TableHandle tableHandle) {
        return false;
    }

    public boolean supportsReportingWrittenBytes(Session session, QualifiedObjectName tableName, Map<String, Object> tableProperties) {
        return false;
    }

    public Optional<TableHandle> getTableHandle(Session session, QualifiedObjectName tableName, Optional<TableVersion> startVersion, Optional<TableVersion> endVersion) {
        return this.delegate.getTableHandle(session, tableName, startVersion, endVersion);
    }

    public static enum Methods {
        GET_TABLE_STATISTICS;

    }
}

