/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.trino.operator.CompletedWork;
import io.trino.operator.GroupByHash;
import io.trino.operator.GroupByIdBlock;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.List;
import org.openjdk.jol.info.ClassLayout;

public class CyclingGroupByHash
implements GroupByHash {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(CyclingGroupByHash.class).instanceSize();
    private final int totalGroupCount;
    private int maxGroupId;
    private int currentGroupId;

    public CyclingGroupByHash(int totalGroupCount) {
        this.totalGroupCount = totalGroupCount;
    }

    public long getEstimatedSize() {
        return INSTANCE_SIZE;
    }

    public long getHashCollisions() {
        return 0L;
    }

    public double getExpectedHashCollisions() {
        return 0.0;
    }

    public List<Type> getTypes() {
        return ImmutableList.of();
    }

    public int getGroupCount() {
        return this.maxGroupId + 1;
    }

    public void appendValuesTo(int groupId, PageBuilder pageBuilder) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public Work<?> addPage(Page page) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public Work<GroupByIdBlock> getGroupIds(Page page) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, page.getChannelCount());
        for (int i = 0; i < page.getPositionCount(); ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)this.currentGroupId);
            this.maxGroupId = Math.max(this.currentGroupId, this.maxGroupId);
            this.currentGroupId = (this.currentGroupId + 1) % this.totalGroupCount;
        }
        return new CompletedWork((Object)new GroupByIdBlock((long)this.getGroupCount(), blockBuilder.build()));
    }

    public boolean contains(int position, Page page, int[] hashChannels) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public long getRawHash(int groupyId) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    public int getCapacity() {
        return this.totalGroupCount;
    }
}

