/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.trino.RowPagesBuilder;
import io.trino.SequencePageBuilder;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.block.BlockAssertions;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.Split;
import io.trino.metadata.SqlFunction;
import io.trino.operator.DriverContext;
import io.trino.operator.GenericLongFunction;
import io.trino.operator.Operator;
import io.trino.operator.OperatorAssertion;
import io.trino.operator.PageAssertions;
import io.trino.operator.ScanFilterAndProjectOperator;
import io.trino.operator.SourceOperator;
import io.trino.operator.index.PageRecordSet;
import io.trino.operator.project.PageProcessor;
import io.trino.operator.project.TestPageProcessor;
import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedPageSource;
import io.trino.spi.connector.RecordPageSource;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.tree.QualifiedName;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingSplit;
import io.trino.testing.TestingTaskContext;
import io.trino.testing.assertions.Assert;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestScanFilterAndProjectOperator
extends AbstractTestFunctions {
    private ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
    private ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
        this.scheduledExecutor.shutdownNow();
        this.scheduledExecutor = null;
    }

    @Test
    public void testPageSource() {
        Page input = SequencePageBuilder.createSequencePage((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), 10000, 0);
        DriverContext driverContext = this.newDriverContext();
        ImmutableList projections = ImmutableList.of((Object)Expressions.field((int)0, (Type)VarcharType.VARCHAR));
        Supplier cursorProcessor = this.functionAssertions.getExpressionCompiler().compileCursorProcessor(Optional.empty(), (List)projections, (Object)"key");
        Supplier pageProcessor = this.functionAssertions.getExpressionCompiler().compilePageProcessor(Optional.empty(), (List)projections);
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, table, columns, dynamicFilter) -> new FixedPageSource((Iterable)ImmutableList.of((Object)input)), cursorProcessor, pageProcessor, TestingHandles.TEST_TABLE_HANDLE, (Iterable)ImmutableList.of(), DynamicFilter.EMPTY, (List)ImmutableList.of((Object)VarcharType.VARCHAR), DataSize.ofBytes((long)0L), 0);
        SourceOperator operator = factory.createOperator(driverContext);
        operator.addSplit(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)TestingSplit.createLocalSplit()));
        operator.noMoreSplits();
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (List<Page>)ImmutableList.of((Object)input));
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), TestScanFilterAndProjectOperator.toPages((Operator)operator));
        Assert.assertEquals((int)actual.getRowCount(), (int)expected.getRowCount());
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testPageSourceMergeOutput() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).addSequencePage(100, 0).addSequencePage(100, 0).addSequencePage(100, 0).addSequencePage(100, 0).build();
        CallExpression filter = Expressions.call((ResolvedFunction)this.functionAssertions.getTestingFunctionResolution().resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)BigintType.BIGINT), Expressions.constant((Object)10L, (Type)BigintType.BIGINT)});
        ImmutableList projections = ImmutableList.of((Object)Expressions.field((int)0, (Type)BigintType.BIGINT));
        Supplier cursorProcessor = this.functionAssertions.getExpressionCompiler().compileCursorProcessor(Optional.of(filter), (List)projections, (Object)"key");
        Supplier pageProcessor = this.functionAssertions.getExpressionCompiler().compilePageProcessor(Optional.of(filter), (List)projections);
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, table, columns, dynamicFilter) -> new FixedPageSource((Iterable)input), cursorProcessor, pageProcessor, TestingHandles.TEST_TABLE_HANDLE, (Iterable)ImmutableList.of(), DynamicFilter.EMPTY, (List)ImmutableList.of((Object)BigintType.BIGINT), DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 2);
        SourceOperator operator = factory.createOperator(this.newDriverContext());
        operator.addSplit(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)TestingSplit.createLocalSplit()));
        operator.noMoreSplits();
        List<Page> actual = TestScanFilterAndProjectOperator.toPages((Operator)operator);
        Assert.assertEquals((int)actual.size(), (int)1);
        List<Page> expected = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(10L).row(10L).row(10L).row(10L).build();
        PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), actual.get(0), expected.get(0));
    }

    @Test
    public void testPageSourceLazyLoad() {
        Block inputBlock = BlockAssertions.createLongSequenceBlock(0, 100);
        Page input = new Page(100, new Block[]{inputBlock, new LazyBlock(100, () -> {
            throw new AssertionError((Object)"Lazy block should not be loaded");
        })});
        DriverContext driverContext = this.newDriverContext();
        ImmutableList projections = ImmutableList.of((Object)Expressions.field((int)0, (Type)VarcharType.VARCHAR));
        Supplier cursorProcessor = this.functionAssertions.getExpressionCompiler().compileCursorProcessor(Optional.empty(), (List)projections, (Object)"key");
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new TestPageProcessor.SelectAllFilter()), (List)ImmutableList.of((Object)new TestPageProcessor.LazyPagePageProjection()));
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, table, columns, dynamicFilter) -> new SinglePagePageSource(input), cursorProcessor, () -> pageProcessor, TestingHandles.TEST_TABLE_HANDLE, (Iterable)ImmutableList.of(), DynamicFilter.EMPTY, (List)ImmutableList.of((Object)BigintType.BIGINT), DataSize.ofBytes((long)0L), 0);
        SourceOperator operator = factory.createOperator(driverContext);
        operator.addSplit(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)TestingSplit.createLocalSplit()));
        operator.noMoreSplits();
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Page>)ImmutableList.of((Object)new Page(new Block[]{inputBlock})));
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), TestScanFilterAndProjectOperator.toPages((Operator)operator));
        Assert.assertEquals((int)actual.getRowCount(), (int)expected.getRowCount());
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testRecordCursorSource() {
        Page input = SequencePageBuilder.createSequencePage((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), 10000, 0);
        DriverContext driverContext = this.newDriverContext();
        ImmutableList projections = ImmutableList.of((Object)Expressions.field((int)0, (Type)VarcharType.VARCHAR));
        Supplier cursorProcessor = this.functionAssertions.getExpressionCompiler().compileCursorProcessor(Optional.empty(), (List)projections, (Object)"key");
        Supplier pageProcessor = this.functionAssertions.getExpressionCompiler().compilePageProcessor(Optional.empty(), (List)projections);
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, table, columns, dynamicFilter) -> new RecordPageSource((RecordSet)new PageRecordSet((List)ImmutableList.of((Object)VarcharType.VARCHAR), input)), cursorProcessor, pageProcessor, TestingHandles.TEST_TABLE_HANDLE, (Iterable)ImmutableList.of(), DynamicFilter.EMPTY, (List)ImmutableList.of((Object)VarcharType.VARCHAR), DataSize.ofBytes((long)0L), 0);
        SourceOperator operator = factory.createOperator(driverContext);
        operator.addSplit(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)TestingSplit.createLocalSplit()));
        operator.noMoreSplits();
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (List<Page>)ImmutableList.of((Object)input));
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), TestScanFilterAndProjectOperator.toPages((Operator)operator));
        Assert.assertEquals((int)actual.getRowCount(), (int)expected.getRowCount());
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testPageYield() {
        int totalRows = 1000;
        Page input = SequencePageBuilder.createSequencePage((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), totalRows, 1);
        DriverContext driverContext = this.newDriverContext();
        int totalColumns = 20;
        ImmutableList.Builder functions = ImmutableList.builder();
        for (int i = 0; i < totalColumns; ++i) {
            functions.add((Object)new GenericLongFunction("page_col" + i, value -> {
                driverContext.getYieldSignal().forceYieldForTesting();
                return value;
            }));
        }
        this.functionAssertions.addFunctions((FunctionBundle)new InternalFunctionBundle((List)functions.build()));
        ExpressionCompiler expressionCompiler = new ExpressionCompiler(this.functionAssertions.getFunctionManager(), new PageFunctionCompiler(this.functionAssertions.getFunctionManager(), 0));
        ImmutableList.Builder projections = ImmutableList.builder();
        for (int i = 0; i < totalColumns; ++i) {
            projections.add((Object)Expressions.call((ResolvedFunction)this.functionAssertions.getMetadata().resolveFunction(this.session, QualifiedName.of((String)("generic_long_page_col" + i)), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})), (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)BigintType.BIGINT)}));
        }
        Supplier cursorProcessor = expressionCompiler.compileCursorProcessor(Optional.empty(), (List)projections.build(), (Object)"key");
        Supplier pageProcessor = expressionCompiler.compilePageProcessor(Optional.empty(), (List)projections.build(), 8192);
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, table, columns, dynamicFilter) -> new FixedPageSource((Iterable)ImmutableList.of((Object)input)), cursorProcessor, pageProcessor, TestingHandles.TEST_TABLE_HANDLE, (Iterable)ImmutableList.of(), DynamicFilter.EMPTY, (List)ImmutableList.of((Object)BigintType.BIGINT), DataSize.ofBytes((long)0L), 0);
        SourceOperator operator = factory.createOperator(driverContext);
        operator.addSplit(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)TestingSplit.createLocalSplit()));
        operator.noMoreSplits();
        for (int i = 1; i <= totalRows * totalColumns; ++i) {
            driverContext.getYieldSignal().setWithDelay(TimeUnit.SECONDS.toNanos(1000L), driverContext.getYieldExecutor());
            Page page = operator.getOutput();
            if (i == totalColumns) {
                org.testng.Assert.assertNotNull((Object)page);
                Assert.assertEquals((int)page.getPositionCount(), (int)totalRows);
                Assert.assertEquals((int)page.getChannelCount(), (int)totalColumns);
                for (int j = 0; j < totalColumns; ++j) {
                    Assert.assertEquals(BlockAssertions.toValues((Type)BigintType.BIGINT, page.getBlock(j)), BlockAssertions.toValues((Type)BigintType.BIGINT, input.getBlock(0)));
                }
            } else {
                org.testng.Assert.assertNull((Object)page);
            }
            driverContext.getYieldSignal().reset();
        }
    }

    @Test
    public void testRecordCursorYield() {
        int length = 15;
        Page input = SequencePageBuilder.createSequencePage((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), length, 0);
        DriverContext driverContext = this.newDriverContext();
        this.functionAssertions.addFunctions((FunctionBundle)new InternalFunctionBundle(new SqlFunction[]{new GenericLongFunction("record_cursor", value -> {
            driverContext.getYieldSignal().forceYieldForTesting();
            return value;
        })}));
        FunctionManager functionManager = this.functionAssertions.getFunctionManager();
        ExpressionCompiler expressionCompiler = new ExpressionCompiler(functionManager, new PageFunctionCompiler(functionManager, 0));
        ImmutableList projections = ImmutableList.of((Object)Expressions.call((ResolvedFunction)this.functionAssertions.getMetadata().resolveFunction(this.session, QualifiedName.of((String)"generic_long_record_cursor"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})), (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)BigintType.BIGINT)}));
        Supplier cursorProcessor = expressionCompiler.compileCursorProcessor(Optional.empty(), (List)projections, (Object)"key");
        Supplier pageProcessor = expressionCompiler.compilePageProcessor(Optional.empty(), (List)projections);
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, table, columns, dynamicFilter) -> new RecordPageSource((RecordSet)new PageRecordSet((List)ImmutableList.of((Object)BigintType.BIGINT), input)), cursorProcessor, pageProcessor, TestingHandles.TEST_TABLE_HANDLE, (Iterable)ImmutableList.of(), DynamicFilter.EMPTY, (List)ImmutableList.of((Object)BigintType.BIGINT), DataSize.ofBytes((long)0L), 0);
        SourceOperator operator = factory.createOperator(driverContext);
        operator.addSplit(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)TestingSplit.createLocalSplit()));
        operator.noMoreSplits();
        for (int i = 0; i < length; ++i) {
            driverContext.getYieldSignal().setWithDelay(TimeUnit.SECONDS.toNanos(1000L), driverContext.getYieldExecutor());
            org.testng.Assert.assertNull((Object)operator.getOutput());
            driverContext.getYieldSignal().reset();
        }
        driverContext.getYieldSignal().setWithDelay(TimeUnit.SECONDS.toNanos(1000L), driverContext.getYieldExecutor());
        Page output = operator.getOutput();
        driverContext.getYieldSignal().reset();
        org.testng.Assert.assertNotNull((Object)output);
        Assert.assertEquals(BlockAssertions.toValues((Type)BigintType.BIGINT, output.getBlock(0)), BlockAssertions.toValues((Type)BigintType.BIGINT, input.getBlock(0)));
    }

    private static List<Page> toPages(Operator operator) {
        ImmutableList.Builder outputPages = ImmutableList.builder();
        int nullPages = 0;
        while (!operator.isFinished()) {
            Page outputPage = operator.getOutput();
            if (outputPage == null) {
                org.testng.Assert.assertTrue((nullPages < 1000000 ? 1 : 0) != 0, (String)"Too many null pages; infinite loop?");
                ++nullPages;
                continue;
            }
            outputPages.add((Object)outputPage);
            nullPages = 0;
        }
        return outputPages.build();
    }

    private DriverContext newDriverContext() {
        return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
    }

    public static class SinglePagePageSource
    implements ConnectorPageSource {
        private Page page;

        public SinglePagePageSource(Page page) {
            this.page = page;
        }

        public void close() {
            this.page = null;
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public long getMemoryUsage() {
            return 0L;
        }

        public boolean isFinished() {
            return this.page == null;
        }

        public Page getNextPage() {
            Page page = this.page;
            this.page = null;
            return page;
        }
    }
}

