/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.DynamicClassLoader;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionNullability;
import io.trino.operator.aggregation.AccumulatorCompiler;
import io.trino.operator.aggregation.AccumulatorFactory;
import io.trino.operator.aggregation.AggregationFunctionAdapter;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.operator.aggregation.LongTimestampAggregation;
import io.trino.operator.aggregation.LongTimestampAggregationState;
import io.trino.operator.aggregation.TestingAggregationFunction;
import io.trino.operator.aggregation.state.StateCompiler;
import io.trino.server.PluginClassLoader;
import io.trino.server.PluginManager;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.RealType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.sql.gen.IsolatedClass;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestAccumulatorCompiler {
    @Test
    public void testAccumulatorCompilerForTypeSpecificObjectParameter() {
        TimestampType parameterType = TimestampType.TIMESTAMP_NANOS;
        Assertions.assertThat((Class)parameterType.getJavaType()).isEqualTo(LongTimestamp.class);
        TestAccumulatorCompiler.assertGenerateAccumulator(LongTimestampAggregation.class, LongTimestampAggregationState.class);
    }

    @Test
    public void testAccumulatorCompilerForTypeSpecificObjectParameterSeparateClassLoader() throws Exception {
        TimestampType parameterType = TimestampType.TIMESTAMP_NANOS;
        Assertions.assertThat((Class)parameterType.getJavaType()).isEqualTo(LongTimestamp.class);
        PluginClassLoader pluginClassLoader = PluginManager.createClassLoader((String)"test", (List)ImmutableList.of());
        DynamicClassLoader classLoader = new DynamicClassLoader((ClassLoader)pluginClassLoader);
        Class stateInterface = IsolatedClass.isolateClass((DynamicClassLoader)classLoader, AccumulatorState.class, LongTimestampAggregationState.class, (Class[])new Class[]{LongTimestampAggregation.class});
        Assertions.assertThat((String)stateInterface.getCanonicalName()).isEqualTo(LongTimestampAggregationState.class.getCanonicalName());
        Assertions.assertThat((Class)stateInterface).isNotSameAs(LongTimestampAggregationState.class);
        Class aggregation = classLoader.loadClass(LongTimestampAggregation.class.getCanonicalName());
        Assertions.assertThat((String)aggregation.getCanonicalName()).isEqualTo(LongTimestampAggregation.class.getCanonicalName());
        Assertions.assertThat((Class)aggregation).isNotSameAs(LongTimestampAggregation.class);
        TestAccumulatorCompiler.assertGenerateAccumulator(aggregation, stateInterface);
    }

    private static <S extends AccumulatorState, A> void assertGenerateAccumulator(Class<A> aggregation, Class<S> stateInterface) {
        AccumulatorStateSerializer stateSerializer = StateCompiler.generateStateSerializer(stateInterface);
        AccumulatorStateFactory stateFactory = StateCompiler.generateStateFactory(stateInterface);
        BoundSignature signature = new BoundSignature("longTimestampAggregation", (Type)RealType.REAL, (List)ImmutableList.of((Object)TimestampType.TIMESTAMP_PICOS));
        MethodHandle inputFunction = Reflection.methodHandle(aggregation, (String)"input", (Class[])new Class[]{stateInterface, LongTimestamp.class});
        inputFunction = AggregationFunctionAdapter.normalizeInputMethod((MethodHandle)inputFunction, (BoundSignature)signature, (AggregationFunctionAdapter.AggregationParameterKind[])new AggregationFunctionAdapter.AggregationParameterKind[]{AggregationFunctionAdapter.AggregationParameterKind.STATE, AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL});
        MethodHandle combineFunction = Reflection.methodHandle(aggregation, (String)"combine", (Class[])new Class[]{stateInterface, stateInterface});
        MethodHandle outputFunction = Reflection.methodHandle(aggregation, (String)"output", (Class[])new Class[]{stateInterface, BlockBuilder.class});
        AggregationMetadata metadata = new AggregationMetadata(inputFunction, Optional.empty(), Optional.of(combineFunction), outputFunction, (List)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(stateInterface, stateSerializer, stateFactory)));
        FunctionNullability functionNullability = new FunctionNullability(false, (List)ImmutableList.of((Object)false));
        AccumulatorFactory accumulatorFactory = AccumulatorCompiler.generateAccumulatorFactory((BoundSignature)signature, (AggregationMetadata)metadata, (FunctionNullability)functionNullability);
        Assertions.assertThat((Object)accumulatorFactory).isNotNull();
        Assertions.assertThat((Object)AccumulatorCompiler.generateWindowAccumulatorClass((BoundSignature)signature, (AggregationMetadata)metadata, (FunctionNullability)functionNullability)).isNotNull();
        TestingAggregationFunction aggregationFunction = new TestingAggregationFunction((List<Type>)ImmutableList.of((Object)TimestampType.TIMESTAMP_PICOS), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (Type)BigintType.BIGINT, accumulatorFactory);
        Assertions.assertThat((Object)AggregationTestUtils.aggregation(aggregationFunction, TestAccumulatorCompiler.createPage(1234))).isEqualTo((Object)1234L);
    }

    private static Page createPage(int count) {
        Block timestampSequenceBlock = TestAccumulatorCompiler.createTimestampSequenceBlock(count);
        return new Page(timestampSequenceBlock.getPositionCount(), new Block[]{timestampSequenceBlock});
    }

    private static Block createTimestampSequenceBlock(int count) {
        BlockBuilder builder = TimestampType.TIMESTAMP_PICOS.createFixedSizeBlockBuilder(count);
        for (int i = 0; i < count; ++i) {
            TimestampType.TIMESTAMP_PICOS.writeObject(builder, (Object)new LongTimestamp((long)i, i));
        }
        return builder.build();
    }
}

