/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.airlift.testing.Assertions;
import io.trino.block.BlockAssertions;
import io.trino.operator.output.PositionsAppender;
import io.trino.operator.output.PositionsAppenderFactory;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.DictionaryId;
import io.trino.spi.block.PageBuilderStatus;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.type.BlockTypeOperators;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestPositionsAppender {
    private static final PositionsAppenderFactory POSITIONS_APPENDER_FACTORY = new PositionsAppenderFactory(new BlockTypeOperators());

    @Test(dataProvider="types")
    public void testMixedBlockTypes(Type type) {
        ImmutableList input = ImmutableList.of((Object)this.input(this.emptyBlock(type), new int[0]), (Object)this.input(this.nullBlock(type, 3), 0, 2), (Object)this.input(this.notNullBlock(type, 3), 1, 2), (Object)this.input(this.partiallyNullBlock(type, 4), 0, 1, 2, 3), (Object)this.input(this.partiallyNullBlock(type, 4), new int[0]), (Object)this.input((Block)this.rleBlock(type, 4), 0, 2), (Object)this.input((Block)this.rleBlock(type, 2), 0, 1), (Object)this.input((Block)this.nullRleBlock(type, 4), 1, 2), (Object)this.input((Block)this.dictionaryBlock(type, 4, 2, 0.0f), 0, 3), (Object)this.input((Block)this.dictionaryBlock(type, 8, 4, 0.5f), 1, 3, 5), (Object)this.input((Block)this.dictionaryBlock(type, 8, 4, 1.0f), 1, 3, 5), (Object)this.input((Block)this.rleBlock((Block)this.dictionaryBlock(type, 1, 2, 0.0f), 3), 2), (Object[])new BlockView[]{this.input((Block)this.rleBlock((Block)this.dictionaryBlock(this.notNullBlock(type, 2), new int[]{1}), 3), 2), this.input((Block)this.rleBlock((Block)this.dictionaryBlock((Block)this.rleBlock(type, 4), 1), 3), 1), this.input((Block)this.dictionaryBlock((Block)this.dictionaryBlock(type, 5, 4, 0.5f), 3), 2), this.input((Block)this.dictionaryBlock((Block)this.dictionaryBlock((Block)this.dictionaryBlock(type, 5, 4, 0.5f), 3), 3), 2), this.input((Block)this.dictionaryBlock((Block)this.rleBlock(type, 4), 3), 0, 2), this.input(this.notNullBlock(type, 4).getRegion(2, 2), 0, 1), this.input(this.partiallyNullBlock(type, 4).getRegion(2, 2), 0, 1), this.input((Block)this.rleBlock(this.notNullBlock(type, 4).getRegion(2, 1), 3), 1)});
        this.testAppend(type, (List<BlockView>)input);
    }

    @Test(dataProvider="nullRleTypes")
    public void testNullRle(Type type) {
        this.testNullRle(type, this.nullBlock(type, 2));
        this.testNullRle(type, (Block)this.nullRleBlock(type, 2));
        this.testNullRle(type, BlockAssertions.createRandomBlockForType(type, 4, 0.5f));
    }

    @Test(dataProvider="types")
    public void testRleSwitchToFlat(Type type) {
        ImmutableList inputs = ImmutableList.of((Object)this.input((Block)this.rleBlock(type, 3), 0, 1), (Object)this.input(this.notNullBlock(type, 2), 0, 1));
        this.testAppend(type, (List<BlockView>)inputs);
        ImmutableList dictionaryInputs = ImmutableList.of((Object)this.input((Block)this.rleBlock(type, 3), 0, 1), (Object)this.input((Block)this.dictionaryBlock(type, 2, 4, 0.0f), 0, 1));
        this.testAppend(type, (List<BlockView>)dictionaryInputs);
    }

    @Test(dataProvider="types")
    public void testFlatAppendRle(Type type) {
        ImmutableList inputs = ImmutableList.of((Object)this.input(this.notNullBlock(type, 2), 0, 1), (Object)this.input((Block)this.rleBlock(type, 3), 0, 1));
        this.testAppend(type, (List<BlockView>)inputs);
        ImmutableList dictionaryInputs = ImmutableList.of((Object)this.input((Block)this.dictionaryBlock(type, 2, 4, 0.0f), 0, 1), (Object)this.input((Block)this.rleBlock(type, 3), 0, 1));
        this.testAppend(type, (List<BlockView>)dictionaryInputs);
    }

    @Test(dataProvider="differentValues")
    public void testMultipleRleBlocksWithDifferentValues(Type type, Block value1, Block value2) {
        ImmutableList input = ImmutableList.of((Object)this.input((Block)this.rleBlock(value1, 3), 0, 1), (Object)this.input((Block)this.rleBlock(value2, 3), 0, 1));
        this.testAppend(type, (List<BlockView>)input);
    }

    @DataProvider(name="differentValues")
    public static Object[][] differentValues() {
        return new Object[][]{{BigintType.BIGINT, BlockAssertions.createLongsBlock(0), BlockAssertions.createLongsBlock(1)}, {BooleanType.BOOLEAN, BlockAssertions.createBooleansBlock(true), BlockAssertions.createBooleansBlock(false)}, {IntegerType.INTEGER, BlockAssertions.createIntsBlock(0), BlockAssertions.createIntsBlock(1)}, {CharType.createCharType((long)10L), BlockAssertions.createStringsBlock("0"), BlockAssertions.createStringsBlock("1")}, {VarcharType.createUnboundedVarcharType(), BlockAssertions.createStringsBlock("0"), BlockAssertions.createStringsBlock("1")}, {DoubleType.DOUBLE, BlockAssertions.createDoublesBlock(0.0), BlockAssertions.createDoublesBlock(1.0)}, {SmallintType.SMALLINT, BlockAssertions.createSmallintsBlock(0), BlockAssertions.createSmallintsBlock(1)}, {TinyintType.TINYINT, BlockAssertions.createTinyintsBlock(0), BlockAssertions.createTinyintsBlock(1)}, {VarbinaryType.VARBINARY, BlockAssertions.createSlicesBlock(Slices.wrappedLongArray((long[])new long[]{0L})), BlockAssertions.createSlicesBlock(Slices.wrappedLongArray((long[])new long[]{1L}))}, {DecimalType.createDecimalType((int)19), BlockAssertions.createLongDecimalsBlock("0"), BlockAssertions.createLongDecimalsBlock("1")}, {new ArrayType((Type)BigintType.BIGINT), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)0L))), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)1L)))}, {TimestampType.createTimestampType((int)9), BlockAssertions.createLongTimestampBlock(TimestampType.createTimestampType((int)9), new LongTimestamp(0L, 0)), BlockAssertions.createLongTimestampBlock(TimestampType.createTimestampType((int)9), new LongTimestamp(1L, 0))}};
    }

    @Test(dataProvider="types")
    public void testMultipleRleWithTheSameValueProduceRle(Type type) {
        PositionsAppender positionsAppender = POSITIONS_APPENDER_FACTORY.create(type, 10, 0x100000L);
        Block value = this.notNullBlock(type, 1);
        positionsAppender.append(this.allPositions(3), (Block)this.rleBlock(value, 3));
        positionsAppender.append(this.allPositions(2), (Block)this.rleBlock(value, 2));
        Block actual = positionsAppender.build();
        Assert.assertEquals((int)actual.getPositionCount(), (int)5);
        Assertions.assertInstanceOf((Object)actual, RunLengthEncodedBlock.class);
    }

    @Test(dataProvider="types")
    public void testConsecutiveBuilds(Type type) {
        PositionsAppender positionsAppender = POSITIONS_APPENDER_FACTORY.create(type, 10, 0x100000L);
        positionsAppender.append(TestPositionsAppender.positions(new int[0]), this.emptyBlock(type));
        Assert.assertEquals((int)positionsAppender.build().getPositionCount(), (int)0);
        Block block = BlockAssertions.createRandomBlockForType(type, 2, 0.5f);
        int nullPosition = block.isNull(0) ? 0 : 1;
        positionsAppender.append(TestPositionsAppender.positions(nullPosition), block);
        Block actualNullBlock = positionsAppender.build();
        Assert.assertEquals((int)actualNullBlock.getPositionCount(), (int)1);
        Assert.assertTrue((boolean)actualNullBlock.isNull(0));
        positionsAppender.append(this.allPositions(2), block);
        BlockAssertions.assertBlockEquals(type, positionsAppender.build(), block);
        RunLengthEncodedBlock rleBlock = this.rleBlock(type, 1);
        positionsAppender.append(this.allPositions(1), (Block)rleBlock);
        BlockAssertions.assertBlockEquals(type, positionsAppender.build(), (Block)rleBlock);
        positionsAppender.append(TestPositionsAppender.positions(new int[0]), (Block)this.rleBlock(type, 0));
        Assert.assertEquals((int)positionsAppender.build().getPositionCount(), (int)0);
        RunLengthEncodedBlock nullRleBlock = this.nullRleBlock(type, 1);
        positionsAppender.append(this.allPositions(1), (Block)nullRleBlock);
        BlockAssertions.assertBlockEquals(type, positionsAppender.build(), (Block)nullRleBlock);
        Assert.assertEquals((int)positionsAppender.build().getPositionCount(), (int)0);
    }

    @Test(priority=-2147483648)
    public void testSliceRle() {
        PositionsAppender positionsAppender = POSITIONS_APPENDER_FACTORY.create((Type)VarcharType.VARCHAR, 10, 0x100000L);
        positionsAppender.appendRle(new RunLengthEncodedBlock(TestPositionsAppender.singleValueBlock("some value"), 1));
        Block emptyStringBlock = TestPositionsAppender.singleValueBlock("");
        for (int i = 0; i < 1000; ++i) {
            positionsAppender.appendRle(new RunLengthEncodedBlock(emptyStringBlock, 2000));
        }
    }

    @Test
    public void testRowWithNestedFields() {
        RowType type = RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, VarcharType.VARCHAR});
        Block rowBLock = RowBlock.fromFieldBlocks((int)2, Optional.empty(), (Block[])new Block[]{this.notNullBlock((Type)BigintType.BIGINT, 2), this.dictionaryBlock((Type)BigintType.BIGINT, 2, 2, 0.5f), this.rleBlock((Type)VarcharType.VARCHAR, 2)});
        PositionsAppender positionsAppender = POSITIONS_APPENDER_FACTORY.create((Type)type, 10, 0x100000L);
        positionsAppender.append(this.allPositions(2), rowBLock);
        Block actual = positionsAppender.build();
        BlockAssertions.assertBlockEquals((Type)type, actual, rowBLock);
    }

    @DataProvider(name="nullRleTypes")
    public static Object[][] nullRleTypes() {
        return new Object[][]{{BigintType.BIGINT}, {BooleanType.BOOLEAN}, {IntegerType.INTEGER}, {CharType.createCharType((long)10L)}, {VarcharType.createUnboundedVarcharType()}, {DoubleType.DOUBLE}, {SmallintType.SMALLINT}, {TinyintType.TINYINT}, {VarbinaryType.VARBINARY}, {DecimalType.createDecimalType((int)19)}, {TimestampType.createTimestampType((int)9)}, {RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR})}};
    }

    @DataProvider(name="types")
    public static Object[][] types() {
        return new Object[][]{{BigintType.BIGINT}, {BooleanType.BOOLEAN}, {IntegerType.INTEGER}, {CharType.createCharType((long)10L)}, {VarcharType.createUnboundedVarcharType()}, {DoubleType.DOUBLE}, {SmallintType.SMALLINT}, {TinyintType.TINYINT}, {VarbinaryType.VARBINARY}, {DecimalType.createDecimalType((int)19)}, {new ArrayType((Type)BigintType.BIGINT)}, {TimestampType.createTimestampType((int)9)}, {RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR})}};
    }

    private static Block singleValueBlock(String value) {
        BlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 1);
        VarcharType.VARCHAR.writeSlice(blockBuilder, Slices.utf8Slice((String)value));
        return blockBuilder.build();
    }

    private IntArrayList allPositions(int count) {
        return new IntArrayList(IntStream.range(0, count).toArray());
    }

    private BlockView input(Block block, int ... positions) {
        return new BlockView(block, new IntArrayList(positions));
    }

    private static IntArrayList positions(int ... positions) {
        return new IntArrayList(positions);
    }

    private DictionaryBlock dictionaryBlock(Block dictionary, int positionCount) {
        return BlockAssertions.createRandomDictionaryBlock(dictionary, positionCount);
    }

    private DictionaryBlock dictionaryBlock(Block dictionary, int[] ids) {
        return new DictionaryBlock(0, ids.length, dictionary, ids, false, DictionaryId.randomDictionaryId());
    }

    private DictionaryBlock dictionaryBlock(Type type, int positionCount, int dictionarySize, float nullRate) {
        Block dictionary = BlockAssertions.createRandomBlockForType(type, dictionarySize, nullRate);
        return BlockAssertions.createRandomDictionaryBlock(dictionary, positionCount);
    }

    private RunLengthEncodedBlock rleBlock(Block value, int positionCount) {
        return new RunLengthEncodedBlock(value, positionCount);
    }

    private RunLengthEncodedBlock rleBlock(Type type, int positionCount) {
        Block rleValue = BlockAssertions.createRandomBlockForType(type, 1, 0.0f);
        return new RunLengthEncodedBlock(rleValue, positionCount);
    }

    private RunLengthEncodedBlock nullRleBlock(Type type, int positionCount) {
        Block rleValue = this.nullBlock(type, 1);
        return new RunLengthEncodedBlock(rleValue, positionCount);
    }

    private Block partiallyNullBlock(Type type, int positionCount) {
        return BlockAssertions.createRandomBlockForType(type, positionCount, 0.5f);
    }

    private Block notNullBlock(Type type, int positionCount) {
        return BlockAssertions.createRandomBlockForType(type, positionCount, 0.0f);
    }

    private Block nullBlock(Type type, int positionCount) {
        BlockBuilder blockBuilder = type.createBlockBuilder(null, positionCount);
        for (int i = 0; i < positionCount; ++i) {
            blockBuilder.appendNull();
        }
        return blockBuilder.build();
    }

    private Block emptyBlock(Type type) {
        return type.createBlockBuilder(null, 0).build();
    }

    private void testNullRle(Type type, Block source) {
        PositionsAppender positionsAppender = POSITIONS_APPENDER_FACTORY.create(type, 10, 0x100000L);
        IntArrayList positions = new IntArrayList(source.getPositionCount());
        for (int i = 0; i < source.getPositionCount(); ++i) {
            if (!source.isNull(i)) continue;
            positions.add(i);
        }
        positionsAppender.append(positions, source);
        positionsAppender.append(positions, source);
        Block actual = positionsAppender.build();
        Assert.assertTrue((boolean)actual.isNull(0));
        Assert.assertEquals((int)actual.getPositionCount(), (int)(positions.size() * 2));
        Assertions.assertInstanceOf((Object)actual, RunLengthEncodedBlock.class);
    }

    private void testAppend(Type type, List<BlockView> inputs) {
        PositionsAppender positionsAppender = POSITIONS_APPENDER_FACTORY.create(type, 10, 0x100000L);
        long initialRetainedSize = positionsAppender.getRetainedSizeInBytes();
        inputs.forEach(input -> positionsAppender.append(input.getPositions(), input.getBlock()));
        long sizeInBytes = positionsAppender.getSizeInBytes();
        Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(positionsAppender.getRetainedSizeInBytes()), (Comparable)Long.valueOf(sizeInBytes));
        Block actual = positionsAppender.build();
        this.assertBlockIsValid(actual, sizeInBytes, type, inputs);
        Assert.assertEquals((long)positionsAppender.getSizeInBytes(), (long)0L);
        Assert.assertEquals((long)positionsAppender.getRetainedSizeInBytes(), (long)initialRetainedSize);
        Block secondBlock = positionsAppender.build();
        Assert.assertEquals((int)secondBlock.getPositionCount(), (int)0);
    }

    private void assertBlockIsValid(Block actual, long sizeInBytes, Type type, List<BlockView> inputs) {
        PageBuilderStatus pageBuilderStatus = new PageBuilderStatus();
        BlockBuilderStatus blockBuilderStatus = pageBuilderStatus.createBlockBuilderStatus();
        Block expected = this.buildBlock(type, inputs, blockBuilderStatus);
        BlockAssertions.assertBlockEquals(type, actual, expected);
        Assert.assertEquals((long)sizeInBytes, (long)pageBuilderStatus.getSizeInBytes());
    }

    private Block buildBlock(Type type, List<BlockView> inputs, BlockBuilderStatus blockBuilderStatus) {
        BlockBuilder blockBuilder = type.createBlockBuilder(blockBuilderStatus, 10);
        for (BlockView input : inputs) {
            IntListIterator intListIterator = input.getPositions().iterator();
            while (intListIterator.hasNext()) {
                int position = (Integer)intListIterator.next();
                type.appendTo(input.getBlock(), position, blockBuilder);
            }
        }
        return blockBuilder.build();
    }

    private static class BlockView {
        private final Block block;
        private final IntArrayList positions;

        private BlockView(Block block, IntArrayList positions) {
            this.block = Objects.requireNonNull(block, "block is null");
            this.positions = Objects.requireNonNull(positions, "positions is null");
        }

        public Block getBlock() {
            return this.block;
        }

        public IntArrayList getPositions() {
            return this.positions;
        }

        public void appendTo(PositionsAppender positionsAppender) {
            positionsAppender.append(this.getPositions(), this.getBlock());
        }
    }
}

