/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.TrinoException;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import org.testng.annotations.Test;

public class TestConcatWsFunction
extends AbstractTestFunctions {
    private static final VarcharType RETURN_TYPE = VarcharType.createUnboundedVarcharType();

    @Test
    public void testSimple() {
        this.assertFunction("concat_ws('abc', 'def')", "def");
        this.assertFunction("concat_ws(',', 'def')", "def");
        this.assertFunction("concat_ws(',', 'def', 'pqr', 'mno')", "def,pqr,mno");
        this.assertFunction("concat_ws('abc', 'def', 'pqr')", "defabcpqr");
    }

    @Test
    public void testEmpty() {
        this.assertFunction("concat_ws('', 'def')", "def");
        this.assertFunction("concat_ws('', 'def', 'pqr')", "defpqr");
        this.assertFunction("concat_ws('', '', 'pqr')", "pqr");
        this.assertFunction("concat_ws('', 'def', '')", "def");
        this.assertFunction("concat_ws('', '', '')", "");
        this.assertFunction("concat_ws(',', 'def', '')", "def,");
        this.assertFunction("concat_ws(',', 'def', '', 'pqr')", "def,,pqr");
        this.assertFunction("concat_ws(',', '', 'pqr')", ",pqr");
    }

    @Test
    public void testNull() {
        this.assertFunction("concat_ws(NULL, 'def')", null);
        this.assertFunction("concat_ws(NULL, cast(NULL as VARCHAR))", null);
        this.assertFunction("concat_ws(NULL, 'def', 'pqr')", null);
        this.assertFunction("concat_ws(',', cast(NULL as VARCHAR))", "");
        this.assertFunction("concat_ws(',', NULL, 'pqr')", "pqr");
        this.assertFunction("concat_ws(',', 'def', NULL)", "def");
        this.assertFunction("concat_ws(',', 'def', NULL, 'pqr')", "def,pqr");
        this.assertFunction("concat_ws(',', 'def', NULL, NULL, 'mno', 'xyz', NULL, 'box')", "def,mno,xyz,box");
    }

    @Test
    public void testArray() {
        this.assertFunction("concat_ws(',', ARRAY[])", "");
        this.assertFunction("concat_ws(',', ARRAY['abc'])", "abc");
        this.assertFunction("concat_ws(',', ARRAY['abc', 'def', 'pqr', 'xyz'])", "abc,def,pqr,xyz");
        this.assertFunction("concat_ws(null, ARRAY['abc'])", null);
        this.assertFunction("concat_ws(',', cast(NULL as array(varchar)))", null);
        this.assertFunction("concat_ws(',', ARRAY['abc', null, null, 'xyz'])", "abc,xyz");
        this.assertFunction("concat_ws(',', ARRAY['abc', '', '', 'xyz','abcdefghi'])", "abc,,,xyz,abcdefghi");
    }

    @Test(expectedExceptions={TrinoException.class}, expectedExceptionsMessageRegExp=".*Unexpected parameters.*")
    public void testBadArray() {
        this.assertFunction("concat_ws(',', ARRAY[1, 15])", "");
    }

    @Test(expectedExceptions={TrinoException.class}, expectedExceptionsMessageRegExp=".*Unexpected parameters.*")
    public void testBadArguments() {
        this.assertFunction("concat_ws(',', 1, 15)", "");
    }

    @Test(expectedExceptions={TrinoException.class}, expectedExceptionsMessageRegExp="There must be two or more.*")
    public void testLowArguments() {
        this.assertFunction("concat_ws(',')", "");
    }

    private void assertFunction(String call, String expected) {
        this.assertFunction(call, (Type)RETURN_TYPE, expected);
    }
}

