/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import org.testng.annotations.Test;

public class TestFormatFunction
extends AbstractTestFunctions {
    @Test
    public void testFormat() {
        this.assertFormat("format('%s%%', 123)", "123%");
        this.assertFormat("format('%.4f', pi())", "3.1416");
        this.assertFormat("format('%.5f', pi())", "3.14159");
        this.assertFormat("format('%03d', 8)", "008");
        this.assertFormat("format('%-7s,%7s', 'hello', 'world')", "hello  ,  world");
        this.assertFormat("format('%b %B %b', true, false, null)", "true FALSE false");
        this.assertFormat("format('%s %s %s', true, false, null)", "true false null");
        this.assertFormat("format('%S %S %S', true, false, null)", "TRUE FALSE NULL");
        this.assertFormat("format('%4$s %3$s %2$s %1$s %4$s %3$s %2$s %1$s', 'a', 'b', 'c', 'd')", "d c b a d c b a");
        this.assertFormat("format('%s %s %<s %<s', 'a', 'b', 'c', 'd')", "a b b b");
        this.assertFormat("format('%2$s %s %<s %s', 'a', 'b', 'c', 'd')", "b a a b");
        this.assertFormat("format('%2$s %3$s %1$s', 'a', 'b', 'c', 'd')", "b c a");
        this.assertFormat("format('%s %s', 2, 3, 4)", "2 3");
        this.assertFormat("format('%d', tinyint '123')", "123");
        this.assertFormat("format('%d', smallint '32123')", "32123");
        this.assertFormat("format('%d', 1234567890)", "1234567890");
        this.assertFormat("format('%d', 1234567890123)", "1234567890123");
        this.assertFormat("format('%,.2f', 1234567.89)", "1,234,567.89");
        this.assertFormat("format('%1$s %1$f %1$.2f', decimal '9.12345678')", "9.12345678 9.123457 9.12");
        this.assertFormat("format('%1$d %1$x %1$X %1$o', 1234)", "1234 4d2 4D2 2322");
        this.assertFormat("format('%s', ipaddress '192.168.88.123')", "192.168.88.123");
        this.assertFormat("format('%s', ipaddress '2001:db8:0:0:1:0:0:1')", "2001:db8::1:0:0:1");
        this.assertFormat("format('%s', json '[123,\"abc\",true]')", "[123,\"abc\",true]");
        this.assertFormat("format('%1$s %1$tF %1$tY-%1$tm-%1$td', date '2001-08-22')", "2001-08-22 2001-08-22 2001-08-22");
        this.assertFormat("format('%1$tA, %1$tB %1$te, %1$tY', date '2006-07-04')", "Tuesday, July 4, 2006");
        this.assertFormat("format('%1$s %1$tT %1$tr', time '16:17:13')", "16:17:13 16:17:13 04:17:13 PM");
        this.assertFormat("format('%1$s %1$tF %1$tT', timestamp '1969-07-20 16:17:00')", "1969-07-20T16:17 1969-07-20 16:17:00");
        this.assertFormat("format('%1$s %1$tF %1$tT', timestamp '1969-07-20 16:17:03')", "1969-07-20T16:17:03 1969-07-20 16:17:03");
        this.assertFormat("format('%1$s %1$tc', cast('1969-07-20 16:17:00 America/New_York' AS timestamp with time zone))", "1969-07-20T16:17-04:00[America/New_York] Sun Jul 20 16:17:00 EDT 1969");
        this.assertFormat("format('%1$s %1$tc', cast('1969-07-20 20:17:00 UTC' AS timestamp with time zone))", "1969-07-20T20:17Z[UTC] Sun Jul 20 20:17:00 UTC 1969");
        this.assertFormat("format('%s', cast('16:17:13 -05:00' AS time with time zone))", "16:17:13.000-05:00");
        this.assertFormat("format('%s', cast('test' AS char(5)))", "test ");
        this.assertInvalidFunction("format('%.4d', 8)", "Invalid format string: %.4d (IllegalFormatPrecision: 4)");
        this.assertInvalidFunction("format('%-02d', 8)", "Invalid format string: %-02d (IllegalFormatFlags: Flags = '-0')");
        this.assertInvalidFunction("format('%--2d', 8)", "Invalid format string: %--2d (DuplicateFormatFlags: Flags = '-')");
        this.assertInvalidFunction("format('%+s', 8)", "Invalid format string: %+s (FormatFlagsConversionMismatch: Conversion = s, Flags = +)");
        this.assertInvalidFunction("format('%-s', 8)", "Invalid format string: %-s (MissingFormatWidth: %-s)");
        this.assertInvalidFunction("format('%5n', 8)", "Invalid format string: %5n (IllegalFormatWidth: 5)");
        this.assertInvalidFunction("format('%s %d', 8)", "Invalid format string: %s %d (MissingFormatArgument: Format specifier '%d')");
        this.assertInvalidFunction("format('%d', decimal '8')", "Invalid format string: %d (IllegalFormatConversion: d != java.math.BigDecimal)");
        this.assertInvalidFunction("format('%tT', current_time)", "Invalid format string: %tT (IllegalFormatConversion: T != java.lang.String)");
        this.assertInvalidFunction("format('%s', array[8])", (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "line 1:14: Type not supported for formatting: array(integer)");
        this.assertInvalidFunction("format(5, 8)", (ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, "line 1:8: Type of first argument to format() must be VARCHAR (actual: integer)");
    }

    private void assertFormat(String projection, String expected) {
        this.assertFunction(projection, (Type)VarcharType.VARCHAR, expected);
    }
}

