/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import org.testng.annotations.Test;

public class TestFormatNumberFunction
extends AbstractTestFunctions {
    @Test
    public void testFormatNumber() {
        this.assertFunction("format_number(TINYINT '123')", (Type)VarcharType.VARCHAR, "123");
        this.assertFunction("format_number(SMALLINT '12345')", (Type)VarcharType.VARCHAR, "12.3K");
        this.assertFunction("format_number(SMALLINT '12399')", (Type)VarcharType.VARCHAR, "12.4K");
        this.assertFunction("format_number(INTEGER '12345678')", (Type)VarcharType.VARCHAR, "12.3M");
        this.assertFunction("format_number(INTEGER '12399999')", (Type)VarcharType.VARCHAR, "12.4M");
        this.assertFunction("format_number(BIGINT '12345678901')", (Type)VarcharType.VARCHAR, "12.3B");
        this.assertFunction("format_number(BIGINT '12399999999')", (Type)VarcharType.VARCHAR, "12.4B");
        this.assertFunction("format_number(DOUBLE '1234.5')", (Type)VarcharType.VARCHAR, "1.23K");
        this.assertFunction("format_number(DOUBLE '1239.9')", (Type)VarcharType.VARCHAR, "1.24K");
        this.assertFunction("format_number(REAL '1234567.8')", (Type)VarcharType.VARCHAR, "1.23M");
        this.assertFunction("format_number(REAL '1239999.9')", (Type)VarcharType.VARCHAR, "1.24M");
        this.assertFunction("format_number(DECIMAL '1234567890.1')", (Type)VarcharType.VARCHAR, "1.23B");
        this.assertFunction("format_number(DECIMAL '1239999999.9')", (Type)VarcharType.VARCHAR, "1.24B");
        this.assertFunction("format_number(-999)", (Type)VarcharType.VARCHAR, "-999");
        this.assertFunction("format_number(-1000)", (Type)VarcharType.VARCHAR, "-1K");
        this.assertFunction("format_number(-999999)", (Type)VarcharType.VARCHAR, "-1000K");
        this.assertFunction("format_number(-1000000)", (Type)VarcharType.VARCHAR, "-1M");
        this.assertFunction("format_number(-999999999)", (Type)VarcharType.VARCHAR, "-1000M");
        this.assertFunction("format_number(-1000000000)", (Type)VarcharType.VARCHAR, "-1B");
        this.assertFunction("format_number(-999999999999)", (Type)VarcharType.VARCHAR, "-1000B");
        this.assertFunction("format_number(-1000000000000)", (Type)VarcharType.VARCHAR, "-1T");
        this.assertFunction("format_number(-999999999999999)", (Type)VarcharType.VARCHAR, "-1000T");
        this.assertFunction("format_number(-1000000000000000)", (Type)VarcharType.VARCHAR, "-1Q");
        this.assertFunction("format_number(-9223372036854775808)", (Type)VarcharType.VARCHAR, "-9223.37Q");
        this.assertFunction("format_number(0)", (Type)VarcharType.VARCHAR, "0");
        this.assertFunction("format_number(999)", (Type)VarcharType.VARCHAR, "999");
        this.assertFunction("format_number(1000)", (Type)VarcharType.VARCHAR, "1K");
        this.assertFunction("format_number(999999)", (Type)VarcharType.VARCHAR, "1000K");
        this.assertFunction("format_number(1000000)", (Type)VarcharType.VARCHAR, "1M");
        this.assertFunction("format_number(999999999)", (Type)VarcharType.VARCHAR, "1000M");
        this.assertFunction("format_number(1000000000)", (Type)VarcharType.VARCHAR, "1B");
        this.assertFunction("format_number(999999999999)", (Type)VarcharType.VARCHAR, "1000B");
        this.assertFunction("format_number(1000000000000)", (Type)VarcharType.VARCHAR, "1T");
        this.assertFunction("format_number(999999999999999)", (Type)VarcharType.VARCHAR, "1000T");
        this.assertFunction("format_number(1000000000000000)", (Type)VarcharType.VARCHAR, "1Q");
        this.assertFunction("format_number(9223372036854775807)", (Type)VarcharType.VARCHAR, "9223Q");
        this.assertFunction("format_number(CAST(NULL AS TINYINT))", (Type)VarcharType.VARCHAR, null);
        this.assertFunction("format_number(CAST(NULL AS SMALLINT))", (Type)VarcharType.VARCHAR, null);
        this.assertFunction("format_number(CAST(NULL AS INTEGER))", (Type)VarcharType.VARCHAR, null);
        this.assertFunction("format_number(CAST(NULL AS DOUBLE))", (Type)VarcharType.VARCHAR, null);
        this.assertFunction("format_number(CAST(NULL AS REAL))", (Type)VarcharType.VARCHAR, null);
        this.assertFunction("format_number(CAST(NULL AS DECIMAL))", (Type)VarcharType.VARCHAR, null);
    }
}

