/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import io.trino.json.JsonInputErrorNode;
import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.Type;
import io.trino.type.Json2016Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import org.testng.annotations.Test;

public class TestJsonInputFunctions
extends AbstractTestFunctions {
    private static final String INPUT = "{\"key1\" : 1e0, \"key2\" : true, \"key3\" : null}";
    private static final JsonNode JSON_OBJECT = new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key1", (Object)DoubleNode.valueOf((double)1.0), (Object)"key2", (Object)BooleanNode.TRUE, (Object)"key3", (Object)NullNode.instance));
    private static final String ERROR_INPUT = "[...";

    @Test
    public void testVarcharToJson() {
        this.assertFunction("\"$varchar_to_json\"('[]', true)", (Type)Json2016Type.JSON_2016, new ArrayNode(JsonNodeFactory.instance));
        this.assertFunction("\"$varchar_to_json\"('{\"key1\" : 1e0, \"key2\" : true, \"key3\" : null}', true)", (Type)Json2016Type.JSON_2016, JSON_OBJECT);
        this.assertInvalidFunction("\"$varchar_to_json\"('[...', true)", (ErrorCodeSupplier)StandardErrorCode.JSON_INPUT_CONVERSION_ERROR, "conversion to JSON failed: ");
        this.assertFunction("\"$varchar_to_json\"('[...', false)", (Type)Json2016Type.JSON_2016, JsonInputErrorNode.JSON_ERROR);
    }

    @Test
    public void testVarbinaryUtf8ToJson() {
        byte[] bytes = INPUT.getBytes(StandardCharsets.UTF_8);
        String varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        this.assertFunction("\"$varbinary_to_json\"(" + varbinaryLiteral + ", true)", (Type)Json2016Type.JSON_2016, JSON_OBJECT);
        this.assertFunction("\"$varbinary_utf8_to_json\"(" + varbinaryLiteral + ", true)", (Type)Json2016Type.JSON_2016, JSON_OBJECT);
        bytes = INPUT.getBytes(StandardCharsets.UTF_16LE);
        varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        this.assertInvalidFunction("\"$varbinary_utf8_to_json\"(" + varbinaryLiteral + ", true)", (ErrorCodeSupplier)StandardErrorCode.JSON_INPUT_CONVERSION_ERROR, "conversion to JSON failed: ");
        this.assertFunction("\"$varbinary_utf8_to_json\"(" + varbinaryLiteral + ", false)", (Type)Json2016Type.JSON_2016, JsonInputErrorNode.JSON_ERROR);
        bytes = ERROR_INPUT.getBytes(StandardCharsets.UTF_8);
        varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        this.assertInvalidFunction("\"$varbinary_utf8_to_json\"(" + varbinaryLiteral + ", true)", (ErrorCodeSupplier)StandardErrorCode.JSON_INPUT_CONVERSION_ERROR, "conversion to JSON failed: ");
        this.assertFunction("\"$varbinary_utf8_to_json\"(" + varbinaryLiteral + ", false)", (Type)Json2016Type.JSON_2016, JsonInputErrorNode.JSON_ERROR);
    }

    @Test
    public void testVarbinaryUtf16ToJson() {
        byte[] bytes = INPUT.getBytes(StandardCharsets.UTF_16LE);
        String varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        this.assertFunction("\"$varbinary_utf16_to_json\"(" + varbinaryLiteral + ", true)", (Type)Json2016Type.JSON_2016, JSON_OBJECT);
        bytes = INPUT.getBytes(StandardCharsets.UTF_16BE);
        varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        this.assertInvalidFunction("\"$varbinary_utf16_to_json\"(" + varbinaryLiteral + ", true)", (ErrorCodeSupplier)StandardErrorCode.JSON_INPUT_CONVERSION_ERROR, "conversion to JSON failed: ");
        bytes = INPUT.getBytes(StandardCharsets.UTF_8);
        varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        this.assertInvalidFunction("\"$varbinary_utf16_to_json\"(" + varbinaryLiteral + ", true)", (ErrorCodeSupplier)StandardErrorCode.JSON_INPUT_CONVERSION_ERROR, "conversion to JSON failed: ");
        this.assertFunction("\"$varbinary_utf16_to_json\"(" + varbinaryLiteral + ", false)", (Type)Json2016Type.JSON_2016, JsonInputErrorNode.JSON_ERROR);
        bytes = ERROR_INPUT.getBytes(StandardCharsets.UTF_16LE);
        varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        this.assertInvalidFunction("\"$varbinary_utf16_to_json\"(" + varbinaryLiteral + ", true)", (ErrorCodeSupplier)StandardErrorCode.JSON_INPUT_CONVERSION_ERROR, "conversion to JSON failed: ");
        this.assertFunction("\"$varbinary_utf16_to_json\"(" + varbinaryLiteral + ", false)", (Type)Json2016Type.JSON_2016, JsonInputErrorNode.JSON_ERROR);
    }

    @Test
    public void testVarbinaryUtf32ToJson() {
        byte[] bytes = INPUT.getBytes(Charset.forName("UTF-32LE"));
        String varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        this.assertFunction("\"$varbinary_utf32_to_json\"(" + varbinaryLiteral + ", true)", (Type)Json2016Type.JSON_2016, JSON_OBJECT);
        bytes = INPUT.getBytes(Charset.forName("UTF-32BE"));
        varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        this.assertInvalidFunction("\"$varbinary_utf32_to_json\"(" + varbinaryLiteral + ", true)", (ErrorCodeSupplier)StandardErrorCode.JSON_INPUT_CONVERSION_ERROR, "conversion to JSON failed: ");
        bytes = INPUT.getBytes(StandardCharsets.UTF_8);
        varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        this.assertInvalidFunction("\"$varbinary_utf32_to_json\"(" + varbinaryLiteral + ", true)", (ErrorCodeSupplier)StandardErrorCode.JSON_INPUT_CONVERSION_ERROR, "conversion to JSON failed: ");
        this.assertFunction("\"$varbinary_utf32_to_json\"(" + varbinaryLiteral + ", false)", (Type)Json2016Type.JSON_2016, JsonInputErrorNode.JSON_ERROR);
        bytes = ERROR_INPUT.getBytes(Charset.forName("UTF-32LE"));
        varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        this.assertInvalidFunction("\"$varbinary_utf32_to_json\"(" + varbinaryLiteral + ", true)", (ErrorCodeSupplier)StandardErrorCode.JSON_INPUT_CONVERSION_ERROR, "conversion to JSON failed: ");
        this.assertFunction("\"$varbinary_utf32_to_json\"(" + varbinaryLiteral + ", false)", (Type)Json2016Type.JSON_2016, JsonInputErrorNode.JSON_ERROR);
    }

    @Test
    public void testNullInput() {
        this.assertFunction("\"$varchar_to_json\"(null, true)", (Type)Json2016Type.JSON_2016, null);
    }

    @Test
    public void testDuplicateObjectKeys() {
        this.assertAmbiguousFunction("\"$varchar_to_json\"('{\"key\" : 1, \"key\" : 2}', true)", (Type)Json2016Type.JSON_2016, (Set<Object>)ImmutableSet.of((Object)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key", (Object)IntNode.valueOf((int)1))), (Object)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"key", (Object)IntNode.valueOf((int)2)))));
    }
}

