/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.metadata.SqlFunction;
import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.operator.scalar.ApplyFunction;
import io.trino.operator.scalar.InvokeFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.TestingSession;
import io.trino.util.StructuralTestUtil;
import java.util.List;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestLambdaExpression
extends AbstractTestFunctions {
    public TestLambdaExpression() {
        super(TestingSession.testSessionBuilder().setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"Pacific/Kiritimati")).build());
    }

    @BeforeClass
    public void setUp() {
        this.functionAssertions.addFunctions((FunctionBundle)new InternalFunctionBundle(new SqlFunction[]{ApplyFunction.APPLY_FUNCTION, InvokeFunction.INVOKE_FUNCTION}));
    }

    @Test
    public void testBasic() {
        this.assertFunction("apply(5, x -> x + 1)", (Type)IntegerType.INTEGER, 6);
        this.assertFunction("apply(5 + RANDOM(1), x -> x + 1)", (Type)IntegerType.INTEGER, 6);
    }

    @Test
    public void testParameterName() {
        String nonLetters = "a.b c; d ' \n \\n \"";
        this.assertFunction("apply(5, " + TestLambdaExpression.quote(nonLetters) + " -> " + TestLambdaExpression.quote(nonLetters) + " * 2)", (Type)IntegerType.INTEGER, 10);
    }

    @Test
    public void testNull() {
        this.assertFunction("apply(3, x -> x + 1)", (Type)IntegerType.INTEGER, 4);
        this.assertFunction("apply(NULL, x -> x + 1)", (Type)IntegerType.INTEGER, null);
        this.assertFunction("apply(CAST (NULL AS INTEGER), x -> x + 1)", (Type)IntegerType.INTEGER, null);
        this.assertFunction("apply(3, x -> x IS NULL)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("apply(NULL, x -> x IS NULL)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("apply(CAST (NULL AS INTEGER), x -> x IS NULL)", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testUnreferencedLambdaArgument() {
        this.assertFunction("apply(5, x -> 6)", (Type)IntegerType.INTEGER, 6);
    }

    @Test
    public void testLambdaWithoutArgument() {
        this.assertFunction("invoke(() -> 42)", (Type)IntegerType.INTEGER, 42);
    }

    @Test
    public void testSessionDependent() {
        this.assertFunction("apply('timezone: ', x -> x || current_timezone())", (Type)VarcharType.VARCHAR, "timezone: Pacific/Kiritimati");
    }

    @Test
    public void testInstanceFunction() {
        this.assertFunction("apply(ARRAY[2], x -> concat(ARRAY [1], x))", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)1, (Object)2));
    }

    @Test
    public void testNestedLambda() {
        this.assertFunction("apply(11, x -> apply(x + 7, y -> apply(y * 3, z -> z * 5) + 1) * 2)", (Type)IntegerType.INTEGER, 542);
        this.assertFunction("apply(11, x -> apply(x + 7, x -> apply(x * 3, x -> x * 5) + 1) * 2)", (Type)IntegerType.INTEGER, 542);
    }

    @Test
    public void testRowAccess() {
        this.assertFunction("apply(CAST(ROW(1, 'a') AS ROW(x INTEGER, y VARCHAR)), r -> r[1])", (Type)IntegerType.INTEGER, 1);
        this.assertFunction("apply(CAST(ROW(1, 'a') AS ROW(x INTEGER, y VARCHAR)), r -> r[2])", (Type)VarcharType.VARCHAR, "a");
    }

    @Test
    public void testBind() {
        this.assertFunction("apply(90, \"$internal$bind\"(9, (x, y) -> x + y))", (Type)IntegerType.INTEGER, 99);
        this.assertFunction("invoke(\"$internal$bind\"(8, x -> x + 1))", (Type)IntegerType.INTEGER, 9);
        this.assertFunction("apply(900, \"$internal$bind\"(90, 9, (x, y, z) -> x + y + z))", (Type)IntegerType.INTEGER, 999);
        this.assertFunction("invoke(\"$internal$bind\"(90, 9, (x, y) -> x + y))", (Type)IntegerType.INTEGER, 99);
    }

    @Test
    public void testCoercion() {
        this.assertFunction("apply(90, x -> x + 9.0E0)", (Type)DoubleType.DOUBLE, 99.0);
        this.assertFunction("apply(90, \"$internal$bind\"(9.0E0, (x, y) -> x + y))", (Type)DoubleType.DOUBLE, 99.0);
        this.assertFunction("invoke(\"$internal$bind\"(8, x -> x + 1.0E0))", (Type)DoubleType.DOUBLE, 9.0);
    }

    @Test
    public void testTypeCombinations() {
        this.assertFunction("apply(25, x -> x + 1)", (Type)IntegerType.INTEGER, 26);
        this.assertFunction("apply(25, x -> x + 1.0E0)", (Type)DoubleType.DOUBLE, 26.0);
        this.assertFunction("apply(25, x -> x = 25)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("apply(25, x -> to_base(x, 16))", (Type)VarcharType.createVarcharType((int)64), "19");
        this.assertFunction("apply(25, x -> ARRAY[x + 1])", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)26));
        this.assertFunction("apply(25.6E0, x -> CAST(x AS BIGINT))", (Type)BigintType.BIGINT, 26L);
        this.assertFunction("apply(25.6E0, x -> x + 1.0E0)", (Type)DoubleType.DOUBLE, 26.6);
        this.assertFunction("apply(25.6E0, x -> x = 25.6E0)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("apply(25.6E0, x -> CAST(x AS VARCHAR))", (Type)VarcharType.createUnboundedVarcharType(), "2.56E1");
        this.assertFunction("apply(25.6E0, x -> MAP(ARRAY[x + 1], ARRAY[true]))", (Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)BooleanType.BOOLEAN), ImmutableMap.of((Object)26.6, (Object)true));
        this.assertFunction("apply(true, x -> if(x, 25, 26))", (Type)IntegerType.INTEGER, 25);
        this.assertFunction("apply(false, x -> if(x, 25.6E0, 28.9E0))", (Type)DoubleType.DOUBLE, 28.9);
        this.assertFunction("apply(true, x -> not x)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("apply(false, x -> CAST(x AS VARCHAR))", (Type)VarcharType.createUnboundedVarcharType(), "false");
        this.assertFunction("apply(true, x -> ARRAY[x])", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true));
        this.assertFunction("apply('41', x -> from_base(x, 16))", (Type)BigintType.BIGINT, 65L);
        this.assertFunction("apply('25.6E0', x -> CAST(x AS DOUBLE))", (Type)DoubleType.DOUBLE, 25.6);
        this.assertFunction("apply('abc', x -> 'abc' = x)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("apply('abc', x -> x || x)", (Type)VarcharType.createUnboundedVarcharType(), "abcabc");
        this.assertFunction("apply('123', x -> ROW(x, CAST(x AS INTEGER), x > '0'))", (Type)RowType.anonymous((List)ImmutableList.of((Object)VarcharType.createVarcharType((int)3), (Object)IntegerType.INTEGER, (Object)BooleanType.BOOLEAN)), ImmutableList.of((Object)"123", (Object)123, (Object)true));
        this.assertFunction("apply(ARRAY['abc', NULL, '123'], x -> from_base(x[3], 10))", (Type)BigintType.BIGINT, 123L);
        this.assertFunction("apply(ARRAY['abc', NULL, '123'], x -> CAST(x[3] AS DOUBLE))", (Type)DoubleType.DOUBLE, 123.0);
        this.assertFunction("apply(ARRAY['abc', NULL, '123'], x -> x[2] IS NULL)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("apply(ARRAY['abc', NULL, '123'], x -> x[2])", (Type)VarcharType.createVarcharType((int)3), null);
        this.assertFunction("apply(MAP(ARRAY['abc', 'def'], ARRAY[123, 456]), x -> map_keys(x))", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of((Object)"abc", (Object)"def"));
    }

    @Test
    public void testFunctionParameter() {
        this.assertInvalidFunction("count(x -> x)", (ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, "line 1:1: Unexpected parameters (<function>) for function count. Expected: count(), count(t) T");
        this.assertInvalidFunction("max(x -> x)", (ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, "line 1:1: Unexpected parameters (<function>) for function max. Expected: max(t) T:orderable, max(e, bigint) E:orderable");
        this.assertInvalidFunction("sqrt(x -> x)", (ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, "line 1:1: Unexpected parameters (<function>) for function sqrt. Expected: sqrt(double)");
        this.assertInvalidFunction("sqrt(x -> x, 123, x -> x)", (ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, "line 1:1: Unexpected parameters (<function>, integer, <function>) for function sqrt. Expected: sqrt(double)");
        this.assertInvalidFunction("pow(x -> x, 123)", (ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, "line 1:1: Unexpected parameters (<function>, integer) for function pow. Expected: pow(double, double)");
        this.assertInvalidFunction("pow(123, x -> x)", (ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, "line 1:1: Unexpected parameters (integer, <function>) for function pow. Expected: pow(double, double)");
    }

    private static String quote(String identifier) {
        return "\"" + identifier.replace("\"", "\"\"") + "\"";
    }
}

