/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import org.testng.annotations.Test;

public class TestLuhnCheckFunction
extends AbstractTestFunctions {
    @Test
    public void testLuhnCheck() {
        this.assertFunction("luhn_check('4242424242424242')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("luhn_check('1234567891234567')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("luhn_check('')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("luhn_check(NULL)", (Type)BooleanType.BOOLEAN, null);
        this.assertInvalidFunction("luhn_check('abcd424242424242')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertFunction("luhn_check('123456789')", (Type)BooleanType.BOOLEAN, false);
        this.assertInvalidFunction("luhn_check('\u4ea0\u4eff\u4ea112345')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("luhn_check('4242\u4fe124242424242')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
    }
}

