/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.type.JsonType;
import io.trino.type.UnknownType;
import java.util.Arrays;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestTryFunction
extends AbstractTestFunctions {
    @BeforeClass
    public void setUp() {
        this.registerScalar(this.getClass());
    }

    @ScalarFunction
    @SqlType(value="bigint")
    public static long throwError() {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "internal error, should not be suppressed by $internal$try");
    }

    @Test
    public void testBasic() {
        this.assertFunction(TestTryFunction.createTryExpression("42"), (Type)IntegerType.INTEGER, 42);
        this.assertFunction(TestTryFunction.createTryExpression("DOUBLE '4.5'"), (Type)DoubleType.DOUBLE, 4.5);
        this.assertFunction(TestTryFunction.createTryExpression("DECIMAL '4.5'"), (Type)DecimalType.createDecimalType((int)2, (int)1), SqlDecimal.decimal((String)"4.5", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        this.assertFunction(TestTryFunction.createTryExpression("TRUE"), (Type)BooleanType.BOOLEAN, true);
        this.assertFunction(TestTryFunction.createTryExpression("'hello'"), (Type)VarcharType.createVarcharType((int)5), "hello");
        this.assertFunction(TestTryFunction.createTryExpression("JSON '[true, false, 12, 12.7, \"12\", null]'"), (Type)JsonType.JSON, "[true,false,12,12.7,\"12\",null]");
        this.assertFunction(TestTryFunction.createTryExpression("ARRAY [1, 2]"), (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(1, 2));
        this.assertFunction(TestTryFunction.createTryExpression("TIMESTAMP '2020-05-10 12:34:56.123456789'"), (Type)TimestampType.createTimestampType((int)9), TestTryFunction.timestamp(9, "2020-05-10 12:34:56.123456789"));
        this.assertFunction(TestTryFunction.createTryExpression("NULL"), (Type)UnknownType.UNKNOWN, null);
    }

    @Test
    public void testExceptions() {
        this.assertFunction(TestTryFunction.createTryExpression("1/0"), (Type)IntegerType.INTEGER, null);
        this.assertFunction(TestTryFunction.createTryExpression("JSON_PARSE('INVALID')"), (Type)JsonType.JSON, null);
        this.assertFunction(TestTryFunction.createTryExpression("CAST(NULL AS INTEGER)"), (Type)IntegerType.INTEGER, null);
        this.assertFunction(TestTryFunction.createTryExpression("CAST('0000-00-01' AS TIMESTAMP)"), (Type)TimestampType.TIMESTAMP_MILLIS, null);
        this.assertFunction(TestTryFunction.createTryExpression("CAST('0000-01-00' AS TIMESTAMP)"), (Type)TimestampType.TIMESTAMP_MILLIS, null);
        this.assertFunction(TestTryFunction.createTryExpression("CAST('0000-01-01 ABC' AS TIMESTAMP WITH TIME ZONE)"), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, null);
        this.assertFunction(TestTryFunction.createTryExpression("ABS(-9223372036854775807 - 1)"), (Type)BigintType.BIGINT, null);
        this.assertInvalidFunction(TestTryFunction.createTryExpression("throw_error()"), (ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR);
    }

    private static String createTryExpression(String expression) {
        return "\"$internal$try\"(() -> " + expression + ")";
    }
}

