/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamp;

import io.trino.Session;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.function.BiFunction;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestTimestamp {
    private static final TimeZoneKey SESSION_TIME_ZONE = TestingSession.DEFAULT_TIME_ZONE_KEY;
    protected QueryAssertions assertions;

    @BeforeClass
    public void init() {
        Session session = TestingSession.testSessionBuilder().setTimeZoneKey(SESSION_TIME_ZONE).build();
        this.assertions = new QueryAssertions(session);
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testToUnixTime() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56')")))).matches("1589067296e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("1589067296.1e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("1589067296.12e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("1589067296.123e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("1589067296.1234e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("1589067296.1234498e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("1589067296.123456e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("1589067296.1234567e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("1589067296.1234567e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("1589067296.1234567e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("1589067296.1234567e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("1589067296.1234567e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("1589067296.1234567e0");
    }

    @Test
    public void testLiterals() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56'")))).hasType((Type)TimestampType.createTimestampType((int)0)).isEqualTo(TestTimestamp.timestamp(0, 2020, 5, 1, 12, 34, 56, 0L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1'")))).hasType((Type)TimestampType.createTimestampType((int)1)).isEqualTo(TestTimestamp.timestamp(1, 2020, 5, 1, 12, 34, 56, 100000000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12'")))).hasType((Type)TimestampType.createTimestampType((int)2)).isEqualTo(TestTimestamp.timestamp(2, 2020, 5, 1, 12, 34, 56, 120000000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123'")))).hasType((Type)TimestampType.createTimestampType((int)3)).isEqualTo(TestTimestamp.timestamp(3, 2020, 5, 1, 12, 34, 56, 123000000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234'")))).hasType((Type)TimestampType.createTimestampType((int)4)).isEqualTo(TestTimestamp.timestamp(4, 2020, 5, 1, 12, 34, 56, 123400000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345'")))).hasType((Type)TimestampType.createTimestampType((int)5)).isEqualTo(TestTimestamp.timestamp(5, 2020, 5, 1, 12, 34, 56, 123450000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456'")))).hasType((Type)TimestampType.createTimestampType((int)6)).isEqualTo(TestTimestamp.timestamp(6, 2020, 5, 1, 12, 34, 56, 123456000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567'")))).hasType((Type)TimestampType.createTimestampType((int)7)).isEqualTo(TestTimestamp.timestamp(7, 2020, 5, 1, 12, 34, 56, 123456700000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678'")))).hasType((Type)TimestampType.createTimestampType((int)8)).isEqualTo(TestTimestamp.timestamp(8, 2020, 5, 1, 12, 34, 56, 123456780000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789'")))).hasType((Type)TimestampType.createTimestampType((int)9)).isEqualTo(TestTimestamp.timestamp(9, 2020, 5, 1, 12, 34, 56, 123456789000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890'")))).hasType((Type)TimestampType.createTimestampType((int)10)).isEqualTo(TestTimestamp.timestamp(10, 2020, 5, 1, 12, 34, 56, 123456789000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901'")))).hasType((Type)TimestampType.createTimestampType((int)11)).isEqualTo(TestTimestamp.timestamp(11, 2020, 5, 1, 12, 34, 56, 123456789010L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012'")))).hasType((Type)TimestampType.createTimestampType((int)12)).isEqualTo(TestTimestamp.timestamp(12, 2020, 5, 1, 12, 34, 56, 123456789012L));
        Assertions.assertThatThrownBy(() -> this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890123'")).hasMessage("line 1:8: TIMESTAMP precision must be in range [0, 12]: 13");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("TIMESTAMP '2020-13-01'")).hasMessage("line 1:8: '2020-13-01' is not a valid timestamp literal");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("TIMESTAMP 'xxx'")).hasMessage("line 1:8: 'xxx' is not a valid timestamp literal");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56'")))).isEqualTo(TestTimestamp.timestamp(0, 1500, 5, 1, 12, 34, 56, 0L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.1'")))).isEqualTo(TestTimestamp.timestamp(1, 1500, 5, 1, 12, 34, 56, 100000000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.12'")))).isEqualTo(TestTimestamp.timestamp(2, 1500, 5, 1, 12, 34, 56, 120000000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.123'")))).isEqualTo(TestTimestamp.timestamp(3, 1500, 5, 1, 12, 34, 56, 123000000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.1234'")))).isEqualTo(TestTimestamp.timestamp(4, 1500, 5, 1, 12, 34, 56, 123400000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.12345'")))).isEqualTo(TestTimestamp.timestamp(5, 1500, 5, 1, 12, 34, 56, 123450000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.123456'")))).isEqualTo(TestTimestamp.timestamp(6, 1500, 5, 1, 12, 34, 56, 123456000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.1234567'")))).isEqualTo(TestTimestamp.timestamp(7, 1500, 5, 1, 12, 34, 56, 123456700000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.12345678'")))).isEqualTo(TestTimestamp.timestamp(8, 1500, 5, 1, 12, 34, 56, 123456780000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.123456789'")))).isEqualTo(TestTimestamp.timestamp(9, 1500, 5, 1, 12, 34, 56, 123456789000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.1234567890'")))).isEqualTo(TestTimestamp.timestamp(10, 1500, 5, 1, 12, 34, 56, 123456789000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.12345678901'")))).isEqualTo(TestTimestamp.timestamp(11, 1500, 5, 1, 12, 34, 56, 123456789010L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.123456789012'")))).isEqualTo(TestTimestamp.timestamp(12, 1500, 5, 1, 12, 34, 56, 123456789012L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '123001-05-01 12:34:56'")))).isEqualTo(TestTimestamp.timestamp(0, 123001, 5, 1, 12, 34, 56, 0L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '123001-05-01 12:34:56.1'")))).isEqualTo(TestTimestamp.timestamp(1, 123001, 5, 1, 12, 34, 56, 100000000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '123001-05-01 12:34:56.12'")))).isEqualTo(TestTimestamp.timestamp(2, 123001, 5, 1, 12, 34, 56, 120000000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '123001-05-01 12:34:56.123'")))).isEqualTo(TestTimestamp.timestamp(3, 123001, 5, 1, 12, 34, 56, 123000000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '123001-05-01 12:34:56.1234'")))).isEqualTo(TestTimestamp.timestamp(4, 123001, 5, 1, 12, 34, 56, 123400000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '123001-05-01 12:34:56.12345'")))).isEqualTo(TestTimestamp.timestamp(5, 123001, 5, 1, 12, 34, 56, 123450000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '123001-05-01 12:34:56.123456'")))).isEqualTo(TestTimestamp.timestamp(6, 123001, 5, 1, 12, 34, 56, 123456000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '123001-05-01 12:34:56.1234567'")))).isEqualTo(TestTimestamp.timestamp(7, 123001, 5, 1, 12, 34, 56, 123456700000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '123001-05-01 12:34:56.12345678'")))).isEqualTo(TestTimestamp.timestamp(8, 123001, 5, 1, 12, 34, 56, 123456780000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '123001-05-01 12:34:56.123456789'")))).isEqualTo(TestTimestamp.timestamp(9, 123001, 5, 1, 12, 34, 56, 123456789000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '123001-05-01 12:34:56.1234567890'")))).isEqualTo(TestTimestamp.timestamp(10, 123001, 5, 1, 12, 34, 56, 123456789000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '123001-05-01 12:34:56.12345678901'")))).isEqualTo(TestTimestamp.timestamp(11, 123001, 5, 1, 12, 34, 56, 123456789010L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '123001-05-01 12:34:56.123456789012'")))).isEqualTo(TestTimestamp.timestamp(12, 123001, 5, 1, 12, 34, 56, 123456789012L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+123001-05-01 12:34:56'")))).isEqualTo(TestTimestamp.timestamp(0, 123001, 5, 1, 12, 34, 56, 0L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+123001-05-01 12:34:56.1'")))).isEqualTo(TestTimestamp.timestamp(1, 123001, 5, 1, 12, 34, 56, 100000000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+123001-05-01 12:34:56.12'")))).isEqualTo(TestTimestamp.timestamp(2, 123001, 5, 1, 12, 34, 56, 120000000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+123001-05-01 12:34:56.123'")))).isEqualTo(TestTimestamp.timestamp(3, 123001, 5, 1, 12, 34, 56, 123000000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+123001-05-01 12:34:56.1234'")))).isEqualTo(TestTimestamp.timestamp(4, 123001, 5, 1, 12, 34, 56, 123400000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+123001-05-01 12:34:56.12345'")))).isEqualTo(TestTimestamp.timestamp(5, 123001, 5, 1, 12, 34, 56, 123450000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+123001-05-01 12:34:56.123456'")))).isEqualTo(TestTimestamp.timestamp(6, 123001, 5, 1, 12, 34, 56, 123456000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+123001-05-01 12:34:56.1234567'")))).isEqualTo(TestTimestamp.timestamp(7, 123001, 5, 1, 12, 34, 56, 123456700000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+123001-05-01 12:34:56.12345678'")))).isEqualTo(TestTimestamp.timestamp(8, 123001, 5, 1, 12, 34, 56, 123456780000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+123001-05-01 12:34:56.123456789'")))).isEqualTo(TestTimestamp.timestamp(9, 123001, 5, 1, 12, 34, 56, 123456789000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+123001-05-01 12:34:56.1234567890'")))).isEqualTo(TestTimestamp.timestamp(10, 123001, 5, 1, 12, 34, 56, 123456789000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+123001-05-01 12:34:56.12345678901'")))).isEqualTo(TestTimestamp.timestamp(11, 123001, 5, 1, 12, 34, 56, 123456789010L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+123001-05-01 12:34:56.123456789012'")))).isEqualTo(TestTimestamp.timestamp(12, 123001, 5, 1, 12, 34, 56, 123456789012L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-123001-05-01 12:34:56'")))).isEqualTo(TestTimestamp.timestamp(0, -123001, 5, 1, 12, 34, 56, 0L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-123001-05-01 12:34:56.1'")))).isEqualTo(TestTimestamp.timestamp(1, -123001, 5, 1, 12, 34, 56, 100000000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-123001-05-01 12:34:56.12'")))).isEqualTo(TestTimestamp.timestamp(2, -123001, 5, 1, 12, 34, 56, 120000000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-123001-05-01 12:34:56.123'")))).isEqualTo(TestTimestamp.timestamp(3, -123001, 5, 1, 12, 34, 56, 123000000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-123001-05-01 12:34:56.1234'")))).isEqualTo(TestTimestamp.timestamp(4, -123001, 5, 1, 12, 34, 56, 123400000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-123001-05-01 12:34:56.12345'")))).isEqualTo(TestTimestamp.timestamp(5, -123001, 5, 1, 12, 34, 56, 123450000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-123001-05-01 12:34:56.123456'")))).isEqualTo(TestTimestamp.timestamp(6, -123001, 5, 1, 12, 34, 56, 123456000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-123001-05-01 12:34:56.1234567'")))).isEqualTo(TestTimestamp.timestamp(7, -123001, 5, 1, 12, 34, 56, 123456700000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-123001-05-01 12:34:56.12345678'")))).isEqualTo(TestTimestamp.timestamp(8, -123001, 5, 1, 12, 34, 56, 123456780000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-123001-05-01 12:34:56.123456789'")))).isEqualTo(TestTimestamp.timestamp(9, -123001, 5, 1, 12, 34, 56, 123456789000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-123001-05-01 12:34:56.1234567890'")))).isEqualTo(TestTimestamp.timestamp(10, -123001, 5, 1, 12, 34, 56, 123456789000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-123001-05-01 12:34:56.12345678901'")))).isEqualTo(TestTimestamp.timestamp(11, -123001, 5, 1, 12, 34, 56, 123456789010L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-123001-05-01 12:34:56.123456789012'")))).isEqualTo(TestTimestamp.timestamp(12, -123001, 5, 1, 12, 34, 56, 123456789012L));
    }

    @Test
    public void testLocalTimestamp() {
        Session session = this.assertions.sessionBuilder().setStart(Instant.from(ZonedDateTime.of(2020, 5, 1, 12, 34, 56, 111111111, this.assertions.getDefaultSession().getTimeZoneKey().getZoneId()))).build();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(0)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(1)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(2)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(3)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(4)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(5)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(6)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(7)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(8)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(9)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(10)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111110'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(11)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(12)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111000'");
        session = this.assertions.sessionBuilder().setStart(Instant.from(ZonedDateTime.of(2020, 5, 1, 12, 34, 56, 555555555, this.assertions.getDefaultSession().getTimeZoneKey().getZoneId()))).build();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(0)", session)))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(1)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(2)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(3)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(4)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(5)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(6)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(7)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(8)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(9)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555555555'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(10)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5555555550'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(11)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55555555500'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtimestamp(12)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555555555000'");
    }

    @Test
    public void testCastToDate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567890' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678901' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789012' AS DATE)")))).matches("DATE '2020-05-01'");
    }

    @Test
    public void testCastFromDate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 00:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 00:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 00:00:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 00:00:00.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-01 00:00:00.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-01 00:00:00.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-01 00:00:00.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(11))")))).matches("TIMESTAMP '2020-05-01 00:00:00.00000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-01 00:00:00.000000000000'");
    }

    @Test
    public void testCastToTime() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIME(2))")))).matches("TIME '12:34:56.12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIME(3))")))).matches("TIME '12:34:56.123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIME(4))")))).matches("TIME '12:34:56.1234'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS TIME(5))")))).matches("TIME '12:34:56.12345'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456' AS TIME(6))")))).matches("TIME '12:34:56.123456'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567' AS TIME(7))")))).matches("TIME '12:34:56.1234567'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678' AS TIME(8))")))).matches("TIME '12:34:56.12345678'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789' AS TIME(9))")))).matches("TIME '12:34:56.123456789'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567891' AS TIME(10))")))).matches("TIME '12:34:56.1234567891'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678912' AS TIME(11))")))).matches("TIME '12:34:56.12345678912'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789123' AS TIME(12))")))).matches("TIME '12:34:56.123456789123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(1))")))).matches("TIME '12:34:56.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(2))")))).matches("TIME '12:34:56.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(3))")))).matches("TIME '12:34:56.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(4))")))).matches("TIME '12:34:56.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(5))")))).matches("TIME '12:34:56.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(6))")))).matches("TIME '12:34:56.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(7))")))).matches("TIME '12:34:56.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(8))")))).matches("TIME '12:34:56.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(9))")))).matches("TIME '12:34:56.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(10))")))).matches("TIME '12:34:56.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(11))")))).matches("TIME '12:34:56.00000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(12))")))).matches("TIME '12:34:56.000000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(2))")))).matches("TIME '12:34:56.10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(3))")))).matches("TIME '12:34:56.100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(4))")))).matches("TIME '12:34:56.1000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(5))")))).matches("TIME '12:34:56.10000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(6))")))).matches("TIME '12:34:56.100000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(7))")))).matches("TIME '12:34:56.1000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(8))")))).matches("TIME '12:34:56.10000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(9))")))).matches("TIME '12:34:56.100000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(10))")))).matches("TIME '12:34:56.1000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(11))")))).matches("TIME '12:34:56.10000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(12))")))).matches("TIME '12:34:56.100000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIME(3))")))).matches("TIME '12:34:56.120'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIME(4))")))).matches("TIME '12:34:56.1200'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIME(5))")))).matches("TIME '12:34:56.12000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIME(6))")))).matches("TIME '12:34:56.120000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIME(7))")))).matches("TIME '12:34:56.1200000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIME(8))")))).matches("TIME '12:34:56.12000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIME(9))")))).matches("TIME '12:34:56.120000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIME(10))")))).matches("TIME '12:34:56.1200000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIME(11))")))).matches("TIME '12:34:56.12000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIME(12))")))).matches("TIME '12:34:56.120000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIME(4))")))).matches("TIME '12:34:56.1230'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIME(5))")))).matches("TIME '12:34:56.12300'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIME(6))")))).matches("TIME '12:34:56.123000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIME(7))")))).matches("TIME '12:34:56.1230000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIME(8))")))).matches("TIME '12:34:56.12300000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIME(9))")))).matches("TIME '12:34:56.123000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIME(10))")))).matches("TIME '12:34:56.1230000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIME(11))")))).matches("TIME '12:34:56.12300000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIME(12))")))).matches("TIME '12:34:56.123000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIME(5))")))).matches("TIME '12:34:56.12340'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIME(6))")))).matches("TIME '12:34:56.123400'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIME(7))")))).matches("TIME '12:34:56.1234000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIME(8))")))).matches("TIME '12:34:56.12340000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIME(9))")))).matches("TIME '12:34:56.123400000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIME(10))")))).matches("TIME '12:34:56.1234000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIME(11))")))).matches("TIME '12:34:56.12340000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIME(12))")))).matches("TIME '12:34:56.123400000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS TIME(6))")))).matches("TIME '12:34:56.123450'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS TIME(7))")))).matches("TIME '12:34:56.1234500'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS TIME(8))")))).matches("TIME '12:34:56.12345000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS TIME(9))")))).matches("TIME '12:34:56.123450000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS TIME(10))")))).matches("TIME '12:34:56.1234500000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS TIME(11))")))).matches("TIME '12:34:56.12345000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS TIME(12))")))).matches("TIME '12:34:56.123450000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456' AS TIME(7))")))).matches("TIME '12:34:56.1234560'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456' AS TIME(8))")))).matches("TIME '12:34:56.12345600'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456' AS TIME(9))")))).matches("TIME '12:34:56.123456000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456' AS TIME(10))")))).matches("TIME '12:34:56.1234560000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456' AS TIME(11))")))).matches("TIME '12:34:56.12345600000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456' AS TIME(12))")))).matches("TIME '12:34:56.123456000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567' AS TIME(8))")))).matches("TIME '12:34:56.12345670'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567' AS TIME(9))")))).matches("TIME '12:34:56.123456700'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567' AS TIME(10))")))).matches("TIME '12:34:56.1234567000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567' AS TIME(11))")))).matches("TIME '12:34:56.12345670000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567' AS TIME(12))")))).matches("TIME '12:34:56.123456700000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678' AS TIME(9))")))).matches("TIME '12:34:56.123456780'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678' AS TIME(10))")))).matches("TIME '12:34:56.1234567800'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678' AS TIME(11))")))).matches("TIME '12:34:56.12345678000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678' AS TIME(12))")))).matches("TIME '12:34:56.123456780000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789' AS TIME(10))")))).matches("TIME '12:34:56.1234567890'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789' AS TIME(11))")))).matches("TIME '12:34:56.12345678900'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789' AS TIME(12))")))).matches("TIME '12:34:56.123456789000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567891' AS TIME(11))")))).matches("TIME '12:34:56.12345678910'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567891' AS TIME(12))")))).matches("TIME '12:34:56.123456789100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678912' AS TIME(12))")))).matches("TIME '12:34:56.123456789120'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111' AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111' AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111' AS TIME(7))")))).matches("TIME '12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIME(7))")))).matches("TIME '12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIME(7))")))).matches("TIME '12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIME(7))")))).matches("TIME '12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIME(7))")))).matches("TIME '12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIME(8))")))).matches("TIME '12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIME(8))")))).matches("TIME '12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIME(8))")))).matches("TIME '12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIME(8))")))).matches("TIME '12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIME(9))")))).matches("TIME '12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIME(9))")))).matches("TIME '12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIME(9))")))).matches("TIME '12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIME(10))")))).matches("TIME '12:34:56.1111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIME(10))")))).matches("TIME '12:34:56.1111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIME(11))")))).matches("TIME '12:34:56.11111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555' AS TIME(6))")))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555' AS TIME(6))")))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIME(6))")))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIME(6))")))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIME(6))")))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIME(6))")))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555' AS TIME(7))")))).matches("TIME '12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIME(7))")))).matches("TIME '12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIME(7))")))).matches("TIME '12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIME(7))")))).matches("TIME '12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIME(7))")))).matches("TIME '12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIME(8))")))).matches("TIME '12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIME(8))")))).matches("TIME '12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIME(8))")))).matches("TIME '12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIME(8))")))).matches("TIME '12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIME(9))")))).matches("TIME '12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIME(9))")))).matches("TIME '12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIME(9))")))).matches("TIME '12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIME(10))")))).matches("TIME '12:34:56.5555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIME(10))")))).matches("TIME '12:34:56.5555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIME(11))")))).matches("TIME '12:34:56.55555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '12001-05-01 12:34:56' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '-12001-05-01 12:34:56' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99' AS TIME(1))")))).matches("TIME '00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999' AS TIME(1))")))).matches("TIME '00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999' AS TIME(1))")))).matches("TIME '00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999' AS TIME(1))")))).matches("TIME '00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999' AS TIME(1))")))).matches("TIME '00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999' AS TIME(1))")))).matches("TIME '00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999' AS TIME(1))")))).matches("TIME '00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999' AS TIME(1))")))).matches("TIME '00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999' AS TIME(1))")))).matches("TIME '00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999' AS TIME(1))")))).matches("TIME '00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999' AS TIME(1))")))).matches("TIME '00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999' AS TIME(2))")))).matches("TIME '00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999' AS TIME(2))")))).matches("TIME '00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999' AS TIME(2))")))).matches("TIME '00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999' AS TIME(2))")))).matches("TIME '00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999' AS TIME(2))")))).matches("TIME '00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999' AS TIME(2))")))).matches("TIME '00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999' AS TIME(2))")))).matches("TIME '00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999' AS TIME(2))")))).matches("TIME '00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999' AS TIME(2))")))).matches("TIME '00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999' AS TIME(2))")))).matches("TIME '00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999' AS TIME(3))")))).matches("TIME '00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999' AS TIME(3))")))).matches("TIME '00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999' AS TIME(3))")))).matches("TIME '00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999' AS TIME(3))")))).matches("TIME '00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999' AS TIME(3))")))).matches("TIME '00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999' AS TIME(3))")))).matches("TIME '00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999' AS TIME(3))")))).matches("TIME '00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999' AS TIME(3))")))).matches("TIME '00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999' AS TIME(3))")))).matches("TIME '00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999' AS TIME(4))")))).matches("TIME '00:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999' AS TIME(4))")))).matches("TIME '00:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999' AS TIME(4))")))).matches("TIME '00:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999' AS TIME(4))")))).matches("TIME '00:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999' AS TIME(4))")))).matches("TIME '00:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999' AS TIME(4))")))).matches("TIME '00:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999' AS TIME(4))")))).matches("TIME '00:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999' AS TIME(4))")))).matches("TIME '00:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999' AS TIME(5))")))).matches("TIME '00:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999' AS TIME(5))")))).matches("TIME '00:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999' AS TIME(5))")))).matches("TIME '00:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999' AS TIME(5))")))).matches("TIME '00:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999' AS TIME(5))")))).matches("TIME '00:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999' AS TIME(5))")))).matches("TIME '00:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999' AS TIME(5))")))).matches("TIME '00:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999' AS TIME(6))")))).matches("TIME '00:00:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999' AS TIME(6))")))).matches("TIME '00:00:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999' AS TIME(6))")))).matches("TIME '00:00:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999' AS TIME(6))")))).matches("TIME '00:00:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999' AS TIME(6))")))).matches("TIME '00:00:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999' AS TIME(6))")))).matches("TIME '00:00:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999' AS TIME(7))")))).matches("TIME '00:00:00.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999' AS TIME(7))")))).matches("TIME '00:00:00.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999' AS TIME(7))")))).matches("TIME '00:00:00.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999' AS TIME(7))")))).matches("TIME '00:00:00.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999' AS TIME(7))")))).matches("TIME '00:00:00.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999' AS TIME(8))")))).matches("TIME '00:00:00.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999' AS TIME(8))")))).matches("TIME '00:00:00.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999' AS TIME(8))")))).matches("TIME '00:00:00.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999' AS TIME(8))")))).matches("TIME '00:00:00.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999' AS TIME(9))")))).matches("TIME '00:00:00.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999' AS TIME(9))")))).matches("TIME '00:00:00.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999' AS TIME(9))")))).matches("TIME '00:00:00.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999' AS TIME(10))")))).matches("TIME '00:00:00.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999' AS TIME(10))")))).matches("TIME '00:00:00.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999' AS TIME(11))")))).matches("TIME '00:00:00.00000000000'");
    }

    @Test
    public void testCastToTimeWithTimeZone() {
        Session session = this.assertions.sessionBuilder().setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"+08:35")).build();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1234+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12345+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123456+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1234567+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12345678+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123456789+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567891' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1234567891+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678912' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12345678912+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789123' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123456789123+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.0+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.0000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.00000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.0000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.00000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.0000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.00000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.000000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.10+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.100+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.10000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.100000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.10000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.100000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.10000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.100000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.120+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1200+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.120000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1200000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.120000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1200000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.120000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1230+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12300+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1230000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12300000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1230000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12300000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12340+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123400+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1234000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12340000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123400000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1234000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12340000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123400000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123450+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1234500+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12345000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123450000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1234500000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12345000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123450000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1234560+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12345600+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123456000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1234560000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12345600000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123456000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12345670+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123456700+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1234567000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12345670000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123456700000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123456780+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1234567800+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12345678000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123456780000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1234567890+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12345678900+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123456789000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567891' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12345678910+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567891' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123456789100+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678912' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123456789120+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11111111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:57+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:57+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:57+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:57+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:57+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:57+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:57+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:57+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:57+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:57+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:57+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:57+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.6+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.6+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.6+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.6+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.6+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.6+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.6+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.6+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.6+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.6+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.6+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.55556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.55556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.55556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.55556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.55556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.55556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.55556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.55555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.55555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.55555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.55555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.555555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.555555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.555555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5555555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5555555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.55555555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '12001-05-01 12:34:56' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '-12001-05-01 12:34:56' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '00:00:00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '00:00:00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '00:00:00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '00:00:00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '00:00:00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '00:00:00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '00:00:00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '00:00:00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '00:00:00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '00:00:00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '00:00:00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '00:00:00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.9999999999' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.99999999999' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 23:59:59.999999999999' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00000000000+08:35'");
    }

    @Test
    public void testCastToTimestampWithTimeZone() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.12 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.123 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234567 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345678 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456789 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567891' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234567891 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678912' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345678912 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789123' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456789123 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.0 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.00 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.0000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.00000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.0000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.00000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.0000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.00000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.000000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.10 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.100 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.10000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.100000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.10000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.100000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.10000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.100000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.120 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1200 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.12000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.120000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1200000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.12000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.120000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1200000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.12000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.120000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1230 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.12300 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.123000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1230000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.12300000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.123000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1230000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.12300000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.123000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.12340 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.123400 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.12340000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.123400000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.12340000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.123400000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.123450 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234500 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.123450000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234500000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.123450000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234560 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345600 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234560000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345600000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345670 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456700 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234567000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345670000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456700000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456780 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234567800 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345678000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456780000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234567890 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345678900 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456789000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567891' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345678910 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567891' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456789100 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678912' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456789120 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1111111111' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.11111111111' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.111111111111' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.5556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.5556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.5556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.5556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.5556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.5556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.5556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.5556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.55556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.55556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.55556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.55556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.55556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.55556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.55556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.55555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.55555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.55555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.55555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.5555555555' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.555555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.555555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.555555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.55555555555' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.5555555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.5555555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.555555555555' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.55555555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '12001-05-01 12:34:56' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '-12001-05-01 12:34:56' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56 Pacific/Apia'");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST(TIMESTAMP '123001-05-01 12:34:56' AS TIMESTAMP WITH TIME ZONE)")).hasMessage("Out of range for timestamp with time zone: 3819379822496000");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST(TIMESTAMP '-123001-05-01 12:34:56' AS TIMESTAMP WITH TIME ZONE)")).hasMessage("Out of range for timestamp with time zone: -3943693439888000");
    }

    @Test
    public void testCastToJson() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS JSON)")))).matches("JSON '\"2020-05-01 12:34:56\"'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS JSON)")))).matches("JSON '\"2020-05-01 12:34:56.1\"'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS JSON)")))).matches("JSON '\"2020-05-01 12:34:56.12\"'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS JSON)")))).matches("JSON '\"2020-05-01 12:34:56.123\"'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS JSON)")))).matches("JSON '\"2020-05-01 12:34:56.1234\"'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS JSON)")))).matches("JSON '\"2020-05-01 12:34:56.12345\"'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456' AS JSON)")))).matches("JSON '\"2020-05-01 12:34:56.123456\"'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567' AS JSON)")))).matches("JSON '\"2020-05-01 12:34:56.1234567\"'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678' AS JSON)")))).matches("JSON '\"2020-05-01 12:34:56.12345678\"'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789' AS JSON)")))).matches("JSON '\"2020-05-01 12:34:56.123456789\"'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567890' AS JSON)")))).matches("JSON '\"2020-05-01 12:34:56.1234567890\"'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678901' AS JSON)")))).matches("JSON '\"2020-05-01 12:34:56.12345678901\"'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789012' AS JSON)")))).matches("JSON '\"2020-05-01 12:34:56.123456789012\"'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '123001-05-01 12:34:56.123456789012' AS JSON)")))).matches("JSON '\"+123001-05-01 12:34:56.123456789012\"'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '-123001-05-01 12:34:56.123456789012' AS JSON)")))).matches("JSON '\"-123001-05-01 12:34:56.123456789012\"'");
    }

    @Test
    public void testCastToVarchar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.12");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.123");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.1234");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.12345");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.123456");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.1234567");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.12345678");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.123456789");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567890' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.1234567890");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678901' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.12345678901");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789012' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.123456789012");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.1' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.12' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.12");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.123' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.123");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.1234' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.1234");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.12345' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.12345");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.123456' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.123456");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.1234567' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.1234567");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.12345678' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.12345678");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.123456789' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.123456789");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.1234567890' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.1234567890");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.12345678901' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.12345678901");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.123456789012' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.123456789012");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '123001-05-01 12:34:56' AS VARCHAR)")))).isEqualTo("+123001-05-01 12:34:56");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '-123001-05-01 12:34:56' AS VARCHAR)")))).isEqualTo("-123001-05-01 12:34:56");
    }

    @Test
    public void testCastFromVarchar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(11))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-01 12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-01 12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-01 12:34:56.5555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555' AS TIMESTAMP(11))")))).matches("TIMESTAMP '2020-05-01 12:34:56.55555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555' AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-01 12:34:56.555555555555'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(11))")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111' AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('1500-05-01 12:34:56.555555555555' AS TIMESTAMP(0))")))).matches("TIMESTAMP '1500-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('1500-05-01 12:34:56.555555555555' AS TIMESTAMP(1))")))).matches("TIMESTAMP '1500-05-01 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('1500-05-01 12:34:56.555555555555' AS TIMESTAMP(2))")))).matches("TIMESTAMP '1500-05-01 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('1500-05-01 12:34:56.555555555555' AS TIMESTAMP(3))")))).matches("TIMESTAMP '1500-05-01 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('1500-05-01 12:34:56.555555555555' AS TIMESTAMP(4))")))).matches("TIMESTAMP '1500-05-01 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('1500-05-01 12:34:56.555555555555' AS TIMESTAMP(5))")))).matches("TIMESTAMP '1500-05-01 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('1500-05-01 12:34:56.555555555555' AS TIMESTAMP(6))")))).matches("TIMESTAMP '1500-05-01 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('1500-05-01 12:34:56.555555555555' AS TIMESTAMP(7))")))).matches("TIMESTAMP '1500-05-01 12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('1500-05-01 12:34:56.555555555555' AS TIMESTAMP(8))")))).matches("TIMESTAMP '1500-05-01 12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('1500-05-01 12:34:56.555555555555' AS TIMESTAMP(9))")))).matches("TIMESTAMP '1500-05-01 12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('1500-05-01 12:34:56.555555555555' AS TIMESTAMP(10))")))).matches("TIMESTAMP '1500-05-01 12:34:56.5555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('1500-05-01 12:34:56.555555555555' AS TIMESTAMP(11))")))).matches("TIMESTAMP '1500-05-01 12:34:56.55555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('1500-05-01 12:34:56.555555555555' AS TIMESTAMP(12))")))).matches("TIMESTAMP '1500-05-01 12:34:56.555555555555'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('123001-05-01 12:34:56.111111111111' AS TIMESTAMP(0))")))).matches("TIMESTAMP '123001-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('123001-05-01 12:34:56.111111111111' AS TIMESTAMP(1))")))).matches("TIMESTAMP '123001-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('123001-05-01 12:34:56.111111111111' AS TIMESTAMP(2))")))).matches("TIMESTAMP '123001-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('123001-05-01 12:34:56.111111111111' AS TIMESTAMP(3))")))).matches("TIMESTAMP '123001-05-01 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('123001-05-01 12:34:56.111111111111' AS TIMESTAMP(4))")))).matches("TIMESTAMP '123001-05-01 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('123001-05-01 12:34:56.111111111111' AS TIMESTAMP(5))")))).matches("TIMESTAMP '123001-05-01 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('123001-05-01 12:34:56.111111111111' AS TIMESTAMP(6))")))).matches("TIMESTAMP '123001-05-01 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('123001-05-01 12:34:56.111111111111' AS TIMESTAMP(7))")))).matches("TIMESTAMP '123001-05-01 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('123001-05-01 12:34:56.111111111111' AS TIMESTAMP(8))")))).matches("TIMESTAMP '123001-05-01 12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('123001-05-01 12:34:56.111111111111' AS TIMESTAMP(9))")))).matches("TIMESTAMP '123001-05-01 12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('123001-05-01 12:34:56.111111111111' AS TIMESTAMP(10))")))).matches("TIMESTAMP '123001-05-01 12:34:56.1111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('123001-05-01 12:34:56.111111111111' AS TIMESTAMP(11))")))).matches("TIMESTAMP '123001-05-01 12:34:56.11111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('123001-05-01 12:34:56.111111111111' AS TIMESTAMP(12))")))).matches("TIMESTAMP '123001-05-01 12:34:56.111111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+123001-05-01 12:34:56.111111111111' AS TIMESTAMP(0))")))).matches("TIMESTAMP '123001-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+123001-05-01 12:34:56.111111111111' AS TIMESTAMP(1))")))).matches("TIMESTAMP '123001-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+123001-05-01 12:34:56.111111111111' AS TIMESTAMP(2))")))).matches("TIMESTAMP '123001-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+123001-05-01 12:34:56.111111111111' AS TIMESTAMP(3))")))).matches("TIMESTAMP '123001-05-01 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+123001-05-01 12:34:56.111111111111' AS TIMESTAMP(4))")))).matches("TIMESTAMP '123001-05-01 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+123001-05-01 12:34:56.111111111111' AS TIMESTAMP(5))")))).matches("TIMESTAMP '123001-05-01 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+123001-05-01 12:34:56.111111111111' AS TIMESTAMP(6))")))).matches("TIMESTAMP '123001-05-01 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+123001-05-01 12:34:56.111111111111' AS TIMESTAMP(7))")))).matches("TIMESTAMP '123001-05-01 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+123001-05-01 12:34:56.111111111111' AS TIMESTAMP(8))")))).matches("TIMESTAMP '123001-05-01 12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+123001-05-01 12:34:56.111111111111' AS TIMESTAMP(9))")))).matches("TIMESTAMP '123001-05-01 12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+123001-05-01 12:34:56.111111111111' AS TIMESTAMP(10))")))).matches("TIMESTAMP '123001-05-01 12:34:56.1111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+123001-05-01 12:34:56.111111111111' AS TIMESTAMP(11))")))).matches("TIMESTAMP '123001-05-01 12:34:56.11111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+123001-05-01 12:34:56.111111111111' AS TIMESTAMP(12))")))).matches("TIMESTAMP '123001-05-01 12:34:56.111111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-123001-05-01 12:34:56.111111111111' AS TIMESTAMP(0))")))).matches("TIMESTAMP '-123001-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-123001-05-01 12:34:56.111111111111' AS TIMESTAMP(1))")))).matches("TIMESTAMP '-123001-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-123001-05-01 12:34:56.111111111111' AS TIMESTAMP(2))")))).matches("TIMESTAMP '-123001-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-123001-05-01 12:34:56.111111111111' AS TIMESTAMP(3))")))).matches("TIMESTAMP '-123001-05-01 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-123001-05-01 12:34:56.111111111111' AS TIMESTAMP(4))")))).matches("TIMESTAMP '-123001-05-01 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-123001-05-01 12:34:56.111111111111' AS TIMESTAMP(5))")))).matches("TIMESTAMP '-123001-05-01 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-123001-05-01 12:34:56.111111111111' AS TIMESTAMP(6))")))).matches("TIMESTAMP '-123001-05-01 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-123001-05-01 12:34:56.111111111111' AS TIMESTAMP(7))")))).matches("TIMESTAMP '-123001-05-01 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-123001-05-01 12:34:56.111111111111' AS TIMESTAMP(8))")))).matches("TIMESTAMP '-123001-05-01 12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-123001-05-01 12:34:56.111111111111' AS TIMESTAMP(9))")))).matches("TIMESTAMP '-123001-05-01 12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-123001-05-01 12:34:56.111111111111' AS TIMESTAMP(10))")))).matches("TIMESTAMP '-123001-05-01 12:34:56.1111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-123001-05-01 12:34:56.111111111111' AS TIMESTAMP(11))")))).matches("TIMESTAMP '-123001-05-01 12:34:56.11111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-123001-05-01 12:34:56.111111111111' AS TIMESTAMP(12))")))).matches("TIMESTAMP '-123001-05-01 12:34:56.111111111111'");
    }

    @Test
    public void testLowerDigitsZeroed() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111' AS TIMESTAMP(0)) AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-10 12:34:56.000000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111' AS TIMESTAMP(3)) AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-10 12:34:56.111000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111' AS TIMESTAMP(6)) AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-10 12:34:56.111111000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111' AS TIMESTAMP(9)) AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-10 12:34:56.111111111000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.111111' AS TIMESTAMP(0)) AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-10 12:34:56.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.111111' AS TIMESTAMP(3)) AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-10 12:34:56.111000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.111111' AS TIMESTAMP(6)) AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-10 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.111' AS TIMESTAMP(0)) AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-10 12:34:56.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555' AS TIMESTAMP(0)) AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-10 12:34:57.000000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555' AS TIMESTAMP(3)) AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-10 12:34:56.556000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555' AS TIMESTAMP(6)) AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-10 12:34:56.555556000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555' AS TIMESTAMP(9)) AS TIMESTAMP(12))")))).matches("TIMESTAMP '2020-05-10 12:34:56.555555556000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.555555' AS TIMESTAMP(0)) AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-10 12:34:57.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.555555' AS TIMESTAMP(3)) AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-10 12:34:56.556000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.555555' AS TIMESTAMP(6)) AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-10 12:34:56.555555'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.555' AS TIMESTAMP(0)) AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-10 12:34:57.000'");
    }

    @Test
    public void testRoundDown() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-10 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-10 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-10 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-10 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-10 12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-10 12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111' AS TIMESTAMP(11))")))).matches("TIMESTAMP '2020-05-10 12:34:56.11111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111111111' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111111111' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111111111' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-10 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111111111' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-10 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111111111' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111111111' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-10 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111111111' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-10 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111111111' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111111111' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-10 12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111111111' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-10 12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111111111' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111111111' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111111111' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111111111' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-10 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111111111' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-10 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111111111' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111111111' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-10 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111111111' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-10 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111111111' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111111111' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-10 12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111111111' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-10 12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-10 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-10 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-10 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-10 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-10 12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111111' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111111' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111111' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-10 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111111' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-10 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111111' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111111' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-10 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111111' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-10 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111111' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111111' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111111' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111111' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-10 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111111' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-10 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111111' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111111' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-10 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111111' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-10 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-10 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-10 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-10 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-10 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-10 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-10 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-10 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-10 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-10 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111111' AS TIMESTAMP(0))")))).matches("TIMESTAMP '1500-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111111' AS TIMESTAMP(1))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111111' AS TIMESTAMP(2))")))).matches("TIMESTAMP '1500-05-10 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111111' AS TIMESTAMP(3))")))).matches("TIMESTAMP '1500-05-10 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111111' AS TIMESTAMP(4))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111111' AS TIMESTAMP(5))")))).matches("TIMESTAMP '1500-05-10 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111111' AS TIMESTAMP(6))")))).matches("TIMESTAMP '1500-05-10 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111111' AS TIMESTAMP(7))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111111' AS TIMESTAMP(8))")))).matches("TIMESTAMP '1500-05-10 12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111111' AS TIMESTAMP(9))")))).matches("TIMESTAMP '1500-05-10 12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111111' AS TIMESTAMP(10))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111111' AS TIMESTAMP(11))")))).matches("TIMESTAMP '1500-05-10 12:34:56.11111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11111111111' AS TIMESTAMP(0))")))).matches("TIMESTAMP '1500-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11111111111' AS TIMESTAMP(1))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11111111111' AS TIMESTAMP(2))")))).matches("TIMESTAMP '1500-05-10 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11111111111' AS TIMESTAMP(3))")))).matches("TIMESTAMP '1500-05-10 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11111111111' AS TIMESTAMP(4))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11111111111' AS TIMESTAMP(5))")))).matches("TIMESTAMP '1500-05-10 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11111111111' AS TIMESTAMP(6))")))).matches("TIMESTAMP '1500-05-10 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11111111111' AS TIMESTAMP(7))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11111111111' AS TIMESTAMP(8))")))).matches("TIMESTAMP '1500-05-10 12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11111111111' AS TIMESTAMP(9))")))).matches("TIMESTAMP '1500-05-10 12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11111111111' AS TIMESTAMP(10))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.1111111111' AS TIMESTAMP(0))")))).matches("TIMESTAMP '1500-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.1111111111' AS TIMESTAMP(1))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.1111111111' AS TIMESTAMP(2))")))).matches("TIMESTAMP '1500-05-10 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.1111111111' AS TIMESTAMP(3))")))).matches("TIMESTAMP '1500-05-10 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.1111111111' AS TIMESTAMP(4))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.1111111111' AS TIMESTAMP(5))")))).matches("TIMESTAMP '1500-05-10 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.1111111111' AS TIMESTAMP(6))")))).matches("TIMESTAMP '1500-05-10 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.1111111111' AS TIMESTAMP(7))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.1111111111' AS TIMESTAMP(8))")))).matches("TIMESTAMP '1500-05-10 12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.1111111111' AS TIMESTAMP(9))")))).matches("TIMESTAMP '1500-05-10 12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111' AS TIMESTAMP(0))")))).matches("TIMESTAMP '1500-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111' AS TIMESTAMP(1))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111' AS TIMESTAMP(2))")))).matches("TIMESTAMP '1500-05-10 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111' AS TIMESTAMP(3))")))).matches("TIMESTAMP '1500-05-10 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111' AS TIMESTAMP(4))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111' AS TIMESTAMP(5))")))).matches("TIMESTAMP '1500-05-10 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111' AS TIMESTAMP(6))")))).matches("TIMESTAMP '1500-05-10 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111' AS TIMESTAMP(7))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111' AS TIMESTAMP(8))")))).matches("TIMESTAMP '1500-05-10 12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11111111' AS TIMESTAMP(0))")))).matches("TIMESTAMP '1500-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11111111' AS TIMESTAMP(1))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11111111' AS TIMESTAMP(2))")))).matches("TIMESTAMP '1500-05-10 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11111111' AS TIMESTAMP(3))")))).matches("TIMESTAMP '1500-05-10 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11111111' AS TIMESTAMP(4))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11111111' AS TIMESTAMP(5))")))).matches("TIMESTAMP '1500-05-10 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11111111' AS TIMESTAMP(6))")))).matches("TIMESTAMP '1500-05-10 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11111111' AS TIMESTAMP(7))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.1111111' AS TIMESTAMP(0))")))).matches("TIMESTAMP '1500-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.1111111' AS TIMESTAMP(1))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.1111111' AS TIMESTAMP(2))")))).matches("TIMESTAMP '1500-05-10 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.1111111' AS TIMESTAMP(3))")))).matches("TIMESTAMP '1500-05-10 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.1111111' AS TIMESTAMP(4))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.1111111' AS TIMESTAMP(5))")))).matches("TIMESTAMP '1500-05-10 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.1111111' AS TIMESTAMP(6))")))).matches("TIMESTAMP '1500-05-10 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111' AS TIMESTAMP(0))")))).matches("TIMESTAMP '1500-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111' AS TIMESTAMP(1))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111' AS TIMESTAMP(2))")))).matches("TIMESTAMP '1500-05-10 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111' AS TIMESTAMP(3))")))).matches("TIMESTAMP '1500-05-10 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111' AS TIMESTAMP(4))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111' AS TIMESTAMP(5))")))).matches("TIMESTAMP '1500-05-10 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11111' AS TIMESTAMP(0))")))).matches("TIMESTAMP '1500-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11111' AS TIMESTAMP(1))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11111' AS TIMESTAMP(2))")))).matches("TIMESTAMP '1500-05-10 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11111' AS TIMESTAMP(3))")))).matches("TIMESTAMP '1500-05-10 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11111' AS TIMESTAMP(4))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.1111' AS TIMESTAMP(0))")))).matches("TIMESTAMP '1500-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.1111' AS TIMESTAMP(1))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.1111' AS TIMESTAMP(2))")))).matches("TIMESTAMP '1500-05-10 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.1111' AS TIMESTAMP(3))")))).matches("TIMESTAMP '1500-05-10 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111' AS TIMESTAMP(0))")))).matches("TIMESTAMP '1500-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111' AS TIMESTAMP(1))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111' AS TIMESTAMP(2))")))).matches("TIMESTAMP '1500-05-10 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11' AS TIMESTAMP(0))")))).matches("TIMESTAMP '1500-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.11' AS TIMESTAMP(1))")))).matches("TIMESTAMP '1500-05-10 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.1' AS TIMESTAMP(0))")))).matches("TIMESTAMP '1500-05-10 12:34:56'");
    }

    @Test
    public void testRoundUp() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-10 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-10 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-10 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-10 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-10 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-10 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-10 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-10 12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-10 12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-10 12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-10 12:34:56.5555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555' AS TIMESTAMP(11))")))).matches("TIMESTAMP '2020-05-10 12:34:56.55555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555555555' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-10 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555555555' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-10 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555555555' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-10 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555555555' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-10 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555555555' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-10 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555555555' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-10 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555555555' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-10 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555555555' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-10 12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555555555' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-10 12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555555555' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-10 12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555555555' AS TIMESTAMP(10))")))).matches("TIMESTAMP '2020-05-10 12:34:56.5555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555555555' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-10 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555555555' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-10 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555555555' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-10 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555555555' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-10 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555555555' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-10 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555555555' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-10 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555555555' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-10 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555555555' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-10 12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555555555' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-10 12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555555555' AS TIMESTAMP(9))")))).matches("TIMESTAMP '2020-05-10 12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-10 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-10 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-10 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-10 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-10 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-10 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-10 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-10 12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555' AS TIMESTAMP(8))")))).matches("TIMESTAMP '2020-05-10 12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555555' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-10 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555555' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-10 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555555' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-10 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555555' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-10 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555555' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-10 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555555' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-10 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555555' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-10 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555555' AS TIMESTAMP(7))")))).matches("TIMESTAMP '2020-05-10 12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555555' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-10 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555555' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-10 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555555' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-10 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555555' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-10 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555555' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-10 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555555' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-10 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555555' AS TIMESTAMP(6))")))).matches("TIMESTAMP '2020-05-10 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-10 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-10 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-10 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-10 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-10 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555' AS TIMESTAMP(5))")))).matches("TIMESTAMP '2020-05-10 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-10 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-10 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-10 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-10 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555' AS TIMESTAMP(4))")))).matches("TIMESTAMP '2020-05-10 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-10 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-10 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-10 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555' AS TIMESTAMP(3))")))).matches("TIMESTAMP '2020-05-10 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-10 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-10 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555' AS TIMESTAMP(2))")))).matches("TIMESTAMP '2020-05-10 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-10 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55' AS TIMESTAMP(1))")))).matches("TIMESTAMP '2020-05-10 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5' AS TIMESTAMP(0))")))).matches("TIMESTAMP '2020-05-10 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.5' AS timestamp(0))")))).matches("TIMESTAMP '1970-01-01 00:00:01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.95' AS timestamp(1))")))).matches("TIMESTAMP '1970-01-01 00:00:01.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.995' AS timestamp(2))")))).matches("TIMESTAMP '1970-01-01 00:00:01.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.9995' AS timestamp(3))")))).matches("TIMESTAMP '1970-01-01 00:00:01.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.99995' AS timestamp(4))")))).matches("TIMESTAMP '1970-01-01 00:00:01.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999995' AS timestamp(5))")))).matches("TIMESTAMP '1970-01-01 00:00:01.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.9999995' AS timestamp(6))")))).matches("TIMESTAMP '1970-01-01 00:00:01.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.99999995' AS timestamp(7))")))).matches("TIMESTAMP '1970-01-01 00:00:01.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999995' AS timestamp(8))")))).matches("TIMESTAMP '1970-01-01 00:00:01.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.9999999995' AS timestamp(9))")))).matches("TIMESTAMP '1970-01-01 00:00:01.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.99999999995' AS timestamp(10))")))).matches("TIMESTAMP '1970-01-01 00:00:01.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999995' AS timestamp(11))")))).matches("TIMESTAMP '1970-01-01 00:00:01.00000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999999' AS timestamp(0))")))).matches("TIMESTAMP '1970-01-01 00:00:01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999999' AS timestamp(1))")))).matches("TIMESTAMP '1970-01-01 00:00:01.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999999' AS timestamp(2))")))).matches("TIMESTAMP '1970-01-01 00:00:01.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999999' AS timestamp(3))")))).matches("TIMESTAMP '1970-01-01 00:00:01.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999999' AS timestamp(4))")))).matches("TIMESTAMP '1970-01-01 00:00:01.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999999' AS timestamp(5))")))).matches("TIMESTAMP '1970-01-01 00:00:01.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999999' AS timestamp(6))")))).matches("TIMESTAMP '1970-01-01 00:00:01.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999999' AS timestamp(7))")))).matches("TIMESTAMP '1970-01-01 00:00:01.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999999' AS timestamp(8))")))).matches("TIMESTAMP '1970-01-01 00:00:01.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999999' AS timestamp(9))")))).matches("TIMESTAMP '1970-01-01 00:00:01.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999999' AS timestamp(10))")))).matches("TIMESTAMP '1970-01-01 00:00:01.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1970-01-01 00:00:00.999999999999' AS timestamp(11))")))).matches("TIMESTAMP '1970-01-01 00:00:01.00000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555555' AS TIMESTAMP(0))")))).matches("TIMESTAMP '1500-05-10 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555555' AS TIMESTAMP(1))")))).matches("TIMESTAMP '1500-05-10 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555555' AS TIMESTAMP(2))")))).matches("TIMESTAMP '1500-05-10 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555555' AS TIMESTAMP(3))")))).matches("TIMESTAMP '1500-05-10 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555555' AS TIMESTAMP(4))")))).matches("TIMESTAMP '1500-05-10 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555555' AS TIMESTAMP(5))")))).matches("TIMESTAMP '1500-05-10 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555555' AS TIMESTAMP(6))")))).matches("TIMESTAMP '1500-05-10 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555555' AS TIMESTAMP(7))")))).matches("TIMESTAMP '1500-05-10 12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555555' AS TIMESTAMP(8))")))).matches("TIMESTAMP '1500-05-10 12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555555' AS TIMESTAMP(9))")))).matches("TIMESTAMP '1500-05-10 12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555555' AS TIMESTAMP(10))")))).matches("TIMESTAMP '1500-05-10 12:34:56.5555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555555' AS TIMESTAMP(11))")))).matches("TIMESTAMP '1500-05-10 12:34:56.55555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55555555555' AS TIMESTAMP(0))")))).matches("TIMESTAMP '1500-05-10 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55555555555' AS TIMESTAMP(1))")))).matches("TIMESTAMP '1500-05-10 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55555555555' AS TIMESTAMP(2))")))).matches("TIMESTAMP '1500-05-10 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55555555555' AS TIMESTAMP(3))")))).matches("TIMESTAMP '1500-05-10 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55555555555' AS TIMESTAMP(4))")))).matches("TIMESTAMP '1500-05-10 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55555555555' AS TIMESTAMP(5))")))).matches("TIMESTAMP '1500-05-10 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55555555555' AS TIMESTAMP(6))")))).matches("TIMESTAMP '1500-05-10 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55555555555' AS TIMESTAMP(7))")))).matches("TIMESTAMP '1500-05-10 12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55555555555' AS TIMESTAMP(8))")))).matches("TIMESTAMP '1500-05-10 12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55555555555' AS TIMESTAMP(9))")))).matches("TIMESTAMP '1500-05-10 12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55555555555' AS TIMESTAMP(10))")))).matches("TIMESTAMP '1500-05-10 12:34:56.5555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.5555555555' AS TIMESTAMP(0))")))).matches("TIMESTAMP '1500-05-10 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.5555555555' AS TIMESTAMP(1))")))).matches("TIMESTAMP '1500-05-10 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.5555555555' AS TIMESTAMP(2))")))).matches("TIMESTAMP '1500-05-10 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.5555555555' AS TIMESTAMP(3))")))).matches("TIMESTAMP '1500-05-10 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.5555555555' AS TIMESTAMP(4))")))).matches("TIMESTAMP '1500-05-10 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.5555555555' AS TIMESTAMP(5))")))).matches("TIMESTAMP '1500-05-10 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.5555555555' AS TIMESTAMP(6))")))).matches("TIMESTAMP '1500-05-10 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.5555555555' AS TIMESTAMP(7))")))).matches("TIMESTAMP '1500-05-10 12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.5555555555' AS TIMESTAMP(8))")))).matches("TIMESTAMP '1500-05-10 12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.5555555555' AS TIMESTAMP(9))")))).matches("TIMESTAMP '1500-05-10 12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555' AS TIMESTAMP(0))")))).matches("TIMESTAMP '1500-05-10 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555' AS TIMESTAMP(1))")))).matches("TIMESTAMP '1500-05-10 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555' AS TIMESTAMP(2))")))).matches("TIMESTAMP '1500-05-10 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555' AS TIMESTAMP(3))")))).matches("TIMESTAMP '1500-05-10 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555' AS TIMESTAMP(4))")))).matches("TIMESTAMP '1500-05-10 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555' AS TIMESTAMP(5))")))).matches("TIMESTAMP '1500-05-10 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555' AS TIMESTAMP(6))")))).matches("TIMESTAMP '1500-05-10 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555' AS TIMESTAMP(7))")))).matches("TIMESTAMP '1500-05-10 12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555' AS TIMESTAMP(8))")))).matches("TIMESTAMP '1500-05-10 12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55555555' AS TIMESTAMP(0))")))).matches("TIMESTAMP '1500-05-10 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55555555' AS TIMESTAMP(1))")))).matches("TIMESTAMP '1500-05-10 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55555555' AS TIMESTAMP(2))")))).matches("TIMESTAMP '1500-05-10 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55555555' AS TIMESTAMP(3))")))).matches("TIMESTAMP '1500-05-10 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55555555' AS TIMESTAMP(4))")))).matches("TIMESTAMP '1500-05-10 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55555555' AS TIMESTAMP(5))")))).matches("TIMESTAMP '1500-05-10 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55555555' AS TIMESTAMP(6))")))).matches("TIMESTAMP '1500-05-10 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55555555' AS TIMESTAMP(7))")))).matches("TIMESTAMP '1500-05-10 12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.5555555' AS TIMESTAMP(0))")))).matches("TIMESTAMP '1500-05-10 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.5555555' AS TIMESTAMP(1))")))).matches("TIMESTAMP '1500-05-10 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.5555555' AS TIMESTAMP(2))")))).matches("TIMESTAMP '1500-05-10 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.5555555' AS TIMESTAMP(3))")))).matches("TIMESTAMP '1500-05-10 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.5555555' AS TIMESTAMP(4))")))).matches("TIMESTAMP '1500-05-10 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.5555555' AS TIMESTAMP(5))")))).matches("TIMESTAMP '1500-05-10 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.5555555' AS TIMESTAMP(6))")))).matches("TIMESTAMP '1500-05-10 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555' AS TIMESTAMP(0))")))).matches("TIMESTAMP '1500-05-10 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555' AS TIMESTAMP(1))")))).matches("TIMESTAMP '1500-05-10 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555' AS TIMESTAMP(2))")))).matches("TIMESTAMP '1500-05-10 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555' AS TIMESTAMP(3))")))).matches("TIMESTAMP '1500-05-10 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555' AS TIMESTAMP(4))")))).matches("TIMESTAMP '1500-05-10 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555' AS TIMESTAMP(5))")))).matches("TIMESTAMP '1500-05-10 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55555' AS TIMESTAMP(0))")))).matches("TIMESTAMP '1500-05-10 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55555' AS TIMESTAMP(1))")))).matches("TIMESTAMP '1500-05-10 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55555' AS TIMESTAMP(2))")))).matches("TIMESTAMP '1500-05-10 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55555' AS TIMESTAMP(3))")))).matches("TIMESTAMP '1500-05-10 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55555' AS TIMESTAMP(4))")))).matches("TIMESTAMP '1500-05-10 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.5555' AS TIMESTAMP(0))")))).matches("TIMESTAMP '1500-05-10 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.5555' AS TIMESTAMP(1))")))).matches("TIMESTAMP '1500-05-10 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.5555' AS TIMESTAMP(2))")))).matches("TIMESTAMP '1500-05-10 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.5555' AS TIMESTAMP(3))")))).matches("TIMESTAMP '1500-05-10 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555' AS TIMESTAMP(0))")))).matches("TIMESTAMP '1500-05-10 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555' AS TIMESTAMP(1))")))).matches("TIMESTAMP '1500-05-10 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555' AS TIMESTAMP(2))")))).matches("TIMESTAMP '1500-05-10 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55' AS TIMESTAMP(0))")))).matches("TIMESTAMP '1500-05-10 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.55' AS TIMESTAMP(1))")))).matches("TIMESTAMP '1500-05-10 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.5' AS TIMESTAMP(0))")))).matches("TIMESTAMP '1500-05-10 12:34:57'");
    }

    @Test
    public void testToIso8601() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56')")))).hasType((Type)VarcharType.createVarcharType((int)22)).isEqualTo("2020-05-01T12:34:56");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.1')")))).hasType((Type)VarcharType.createVarcharType((int)24)).isEqualTo("2020-05-01T12:34:56.1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.12')")))).hasType((Type)VarcharType.createVarcharType((int)25)).isEqualTo("2020-05-01T12:34:56.12");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.123')")))).hasType((Type)VarcharType.createVarcharType((int)26)).isEqualTo("2020-05-01T12:34:56.123");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.1234')")))).hasType((Type)VarcharType.createVarcharType((int)27)).isEqualTo("2020-05-01T12:34:56.1234");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.12345')")))).hasType((Type)VarcharType.createVarcharType((int)28)).isEqualTo("2020-05-01T12:34:56.12345");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.123456')")))).hasType((Type)VarcharType.createVarcharType((int)29)).isEqualTo("2020-05-01T12:34:56.123456");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.1234567')")))).hasType((Type)VarcharType.createVarcharType((int)30)).isEqualTo("2020-05-01T12:34:56.1234567");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.12345678')")))).hasType((Type)VarcharType.createVarcharType((int)31)).isEqualTo("2020-05-01T12:34:56.12345678");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.123456789')")))).hasType((Type)VarcharType.createVarcharType((int)32)).isEqualTo("2020-05-01T12:34:56.123456789");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.1234567890')")))).hasType((Type)VarcharType.createVarcharType((int)33)).isEqualTo("2020-05-01T12:34:56.1234567890");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.12345678901')")))).hasType((Type)VarcharType.createVarcharType((int)34)).isEqualTo("2020-05-01T12:34:56.12345678901");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.123456789012')")))).hasType((Type)VarcharType.createVarcharType((int)35)).isEqualTo("2020-05-01T12:34:56.123456789012");
    }

    @Test
    public void testFormat() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56')")))).isEqualTo("2020-05-10T12:34:56");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.1')")))).isEqualTo("2020-05-10T12:34:56.100");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.11')")))).isEqualTo("2020-05-10T12:34:56.110");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.111')")))).isEqualTo("2020-05-10T12:34:56.111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.1111')")))).isEqualTo("2020-05-10T12:34:56.111100");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.11111')")))).isEqualTo("2020-05-10T12:34:56.111110");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.111111')")))).isEqualTo("2020-05-10T12:34:56.111111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.1111111')")))).isEqualTo("2020-05-10T12:34:56.111111100");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.11111111')")))).isEqualTo("2020-05-10T12:34:56.111111110");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.111111111')")))).isEqualTo("2020-05-10T12:34:56.111111111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.1111111111')")))).isEqualTo("2020-05-10T12:34:56.111111111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.11111111111')")))).isEqualTo("2020-05-10T12:34:56.111111111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.111111111111')")))).isEqualTo("2020-05-10T12:34:56.111111111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56')")))).isEqualTo("2020-05-10T12:34:56");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.5')")))).isEqualTo("2020-05-10T12:34:56.500");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.55')")))).isEqualTo("2020-05-10T12:34:56.550");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.555')")))).isEqualTo("2020-05-10T12:34:56.555");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.5555')")))).isEqualTo("2020-05-10T12:34:56.555500");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.55555')")))).isEqualTo("2020-05-10T12:34:56.555550");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.555555')")))).isEqualTo("2020-05-10T12:34:56.555555");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.5555555')")))).isEqualTo("2020-05-10T12:34:56.555555500");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.55555555')")))).isEqualTo("2020-05-10T12:34:56.555555550");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.555555555')")))).isEqualTo("2020-05-10T12:34:56.555555555");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.5555555555')")))).isEqualTo("2020-05-10T12:34:56.555555556");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.55555555555')")))).isEqualTo("2020-05-10T12:34:56.555555556");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.555555555555')")))).isEqualTo("2020-05-10T12:34:56.555555556");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '123001-05-10 12:34:56')")))).isEqualTo("+123001-05-10T12:34:56");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '123001-05-10 12:34:56.1')")))).isEqualTo("+123001-05-10T12:34:56.100");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '123001-05-10 12:34:56.11')")))).isEqualTo("+123001-05-10T12:34:56.110");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '123001-05-10 12:34:56.111')")))).isEqualTo("+123001-05-10T12:34:56.111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '123001-05-10 12:34:56.1111')")))).isEqualTo("+123001-05-10T12:34:56.111100");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '123001-05-10 12:34:56.11111')")))).isEqualTo("+123001-05-10T12:34:56.111110");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '123001-05-10 12:34:56.111111')")))).isEqualTo("+123001-05-10T12:34:56.111111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '123001-05-10 12:34:56.1111111')")))).isEqualTo("+123001-05-10T12:34:56.111111100");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '123001-05-10 12:34:56.11111111')")))).isEqualTo("+123001-05-10T12:34:56.111111110");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '123001-05-10 12:34:56.111111111')")))).isEqualTo("+123001-05-10T12:34:56.111111111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '123001-05-10 12:34:56.1111111111')")))).isEqualTo("+123001-05-10T12:34:56.111111111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '123001-05-10 12:34:56.11111111111')")))).isEqualTo("+123001-05-10T12:34:56.111111111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '123001-05-10 12:34:56.111111111111')")))).isEqualTo("+123001-05-10T12:34:56.111111111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-123001-05-10 12:34:56')")))).isEqualTo("-123001-05-10T12:34:56");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-123001-05-10 12:34:56.1')")))).isEqualTo("-123001-05-10T12:34:56.100");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-123001-05-10 12:34:56.11')")))).isEqualTo("-123001-05-10T12:34:56.110");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-123001-05-10 12:34:56.111')")))).isEqualTo("-123001-05-10T12:34:56.111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-123001-05-10 12:34:56.1111')")))).isEqualTo("-123001-05-10T12:34:56.111100");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-123001-05-10 12:34:56.11111')")))).isEqualTo("-123001-05-10T12:34:56.111110");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-123001-05-10 12:34:56.111111')")))).isEqualTo("-123001-05-10T12:34:56.111111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-123001-05-10 12:34:56.1111111')")))).isEqualTo("-123001-05-10T12:34:56.111111100");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-123001-05-10 12:34:56.11111111')")))).isEqualTo("-123001-05-10T12:34:56.111111110");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-123001-05-10 12:34:56.111111111')")))).isEqualTo("-123001-05-10T12:34:56.111111111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-123001-05-10 12:34:56.1111111111')")))).isEqualTo("-123001-05-10T12:34:56.111111111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-123001-05-10 12:34:56.11111111111')")))).isEqualTo("-123001-05-10T12:34:56.111111111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-123001-05-10 12:34:56.111111111111')")))).isEqualTo("-123001-05-10T12:34:56.111111111");
    }

    @Test
    public void testFormatDateTime() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.1', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.100");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.11', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.110");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.111', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.1111', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.11111', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.111111', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.1111111', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.11111111', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.111111111', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.1111111111', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.11111111111', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.111111111111', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.5', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.500");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.55', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.550");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.555', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.555");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.5555', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.556");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.55555', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.556");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.555555', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.556");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.5555555', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.556");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.55555555', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.556");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.555555555', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.556");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.5555555555', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.556");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.55555555555', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.556");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.555555555555', 'yyyy-MM-dd HH:mm:ss.SSS')")))).isEqualTo("2020-05-10 12:34:56.556");
    }

    @Test
    public void testDateFormat() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.000000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.1', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.100000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.11', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.110000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.111', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.1111', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.11111', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.111111', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.1111111', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.11111111', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.111111111', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.1111111111', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.11111111111', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.111111111111', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.000000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.5', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.500000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.55', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.550000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.555', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.555000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.5555', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.55555', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.555555', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.5555555', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.55555555', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.555555555', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.5555555555', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.55555555555', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.555555555555', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
    }

    @Test
    public void testWithTimeZone() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("with_timezone(TIMESTAMP '2020-05-01 12:34:56', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-05-01 12:34:56 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("with_timezone(TIMESTAMP '2020-05-01 12:34:56.1', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-05-01 12:34:56.1 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("with_timezone(TIMESTAMP '2020-05-01 12:34:56.12', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-05-01 12:34:56.12 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("with_timezone(TIMESTAMP '2020-05-01 12:34:56.123', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-05-01 12:34:56.123 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("with_timezone(TIMESTAMP '2020-05-01 12:34:56.1234', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("with_timezone(TIMESTAMP '2020-05-01 12:34:56.12345', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("with_timezone(TIMESTAMP '2020-05-01 12:34:56.123456', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("with_timezone(TIMESTAMP '2020-05-01 12:34:56.1234567', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234567 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("with_timezone(TIMESTAMP '2020-05-01 12:34:56.12345678', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345678 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("with_timezone(TIMESTAMP '2020-05-01 12:34:56.123456789', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456789 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("with_timezone(TIMESTAMP '2020-05-01 12:34:56.1234567891', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-05-01 12:34:56.1234567891 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("with_timezone(TIMESTAMP '2020-05-01 12:34:56.12345678912', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-05-01 12:34:56.12345678912 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("with_timezone(TIMESTAMP '2020-05-01 12:34:56.123456789123', 'America/Los_Angeles')")))).matches("TIMESTAMP '2020-05-01 12:34:56.123456789123 America/Los_Angeles'");
    }

    @Test
    public void testSequenceIntervalDayToSecond() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56', TIMESTAMP '2020-01-01 12:34:59', INTERVAL '1' SECOND)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56', TIMESTAMP '2020-01-01 12:34:57', TIMESTAMP '2020-01-01 12:34:58', TIMESTAMP '2020-01-01 12:34:59']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56.1', TIMESTAMP '2020-01-01 12:34:59.1', INTERVAL '1' SECOND)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56.1', TIMESTAMP '2020-01-01 12:34:57.1', TIMESTAMP '2020-01-01 12:34:58.1', TIMESTAMP '2020-01-01 12:34:59.1']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56.12', TIMESTAMP '2020-01-01 12:34:59.12', INTERVAL '1' SECOND)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56.12', TIMESTAMP '2020-01-01 12:34:57.12', TIMESTAMP '2020-01-01 12:34:58.12', TIMESTAMP '2020-01-01 12:34:59.12']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56.123', TIMESTAMP '2020-01-01 12:34:59.123', INTERVAL '1' SECOND)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56.123', TIMESTAMP '2020-01-01 12:34:57.123', TIMESTAMP '2020-01-01 12:34:58.123', TIMESTAMP '2020-01-01 12:34:59.123']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56.1234', TIMESTAMP '2020-01-01 12:34:59.1234', INTERVAL '1' SECOND)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56.1234', TIMESTAMP '2020-01-01 12:34:57.1234', TIMESTAMP '2020-01-01 12:34:58.1234', TIMESTAMP '2020-01-01 12:34:59.1234']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56.12345', TIMESTAMP '2020-01-01 12:34:59.12345', INTERVAL '1' SECOND)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56.12345', TIMESTAMP '2020-01-01 12:34:57.12345', TIMESTAMP '2020-01-01 12:34:58.12345', TIMESTAMP '2020-01-01 12:34:59.12345']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56.123456', TIMESTAMP '2020-01-01 12:34:59.123456', INTERVAL '1' SECOND)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56.123456', TIMESTAMP '2020-01-01 12:34:57.123456', TIMESTAMP '2020-01-01 12:34:58.123456', TIMESTAMP '2020-01-01 12:34:59.123456']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56.1234567', TIMESTAMP '2020-01-01 12:34:59.1234567', INTERVAL '1' SECOND)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56.1234567', TIMESTAMP '2020-01-01 12:34:57.1234567', TIMESTAMP '2020-01-01 12:34:58.1234567', TIMESTAMP '2020-01-01 12:34:59.1234567']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56.12345678', TIMESTAMP '2020-01-01 12:34:59.12345678', INTERVAL '1' SECOND)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56.12345678', TIMESTAMP '2020-01-01 12:34:57.12345678', TIMESTAMP '2020-01-01 12:34:58.12345678', TIMESTAMP '2020-01-01 12:34:59.12345678']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56.123456789', TIMESTAMP '2020-01-01 12:34:59.123456789', INTERVAL '1' SECOND)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56.123456789', TIMESTAMP '2020-01-01 12:34:57.123456789', TIMESTAMP '2020-01-01 12:34:58.123456789', TIMESTAMP '2020-01-01 12:34:59.123456789']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56.1234567890', TIMESTAMP '2020-01-01 12:34:59.1234567890', INTERVAL '1' SECOND)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56.1234567890', TIMESTAMP '2020-01-01 12:34:57.1234567890', TIMESTAMP '2020-01-01 12:34:58.1234567890', TIMESTAMP '2020-01-01 12:34:59.1234567890']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56.12345678901', TIMESTAMP '2020-01-01 12:34:59.12345678901', INTERVAL '1' SECOND)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56.12345678901', TIMESTAMP '2020-01-01 12:34:57.12345678901', TIMESTAMP '2020-01-01 12:34:58.12345678901', TIMESTAMP '2020-01-01 12:34:59.12345678901']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56.123456789012', TIMESTAMP '2020-01-01 12:34:59.123456789012', INTERVAL '1' SECOND)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56.123456789012', TIMESTAMP '2020-01-01 12:34:57.123456789012', TIMESTAMP '2020-01-01 12:34:58.123456789012', TIMESTAMP '2020-01-01 12:34:59.123456789012']");
    }

    @Test
    public void testSequenceIntervalYearToMonth() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56', TIMESTAMP '2020-04-01 12:34:56', INTERVAL '1' MONTH)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56', TIMESTAMP '2020-02-01 12:34:56', TIMESTAMP '2020-03-01 12:34:56', TIMESTAMP '2020-04-01 12:34:56']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56.1', TIMESTAMP '2020-04-01 12:34:56.1', INTERVAL '1' MONTH)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56.1', TIMESTAMP '2020-02-01 12:34:56.1', TIMESTAMP '2020-03-01 12:34:56.1', TIMESTAMP '2020-04-01 12:34:56.1']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56.12', TIMESTAMP '2020-04-01 12:34:59.12', INTERVAL '1' MONTH)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56.12', TIMESTAMP '2020-02-01 12:34:56.12', TIMESTAMP '2020-03-01 12:34:56.12', TIMESTAMP '2020-04-01 12:34:56.12']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56.123', TIMESTAMP '2020-04-01 12:34:59.123', INTERVAL '1' MONTH)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56.123', TIMESTAMP '2020-02-01 12:34:56.123', TIMESTAMP '2020-03-01 12:34:56.123', TIMESTAMP '2020-04-01 12:34:56.123']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56.1234', TIMESTAMP '2020-04-01 12:34:59.1234', INTERVAL '1' MONTH)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56.1234', TIMESTAMP '2020-02-01 12:34:56.1234', TIMESTAMP '2020-03-01 12:34:56.1234', TIMESTAMP '2020-04-01 12:34:56.1234']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56.12345', TIMESTAMP '2020-04-01 12:34:59.12345', INTERVAL '1' MONTH)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56.12345', TIMESTAMP '2020-02-01 12:34:56.12345', TIMESTAMP '2020-03-01 12:34:56.12345', TIMESTAMP '2020-04-01 12:34:56.12345']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56.123456', TIMESTAMP '2020-04-01 12:34:59.123456', INTERVAL '1' MONTH)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56.123456', TIMESTAMP '2020-02-01 12:34:56.123456', TIMESTAMP '2020-03-01 12:34:56.123456', TIMESTAMP '2020-04-01 12:34:56.123456']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56.1234567', TIMESTAMP '2020-04-01 12:34:59.1234567', INTERVAL '1' MONTH)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56.1234567', TIMESTAMP '2020-02-01 12:34:56.1234567', TIMESTAMP '2020-03-01 12:34:56.1234567', TIMESTAMP '2020-04-01 12:34:56.1234567']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56.12345678', TIMESTAMP '2020-04-01 12:34:59.12345678', INTERVAL '1' MONTH)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56.12345678', TIMESTAMP '2020-02-01 12:34:56.12345678', TIMESTAMP '2020-03-01 12:34:56.12345678', TIMESTAMP '2020-04-01 12:34:56.12345678']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56.123456789', TIMESTAMP '2020-04-01 12:34:59.123456789', INTERVAL '1' MONTH)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56.123456789', TIMESTAMP '2020-02-01 12:34:56.123456789', TIMESTAMP '2020-03-01 12:34:56.123456789', TIMESTAMP '2020-04-01 12:34:56.123456789']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56.1234567890', TIMESTAMP '2020-04-01 12:34:59.1234567890', INTERVAL '1' MONTH)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56.1234567890', TIMESTAMP '2020-02-01 12:34:56.1234567890', TIMESTAMP '2020-03-01 12:34:56.1234567890', TIMESTAMP '2020-04-01 12:34:56.1234567890']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56.12345678901', TIMESTAMP '2020-04-01 12:34:59.12345678901', INTERVAL '1' MONTH)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56.12345678901', TIMESTAMP '2020-02-01 12:34:56.12345678901', TIMESTAMP '2020-03-01 12:34:56.12345678901', TIMESTAMP '2020-04-01 12:34:56.12345678901']");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("sequence(TIMESTAMP '2020-01-01 12:34:56.123456789012', TIMESTAMP '2020-04-01 12:34:59.123456789012', INTERVAL '1' MONTH)")))).matches("ARRAY[TIMESTAMP '2020-01-01 12:34:56.123456789012', TIMESTAMP '2020-02-01 12:34:56.123456789012', TIMESTAMP '2020-03-01 12:34:56.123456789012', TIMESTAMP '2020-04-01 12:34:56.123456789012']");
    }

    @Test
    public void testDateDiff() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55', TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '1000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.1', TIMESTAMP '2020-05-10 12:34:56.2')")))).matches("BIGINT '1100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.11', TIMESTAMP '2020-05-10 12:34:56.22')")))).matches("BIGINT '1110'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.111', TIMESTAMP '2020-05-10 12:34:56.222')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.1111', TIMESTAMP '2020-05-10 12:34:56.2222')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.11111', TIMESTAMP '2020-05-10 12:34:56.22222')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.111111', TIMESTAMP '2020-05-10 12:34:56.222222')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.1111111', TIMESTAMP '2020-05-10 12:34:56.2222222')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.11111111', TIMESTAMP '2020-05-10 12:34:56.22222222')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.111111111', TIMESTAMP '2020-05-10 12:34:56.222222222')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.1111111111', TIMESTAMP '2020-05-10 12:34:56.2222222222')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.11111111111', TIMESTAMP '2020-05-10 12:34:56.22222222222')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.111111111111', TIMESTAMP '2020-05-10 12:34:56.222222222222')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55', TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '1000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.1', TIMESTAMP '2020-05-10 12:34:56.9')")))).matches("BIGINT '1800'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.11', TIMESTAMP '2020-05-10 12:34:56.99')")))).matches("BIGINT '1880'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.111', TIMESTAMP '2020-05-10 12:34:56.999')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.1111', TIMESTAMP '2020-05-10 12:34:56.9999')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.11111', TIMESTAMP '2020-05-10 12:34:56.99999')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.111111', TIMESTAMP '2020-05-10 12:34:56.999999')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.1111111', TIMESTAMP '2020-05-10 12:34:56.9999999')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.11111111', TIMESTAMP '2020-05-10 12:34:56.99999999')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.111111111', TIMESTAMP '2020-05-10 12:34:56.999999999')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.1111111111', TIMESTAMP '2020-05-10 12:34:56.9999999999')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.11111111111', TIMESTAMP '2020-05-10 12:34:56.99999999999')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.111111111111', TIMESTAMP '2020-05-10 12:34:56.999999999999')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55', TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.1', TIMESTAMP '2020-05-10 12:34:56.2')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.11', TIMESTAMP '2020-05-10 12:34:56.22')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.111', TIMESTAMP '2020-05-10 12:34:56.222')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.1111', TIMESTAMP '2020-05-10 12:34:56.2222')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.11111', TIMESTAMP '2020-05-10 12:34:56.22222')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.111111', TIMESTAMP '2020-05-10 12:34:56.222222')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.1111111', TIMESTAMP '2020-05-10 12:34:56.2222222')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.11111111', TIMESTAMP '2020-05-10 12:34:56.22222222')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.111111111', TIMESTAMP '2020-05-10 12:34:56.222222222')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.1111111111', TIMESTAMP '2020-05-10 12:34:56.2222222222')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.11111111111', TIMESTAMP '2020-05-10 12:34:56.22222222222')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.111111111111', TIMESTAMP '2020-05-10 12:34:56.222222222222')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.1', TIMESTAMP '2020-05-10 12:34:56.9')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.11', TIMESTAMP '2020-05-10 12:34:56.99')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.111', TIMESTAMP '2020-05-10 12:34:56.999')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.1111', TIMESTAMP '2020-05-10 12:34:56.9999')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.11111', TIMESTAMP '2020-05-10 12:34:56.99999')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.111111', TIMESTAMP '2020-05-10 12:34:56.999999')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.1111111', TIMESTAMP '2020-05-10 12:34:56.9999999')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.11111111', TIMESTAMP '2020-05-10 12:34:56.99999999')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.111111111', TIMESTAMP '2020-05-10 12:34:56.999999999')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.1111111111', TIMESTAMP '2020-05-10 12:34:56.9999999999')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.11111111111', TIMESTAMP '2020-05-10 12:34:56.99999999999')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.111111111111', TIMESTAMP '2020-05-10 12:34:56.999999999999')")))).matches("BIGINT '1'");
    }

    @Test
    public void testDateAdd() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56')")))).matches("TIMESTAMP '2020-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("TIMESTAMP '2020-05-10 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.11')")))).matches("TIMESTAMP '2020-05-10 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.111')")))).matches("TIMESTAMP '2020-05-10 12:34:56.112'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.1111')")))).matches("TIMESTAMP '2020-05-10 12:34:56.1121'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.11111')")))).matches("TIMESTAMP '2020-05-10 12:34:56.11211'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.111111')")))).matches("TIMESTAMP '2020-05-10 12:34:56.112111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.1111111')")))).matches("TIMESTAMP '2020-05-10 12:34:56.1121111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.11111111')")))).matches("TIMESTAMP '2020-05-10 12:34:56.11211111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.111111111')")))).matches("TIMESTAMP '2020-05-10 12:34:56.112111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.1111111111')")))).matches("TIMESTAMP '2020-05-10 12:34:56.1121111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.11111111111')")))).matches("TIMESTAMP '2020-05-10 12:34:56.11211111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.111111111111')")))).matches("TIMESTAMP '2020-05-10 12:34:56.112111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56')")))).matches("TIMESTAMP '2020-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.5')")))).matches("TIMESTAMP '2020-05-10 12:34:56.5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.55')")))).matches("TIMESTAMP '2020-05-10 12:34:56.55'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.555')")))).matches("TIMESTAMP '2020-05-10 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.5555')")))).matches("TIMESTAMP '2020-05-10 12:34:56.5565'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.55555')")))).matches("TIMESTAMP '2020-05-10 12:34:56.55655'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.555555')")))).matches("TIMESTAMP '2020-05-10 12:34:56.556555'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.5555555')")))).matches("TIMESTAMP '2020-05-10 12:34:56.5565555'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.55555555')")))).matches("TIMESTAMP '2020-05-10 12:34:56.55655555'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.555555555')")))).matches("TIMESTAMP '2020-05-10 12:34:56.556555555'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.5555555555')")))).matches("TIMESTAMP '2020-05-10 12:34:56.5565555555'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.55555555555')")))).matches("TIMESTAMP '2020-05-10 12:34:56.55655555555'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.555555555555')")))).matches("TIMESTAMP '2020-05-10 12:34:56.556555555555'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1000, TIMESTAMP '2020-05-10 12:34:56')")))).matches("TIMESTAMP '2020-05-10 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56')")))).matches("TIMESTAMP '1500-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.1')")))).matches("TIMESTAMP '1500-05-10 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.11')")))).matches("TIMESTAMP '1500-05-10 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.111')")))).matches("TIMESTAMP '1500-05-10 12:34:56.112'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.1111')")))).matches("TIMESTAMP '1500-05-10 12:34:56.1121'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.11111')")))).matches("TIMESTAMP '1500-05-10 12:34:56.11211'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.111111')")))).matches("TIMESTAMP '1500-05-10 12:34:56.112111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.1111111')")))).matches("TIMESTAMP '1500-05-10 12:34:56.1121111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.11111111')")))).matches("TIMESTAMP '1500-05-10 12:34:56.11211111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.111111111')")))).matches("TIMESTAMP '1500-05-10 12:34:56.112111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.1111111111')")))).matches("TIMESTAMP '1500-05-10 12:34:56.1121111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.11111111111')")))).matches("TIMESTAMP '1500-05-10 12:34:56.11211111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.111111111111')")))).matches("TIMESTAMP '1500-05-10 12:34:56.112111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56')")))).matches("TIMESTAMP '1500-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.5')")))).matches("TIMESTAMP '1500-05-10 12:34:56.5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.55')")))).matches("TIMESTAMP '1500-05-10 12:34:56.55'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.555')")))).matches("TIMESTAMP '1500-05-10 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.5555')")))).matches("TIMESTAMP '1500-05-10 12:34:56.5565'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.55555')")))).matches("TIMESTAMP '1500-05-10 12:34:56.55655'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.555555')")))).matches("TIMESTAMP '1500-05-10 12:34:56.556555'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.5555555')")))).matches("TIMESTAMP '1500-05-10 12:34:56.5565555'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.55555555')")))).matches("TIMESTAMP '1500-05-10 12:34:56.55655555'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.555555555')")))).matches("TIMESTAMP '1500-05-10 12:34:56.556555555'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.5555555555')")))).matches("TIMESTAMP '1500-05-10 12:34:56.5565555555'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.55555555555')")))).matches("TIMESTAMP '1500-05-10 12:34:56.55655555555'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.555555555555')")))).matches("TIMESTAMP '1500-05-10 12:34:56.556555555555'");
    }

    @Test
    public void testLastDayOfMonth() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.1')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.12')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.123')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.1234')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.12345')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.123456')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.1234567')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.12345678')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.123456789')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.1234567891')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.12345678912')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.123456789123')")))).matches("DATE '2020-05-31'");
    }

    @Test
    public void testCastToTimeWithDaylightSavings() {
        Session session = this.assertions.sessionBuilder().setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"America/Los_Angeles")).build();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-26 09:26:10' as TIME(0))", session)))).matches("TIME '09:26:10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-26 09:26:10.1' as TIME(1))", session)))).matches("TIME '09:26:10.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-26 09:26:10.11' as TIME(2))", session)))).matches("TIME '09:26:10.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-26 09:26:10.111' as TIME(3))", session)))).matches("TIME '09:26:10.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-26 09:26:10.1111' as TIME(4))", session)))).matches("TIME '09:26:10.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-26 09:26:10.11111' as TIME(5))", session)))).matches("TIME '09:26:10.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-26 09:26:10.111111' as TIME(6))", session)))).matches("TIME '09:26:10.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-26 09:26:10.1111111' as TIME(7))", session)))).matches("TIME '09:26:10.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-26 09:26:10.11111111' as TIME(8))", session)))).matches("TIME '09:26:10.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-26 09:26:10.111111111' as TIME(9))", session)))).matches("TIME '09:26:10.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-26 09:26:10.1111111111' as TIME(10))", session)))).matches("TIME '09:26:10.1111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-26 09:26:10.11111111111' as TIME(11))", session)))).matches("TIME '09:26:10.11111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-26 09:26:10.111111111111' as TIME(12))", session)))).matches("TIME '09:26:10.111111111111'");
    }

    @Test
    public void testAtTimeZone() {
        Session session = this.assertions.sessionBuilder().setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"Pacific/Apia")).build();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' AT TIME ZONE 'America/Los_Angeles'", session)))).matches("TIMESTAMP '2020-04-30 16:34:56 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1' AT TIME ZONE 'America/Los_Angeles'", session)))).matches("TIMESTAMP '2020-04-30 16:34:56.1 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12' AT TIME ZONE 'America/Los_Angeles'", session)))).matches("TIMESTAMP '2020-04-30 16:34:56.12 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123' AT TIME ZONE 'America/Los_Angeles'", session)))).matches("TIMESTAMP '2020-04-30 16:34:56.123 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234' AT TIME ZONE 'America/Los_Angeles'", session)))).matches("TIMESTAMP '2020-04-30 16:34:56.1234 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345' AT TIME ZONE 'America/Los_Angeles'", session)))).matches("TIMESTAMP '2020-04-30 16:34:56.12345 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456' AT TIME ZONE 'America/Los_Angeles'", session)))).matches("TIMESTAMP '2020-04-30 16:34:56.123456 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567' AT TIME ZONE 'America/Los_Angeles'", session)))).matches("TIMESTAMP '2020-04-30 16:34:56.1234567 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678' AT TIME ZONE 'America/Los_Angeles'", session)))).matches("TIMESTAMP '2020-04-30 16:34:56.12345678 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789' AT TIME ZONE 'America/Los_Angeles'", session)))).matches("TIMESTAMP '2020-04-30 16:34:56.123456789 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567891' AT TIME ZONE 'America/Los_Angeles'", session)))).matches("TIMESTAMP '2020-04-30 16:34:56.1234567891 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678912' AT TIME ZONE 'America/Los_Angeles'", session)))).matches("TIMESTAMP '2020-04-30 16:34:56.12345678912 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789123' AT TIME ZONE 'America/Los_Angeles'", session)))).matches("TIMESTAMP '2020-04-30 16:34:56.123456789123 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIMESTAMP '2020-05-01 09:34:56 +10:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIMESTAMP '2020-05-01 09:34:56.1 +10:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIMESTAMP '2020-05-01 09:34:56.12 +10:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIMESTAMP '2020-05-01 09:34:56.123 +10:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIMESTAMP '2020-05-01 09:34:56.1234 +10:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIMESTAMP '2020-05-01 09:34:56.12345 +10:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIMESTAMP '2020-05-01 09:34:56.123456 +10:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIMESTAMP '2020-05-01 09:34:56.1234567 +10:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIMESTAMP '2020-05-01 09:34:56.12345678 +10:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIMESTAMP '2020-05-01 09:34:56.123456789 +10:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567891' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIMESTAMP '2020-05-01 09:34:56.1234567891 +10:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678912' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIMESTAMP '2020-05-01 09:34:56.12345678912 +10:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789123' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIMESTAMP '2020-05-01 09:34:56.123456789123 +10:00'");
    }

    @Test
    public void testCastInvalidTimestamp() {
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST('ABC' AS TIMESTAMP)")).hasMessage("Value cannot be cast to timestamp: ABC");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST('2022-01-00 00:00:00' AS TIMESTAMP)")).hasMessage("Value cannot be cast to timestamp: 2022-01-00 00:00:00");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST('2022-00-01 00:00:00' AS TIMESTAMP)")).hasMessage("Value cannot be cast to timestamp: 2022-00-01 00:00:00");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST('2022-01-01 25:00:00' AS TIMESTAMP)")).hasMessage("Value cannot be cast to timestamp: 2022-01-01 25:00:00");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST('2022-01-01 00:61:00' AS TIMESTAMP)")).hasMessage("Value cannot be cast to timestamp: 2022-01-01 00:61:00");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST('2022-01-01 00:00:61' AS TIMESTAMP)")).hasMessage("Value cannot be cast to timestamp: 2022-01-01 00:00:61");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST('ABC' AS TIMESTAMP(12))")).hasMessage("Value cannot be cast to timestamp: ABC");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST('2022-01-00 00:00:00' AS TIMESTAMP(12))")).hasMessage("Value cannot be cast to timestamp: 2022-01-00 00:00:00");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST('2022-00-01 00:00:00' AS TIMESTAMP(12))")).hasMessage("Value cannot be cast to timestamp: 2022-00-01 00:00:00");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST('2022-01-01 25:00:00' AS TIMESTAMP(12))")).hasMessage("Value cannot be cast to timestamp: 2022-01-01 25:00:00");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST('2022-01-01 00:61:00' AS TIMESTAMP(12))")).hasMessage("Value cannot be cast to timestamp: 2022-01-01 00:61:00");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST('2022-01-01 00:00:61' AS TIMESTAMP(12))")).hasMessage("Value cannot be cast to timestamp: 2022-01-01 00:00:61");
    }

    private static BiFunction<Session, QueryRunner, Object> timestamp(int precision, int year, int month, int day, int hour, int minute, int second, long picoOfSecond) {
        return (session, queryRunner) -> {
            LocalDateTime base = LocalDateTime.of(year, month, day, hour, minute, second);
            ZoneOffset offset = ZoneOffset.UTC;
            long epochMicros = base.toEpochSecond(offset) * 1000000L + picoOfSecond / 1000000L;
            int picosOfMicro = (int)(picoOfSecond % 1000000L);
            return SqlTimestamp.newInstance((int)precision, (long)epochMicros, (int)picosOfMicro);
        };
    }
}

