/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.matcher;

import com.google.common.collect.ImmutableList;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.memory.context.SimpleLocalMemoryContext;
import io.trino.operator.PagesIndex;
import io.trino.operator.window.matcher.ArrayView;
import io.trino.operator.window.matcher.IrRowPatternToProgramRewriter;
import io.trino.operator.window.matcher.MatchResult;
import io.trino.operator.window.matcher.Matcher;
import io.trino.operator.window.matcher.Program;
import io.trino.operator.window.pattern.LabelEvaluator;
import io.trino.operator.window.pattern.MatchAggregation;
import io.trino.operator.window.pattern.ProjectingPagesWindowIndex;
import io.trino.spi.Page;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIntArrayAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.CanIgnoreReturnValue;

public class MatchAssert
extends AbstractAssert<MatchAssert, MatchResult> {
    private final Map<IrLabel, Integer> labelMapping;

    private MatchAssert(MatchResult actual, Map<IrLabel, Integer> labelMapping) {
        super((Object)actual, Object.class);
        this.labelMapping = labelMapping;
    }

    public static AssertProvider<MatchAssert> match(IrRowPattern pattern, String input, Map<IrLabel, Integer> labelMapping) {
        Program program = IrRowPatternToProgramRewriter.rewrite((IrRowPattern)pattern, labelMapping);
        ImmutableList dummyPointers = ImmutableList.of((Object)ImmutableList.of(), (Object)ImmutableList.of(), (Object)ImmutableList.of(), (Object)ImmutableList.of(), (Object)ImmutableList.of());
        Matcher matcher = new Matcher(program, (List)dummyPointers, (List)ImmutableList.of(), (List)ImmutableList.of());
        int[] mappedInput = new int[input.length()];
        char[] chars = input.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            mappedInput[i] = labelMapping.get(new IrLabel(String.valueOf(chars[i])));
        }
        return () -> new MatchAssert(matcher.run(MatchAssert.identityEvaluator(mappedInput), (LocalMemoryContext)new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), "dummy"), AggregatedMemoryContext.newSimpleAggregatedMemoryContext()), labelMapping);
    }

    @CanIgnoreReturnValue
    public MatchAssert hasLabels(char[] expectedLabels) {
        int[] mappedExpected = new int[expectedLabels.length];
        for (int i = 0; i < expectedLabels.length; ++i) {
            mappedExpected[i] = this.labelMapping.get(new IrLabel(String.valueOf(expectedLabels[i])));
        }
        return (MatchAssert)((MatchAssert)this.satisfies(actual -> Assertions.assertThat((boolean)actual.isMatched()).isTrue())).satisfies(actual -> ((AbstractIntArrayAssert)Assertions.assertThat((int[])actual.getLabels().toArray()).as("Matched labels", new Object[0])).isEqualTo((Object)mappedExpected));
    }

    @CanIgnoreReturnValue
    public MatchAssert hasCaptures(int[] expectedCaptures) {
        return (MatchAssert)((MatchAssert)this.satisfies(actual -> Assertions.assertThat((boolean)actual.isMatched()).isTrue())).satisfies(actual -> ((AbstractIntArrayAssert)Assertions.assertThat((int[])actual.getExclusions().toArray()).as("Captured exclusions", new Object[0])).isEqualTo((Object)expectedCaptures));
    }

    @CanIgnoreReturnValue
    public MatchAssert isNoMatch() {
        return (MatchAssert)this.satisfies(actual -> Assertions.assertThat((boolean)actual.isMatched()).isFalse());
    }

    private static LabelEvaluator identityEvaluator(int[] input) {
        PagesIndex pagesIndex = new PagesIndex.TestingFactory(false).newPagesIndex((List)ImmutableList.of(), 1);
        pagesIndex.addPage(new Page(1));
        return new IdentityEvaluator(input, new ProjectingPagesWindowIndex(pagesIndex, 0, 1, (List)ImmutableList.of(), (List)ImmutableList.of()));
    }

    private static class IdentityEvaluator
    extends LabelEvaluator {
        private final int[] input;

        public IdentityEvaluator(int[] input, ProjectingPagesWindowIndex dummy) {
            super(0L, 0, 0, 0, 1, (List)ImmutableList.of(), dummy);
            this.input = input;
        }

        public int getInputLength() {
            return this.input.length;
        }

        public boolean isMatchingAtPartitionStart() {
            return true;
        }

        public boolean evaluateLabel(ArrayView matchedLabels, MatchAggregation[] aggregations) {
            int position = matchedLabels.length() - 1;
            return this.input[position] == matchedLabels.get(position);
        }
    }
}

