/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import com.google.common.io.Resources;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.testing.TestingHttpServer;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.node.NodeInfo;
import io.airlift.security.pem.PemReader;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.security.Keys;
import io.trino.client.OkHttpUtil;
import io.trino.client.ProtocolHeaders;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.plugin.base.security.AllowAllSystemAccessControl;
import io.trino.security.AccessControl;
import io.trino.security.AccessControlManager;
import io.trino.server.HttpRequestSessionContextFactory;
import io.trino.server.ProtocolConfig;
import io.trino.server.protocol.PreparedStatementEncoder;
import io.trino.server.security.PasswordAuthenticatorManager;
import io.trino.server.security.ResourceSecurity;
import io.trino.server.security.jwt.JwtUtil;
import io.trino.server.security.oauth2.ChallengeFailedException;
import io.trino.server.security.oauth2.OAuth2Client;
import io.trino.server.security.oauth2.TokenPairSerializer;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.BasicPrincipal;
import io.trino.spi.security.Identity;
import io.trino.spi.security.PasswordAuthenticator;
import io.trino.spi.security.SystemAccessControl;
import io.trino.spi.security.SystemSecurityContext;
import java.io.File;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import javax.inject.Inject;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.JavaNetCookieJar;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestResourceSecurity {
    private static final String LOCALHOST_KEYSTORE = Resources.getResource((String)"cert/localhost.pem").getPath();
    private static final String ALLOWED_USER_MAPPING_PATTERN = "(.*)@allowed";
    private static final ImmutableMap<String, String> SECURE_PROPERTIES = ImmutableMap.builder().put((Object)"http-server.https.enabled", (Object)"true").put((Object)"http-server.https.keystore.path", (Object)LOCALHOST_KEYSTORE).put((Object)"http-server.https.keystore.key", (Object)"").put((Object)"http-server.process-forwarded", (Object)"true").put((Object)"http-server.authentication.insecure.user-mapping.pattern", (Object)"(.*)@allowed").buildOrThrow();
    private static final String TEST_USER = "test-user";
    private static final String TEST_USER_LOGIN = "test-user@allowed";
    private static final String TEST_PASSWORD = "test-password";
    private static final String TEST_PASSWORD2 = "test-password-2";
    private static final String MANAGEMENT_USER = "management-user";
    private static final String MANAGEMENT_USER_LOGIN = "management-user@allowed";
    private static final String MANAGEMENT_PASSWORD = "management-password";
    private static final String HMAC_KEY = Resources.getResource((String)"hmac_key.txt").getPath();
    private static final String JWK_KEY_ID = "test-rsa";
    private static final String GROUPS_CLAIM = "groups";
    private static final PrivateKey JWK_PRIVATE_KEY;
    private static final PublicKey JWK_PUBLIC_KEY;
    private static final ObjectMapper json;
    private OkHttpClient client;
    private Path passwordConfigDummy;

    @BeforeClass
    public void setup() throws IOException {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().followRedirects(false);
        OkHttpUtil.setupSsl((OkHttpClient.Builder)clientBuilder, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(LOCALHOST_KEYSTORE), Optional.empty(), Optional.empty(), (boolean)false);
        this.client = clientBuilder.build();
        this.passwordConfigDummy = Files.createTempFile("passwordConfigDummy", "", new FileAttribute[0]);
        this.passwordConfigDummy.toFile().deleteOnExit();
    }

    @Test
    public void testInsecureAuthenticatorHttp() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().put((Object)"http-server.authentication.insecure.user-mapping.pattern", (Object)ALLOWED_USER_MAPPING_PATTERN).buildOrThrow()).build();){
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)TestSystemAccessControl.WITH_IMPERSONATION);
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertInsecureAuthentication(httpServerInfo.getHttpUri());
        }
    }

    @Test
    public void testInsecureAuthenticatorHttps() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties(SECURE_PROPERTIES).build();){
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)TestSystemAccessControl.WITH_IMPERSONATION);
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertInsecureAuthentication(httpServerInfo.getHttpUri());
            this.assertInsecureAuthentication(httpServerInfo.getHttpsUri());
        }
    }

    @Test
    public void testInsecureAuthenticatorHttpsOnly() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.allow-insecure-over-http", (Object)"false").buildOrThrow()).build();){
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)TestSystemAccessControl.WITH_IMPERSONATION);
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertAuthenticationDisabled(httpServerInfo.getHttpUri());
            this.assertInsecureAuthentication(httpServerInfo.getHttpsUri());
        }
    }

    @Test
    public void testPasswordAuthenticator() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"password-authenticator.config-files", (Object)this.passwordConfigDummy.toString()).put((Object)"http-server.authentication.type", (Object)"password").put((Object)"http-server.authentication.password.user-mapping.pattern", (Object)ALLOWED_USER_MAPPING_PATTERN).buildOrThrow()).build();){
            ((PasswordAuthenticatorManager)server.getInstance(com.google.inject.Key.get(PasswordAuthenticatorManager.class))).setAuthenticators(new PasswordAuthenticator[]{TestResourceSecurity::authenticate});
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)TestSystemAccessControl.WITH_IMPERSONATION);
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertAuthenticationDisabled(httpServerInfo.getHttpUri());
            this.assertPasswordAuthentication(httpServerInfo.getHttpsUri());
        }
    }

    @Test
    public void testMultiplePasswordAuthenticators() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"password-authenticator.config-files", (Object)this.passwordConfigDummy.toString()).put((Object)"http-server.authentication.type", (Object)"password").put((Object)"http-server.authentication.password.user-mapping.pattern", (Object)ALLOWED_USER_MAPPING_PATTERN).buildOrThrow()).build();){
            ((PasswordAuthenticatorManager)server.getInstance(com.google.inject.Key.get(PasswordAuthenticatorManager.class))).setAuthenticators(new PasswordAuthenticator[]{TestResourceSecurity::authenticate, TestResourceSecurity::authenticate2});
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)TestSystemAccessControl.WITH_IMPERSONATION);
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertAuthenticationDisabled(httpServerInfo.getHttpUri());
            this.assertPasswordAuthentication(httpServerInfo.getHttpsUri(), TEST_PASSWORD, TEST_PASSWORD2);
        }
    }

    @Test
    public void testMultiplePasswordAuthenticatorsMessages() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"password-authenticator.config-files", (Object)this.passwordConfigDummy.toString()).put((Object)"http-server.authentication.type", (Object)"password").put((Object)"http-server.authentication.password.user-mapping.pattern", (Object)ALLOWED_USER_MAPPING_PATTERN).buildOrThrow()).build();){
            ((PasswordAuthenticatorManager)server.getInstance(com.google.inject.Key.get(PasswordAuthenticatorManager.class))).setAuthenticators(new PasswordAuthenticator[]{TestResourceSecurity::authenticate, TestResourceSecurity::authenticate2});
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)TestSystemAccessControl.WITH_IMPERSONATION);
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            Request request = new Request.Builder().url(TestResourceSecurity.getAuthorizedUserLocation(httpServerInfo.getHttpsUri())).headers(Headers.of((String[])new String[]{"Authorization", Credentials.basic((String)TEST_USER_LOGIN, (String)"wrong_password")})).build();
            try (Response response = this.client.newCall(request).execute();){
                Assertions.assertThat((String)response.message()).isEqualTo("Access Denied: Invalid credentials | Access Denied: Invalid credentials2");
            }
        }
    }

    @Test
    public void testPasswordAuthenticatorUserMapping() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"password-authenticator.config-files", (Object)this.passwordConfigDummy.toString()).put((Object)"http-server.authentication.type", (Object)"password").put((Object)"http-server.authentication.password.user-mapping.pattern", (Object)ALLOWED_USER_MAPPING_PATTERN).buildOrThrow()).setAdditionalModule(binder -> JaxrsBinder.jaxrsBinder((Binder)binder).bind(TestResource.class)).build();){
            ((PasswordAuthenticatorManager)server.getInstance(com.google.inject.Key.get(PasswordAuthenticatorManager.class))).setAuthenticators(new PasswordAuthenticator[]{TestResourceSecurity::authenticate});
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)TestSystemAccessControl.WITH_IMPERSONATION);
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            Request request = new Request.Builder().url(TestResourceSecurity.getLocation(httpServerInfo.getHttpsUri(), "/protocol/identity")).addHeader("Authorization", Credentials.basic((String)TEST_USER_LOGIN, (String)TEST_PASSWORD)).addHeader("X-Trino-User", TEST_USER_LOGIN).build();
            try (Response response = this.client.newCall(request).execute();){
                io.trino.testing.assertions.Assert.assertEquals((int)response.code(), (int)200);
                io.trino.testing.assertions.Assert.assertEquals((String)response.header("user"), (String)TEST_USER);
                io.trino.testing.assertions.Assert.assertEquals((String)response.header("principal"), (String)TEST_USER_LOGIN);
            }
        }
    }

    @Test
    public void testPasswordAuthenticatorWithInsecureHttp() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"password-authenticator.config-files", (Object)this.passwordConfigDummy.toString()).put((Object)"http-server.authentication.type", (Object)"password").put((Object)"http-server.authentication.allow-insecure-over-http", (Object)"true").put((Object)"http-server.authentication.password.user-mapping.pattern", (Object)ALLOWED_USER_MAPPING_PATTERN).buildOrThrow()).build();){
            ((PasswordAuthenticatorManager)server.getInstance(com.google.inject.Key.get(PasswordAuthenticatorManager.class))).setAuthenticators(new PasswordAuthenticator[]{TestResourceSecurity::authenticate});
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)TestSystemAccessControl.WITH_IMPERSONATION);
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertInsecureAuthentication(httpServerInfo.getHttpUri());
            this.assertPasswordAuthentication(httpServerInfo.getHttpsUri());
        }
    }

    @Test
    public void testFixedManagerAuthenticatorHttpInsecureEnabledOnly() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"password-authenticator.config-files", (Object)this.passwordConfigDummy.toString()).put((Object)"http-server.authentication.type", (Object)"password").put((Object)"http-server.authentication.allow-insecure-over-http", (Object)"true").put((Object)"http-server.authentication.password.user-mapping.pattern", (Object)ALLOWED_USER_MAPPING_PATTERN).put((Object)"management.user", (Object)MANAGEMENT_USER).buildOrThrow()).build();){
            ((PasswordAuthenticatorManager)server.getInstance(com.google.inject.Key.get(PasswordAuthenticatorManager.class))).setAuthenticators(new PasswordAuthenticator[]{TestResourceSecurity::authenticate});
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)TestSystemAccessControl.WITH_IMPERSONATION);
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertFixedManagementUser(httpServerInfo.getHttpUri(), true);
            this.assertPasswordAuthentication(httpServerInfo.getHttpsUri());
        }
    }

    @Test
    public void testFixedManagerAuthenticatorHttpInsecureDisabledOnly() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"password-authenticator.config-files", (Object)this.passwordConfigDummy.toString()).put((Object)"http-server.authentication.type", (Object)"password").put((Object)"http-server.authentication.allow-insecure-over-http", (Object)"false").put((Object)"http-server.authentication.password.user-mapping.pattern", (Object)ALLOWED_USER_MAPPING_PATTERN).put((Object)"management.user", (Object)MANAGEMENT_USER).buildOrThrow()).build();){
            ((PasswordAuthenticatorManager)server.getInstance(com.google.inject.Key.get(PasswordAuthenticatorManager.class))).setAuthenticators(new PasswordAuthenticator[]{TestResourceSecurity::authenticate});
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)TestSystemAccessControl.WITH_IMPERSONATION);
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getPublicLocation(httpServerInfo.getHttpUri()), 200);
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(httpServerInfo.getHttpUri()), 403, TEST_USER_LOGIN, null);
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(httpServerInfo.getHttpUri()), 200);
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(httpServerInfo.getHttpUri()), 200, "unknown", "something");
            this.assertPasswordAuthentication(httpServerInfo.getHttpsUri());
        }
    }

    @Test
    public void testFixedManagerAuthenticatorHttps() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"password-authenticator.config-files", (Object)this.passwordConfigDummy.toString()).put((Object)"http-server.authentication.type", (Object)"password").put((Object)"http-server.authentication.allow-insecure-over-http", (Object)"true").put((Object)"management.user", (Object)MANAGEMENT_USER).put((Object)"management.user.https-enabled", (Object)"true").buildOrThrow()).build();){
            ((PasswordAuthenticatorManager)server.getInstance(com.google.inject.Key.get(PasswordAuthenticatorManager.class))).setAuthenticators(new PasswordAuthenticator[]{TestResourceSecurity::authenticate});
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)TestSystemAccessControl.WITH_IMPERSONATION);
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertFixedManagementUser(httpServerInfo.getHttpUri(), true);
            this.assertFixedManagementUser(httpServerInfo.getHttpsUri(), false);
        }
    }

    @Test
    public void testCertAuthenticator() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"certificate").put((Object)"http-server.https.truststore.path", (Object)LOCALHOST_KEYSTORE).put((Object)"http-server.https.truststore.key", (Object)"").buildOrThrow()).build();){
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)TestSystemAccessControl.NO_IMPERSONATION);
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertAuthenticationDisabled(httpServerInfo.getHttpUri());
            OkHttpClient.Builder clientBuilder = this.client.newBuilder();
            OkHttpUtil.setupSsl((OkHttpClient.Builder)clientBuilder, Optional.of(LOCALHOST_KEYSTORE), Optional.empty(), Optional.empty(), Optional.of(LOCALHOST_KEYSTORE), Optional.empty(), Optional.empty(), (boolean)false);
            OkHttpClient clientWithCert = clientBuilder.build();
            TestResourceSecurity.assertAuthenticationAutomatic(httpServerInfo.getHttpsUri(), clientWithCert);
        }
    }

    @Test
    public void testJwtAuthenticator() throws Exception {
        this.verifyJwtAuthenticator(Optional.empty());
        this.verifyJwtAuthenticator(Optional.of("custom-principal"));
    }

    private void verifyJwtAuthenticator(Optional<String> principalField) throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"jwt").put((Object)"http-server.authentication.jwt.key-file", (Object)HMAC_KEY).put((Object)"http-server.authentication.jwt.principal-field", (Object)principalField.orElse("sub")).buildOrThrow()).build();){
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)TestSystemAccessControl.NO_IMPERSONATION);
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertAuthenticationDisabled(httpServerInfo.getHttpUri());
            SecretKey hmac = Keys.hmacShaKeyFor((byte[])Base64.getDecoder().decode(Files.readString(Paths.get(HMAC_KEY, new String[0])).trim()));
            JwtBuilder tokenBuilder = JwtUtil.newJwtBuilder().signWith((Key)hmac).setExpiration(Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant()));
            if (principalField.isPresent()) {
                tokenBuilder.claim(principalField.get(), (Object)TEST_USER);
            } else {
                tokenBuilder.setSubject(TEST_USER);
            }
            String token = tokenBuilder.compact();
            OkHttpClient clientWithJwt = this.client.newBuilder().authenticator((route, response) -> response.request().newBuilder().header("Authorization", "Bearer " + token).build()).build();
            TestResourceSecurity.assertAuthenticationAutomatic(httpServerInfo.getHttpsUri(), clientWithJwt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJwtWithJwkAuthenticator() throws Exception {
        TestingHttpServer jwkServer = TestResourceSecurity.createTestingJwkServer();
        jwkServer.start();
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"jwt").put((Object)"http-server.authentication.jwt.key-file", (Object)jwkServer.getBaseUrl().toString()).buildOrThrow()).build();){
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)TestSystemAccessControl.NO_IMPERSONATION);
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertAuthenticationDisabled(httpServerInfo.getHttpUri());
            String token = JwtUtil.newJwtBuilder().signWith((Key)JWK_PRIVATE_KEY).setHeaderParam("kid", (Object)JWK_KEY_ID).setSubject(TEST_USER).setExpiration(Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant())).compact();
            OkHttpClient clientWithJwt = this.client.newBuilder().authenticator((route, response) -> response.request().newBuilder().header("Authorization", "Bearer " + token).build()).build();
            TestResourceSecurity.assertAuthenticationAutomatic(httpServerInfo.getHttpsUri(), clientWithJwt);
        }
        finally {
            jwkServer.stop();
        }
    }

    @Test
    public void testOAuth2Authenticator() throws Exception {
        this.verifyOAuth2Authenticator(true, false, Optional.empty());
        this.verifyOAuth2Authenticator(false, false, Optional.empty());
        this.verifyOAuth2Authenticator(true, false, Optional.of("custom-principal"));
        this.verifyOAuth2Authenticator(false, false, Optional.of("custom-principal"));
        this.verifyOAuth2Authenticator(false, true, Optional.empty());
    }

    private void verifyOAuth2Authenticator(boolean webUiEnabled, boolean refreshTokensEnabled, Optional<String> principalField) throws Exception {
        CookieManager cookieManager = new CookieManager();
        OkHttpClient client = this.client.newBuilder().cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)cookieManager)).build();
        try (TokenServer tokenServer = new TokenServer(principalField);
             TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"web-ui.enabled", (Object)String.valueOf(webUiEnabled)).put((Object)"http-server.authentication.type", (Object)"oauth2").putAll(TestResourceSecurity.getOAuth2Properties(tokenServer)).put((Object)"http-server.authentication.oauth2.principal-field", (Object)principalField.orElse("sub")).put((Object)"http-server.authentication.oauth2.refresh-tokens", (Object)String.valueOf(refreshTokensEnabled)).buildOrThrow()).setAdditionalModule(TestResourceSecurity.oauth2Module(tokenServer)).build();){
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)TestSystemAccessControl.NO_IMPERSONATION);
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertAuthenticationDisabled(httpServerInfo.getHttpUri());
            URI baseUri = httpServerInfo.getHttpsUri();
            TestResourceSecurity.assertOk(client, TestResourceSecurity.getPublicLocation(baseUri));
            TestResourceSecurity.assertAuthenticateOAuth2Bearer(client, TestResourceSecurity.getManagementLocation(baseUri), "http://example.com/authorize");
            OAuthBearer bearer = TestResourceSecurity.assertAuthenticateOAuth2Bearer(client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), "http://example.com/authorize");
            TestResourceSecurity.assertResponseCode(client, TestResourceSecurity.getInternalLocation(baseUri), 403);
            TestResourceSecurity.assertOk(client, HttpUriBuilder.uriBuilderFrom((URI)baseUri).replacePath("/oauth2/callback/").addParameter("code", new String[]{"TEST_CODE"}).addParameter("state", new String[]{bearer.getState()}).toString());
            if (refreshTokensEnabled) {
                TokenPairSerializer serializer = (TokenPairSerializer)server.getInstance(com.google.inject.Key.get(TokenPairSerializer.class));
                TokenPairSerializer.TokenPair tokenPair = serializer.deserialize(TestResourceSecurity.getOauthToken(client, bearer.getTokenServer()));
                io.trino.testing.assertions.Assert.assertEquals((String)tokenPair.getAccessToken(), (String)tokenServer.getAccessToken());
                io.trino.testing.assertions.Assert.assertEquals((Object)tokenPair.getRefreshToken(), Optional.of(tokenServer.getRefreshToken()));
            } else {
                io.trino.testing.assertions.Assert.assertEquals((String)TestResourceSecurity.getOauthToken(client, bearer.getTokenServer()), (String)tokenServer.getAccessToken());
            }
            if (webUiEnabled) {
                HttpCookie cookie = (HttpCookie)Iterables.getOnlyElement(cookieManager.getCookieStore().getCookies());
                io.trino.testing.assertions.Assert.assertEquals((String)cookie.getValue(), (String)tokenServer.getAccessToken());
                io.trino.testing.assertions.Assert.assertEquals((String)cookie.getPath(), (String)"/ui/");
                io.trino.testing.assertions.Assert.assertEquals((String)cookie.getDomain(), (String)baseUri.getHost());
                Assert.assertTrue((cookie.getMaxAge() > 0L && cookie.getMaxAge() < TimeUnit.MINUTES.toSeconds(5L) ? 1 : 0) != 0);
                Assert.assertTrue((boolean)cookie.isHttpOnly());
                cookieManager.getCookieStore().removeAll();
            } else {
                List<HttpCookie> cookies = cookieManager.getCookieStore().getCookies();
                Assert.assertTrue((boolean)cookies.isEmpty(), (String)("Expected no cookies when webUi is not enabled, but got: " + cookies));
            }
            OkHttpClient clientWithOAuthToken = client.newBuilder().authenticator((route, response) -> response.request().newBuilder().header("Authorization", "Bearer " + TestResourceSecurity.getOauthToken(client, bearer.getTokenServer())).build()).build();
            TestResourceSecurity.assertAuthenticationAutomatic(httpServerInfo.getHttpsUri(), clientWithOAuthToken);
        }
    }

    private static OAuthBearer assertAuthenticateOAuth2Bearer(OkHttpClient client, String url, String expectedRedirect) throws IOException {
        String tokenServer;
        String redirectTo;
        Matcher matcher;
        Request request = new Request.Builder().url(url).build();
        try (Response response = client.newCall(request).execute();){
            io.trino.testing.assertions.Assert.assertEquals((int)response.code(), (int)401, (String)url);
            String authenticateHeader = response.header("WWW-Authenticate");
            Assert.assertNotNull((Object)authenticateHeader);
            Pattern oauth2BearerPattern = Pattern.compile("Bearer x_redirect_server=\"(https://127.0.0.1:[0-9]+/oauth2/token/initiate/.+)\", x_token_server=\"(https://127.0.0.1:[0-9]+/oauth2/token/.+)\"");
            matcher = oauth2BearerPattern.matcher(authenticateHeader);
            Assert.assertTrue((boolean)matcher.matches(), (String)String.format("Invalid authentication header.\nExpected: %s\nPattern: %s", authenticateHeader, oauth2BearerPattern));
            redirectTo = matcher.group(1);
            tokenServer = matcher.group(2);
        }
        request = new Request.Builder().url(redirectTo).build();
        response = client.newCall(request).execute();
        try {
            io.trino.testing.assertions.Assert.assertEquals((int)response.code(), (int)303);
            String locationHeader = response.header("Location");
            Assert.assertNotNull((Object)locationHeader);
            Pattern locationPattern = Pattern.compile(String.format("%s\\?(.+)", expectedRedirect));
            matcher = locationPattern.matcher(locationHeader);
            Assert.assertTrue((boolean)matcher.matches(), (String)String.format("Invalid location header.\nExpected: %s\nPattern: %s", expectedRedirect, locationPattern));
            HttpCookie nonceCookie = HttpCookie.parse(Objects.requireNonNull(response.header("Set-Cookie"))).get(0);
            nonceCookie.setDomain(request.url().host());
            OAuthBearer oAuthBearer = new OAuthBearer(matcher.group(1), tokenServer, nonceCookie);
            return oAuthBearer;
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Test(dataProvider="groups")
    public void testOAuth2Groups(Optional<Set<String>> groups) throws Exception {
        try (TokenServer tokenServer = new TokenServer(Optional.empty());
             TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"web-ui.enabled", (Object)"true").put((Object)"http-server.authentication.type", (Object)"oauth2").putAll(TestResourceSecurity.getOAuth2Properties(tokenServer)).put((Object)"http-server.authentication.oauth2.groups-field", (Object)GROUPS_CLAIM).buildOrThrow()).setAdditionalModule(TestResourceSecurity.oauth2Module(tokenServer)).build();){
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)TestSystemAccessControl.NO_IMPERSONATION);
            final HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            final String accessToken = tokenServer.issueAccessToken(groups);
            OkHttpClient clientWithOAuthToken = this.client.newBuilder().authenticator((route, response) -> response.request().newBuilder().header("Authorization", "Bearer " + accessToken).build()).build();
            TestResourceSecurity.assertAuthenticationAutomatic(httpServerInfo.getHttpsUri(), clientWithOAuthToken);
            try (Response response2 = clientWithOAuthToken.newCall(new Request.Builder().url(TestResourceSecurity.getLocation(httpServerInfo.getHttpsUri(), "/protocol/identity")).build()).execute();){
                io.trino.testing.assertions.Assert.assertEquals((int)response2.code(), (int)200);
                io.trino.testing.assertions.Assert.assertEquals((String)response2.header("user"), (String)TEST_USER);
                io.trino.testing.assertions.Assert.assertEquals((String)response2.header("principal"), (String)TEST_USER);
                io.trino.testing.assertions.Assert.assertEquals((String)response2.header(GROUPS_CLAIM), (String)groups.map(TestResource::toHeader).orElse(""));
            }
            OkHttpClient clientWithOAuthCookie = this.client.newBuilder().cookieJar(new CookieJar(){

                public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
                }

                public List<Cookie> loadForRequest(HttpUrl url) {
                    return ImmutableList.of((Object)new Cookie.Builder().domain(httpServerInfo.getHttpsUri().getHost()).path("/ui/").name("__Secure-Trino-OAuth2-Token").value(accessToken).httpOnly().secure().build());
                }
            }).build();
            try (Response response3 = clientWithOAuthCookie.newCall(new Request.Builder().url(TestResourceSecurity.getLocation(httpServerInfo.getHttpsUri(), "/ui/api/identity")).build()).execute();){
                io.trino.testing.assertions.Assert.assertEquals((int)response3.code(), (int)200);
                io.trino.testing.assertions.Assert.assertEquals((String)response3.header("user"), (String)TEST_USER);
                io.trino.testing.assertions.Assert.assertEquals((String)response3.header("principal"), (String)TEST_USER);
                io.trino.testing.assertions.Assert.assertEquals((String)response3.header(GROUPS_CLAIM), (String)groups.map(TestResource::toHeader).orElse(""));
            }
        }
    }

    @DataProvider(name="groups")
    public static Object[][] groups() {
        return new Object[][]{{Optional.empty()}, {Optional.of(ImmutableSet.of())}, {Optional.of(ImmutableSet.of((Object)"admin", (Object)"public"))}};
    }

    @Test
    public void testJwtAndOAuth2AuthenticatorsSeparation() throws Exception {
        TestingHttpServer jwkServer = TestResourceSecurity.createTestingJwkServer();
        jwkServer.start();
        try (TokenServer tokenServer = new TokenServer(Optional.empty());
             TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"jwt,oauth2").put((Object)"http-server.authentication.jwt.key-file", (Object)jwkServer.getBaseUrl().toString()).putAll(TestResourceSecurity.getOAuth2Properties(tokenServer)).put((Object)"web-ui.enabled", (Object)"true").buildOrThrow()).setAdditionalModule(TestResourceSecurity.oauth2Module(tokenServer)).build();){
            ((AccessControlManager)server.getInstance(com.google.inject.Key.get(AccessControlManager.class))).addSystemAccessControl((SystemAccessControl)TestSystemAccessControl.NO_IMPERSONATION);
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertAuthenticationDisabled(httpServerInfo.getHttpUri());
            OkHttpClient clientWithOAuthToken = this.client.newBuilder().authenticator((route, response) -> response.request().newBuilder().header("Authorization", "Bearer " + tokenServer.getAccessToken()).build()).build();
            TestResourceSecurity.assertAuthenticationAutomatic(httpServerInfo.getHttpsUri(), clientWithOAuthToken);
            String token = JwtUtil.newJwtBuilder().signWith((Key)JWK_PRIVATE_KEY).setHeaderParam("kid", (Object)JWK_KEY_ID).setSubject(TEST_USER).setExpiration(Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant())).compact();
            OkHttpClient clientWithJwt = this.client.newBuilder().authenticator((route, response) -> response.request().newBuilder().header("Authorization", "Bearer " + token).build()).build();
            TestResourceSecurity.assertAuthenticationAutomatic(httpServerInfo.getHttpsUri(), clientWithJwt);
        }
    }

    private static Module oauth2Module(TokenServer tokenServer) {
        return binder -> {
            JaxrsBinder.jaxrsBinder((Binder)binder).bind(TestResource.class);
            OptionalBinder.newOptionalBinder((Binder)binder, OAuth2Client.class).setBinding().toInstance((Object)tokenServer.getOAuth2Client());
        };
    }

    private static Map<String, String> getOAuth2Properties(TokenServer tokenServer) {
        return ImmutableMap.builder().put((Object)"http-server.authentication.oauth2.issuer", (Object)tokenServer.getIssuer()).put((Object)"http-server.authentication.oauth2.jwks-url", (Object)tokenServer.getJwksUrl()).put((Object)"http-server.authentication.oauth2.state-key", (Object)"test-state-key").put((Object)"http-server.authentication.oauth2.auth-url", (Object)tokenServer.getIssuer()).put((Object)"http-server.authentication.oauth2.token-url", (Object)tokenServer.getIssuer()).put((Object)"http-server.authentication.oauth2.client-id", (Object)tokenServer.getClientId()).put((Object)"http-server.authentication.oauth2.client-secret", (Object)tokenServer.getClientSecret()).put((Object)"http-server.authentication.oauth2.oidc.discovery", (Object)"false").buildOrThrow();
    }

    private static String getOauthToken(OkHttpClient client, String url) throws IOException {
        Request request = new Request.Builder().url(url).build();
        try (Response response = client.newCall(request).execute();){
            String body = Objects.requireNonNull(response.body()).string();
            String string = ((TokenDTO)TestResourceSecurity.json.readValue((String)body, TokenDTO.class)).token;
            return string;
        }
    }

    private void assertInsecureAuthentication(URI baseUri) throws IOException {
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 200, MANAGEMENT_USER_LOGIN, null);
        TestResourceSecurity.assertOk(this.client, TestResourceSecurity.getPublicLocation(baseUri));
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 401);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 200, TEST_USER_LOGIN, null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 401, TEST_USER_LOGIN, "something");
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 401, "unknown", null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 403, TEST_USER_LOGIN, null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401, TEST_USER_LOGIN, "something");
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401, "unknown", null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 200, MANAGEMENT_USER_LOGIN, null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401, MANAGEMENT_USER_LOGIN, "something");
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401, MANAGEMENT_USER_LOGIN, MANAGEMENT_PASSWORD);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403, TEST_USER_LOGIN, null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403, MANAGEMENT_USER_LOGIN, null);
    }

    private void assertPasswordAuthentication(URI baseUri) throws IOException {
        this.assertPasswordAuthentication(baseUri, TEST_PASSWORD);
    }

    private void assertPasswordAuthentication(URI baseUri, String ... allowedPasswords) throws IOException {
        TestResourceSecurity.assertOk(this.client, TestResourceSecurity.getPublicLocation(baseUri));
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 401);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 401, TEST_USER_LOGIN, null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 401, TEST_USER_LOGIN, "invalid");
        for (String password : allowedPasswords) {
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 200, TEST_USER_LOGIN, password);
        }
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401, TEST_USER_LOGIN, null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401, TEST_USER_LOGIN, "invalid");
        for (String password : allowedPasswords) {
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 403, TEST_USER_LOGIN, password);
        }
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401, MANAGEMENT_USER_LOGIN, null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 401, MANAGEMENT_USER_LOGIN, "invalid");
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 200, MANAGEMENT_USER_LOGIN, MANAGEMENT_PASSWORD);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403);
        for (String password : allowedPasswords) {
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403, TEST_USER_LOGIN, password);
        }
    }

    private static void assertAuthenticationAutomatic(URI baseUri, OkHttpClient authorizedClient) throws IOException {
        TestResourceSecurity.assertResponseCode(authorizedClient, TestResourceSecurity.getPublicLocation(baseUri), 200);
        TestResourceSecurity.assertResponseCode(authorizedClient, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 200);
        TestResourceSecurity.assertResponseCode(authorizedClient, TestResourceSecurity.getManagementLocation(baseUri), 403);
        TestResourceSecurity.assertResponseCode(authorizedClient, TestResourceSecurity.getManagementLocation(baseUri), 200, Headers.of((String[])new String[]{ProtocolHeaders.TRINO_HEADERS.requestUser(), MANAGEMENT_USER}));
        TestResourceSecurity.assertResponseCode(authorizedClient, TestResourceSecurity.getInternalLocation(baseUri), 403);
    }

    private void assertAuthenticationDisabled(URI baseUri) throws IOException {
        TestResourceSecurity.assertOk(this.client, TestResourceSecurity.getPublicLocation(baseUri));
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 403);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 403, "unknown", null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 403, "unknown", "something");
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 403, TEST_USER_LOGIN, TEST_PASSWORD);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 403);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 403, "unknown", null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 403, "unknown", "something");
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 403, TEST_USER_LOGIN, TEST_PASSWORD);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403, "unknown", null);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403, "unknown", "something");
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getInternalLocation(baseUri), 403, TEST_USER_LOGIN, TEST_PASSWORD);
    }

    private void assertFixedManagementUser(URI baseUri, boolean insecureAuthentication) throws IOException {
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getPublicLocation(baseUri), 200);
        if (insecureAuthentication) {
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 200, TEST_USER_LOGIN, null);
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 401, "unknown", null);
        } else {
            TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getAuthorizedUserLocation(baseUri), 200, TEST_USER_LOGIN, TEST_PASSWORD);
        }
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 200);
        TestResourceSecurity.assertResponseCode(this.client, TestResourceSecurity.getManagementLocation(baseUri), 200, "unknown", "something");
    }

    private static void assertOk(OkHttpClient client, String url) throws IOException {
        TestResourceSecurity.assertResponseCode(client, url, 200, null, null);
    }

    private static void assertResponseCode(OkHttpClient client, String url, int expectedCode) throws IOException {
        TestResourceSecurity.assertResponseCode(client, url, expectedCode, null, null);
    }

    private static void assertResponseCode(OkHttpClient client, String url, int expectedCode, String userName, String password) throws IOException {
        TestResourceSecurity.assertResponseCode(client, url, expectedCode, Headers.of((String[])new String[]{"Authorization", Credentials.basic((String)((String)MoreObjects.firstNonNull((Object)userName, (Object)"")), (String)((String)MoreObjects.firstNonNull((Object)password, (Object)"")))}));
    }

    private static void assertResponseCode(OkHttpClient client, String url, int expectedCode, Headers headers) throws IOException {
        Request request = new Request.Builder().url(url).headers(headers).build();
        try (Response response = client.newCall(request).execute();){
            io.trino.testing.assertions.Assert.assertEquals((int)response.code(), (int)expectedCode, (String)url);
        }
    }

    private static String getInternalLocation(URI baseUri) {
        return TestResourceSecurity.getLocation(baseUri, "/v1/task");
    }

    private static String getManagementLocation(URI baseUri) {
        return TestResourceSecurity.getLocation(baseUri, "/v1/node");
    }

    private static String getAuthorizedUserLocation(URI baseUri) {
        return TestResourceSecurity.getLocation(baseUri, "/v1/query");
    }

    private static String getPublicLocation(URI baseUri) {
        return TestResourceSecurity.getLocation(baseUri, "/v1/info");
    }

    private static String getLocation(URI baseUri, String path) {
        return HttpUriBuilder.uriBuilderFrom((URI)baseUri).replacePath(path).toString();
    }

    private static Principal authenticate(String user, String password) {
        if (TEST_USER_LOGIN.equals(user) && TEST_PASSWORD.equals(password) || MANAGEMENT_USER_LOGIN.equals(user) && MANAGEMENT_PASSWORD.equals(password)) {
            return new BasicPrincipal(user);
        }
        throw new AccessDeniedException("Invalid credentials");
    }

    private static Principal authenticate2(String user, String password) {
        if (TEST_USER_LOGIN.equals(user) && TEST_PASSWORD2.equals(password) || MANAGEMENT_USER_LOGIN.equals(user) && MANAGEMENT_PASSWORD.equals(password)) {
            return new BasicPrincipal(user);
        }
        throw new AccessDeniedException("Invalid credentials2");
    }

    private static TestingHttpServer createTestingJwkServer() throws IOException {
        NodeInfo nodeInfo = new NodeInfo("test");
        HttpServerConfig config = new HttpServerConfig().setHttpPort(0);
        HttpServerInfo httpServerInfo = new HttpServerInfo(config, nodeInfo);
        return new TestingHttpServer(httpServerInfo, nodeInfo, config, (Servlet)new JwkServlet(), (Map)ImmutableMap.of());
    }

    static {
        json = new ObjectMapper();
        try {
            JWK_PRIVATE_KEY = PemReader.loadPrivateKey((File)new File(Resources.getResource((String)"jwk/jwk-rsa-private.pem").toURI()), Optional.empty());
            JWK_PUBLIC_KEY = PemReader.loadPublicKey((File)new File(Resources.getResource((String)"jwk/jwk-rsa-public.pem").getPath()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class TestSystemAccessControl
    extends AllowAllSystemAccessControl {
        public static final TestSystemAccessControl WITH_IMPERSONATION = new TestSystemAccessControl(false);
        public static final TestSystemAccessControl NO_IMPERSONATION = new TestSystemAccessControl(true);
        private final boolean allowImpersonation;

        private TestSystemAccessControl(boolean allowImpersonation) {
            this.allowImpersonation = allowImpersonation;
        }

        public void checkCanImpersonateUser(SystemSecurityContext context, String userName) {
            if (!this.allowImpersonation) {
                AccessDeniedException.denyImpersonateUser((String)context.getIdentity().getUser(), (String)userName);
            }
        }

        public void checkCanReadSystemInformation(SystemSecurityContext context) {
            if (!context.getIdentity().getUser().equals(TestResourceSecurity.MANAGEMENT_USER)) {
                AccessDeniedException.denyReadSystemInformationAccess();
            }
        }
    }

    private static class TokenServer
    implements AutoCloseable {
        private static final String REFRESH_TOKEN = "REFRESH_TOKEN";
        private final String issuer = "http://example.com/";
        private final String clientId = "clientID";
        private final Date tokenExpiration = Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant());
        private final JwtParser jwtParser = JwtUtil.newJwtParserBuilder().setSigningKey((Key)JWK_PUBLIC_KEY).build();
        private final Optional<String> principalField;
        private final TestingHttpServer jwkServer;
        private final String accessToken;

        public TokenServer(Optional<String> principalField) throws Exception {
            this.principalField = Objects.requireNonNull(principalField, "principalField is null");
            this.jwkServer = TestResourceSecurity.createTestingJwkServer();
            this.jwkServer.start();
            this.accessToken = this.issueAccessToken(Optional.empty());
        }

        @Override
        public void close() throws Exception {
            this.jwkServer.stop();
        }

        public OAuth2Client getOAuth2Client() {
            return new OAuth2Client(){

                public void load() {
                }

                public OAuth2Client.Request createAuthorizationRequest(String state, URI callbackUri) {
                    return new OAuth2Client.Request(URI.create("http://example.com/authorize?" + state), Optional.of(UUID.randomUUID().toString()));
                }

                public OAuth2Client.Response getOAuth2Response(String code, URI callbackUri, Optional<String> nonce) {
                    if (!"TEST_CODE".equals(code)) {
                        throw new IllegalArgumentException("Expected TEST_CODE");
                    }
                    return new OAuth2Client.Response(accessToken, Instant.now().plus(5L, ChronoUnit.MINUTES), Optional.of(this.issueIdToken(nonce.map(this::hashNonce))), Optional.of(TokenServer.REFRESH_TOKEN));
                }

                public Optional<Map<String, Object>> getClaims(String accessToken) {
                    return Optional.of((Map)jwtParser.parseClaimsJws(accessToken).getBody());
                }

                public OAuth2Client.Response refreshTokens(String refreshToken) throws ChallengeFailedException {
                    throw new UnsupportedOperationException("refresh tokens not supported");
                }

                private String hashNonce(String nonce) {
                    return Hashing.sha256().hashString((CharSequence)nonce, StandardCharsets.UTF_8).toString();
                }
            };
        }

        public String getIssuer() {
            return "http://example.com/";
        }

        public String getJwksUrl() {
            return this.jwkServer.getBaseUrl().toString();
        }

        public String getClientId() {
            return "clientID";
        }

        public String getClientSecret() {
            return "clientSecret";
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getRefreshToken() {
            return REFRESH_TOKEN;
        }

        public String issueAccessToken(Optional<Set<String>> groups) {
            JwtBuilder accessToken = JwtUtil.newJwtBuilder().signWith((Key)JWK_PRIVATE_KEY).setHeaderParam("kid", (Object)TestResourceSecurity.JWK_KEY_ID).setIssuer("http://example.com/").setAudience("clientID").setExpiration(this.tokenExpiration);
            if (this.principalField.isPresent()) {
                accessToken.claim(this.principalField.get(), (Object)TestResourceSecurity.TEST_USER);
            } else {
                accessToken.setSubject(TestResourceSecurity.TEST_USER);
            }
            groups.ifPresent(groupsClaim -> accessToken.claim(TestResourceSecurity.GROUPS_CLAIM, groupsClaim));
            return accessToken.compact();
        }

        private String issueIdToken(Optional<String> nonceHash) {
            JwtBuilder idToken = JwtUtil.newJwtBuilder().signWith((Key)JWK_PRIVATE_KEY).setHeaderParam("kid", (Object)TestResourceSecurity.JWK_KEY_ID).setIssuer("http://example.com/").setAudience("clientID").setExpiration(this.tokenExpiration);
            if (this.principalField.isPresent()) {
                idToken.claim(this.principalField.get(), (Object)TestResourceSecurity.TEST_USER);
            } else {
                idToken.setSubject(TestResourceSecurity.TEST_USER);
            }
            nonceHash.ifPresent(nonce -> idToken.claim("nonce", nonce));
            return idToken.compact();
        }
    }

    private static class OAuthBearer {
        private final String state;
        private final String tokenServer;
        private final HttpCookie nonceCookie;

        public OAuthBearer(String state, String tokenServer, HttpCookie nonceCookie) {
            this.state = Objects.requireNonNull(state, "state is null");
            this.tokenServer = Objects.requireNonNull(tokenServer, "tokenServer is null");
            this.nonceCookie = Objects.requireNonNull(nonceCookie, "nonce is null");
        }

        public String getState() {
            return this.state;
        }

        public String getTokenServer() {
            return this.tokenServer;
        }

        public HttpCookie getNonceCookie() {
            return this.nonceCookie;
        }
    }

    private static class TokenDTO {
        @JsonProperty
        String token;

        private TokenDTO() {
        }
    }

    private static class JwkServlet
    extends HttpServlet {
        private JwkServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            String jwkKeys = Resources.toString((URL)Resources.getResource((String)"jwk/jwk-public.json"), (Charset)StandardCharsets.UTF_8);
            response.getWriter().println(jwkKeys);
        }
    }

    @javax.ws.rs.Path(value="/")
    public static class TestResource {
        private final HttpRequestSessionContextFactory sessionContextFactory;

        @Inject
        public TestResource(AccessControl accessControl) {
            this.sessionContextFactory = new HttpRequestSessionContextFactory(new PreparedStatementEncoder(new ProtocolConfig()), (Metadata)MetadataManager.createTestMetadataManager(), user -> ImmutableSet.of(), accessControl);
        }

        @ResourceSecurity(value=ResourceSecurity.AccessType.AUTHENTICATED_USER)
        @GET
        @javax.ws.rs.Path(value="/protocol/identity")
        public javax.ws.rs.core.Response protocolIdentity(@Context HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) {
            return this.echoIdentity(servletRequest, httpHeaders);
        }

        @ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
        @GET
        @javax.ws.rs.Path(value="/ui/api/identity")
        public javax.ws.rs.core.Response webUiIdentity(@Context HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) {
            return this.echoIdentity(servletRequest, httpHeaders);
        }

        public javax.ws.rs.core.Response echoIdentity(HttpServletRequest servletRequest, HttpHeaders httpHeaders) {
            Identity identity = this.sessionContextFactory.extractAuthorizedIdentity(servletRequest, httpHeaders, Optional.empty());
            return javax.ws.rs.core.Response.ok().header("user", (Object)identity.getUser()).header("principal", identity.getPrincipal().map(Principal::getName).orElse(null)).header(TestResourceSecurity.GROUPS_CLAIM, (Object)TestResource.toHeader(identity.getGroups())).build();
        }

        public static String toHeader(Set<String> groups) {
            return groups.stream().sorted().collect(Collectors.joining(","));
        }
    }
}

