/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import com.nimbusds.jose.KeyLengthException;
import io.airlift.units.Duration;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.trino.server.security.oauth2.JweTokenSerializer;
import io.trino.server.security.oauth2.OAuth2Client;
import io.trino.server.security.oauth2.RefreshTokensConfig;
import io.trino.server.security.oauth2.TokenPairSerializer;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestJweTokenSerializer {
    @Test
    public void testSerialization() throws Exception {
        JweTokenSerializer serializer = this.tokenSerializer(Clock.systemUTC(), Duration.succinctDuration((double)5.0, (TimeUnit)TimeUnit.SECONDS));
        Date expiration = new Calendar.Builder().setDate(2022, 6, 22).build().getTime();
        String serializedTokenPair = serializer.serialize(TokenPairSerializer.TokenPair.accessAndRefreshTokens((String)"access_token", (Date)expiration, (String)"refresh_token"));
        TokenPairSerializer.TokenPair deserializedTokenPair = serializer.deserialize(serializedTokenPair);
        Assertions.assertThat((String)deserializedTokenPair.getAccessToken()).isEqualTo("access_token");
        Assertions.assertThat((Date)deserializedTokenPair.getExpiration()).isEqualTo((Object)expiration);
        Assertions.assertThat((Optional)deserializedTokenPair.getRefreshToken()).isEqualTo(Optional.of("refresh_token"));
    }

    @Test
    public void testTokenDeserializationAfterTimeoutButBeforeExpirationExtension() throws Exception {
        TestingClock clock = new TestingClock();
        JweTokenSerializer serializer = this.tokenSerializer(clock, Duration.succinctDuration((double)12.0, (TimeUnit)TimeUnit.MINUTES));
        Date expiration = new Calendar.Builder().setDate(2022, 6, 22).build().getTime();
        String serializedTokenPair = serializer.serialize(TokenPairSerializer.TokenPair.accessAndRefreshTokens((String)"access_token", (Date)expiration, (String)"refresh_token"));
        clock.advanceBy(Duration.succinctDuration((double)10.0, (TimeUnit)TimeUnit.MINUTES));
        TokenPairSerializer.TokenPair deserializedTokenPair = serializer.deserialize(serializedTokenPair);
        Assertions.assertThat((String)deserializedTokenPair.getAccessToken()).isEqualTo("access_token");
        Assertions.assertThat((Date)deserializedTokenPair.getExpiration()).isEqualTo((Object)expiration);
        Assertions.assertThat((Optional)deserializedTokenPair.getRefreshToken()).isEqualTo(Optional.of("refresh_token"));
    }

    @Test
    public void testTokenDeserializationAfterTimeoutAndExpirationExtension() throws Exception {
        TestingClock clock = new TestingClock();
        JweTokenSerializer serializer = this.tokenSerializer(clock, Duration.succinctDuration((double)12.0, (TimeUnit)TimeUnit.MINUTES));
        Date expiration = new Calendar.Builder().setDate(2022, 6, 22).build().getTime();
        String serializedTokenPair = serializer.serialize(TokenPairSerializer.TokenPair.accessAndRefreshTokens((String)"access_token", (Date)expiration, (String)"refresh_token"));
        clock.advanceBy(Duration.succinctDuration((double)20.0, (TimeUnit)TimeUnit.MINUTES));
        Assertions.assertThatThrownBy(() -> serializer.deserialize(serializedTokenPair)).isExactlyInstanceOf(ExpiredJwtException.class);
    }

    private JweTokenSerializer tokenSerializer(Clock clock, Duration tokenExpiration) throws GeneralSecurityException, KeyLengthException {
        return new JweTokenSerializer(new RefreshTokensConfig(), (OAuth2Client)new Oauth2ClientStub(), "trino_coordinator_test_version", "trino_coordinator", "sub", clock, tokenExpiration);
    }

    private static class TestingClock
    extends Clock {
        private Instant currentTime = ZonedDateTime.of(2022, 5, 6, 10, 15, 0, 0, ZoneId.systemDefault()).toInstant();

        private TestingClock() {
        }

        @Override
        public ZoneId getZone() {
            return ZoneId.systemDefault();
        }

        @Override
        public Clock withZone(ZoneId zone) {
            return this;
        }

        @Override
        public Instant instant() {
            return this.currentTime;
        }

        public void advanceBy(Duration currentTimeDelta) {
            this.currentTime = this.currentTime.plus(currentTimeDelta.toMillis(), ChronoUnit.MILLIS);
        }
    }

    static class Oauth2ClientStub
    implements OAuth2Client {
        private final Map<String, Object> claims = Jwts.claims().setSubject("user");

        Oauth2ClientStub() {
        }

        public void load() {
        }

        public OAuth2Client.Request createAuthorizationRequest(String state, URI callbackUri) {
            throw new UnsupportedOperationException("operation is not yet supported");
        }

        public OAuth2Client.Response getOAuth2Response(String code, URI callbackUri, Optional<String> nonce) {
            throw new UnsupportedOperationException("operation is not yet supported");
        }

        public Optional<Map<String, Object>> getClaims(String accessToken) {
            return Optional.of(this.claims);
        }

        public OAuth2Client.Response refreshTokens(String refreshToken) {
            throw new UnsupportedOperationException("operation is not yet supported");
        }
    }
}

