/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.trino.server.security.oauth2.OAuth2Config;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestOAuth2Config {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((OAuth2Config)ConfigAssertions.recordDefaults(OAuth2Config.class)).setStateKey(null).setIssuer(null).setClientId(null).setClientSecret(null).setScopes("openid").setChallengeTimeout(new Duration(15.0, TimeUnit.MINUTES)).setPrincipalField("sub").setGroupsField(null).setAdditionalAudiences(Collections.emptyList()).setMaxClockSkew(new Duration(1.0, TimeUnit.MINUTES)).setUserMappingPattern(null).setUserMappingFile(null).setEnableRefreshTokens(false).setEnableDiscovery(true));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        Path userMappingFile = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = ImmutableMap.builder().put((Object)"http-server.authentication.oauth2.state-key", (Object)"key-secret").put((Object)"http-server.authentication.oauth2.issuer", (Object)"http://127.0.0.1:9000/oauth2").put((Object)"http-server.authentication.oauth2.client-id", (Object)"another-consumer").put((Object)"http-server.authentication.oauth2.client-secret", (Object)"consumer-secret").put((Object)"http-server.authentication.oauth2.scopes", (Object)"email,offline").put((Object)"http-server.authentication.oauth2.principal-field", (Object)"some-field").put((Object)"http-server.authentication.oauth2.groups-field", (Object)"groups").put((Object)"http-server.authentication.oauth2.additional-audiences", (Object)"test-aud1,test-aud2").put((Object)"http-server.authentication.oauth2.challenge-timeout", (Object)"90s").put((Object)"http-server.authentication.oauth2.max-clock-skew", (Object)"15s").put((Object)"http-server.authentication.oauth2.user-mapping.pattern", (Object)"(.*)@something").put((Object)"http-server.authentication.oauth2.user-mapping.file", (Object)userMappingFile.toString()).put((Object)"http-server.authentication.oauth2.refresh-tokens", (Object)"true").put((Object)"http-server.authentication.oauth2.oidc.discovery", (Object)"false").buildOrThrow();
        OAuth2Config expected = new OAuth2Config().setStateKey("key-secret").setIssuer("http://127.0.0.1:9000/oauth2").setClientId("another-consumer").setClientSecret("consumer-secret").setScopes("email, offline").setPrincipalField("some-field").setGroupsField("groups").setAdditionalAudiences(List.of("test-aud1", "test-aud2")).setChallengeTimeout(new Duration(90.0, TimeUnit.SECONDS)).setMaxClockSkew(new Duration(15.0, TimeUnit.SECONDS)).setUserMappingPattern("(.*)@something").setUserMappingFile(userMappingFile.toFile()).setEnableRefreshTokens(true).setEnableDiscovery(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

