/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.Work;
import io.trino.operator.project.PageProjection;
import io.trino.operator.project.SelectedPositions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.RowExpression;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPageFunctionCompiler {
    private static final TestingFunctionResolution FUNCTION_RESOLUTION = new TestingFunctionResolution();
    private static final CallExpression ADD_10_EXPRESSION = Expressions.call((ResolvedFunction)FUNCTION_RESOLUTION.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)BigintType.BIGINT), Expressions.constant((Object)10L, (Type)BigintType.BIGINT)});

    @Test
    public void testFailureDoesNotCorruptFutureResults() {
        PageFunctionCompiler functionCompiler = FUNCTION_RESOLUTION.getPageFunctionCompiler();
        Supplier projectionSupplier = functionCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.empty());
        PageProjection projection = (PageProjection)projectionSupplier.get();
        Page goodPage = TestPageFunctionCompiler.createLongBlockPage(0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L);
        Block goodResult = this.project(projection, goodPage, SelectedPositions.positionsRange((int)0, (int)goodPage.getPositionCount()));
        Assert.assertEquals((int)goodPage.getPositionCount(), (int)goodResult.getPositionCount());
        Page badPage = TestPageFunctionCompiler.createLongBlockPage(0L, 1L, 2L, 3L, 4L, Long.MAX_VALUE);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.project(projection, badPage, SelectedPositions.positionsRange((int)0, (int)100))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        goodResult = this.project(projection, goodPage, SelectedPositions.positionsRange((int)0, (int)goodPage.getPositionCount()));
        Assert.assertEquals((int)goodPage.getPositionCount(), (int)goodResult.getPositionCount());
    }

    @Test
    public void testGeneratedClassName() {
        PageFunctionCompiler functionCompiler = FUNCTION_RESOLUTION.getPageFunctionCompiler();
        String planNodeId = "7";
        String stageId = "20170707_223500_67496_zguwn.2";
        String classSuffix = stageId + "_" + planNodeId;
        Supplier projectionSupplier = functionCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of(classSuffix));
        PageProjection projection = (PageProjection)projectionSupplier.get();
        Work work = projection.project(TestingConnectorSession.SESSION, new DriverYieldSignal(), TestPageFunctionCompiler.createLongBlockPage(0L), SelectedPositions.positionsRange((int)0, (int)1));
        Assert.assertTrue((boolean)work.getClass().getSimpleName().startsWith("PageProjectionWork_" + stageId.replace('.', '_') + "_" + planNodeId));
    }

    @Test
    public void testCache() {
        PageFunctionCompiler cacheCompiler = FUNCTION_RESOLUTION.getPageFunctionCompiler(100);
        Assert.assertSame((Object)cacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.empty()), (Object)cacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.empty()));
        Assert.assertSame((Object)cacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint")), (Object)cacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint")));
        Assert.assertSame((Object)cacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint")), (Object)cacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint2")));
        Assert.assertSame((Object)cacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.empty()), (Object)cacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint2")));
        PageFunctionCompiler noCacheCompiler = FUNCTION_RESOLUTION.getPageFunctionCompiler();
        Assert.assertNotSame((Object)noCacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.empty()), (Object)noCacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.empty()));
        Assert.assertNotSame((Object)noCacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint")), (Object)noCacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint")));
        Assert.assertNotSame((Object)noCacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint")), (Object)noCacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint2")));
        Assert.assertNotSame((Object)noCacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.empty()), (Object)noCacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint2")));
    }

    private Block project(PageProjection projection, Page page, SelectedPositions selectedPositions) {
        Work work = projection.project(TestingConnectorSession.SESSION, new DriverYieldSignal(), page, selectedPositions);
        Assert.assertTrue((boolean)work.process());
        return (Block)work.getResult();
    }

    private static Page createLongBlockPage(long ... values) {
        BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(values.length);
        for (long value : values) {
            BigintType.BIGINT.writeLong(builder, value);
        }
        return new Page(new Block[]{builder.build()});
    }
}

