/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.jmh.Benchmarks;
import io.trino.plugin.tpch.ColumnNaming;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.Plan;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import io.trino.tpch.Customer;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.intellij.lang.annotations.Language;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.options.WarmupMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@State(value=Scope.Benchmark)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Warmup(iterations=5)
@Fork(value=1)
@Measurement(iterations=20)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkPlanner {
    @Benchmark
    public List<Plan> planQueries(BenchmarkData benchmarkData) {
        return (List)benchmarkData.queryRunner.inTransaction(transactionSession -> {
            LogicalPlanner.Stage stage = LogicalPlanner.Stage.valueOf((String)benchmarkData.stage.toUpperCase(Locale.ENGLISH));
            return (ImmutableList)benchmarkData.queries.stream().map(query -> benchmarkData.queryRunner.createPlan(transactionSession, query, stage, false, WarningCollector.NOOP)).collect(ImmutableList.toImmutableList());
        });
    }

    @Benchmark
    public Plan planLargeInQuery(BenchmarkData benchmarkData) {
        return (Plan)benchmarkData.queryRunner.inTransaction(transactionSession -> {
            LogicalPlanner.Stage stage = LogicalPlanner.Stage.valueOf((String)benchmarkData.stage.toUpperCase(Locale.ENGLISH));
            return benchmarkData.queryRunner.createPlan(transactionSession, benchmarkData.largeInQuery, stage, false, WarningCollector.NOOP);
        });
    }

    @Test
    public void verify() {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        BenchmarkPlanner benchmark = new BenchmarkPlanner();
        Assert.assertEquals((int)benchmark.planQueries(data).size(), (int)21);
        Assert.assertNotNull((Object)benchmark.planLargeInQuery(data));
    }

    public static void main(String[] args) throws Exception {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        try {
            new BenchmarkPlanner().planQueries(data);
        }
        finally {
            data.tearDown();
        }
        Benchmarks.benchmark(BenchmarkPlanner.class, (WarmupMode)WarmupMode.BULK).run();
    }

    @State(value=Scope.Benchmark)
    public static class BenchmarkData {
        @Param(value={"optimized", "created"})
        private String stage = LogicalPlanner.Stage.OPTIMIZED.toString();
        private LocalQueryRunner queryRunner;
        private List<String> queries;
        @Language(value="SQL")
        private String largeInQuery;
        private Session session;

        @Setup
        public void setup() {
            String tpch = "tpch";
            this.session = TestingSession.testSessionBuilder().setCatalog(tpch).setSchema("sf1").build();
            this.queryRunner = LocalQueryRunner.create((Session)this.session);
            this.queryRunner.createCatalog(tpch, (ConnectorFactory)new TpchConnectorFactory(4), (Map)ImmutableMap.of((Object)"tpch.column-naming", (Object)ColumnNaming.STANDARD.name()));
            this.queries = (List)IntStream.rangeClosed(1, 22).boxed().filter(i -> i != 15).map(i -> this.readResource(String.format("/io/trino/tpch/queries/q%d.sql", i))).collect(ImmutableList.toImmutableList());
            this.largeInQuery = "SELECT * from orders where o_orderkey in " + IntStream.range(0, 5000).mapToObj(Integer::toString).collect(Collectors.joining(", ", "(", ")"));
        }

        @TearDown
        public void tearDown() {
            this.queryRunner.close();
            this.queryRunner = null;
        }

        public String readResource(String resource) {
            try {
                URL resourceUrl = Customer.class.getResource(resource);
                return Resources.toString((URL)resourceUrl, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

