/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.metadata.AbstractMockMetadata;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.LocalDynamicFilterConsumer;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.testing.assertions.Assert;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestLocalDynamicFilterConsumer
extends BasePlanTest {
    public TestLocalDynamicFilterConsumer() {
        super((Map<String, String>)ImmutableMap.of((Object)"enable_dynamic_filtering", (Object)"true", (Object)"join_reordering_strategy", (Object)OptimizerConfig.JoinReorderingStrategy.NONE.name(), (Object)"join_distribution_type", (Object)OptimizerConfig.JoinDistributionType.BROADCAST.name()));
    }

    @Test
    public void testSimple() {
        TestingDynamicFilterCollector collector = new TestingDynamicFilterCollector();
        LocalDynamicFilterConsumer filter = new LocalDynamicFilterConsumer((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)IntegerType.INTEGER), (List)ImmutableList.of((Object)collector), DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.KILOBYTE));
        filter.setPartitionCount(1);
        Assert.assertEquals((Map)filter.getBuildChannels(), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0));
        org.testng.Assert.assertFalse((boolean)collector.isCollectionComplete());
        filter.addPartition(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)7L))));
        Assert.assertEquals(collector.getCollectedDomains(), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)7L)));
    }

    @Test
    public void testShortCircuitOnAllTupleDomain() {
        TestingDynamicFilterCollector collector = new TestingDynamicFilterCollector();
        LocalDynamicFilterConsumer filter = new LocalDynamicFilterConsumer((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)IntegerType.INTEGER), (List)ImmutableList.of((Object)collector), DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.KILOBYTE));
        org.testng.Assert.assertFalse((boolean)collector.isCollectionComplete());
        filter.addPartition(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.all((Type)IntegerType.INTEGER))));
        Assert.assertEquals(collector.getCollectedDomains(), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.all((Type)IntegerType.INTEGER)));
        filter.setPartitionCount(2);
        filter.addPartition(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L))));
        Assert.assertEquals(collector.getCollectedDomains(), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.all((Type)IntegerType.INTEGER)));
    }

    @Test
    public void testMultiplePartitions() {
        TestingDynamicFilterCollector collector = new TestingDynamicFilterCollector();
        LocalDynamicFilterConsumer filter = new LocalDynamicFilterConsumer((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)IntegerType.INTEGER), (List)ImmutableList.of((Object)collector), DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.KILOBYTE));
        Assert.assertEquals((Map)filter.getBuildChannels(), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0));
        org.testng.Assert.assertFalse((boolean)collector.isCollectionComplete());
        filter.addPartition(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)10L))));
        org.testng.Assert.assertFalse((boolean)collector.isCollectionComplete());
        filter.addPartition(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)20L))));
        org.testng.Assert.assertFalse((boolean)collector.isCollectionComplete());
        filter.setPartitionCount(2);
        Assert.assertEquals(collector.getCollectedDomains(), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)10L, (Object)20L))));
    }

    @Test
    public void testAllDomain() {
        DynamicFilterId filter1 = new DynamicFilterId("123");
        DynamicFilterId filter2 = new DynamicFilterId("124");
        TestingDynamicFilterCollector collector = new TestingDynamicFilterCollector();
        LocalDynamicFilterConsumer filter = new LocalDynamicFilterConsumer((Map)ImmutableMap.of((Object)filter1, (Object)0, (Object)filter2, (Object)1), (Map)ImmutableMap.of((Object)filter1, (Object)IntegerType.INTEGER, (Object)filter2, (Object)IntegerType.INTEGER), (List)ImmutableList.of((Object)collector), DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.KILOBYTE));
        filter.setPartitionCount(1);
        org.testng.Assert.assertFalse((boolean)collector.isCollectionComplete());
        filter.addPartition(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)filter1, (Object)Domain.all((Type)IntegerType.INTEGER), (Object)filter2, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L))));
        Assert.assertEquals(collector.getCollectedDomains(), (Map)ImmutableMap.of((Object)filter1, (Object)Domain.all((Type)IntegerType.INTEGER), (Object)filter2, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L)));
    }

    @Test
    public void testNone() {
        TestingDynamicFilterCollector collector = new TestingDynamicFilterCollector();
        LocalDynamicFilterConsumer filter = new LocalDynamicFilterConsumer((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)IntegerType.INTEGER), (List)ImmutableList.of((Object)collector), DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.KILOBYTE));
        filter.setPartitionCount(1);
        Assert.assertEquals((Map)filter.getBuildChannels(), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0));
        org.testng.Assert.assertFalse((boolean)collector.isCollectionComplete());
        filter.addPartition(TupleDomain.none());
        Assert.assertEquals(collector.getCollectedDomains(), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.none((Type)IntegerType.INTEGER)));
    }

    @Test
    public void testMultipleColumns() {
        TestingDynamicFilterCollector collector = new TestingDynamicFilterCollector();
        LocalDynamicFilterConsumer filter = new LocalDynamicFilterConsumer((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0, (Object)new DynamicFilterId("456"), (Object)1), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)IntegerType.INTEGER, (Object)new DynamicFilterId("456"), (Object)IntegerType.INTEGER), (List)ImmutableList.of((Object)collector), DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.KILOBYTE));
        filter.setPartitionCount(1);
        Assert.assertEquals((Map)filter.getBuildChannels(), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0, (Object)new DynamicFilterId("456"), (Object)1));
        org.testng.Assert.assertFalse((boolean)collector.isCollectionComplete());
        filter.addPartition(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)10L), (Object)new DynamicFilterId("456"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)20L))));
        Assert.assertEquals(collector.getCollectedDomains(), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)10L), (Object)new DynamicFilterId("456"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)20L)));
    }

    @Test
    public void testMultiplePartitionsAndColumns() {
        TestingDynamicFilterCollector collector = new TestingDynamicFilterCollector();
        LocalDynamicFilterConsumer filter = new LocalDynamicFilterConsumer((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0, (Object)new DynamicFilterId("456"), (Object)1), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)IntegerType.INTEGER, (Object)new DynamicFilterId("456"), (Object)BigintType.BIGINT), (List)ImmutableList.of((Object)collector), DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.KILOBYTE));
        filter.setPartitionCount(2);
        Assert.assertEquals((Map)filter.getBuildChannels(), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)0, (Object)new DynamicFilterId("456"), (Object)1));
        org.testng.Assert.assertFalse((boolean)collector.isCollectionComplete());
        filter.addPartition(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)10L), (Object)new DynamicFilterId("456"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)100L))));
        org.testng.Assert.assertFalse((boolean)collector.isCollectionComplete());
        filter.addPartition(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)20L), (Object)new DynamicFilterId("456"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)200L))));
        Assert.assertEquals(collector.getCollectedDomains(), (Map)ImmutableMap.of((Object)new DynamicFilterId("123"), (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)10L, (Object)20L)), (Object)new DynamicFilterId("456"), (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)100L, (Object)200L))));
    }

    @Test
    public void testDynamicFilterPruning() {
        PlanBuilder planBuilder = new PlanBuilder(new PlanNodeIdAllocator(), AbstractMockMetadata.dummyMetadata(), this.getQueryRunner().getDefaultSession());
        Symbol left1 = planBuilder.symbol("left1", (Type)BigintType.BIGINT);
        Symbol left2 = planBuilder.symbol("left2", (Type)IntegerType.INTEGER);
        Symbol left3 = planBuilder.symbol("left3", (Type)SmallintType.SMALLINT);
        Symbol right1 = planBuilder.symbol("right1", (Type)BigintType.BIGINT);
        Symbol right2 = planBuilder.symbol("right2", (Type)IntegerType.INTEGER);
        Symbol right3 = planBuilder.symbol("right3", (Type)SmallintType.SMALLINT);
        DynamicFilterId filter1 = new DynamicFilterId("filter1");
        DynamicFilterId filter2 = new DynamicFilterId("filter2");
        DynamicFilterId filter3 = new DynamicFilterId("filter3");
        JoinNode joinNode = planBuilder.join(JoinNode.Type.INNER, (PlanNode)planBuilder.values(left1, left2, left3), (PlanNode)planBuilder.values(right1, right2, right3), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(left1, right1), (Object)new JoinNode.EquiJoinClause(left2, right2), (Object)new JoinNode.EquiJoinClause(left3, right3)), (List<Symbol>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of((Object)filter1, (Object)right1, (Object)filter2, (Object)right2, (Object)filter3, (Object)right3));
        TestingDynamicFilterCollector collector = new TestingDynamicFilterCollector();
        LocalDynamicFilterConsumer consumer = LocalDynamicFilterConsumer.create((JoinNode)joinNode, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)IntegerType.INTEGER, (Object)SmallintType.SMALLINT), (Set)ImmutableSet.of((Object)filter1, (Object)filter3), (List)ImmutableList.of((Object)collector), (DataSize)DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.KILOBYTE));
        Assert.assertEquals((Map)consumer.getBuildChannels(), (Map)ImmutableMap.of((Object)filter1, (Object)0, (Object)filter3, (Object)2));
        org.testng.Assert.assertFalse((boolean)collector.isCollectionComplete());
        consumer.addPartition(TupleDomain.none());
        org.testng.Assert.assertFalse((boolean)collector.isCollectionComplete());
        consumer.setPartitionCount(1);
        Assert.assertEquals(collector.getCollectedDomains(), (Map)ImmutableMap.of((Object)filter1, (Object)Domain.none((Type)BigintType.BIGINT), (Object)filter3, (Object)Domain.none((Type)SmallintType.SMALLINT)));
    }

    @Test
    public void testCompactionOnSizeLimitExceeded() {
        TestingDynamicFilterCollector collector = new TestingDynamicFilterCollector();
        DataSize sizeLimit = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
        DynamicFilterId filterId = new DynamicFilterId("123");
        LocalDynamicFilterConsumer filter = new LocalDynamicFilterConsumer((Map)ImmutableMap.of((Object)filterId, (Object)0), (Map)ImmutableMap.of((Object)filterId, (Object)VarcharType.VARCHAR), (List)ImmutableList.of((Object)collector), sizeLimit);
        org.testng.Assert.assertFalse((boolean)collector.isCollectionComplete());
        Domain domain1 = Domain.multipleValues((Type)VarcharType.VARCHAR, (List)((List)LongStream.range(0L, 5L).mapToObj(i -> Slices.utf8Slice((String)("value" + i))).collect(ImmutableList.toImmutableList())));
        Domain domain2 = Domain.multipleValues((Type)VarcharType.VARCHAR, (List)((List)LongStream.range(6L, 31L).mapToObj(i -> Slices.utf8Slice((String)("value" + i))).collect(ImmutableList.toImmutableList())));
        Assertions.assertThat((long)domain1.getRetainedSizeInBytes()).isLessThan(sizeLimit.toBytes());
        Assertions.assertThat((long)domain1.union(domain2).getRetainedSizeInBytes()).isGreaterThanOrEqualTo(sizeLimit.toBytes());
        filter.addPartition(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)filterId, (Object)domain1)));
        org.testng.Assert.assertFalse((boolean)collector.isCollectionComplete());
        filter.addPartition(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)filterId, (Object)domain2)));
        org.testng.Assert.assertFalse((boolean)collector.isCollectionComplete());
        filter.setPartitionCount(2);
        org.testng.Assert.assertTrue((boolean)collector.isCollectionComplete());
        Domain collectedDomain = collector.getCollectedDomains().get(filterId);
        Assert.assertEquals((Object)collectedDomain.getValues(), (Object)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"value0"), (boolean)true, (Object)Slices.utf8Slice((String)"value9"), (boolean)true), (Range[])new Range[0]));
    }

    @Test
    public void testSizeLimitExceededAfterCompaction() {
        TestingDynamicFilterCollector collector = new TestingDynamicFilterCollector();
        DataSize sizeLimit = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
        DynamicFilterId filterId = new DynamicFilterId("123");
        LocalDynamicFilterConsumer filter = new LocalDynamicFilterConsumer((Map)ImmutableMap.of((Object)filterId, (Object)0), (Map)ImmutableMap.of((Object)filterId, (Object)VarcharType.VARCHAR), (List)ImmutableList.of((Object)collector), sizeLimit);
        org.testng.Assert.assertFalse((boolean)collector.isCollectionComplete());
        Domain domain1 = Domain.multipleValues((Type)VarcharType.VARCHAR, (List)((List)LongStream.range(0L, 5L).mapToObj(i -> Slices.utf8Slice((String)("value" + i))).collect(ImmutableList.toImmutableList())));
        Domain domain2 = Domain.multipleValues((Type)VarcharType.VARCHAR, (List)((List)LongStream.range(6L, 31L).mapToObj(i -> Slices.utf8Slice((String)("value" + i))).collect(ImmutableList.toImmutableList())));
        Assertions.assertThat((long)domain1.getRetainedSizeInBytes()).isLessThan(sizeLimit.toBytes());
        Assertions.assertThat((long)domain1.union(domain2).simplify(1).getRetainedSizeInBytes()).isLessThanOrEqualTo(sizeLimit.toBytes());
        filter.addPartition(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)filterId, (Object)domain1)));
        org.testng.Assert.assertFalse((boolean)collector.isCollectionComplete());
        filter.addPartition(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)filterId, (Object)domain2)));
        org.testng.Assert.assertFalse((boolean)collector.isCollectionComplete());
        Domain domain3 = Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)IntStream.range(0, 800).mapToObj(i -> "x").collect(Collectors.joining())));
        Assertions.assertThat((long)domain1.union(domain2).union(domain3).simplify(1).getRetainedSizeInBytes()).isGreaterThanOrEqualTo(sizeLimit.toBytes());
        filter.addPartition(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)filterId, (Object)domain3)));
        org.testng.Assert.assertTrue((boolean)collector.isCollectionComplete());
        Assert.assertEquals(collector.getCollectedDomains(), (Map)ImmutableMap.of((Object)filterId, (Object)Domain.all((Type)VarcharType.VARCHAR)));
    }

    private static class TestingDynamicFilterCollector
    implements Consumer<Map<DynamicFilterId, Domain>> {
        private Map<DynamicFilterId, Domain> collectedDomains;

        private TestingDynamicFilterCollector() {
        }

        @Override
        public void accept(Map<DynamicFilterId, Domain> dynamicFilterDomains) {
            Verify.verify((this.collectedDomains == null ? 1 : 0) != 0, (String)"collectedDomains is already set", (Object[])new Object[0]);
            this.collectedDomains = dynamicFilterDomains;
        }

        public boolean isCollectionComplete() {
            return this.collectedDomains != null;
        }

        public Map<DynamicFilterId, Domain> getCollectedDomains() {
            Objects.requireNonNull(this.collectedDomains, "collectedDomains is null");
            return this.collectedDomains;
        }
    }
}

