/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ExpressionTestUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.iterative.rule.CanonicalizeExpressionRewriter;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.SymbolReference;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionBuilder;
import io.trino.transaction.TransactionManager;
import java.util.Map;
import org.testng.annotations.Test;

public class TestCanonicalizeExpressionRewriter {
    private static final TransactionManager TRANSACTION_MANAGER = InMemoryTransactionManager.createTestTransactionManager();
    private static final PlannerContext PLANNER_CONTEXT = TestingPlannerContext.plannerContextBuilder().withTransactionManager(TRANSACTION_MANAGER).build();
    private static final TypeAnalyzer TYPE_ANALYZER = TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)PLANNER_CONTEXT);
    private static final AllowAllAccessControl ACCESS_CONTROL = new AllowAllAccessControl();

    @Test
    public void testRewriteIsNotNullPredicate() {
        TestCanonicalizeExpressionRewriter.assertRewritten("x is NOT NULL", "NOT (x IS NULL)");
    }

    @Test
    public void testRewriteIfExpression() {
        TestCanonicalizeExpressionRewriter.assertRewritten("IF(x = 0, 0, 1)", "CASE WHEN x = 0 THEN 0 ELSE 1 END");
    }

    @Test
    public void testRewriteYearExtract() {
        TestCanonicalizeExpressionRewriter.assertRewritten("EXTRACT(YEAR FROM DATE '2017-07-20')", "year(DATE '2017-07-20')");
    }

    @Test
    public void testCanonicalizeArithmetic() {
        TestCanonicalizeExpressionRewriter.assertRewritten("a + 1", "a + 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("1 + a", "a + 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("a * 1", "a * 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("1 * a", "a * 1");
    }

    @Test
    public void testCanonicalizeComparison() {
        TestCanonicalizeExpressionRewriter.assertRewritten("a = 1", "a = 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("1 = a", "a = 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("a <> 1", "a <> 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("1 <> a", "a <> 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("a > 1", "a > 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("1 > a", "a < 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("a < 1", "a < 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("1 < a", "a > 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("a >= 1", "a >= 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("1 >= a", "a <= 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("a <= 1", "a <= 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("1 <= a", "a >= 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("a IS DISTINCT FROM 1", "a IS DISTINCT FROM 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("1 IS DISTINCT FROM a", "a IS DISTINCT FROM 1");
    }

    @Test
    public void testTypedLiteral() {
        TestCanonicalizeExpressionRewriter.assertRewritten("a = CAST(1 AS decimal(5,2))", "a = CAST(1 AS decimal(5,2))");
        TestCanonicalizeExpressionRewriter.assertRewritten("CAST(1 AS decimal(5,2)) = a", "a = CAST(1 AS decimal(5,2))");
        TestCanonicalizeExpressionRewriter.assertRewritten("a + CAST(1 AS decimal(5,2))", "a + CAST(1 AS decimal(5,2))");
        TestCanonicalizeExpressionRewriter.assertRewritten("CAST(1 AS decimal(5,2)) + a", "a + CAST(1 AS decimal(5,2))");
    }

    @Test
    public void testCanonicalizeRewriteDateFunctionToCast() {
        TestCanonicalizeExpressionRewriter.assertRewritten("date(ts)", "CAST(ts as DATE)");
        TestCanonicalizeExpressionRewriter.assertRewritten("date(tstz)", "CAST(tstz as DATE)");
        TestCanonicalizeExpressionRewriter.assertRewritten("date(v)", "CAST(v as DATE)");
    }

    private static void assertRewritten(String from, String to) {
        ExpressionTestUtils.assertExpressionEquals((Expression)TransactionBuilder.transaction((TransactionManager)TRANSACTION_MANAGER, (AccessControl)ACCESS_CONTROL).execute(SessionTestUtils.TEST_SESSION, transactedSession -> CanonicalizeExpressionRewriter.rewrite((Expression)PlanBuilder.expression(from), (Session)transactedSession, (PlannerContext)PLANNER_CONTEXT, (TypeAnalyzer)TYPE_ANALYZER, (TypeProvider)TypeProvider.copyOf((Map)ImmutableMap.builder().put((Object)new Symbol("x"), (Object)BigintType.BIGINT).put((Object)new Symbol("a"), (Object)BigintType.BIGINT).put((Object)new Symbol("ts"), (Object)TimestampType.createTimestampType((int)3)).put((Object)new Symbol("tstz"), (Object)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3)).put((Object)new Symbol("v"), (Object)VarcharType.createVarcharType((int)100)).buildOrThrow()))), PlanBuilder.expression(to), SymbolAliases.builder().put("x", new SymbolReference("x")).put("a", new SymbolReference("a")).put("ts", new SymbolReference("ts")).put("tstz", new SymbolReference("tstz")).put("v", new SymbolReference("v")).build());
    }
}

