/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.GatherAndMergeWindows;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SymbolReference;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.testng.annotations.Test;

public class TestMergeAdjacentWindows
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTION_RESOLUTION = new TestingFunctionResolution();
    private static final ResolvedFunction AVG = FUNCTION_RESOLUTION.resolveFunction(QualifiedName.of((String)"avg"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE}));
    private static final ResolvedFunction SUM = FUNCTION_RESOLUTION.resolveFunction(QualifiedName.of((String)"sum"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE}));
    private static final ResolvedFunction LAG = FUNCTION_RESOLUTION.resolveFunction(QualifiedName.of((String)"lag"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE}));
    private static final String columnAAlias = "ALIAS_A";
    private static final ExpectedValueProvider<WindowNode.Specification> specificationA = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"ALIAS_A"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of());

    public TestMergeAdjacentWindows() {
        super(new Plugin[0]);
    }

    @Test
    public void testPlanWithoutWindowNode() {
        this.tester().assertThat((Rule<?>)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.values(p.symbol("a"))).doesNotFire();
    }

    @Test
    public void testPlanWithSingleWindowNode() {
        this.tester().assertThat((Rule<?>)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1"), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(AVG, "a")), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }

    @Test
    public void testDistinctAdjacentWindowSpecifications() {
        this.tester().assertThat((Rule<?>)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1"), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(AVG, "a")), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "b"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("sum_1"), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(SUM, "b")), (PlanNode)p.values(p.symbol("b"))))).doesNotFire();
    }

    @Test
    public void testIntermediateNonProjectNode() {
        this.tester().assertThat((Rule<?>)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(1)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_2"), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(AVG, "a")), (PlanNode)p.filter(PlanBuilder.expression("a > 5"), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1"), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(AVG, "a")), (PlanNode)p.values(p.symbol("a")))))).doesNotFire();
    }

    @Test
    public void testDependentAdjacentWindowsIdenticalSpecifications() {
        this.tester().assertThat((Rule<?>)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1"), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(AVG, "avg_2")), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_2"), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(AVG, "a")), (PlanNode)p.values(p.symbol("a"))))).doesNotFire();
    }

    @Test
    public void testDependentAdjacentWindowsDistinctSpecifications() {
        this.tester().assertThat((Rule<?>)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1"), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(AVG, "avg_2")), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "b"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_2"), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(AVG, "a")), (PlanNode)p.values(p.symbol("a"), p.symbol("b"))))).doesNotFire();
    }

    @Test
    public void testIdenticalAdjacentWindowSpecifications() {
        this.tester().assertThat((Rule<?>)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(0)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avg_1"), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(AVG, "a")), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("sum_1"), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(SUM, "a")), (PlanNode)p.values(p.symbol("a"))))).matches(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationA).addFunction(PlanMatchPattern.functionCall(AVG.getSignature().getName(), Optional.empty(), (List<String>)ImmutableList.of((Object)columnAAlias))).addFunction(PlanMatchPattern.functionCall(SUM.getSignature().getName(), Optional.empty(), (List<String>)ImmutableList.of((Object)columnAAlias))), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)columnAAlias, (Object)0))));
    }

    @Test
    public void testIntermediateProjectNodes() {
        String oneAlias = "ALIAS_one";
        String unusedAlias = "ALIAS_unused";
        String lagOutputAlias = "ALIAS_lagOutput";
        String avgOutputAlias = "ALIAS_avgOutput";
        this.tester().assertThat((Rule<?>)new GatherAndMergeWindows.MergeAdjacentWindowsOverProjects(2)).on(p -> p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("lagOutput"), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(LAG, "a", "one")), (PlanNode)p.project(Assignments.builder().put(p.symbol("one"), PlanBuilder.expression("CAST(1 AS bigint)")).putIdentities((Iterable)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("avgOutput"))).build(), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("a"), p.symbol("avgOutput"), p.symbol("unused")}), (PlanNode)p.window(TestMergeAdjacentWindows.newWindowNodeSpecification(p, "a"), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)p.symbol("avgOutput"), (Object)TestMergeAdjacentWindows.newWindowNodeFunction(AVG, "a")), (PlanNode)p.values(p.symbol("a"), p.symbol("unused"))))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)columnAAlias, (Object)PlanMatchPattern.expression(columnAAlias), (Object)oneAlias, (Object)PlanMatchPattern.expression(oneAlias), (Object)lagOutputAlias, (Object)PlanMatchPattern.expression(lagOutputAlias), (Object)avgOutputAlias, (Object)PlanMatchPattern.expression(avgOutputAlias)), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationA).addFunction(lagOutputAlias, PlanMatchPattern.functionCall(LAG.getSignature().getName(), Optional.empty(), (List<String>)ImmutableList.of((Object)columnAAlias, (Object)oneAlias))).addFunction(avgOutputAlias, PlanMatchPattern.functionCall(AVG.getSignature().getName(), Optional.empty(), (List<String>)ImmutableList.of((Object)columnAAlias))), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)oneAlias, (Object)PlanMatchPattern.expression("CAST(1 AS bigint)"), (Object)columnAAlias, (Object)PlanMatchPattern.expression(columnAAlias), (Object)unusedAlias, (Object)PlanMatchPattern.expression(unusedAlias)), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)columnAAlias, (Object)PlanMatchPattern.expression(columnAAlias), (Object)unusedAlias, (Object)PlanMatchPattern.expression(unusedAlias)), PlanMatchPattern.values(columnAAlias, unusedAlias))))));
    }

    private static WindowNode.Specification newWindowNodeSpecification(PlanBuilder planBuilder, String symbolName) {
        return new WindowNode.Specification((List)ImmutableList.of((Object)planBuilder.symbol(symbolName, (Type)BigintType.BIGINT)), Optional.empty());
    }

    private static WindowNode.Function newWindowNodeFunction(ResolvedFunction resolvedFunction, String ... symbols) {
        return new WindowNode.Function(resolvedFunction, Arrays.stream(symbols).map(SymbolReference::new).collect(Collectors.toList()), WindowNode.Frame.DEFAULT_FRAME, false);
    }
}

