/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneApplySourceColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.SymbolReference;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPruneApplySourceColumns
extends BaseRuleTest {
    public TestPruneApplySourceColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllSubquerySymbolsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneApplySourceColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol subquerySymbol1 = p.symbol("subquery_symbol_1");
            Symbol subquerySymbol2 = p.symbol("subquery_symbol_2");
            Symbol inResult = p.symbol("in_result");
            return p.apply(Assignments.of((Symbol)inResult, (Expression)new InPredicate((Expression)a.toSymbolReference(), (Expression)subquerySymbol1.toSymbolReference())), (List<Symbol>)ImmutableList.of(), (PlanNode)p.values(a), (PlanNode)p.values(subquerySymbol1, subquerySymbol2));
        }).matches(PlanMatchPattern.apply((List<String>)ImmutableList.of(), (Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"in_result", (Object)ExpressionMatcher.inPredicate(new SymbolReference("a"), new SymbolReference("subquery_symbol_1"))), PlanMatchPattern.values("a"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"subquery_symbol_1", (Object)PlanMatchPattern.expression("subquery_symbol_1")), PlanMatchPattern.values("subquery_symbol_1", "subquery_symbol_2"))));
    }

    @Test
    public void testAllSubquerySymbolsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneApplySourceColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol subquerySymbol1 = p.symbol("subquery_symbol_1");
            Symbol subquerySymbol2 = p.symbol("subquery_symbol_2");
            Symbol inResult1 = p.symbol("in_result_1");
            Symbol inResult2 = p.symbol("in_result_2");
            return p.apply(Assignments.of((Symbol)inResult1, (Expression)new InPredicate((Expression)a.toSymbolReference(), (Expression)subquerySymbol1.toSymbolReference()), (Symbol)inResult2, (Expression)new InPredicate((Expression)a.toSymbolReference(), (Expression)subquerySymbol2.toSymbolReference())), (List<Symbol>)ImmutableList.of(), (PlanNode)p.values(a), (PlanNode)p.values(subquerySymbol1, subquerySymbol2));
        }).doesNotFire();
    }

    @Test
    public void testNoSubquerySymbolsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneApplySourceColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol subquerySymbol = p.symbol("subquery_symbol");
            Symbol inResult = p.symbol("in_result");
            return p.apply(Assignments.of((Symbol)inResult, (Expression)new InPredicate((Expression)a.toSymbolReference(), (Expression)a.toSymbolReference())), (List<Symbol>)ImmutableList.of(), (PlanNode)p.values(a), (PlanNode)p.values(subquerySymbol));
        }).matches(PlanMatchPattern.apply((List<String>)ImmutableList.of(), (Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"in_result", (Object)ExpressionMatcher.inPredicate(new SymbolReference("a"), new SymbolReference("a"))), PlanMatchPattern.values("a"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.values("subquery_symbol"))));
    }
}

