/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneJoinColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.testng.annotations.Test;

public class TestPruneJoinColumns
extends BaseRuleTest {
    public TestPruneJoinColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneJoinColumns()).on(p -> TestPruneJoinColumns.buildProjectedJoin(p, symbol -> symbol.getName().equals("rightValue"))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"rightValue", (Object)PlanMatchPattern.expression("rightValue")), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("leftKey", "rightKey")), Optional.empty(), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"leftKey", (Object)"leftValue")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"rightKey", (Object)"rightValue"))).withExactOutputs("rightValue")));
    }

    @Test
    public void testAllInputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneJoinColumns()).on(p -> TestPruneJoinColumns.buildProjectedJoin(p, (Predicate<Symbol>)Predicates.alwaysTrue())).doesNotFire();
    }

    @Test
    public void testCrossJoin() {
        this.tester().assertThat((Rule<?>)new PruneJoinColumns()).on(p -> {
            Symbol leftValue = p.symbol("leftValue");
            Symbol rightValue = p.symbol("rightValue");
            return p.project(Assignments.of(), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(leftValue), (PlanNode)p.values(rightValue), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<Symbol>)ImmutableList.of((Object)leftValue), (List<Symbol>)ImmutableList.of((Object)rightValue), Optional.empty(), Optional.empty(), Optional.empty()));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.empty(), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"leftValue")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"rightValue"))).withExactOutputs(new String[0])));
    }

    private static PlanNode buildProjectedJoin(PlanBuilder p, Predicate<Symbol> projectionFilter) {
        Symbol leftKey = p.symbol("leftKey");
        Symbol leftValue = p.symbol("leftValue");
        Symbol rightKey = p.symbol("rightKey");
        Symbol rightValue = p.symbol("rightValue");
        ImmutableList leftOutputs = ImmutableList.of((Object)leftKey, (Object)leftValue);
        ImmutableList rightOutputs = ImmutableList.of((Object)rightKey, (Object)rightValue);
        return p.project(Assignments.identity((Iterable)((Iterable)ImmutableList.of((Object)leftKey, (Object)leftValue, (Object)rightKey, (Object)rightValue).stream().filter(projectionFilter).collect(ImmutableList.toImmutableList()))), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(leftKey, leftValue), (PlanNode)p.values(rightKey, rightValue), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(leftKey, rightKey)), (List<Symbol>)leftOutputs, (List<Symbol>)rightOutputs, Optional.empty(), Optional.empty(), Optional.empty()));
    }
}

