/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.assertions.TopNRankingSymbolMatcher;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushdownFilterIntoWindow;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestPushdownFilterIntoWindow
extends BaseRuleTest {
    public TestPushdownFilterIntoWindow() {
        super(new Plugin[0]);
    }

    @Test
    public void testEliminateFilter() {
        this.assertEliminateFilter("row_number");
        this.assertEliminateFilter("rank");
    }

    private void assertEliminateFilter(String rankingFunctionName) {
        ResolvedFunction ranking = this.tester().getMetadata().resolveFunction(this.tester().getSession(), QualifiedName.of((String)rankingFunctionName), TypeSignatureProvider.fromTypes((Type[])new Type[0]));
        this.tester().assertThat((Rule<?>)new PushdownFilterIntoWindow(this.tester().getPlannerContext())).on(p -> {
            Symbol rankSymbol = p.symbol("rank_1");
            Symbol a = p.symbol("a", (Type)BigintType.BIGINT);
            OrderingScheme orderingScheme = new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST));
            return p.filter(PlanBuilder.expression("rank_1 < cast(100 as bigint)"), (PlanNode)p.window(new WindowNode.Specification((List)ImmutableList.of((Object)a), Optional.of(orderingScheme)), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)rankSymbol, (Object)TestPushdownFilterIntoWindow.newWindowNodeFunction(ranking, a)), (PlanNode)p.values(p.symbol("a"))));
        }).matches(PlanMatchPattern.topNRanking(pattern -> pattern.maxRankingPerPartition(99).partial(false), PlanMatchPattern.values("a")));
    }

    @Test
    public void testKeepFilter() {
        this.assertKeepFilter("row_number");
        this.assertKeepFilter("rank");
    }

    private void assertKeepFilter(String rankingFunctionName) {
        ResolvedFunction ranking = this.tester().getMetadata().resolveFunction(this.tester().getSession(), QualifiedName.of((String)rankingFunctionName), TypeSignatureProvider.fromTypes((Type[])new Type[0]));
        this.tester().assertThat((Rule<?>)new PushdownFilterIntoWindow(this.tester().getPlannerContext())).on(p -> {
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            Symbol a = p.symbol("a", (Type)BigintType.BIGINT);
            OrderingScheme orderingScheme = new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST));
            return p.filter(PlanBuilder.expression("cast(3 as bigint) < row_number_1 and row_number_1 < cast(100 as bigint)"), (PlanNode)p.window(new WindowNode.Specification((List)ImmutableList.of((Object)a), Optional.of(orderingScheme)), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)rowNumberSymbol, (Object)TestPushdownFilterIntoWindow.newWindowNodeFunction(ranking, a)), (PlanNode)p.values(p.symbol("a"))));
        }).matches(PlanMatchPattern.filter("cast(3 as bigint) < row_number_1 and row_number_1 < cast(100 as bigint)", PlanMatchPattern.topNRanking(pattern -> pattern.partial(false).maxRankingPerPartition(99).specification((List<String>)ImmutableList.of((Object)"a"), (List<String>)ImmutableList.of((Object)"a"), (Map<String, SortOrder>)ImmutableMap.of((Object)"a", (Object)SortOrder.ASC_NULLS_FIRST)), PlanMatchPattern.values("a")).withAlias("row_number_1", (RvalueMatcher)new TopNRankingSymbolMatcher())));
        this.tester().assertThat((Rule<?>)new PushdownFilterIntoWindow(this.tester().getPlannerContext())).on(p -> {
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            Symbol a = p.symbol("a", (Type)BigintType.BIGINT);
            OrderingScheme orderingScheme = new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST));
            return p.filter(PlanBuilder.expression("row_number_1 < cast(100 as bigint) and a = 1"), (PlanNode)p.window(new WindowNode.Specification((List)ImmutableList.of((Object)a), Optional.of(orderingScheme)), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)rowNumberSymbol, (Object)TestPushdownFilterIntoWindow.newWindowNodeFunction(ranking, a)), (PlanNode)p.values(p.symbol("a"))));
        }).matches(PlanMatchPattern.filter("a = 1", PlanMatchPattern.topNRanking(pattern -> pattern.partial(false).maxRankingPerPartition(99).specification((List<String>)ImmutableList.of((Object)"a"), (List<String>)ImmutableList.of((Object)"a"), (Map<String, SortOrder>)ImmutableMap.of((Object)"a", (Object)SortOrder.ASC_NULLS_FIRST)), PlanMatchPattern.values("a")).withAlias("row_number_1", (RvalueMatcher)new TopNRankingSymbolMatcher())));
    }

    @Test
    public void testNoUpperBound() {
        this.assertNoUpperBound("row_number");
        this.assertNoUpperBound("rank");
    }

    private void assertNoUpperBound(String rankingFunctionName) {
        ResolvedFunction ranking = this.tester().getMetadata().resolveFunction(this.tester().getSession(), QualifiedName.of((String)rankingFunctionName), TypeSignatureProvider.fromTypes((Type[])new Type[0]));
        this.tester().assertThat((Rule<?>)new PushdownFilterIntoWindow(this.tester().getPlannerContext())).on(p -> {
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            Symbol a = p.symbol("a");
            OrderingScheme orderingScheme = new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST));
            return p.filter(PlanBuilder.expression("cast(3 as bigint) < row_number_1"), (PlanNode)p.window(new WindowNode.Specification((List)ImmutableList.of((Object)a), Optional.of(orderingScheme)), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)rowNumberSymbol, (Object)TestPushdownFilterIntoWindow.newWindowNodeFunction(ranking, a)), (PlanNode)p.values(a)));
        }).doesNotFire();
    }

    private static WindowNode.Function newWindowNodeFunction(ResolvedFunction resolvedFunction, Symbol symbol) {
        return new WindowNode.Function(resolvedFunction, (List)ImmutableList.of((Object)symbol.toSymbolReference()), WindowNode.Frame.DEFAULT_FRAME, false);
    }
}

