/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.TableHandle;
import io.trino.plugin.tpch.TpchTableHandle;
import io.trino.plugin.tpch.TpchTransactionHandle;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.RemoveEmptyDeleteRuleSet;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.testing.DataProviders;
import io.trino.testing.TestingHandles;
import java.util.List;
import java.util.Map;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestRemoveEmptyDeleteRuleSet
extends BaseRuleTest {
    public TestRemoveEmptyDeleteRuleSet() {
        super(new Plugin[0]);
    }

    @Test(dataProvider="rules")
    public void testDoesNotFire(Rule<?> rule) {
        this.tester().assertThat(rule).on(p -> p.tableDelete(new SchemaTableName("sch", "tab"), (PlanNode)p.tableScan(new TableHandle(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorTableHandle)new TpchTableHandle("sf1", "nation", 1.0), (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE), (List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of()), p.symbol("a", (Type)BigintType.BIGINT))).doesNotFire();
        this.tester().assertThat(rule).on(p -> p.tableWithExchangeDelete(new SchemaTableName("sch", "tab"), (PlanNode)p.tableScan(new TableHandle(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorTableHandle)new TpchTableHandle("sf1", "nation", 1.0), (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE), (List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of()), p.symbol("a", (Type)BigintType.BIGINT))).doesNotFire();
    }

    @Test
    public void test() {
        this.tester().assertThat(RemoveEmptyDeleteRuleSet.remoteEmptyDeleteRule()).on(p -> p.tableDelete(new SchemaTableName("sch", "tab"), (PlanNode)p.values(new Symbol[0]), p.symbol("a", (Type)BigintType.BIGINT))).matches(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0)));
    }

    @Test
    public void testWithExchange() {
        this.tester().assertThat(RemoveEmptyDeleteRuleSet.removeEmptyDeleteWithExchangeRule()).on(p -> p.tableWithExchangeDelete(new SchemaTableName("sch", "tab"), (PlanNode)p.values(new Symbol[0]), p.symbol("a", (Type)BigintType.BIGINT))).matches(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0)));
    }

    @DataProvider
    public static Object[][] rules() {
        return (Object[][])RemoveEmptyDeleteRuleSet.rules().stream().collect(DataProviders.toDataProvider());
    }
}

