/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ReplaceJoinOverConstantWithProject;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Expression;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestReplaceJoinOverConstantWithProject
extends BaseRuleTest {
    public TestReplaceJoinOverConstantWithProject() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireOnJoinWithEmptySource() {
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(1, p.symbol("a")), (PlanNode)p.values(0, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(0, p.symbol("a")), (PlanNode)p.values(1, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnJoinWithCondition() {
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(1, p.symbol("a")), (PlanNode)p.values(5, p.symbol("b")), new JoinNode.EquiJoinClause(p.symbol("a"), p.symbol("b")))).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(1, p.symbol("a")), (PlanNode)p.values(5, p.symbol("b")), PlanBuilder.expression("a > b"), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnValuesWithMultipleRows() {
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(5, p.symbol("a")), (PlanNode)p.values(5, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnValuesWithNoOutputs() {
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.values(5, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnValuesWithNonRowExpression() {
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<Expression>)ImmutableList.of((Object)PlanBuilder.expression("CAST(ROW('true') AS ROW(b boolean))"))), (PlanNode)p.values(5, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnOuterJoinWhenSourcePossiblyEmpty() {
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject()).on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(1, p.symbol("a")), (PlanNode)p.filter(PlanBuilder.expression("b > 5"), (PlanNode)p.values(10, p.symbol("b"))), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject()).on(p -> p.join(JoinNode.Type.RIGHT, (PlanNode)p.filter(PlanBuilder.expression("a > 5"), (PlanNode)p.values(10, p.symbol("a"))), (PlanNode)p.values(1, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject()).on(p -> p.join(JoinNode.Type.FULL, (PlanNode)p.values(1, p.symbol("a")), (PlanNode)p.filter(PlanBuilder.expression("b > 5"), (PlanNode)p.values(10, p.symbol("b"))), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject()).on(p -> p.join(JoinNode.Type.FULL, (PlanNode)p.filter(PlanBuilder.expression("a > 5"), (PlanNode)p.values(10, p.symbol("a"))), (PlanNode)p.values(1, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testReplaceInnerJoinWithProject() {
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)PlanBuilder.expression("ROW(1, 'x')"))), (PlanNode)p.values(5, p.symbol("c")), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("1"), (Object)"b", (Object)PlanMatchPattern.expression("'x'"), (Object)"c", (Object)PlanMatchPattern.expression("c")), PlanMatchPattern.values("c")));
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(5, p.symbol("c")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)PlanBuilder.expression("ROW(1, 'x')"))), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("1"), (Object)"b", (Object)PlanMatchPattern.expression("'x'"), (Object)"c", (Object)PlanMatchPattern.expression("c")), PlanMatchPattern.values("c")));
    }

    @Test
    public void testReplaceLeftJoinWithProject() {
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject()).on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)PlanBuilder.expression("ROW(1, 'x')"))), (PlanNode)p.values(5, p.symbol("c")), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("1"), (Object)"b", (Object)PlanMatchPattern.expression("'x'"), (Object)"c", (Object)PlanMatchPattern.expression("c")), PlanMatchPattern.values("c")));
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject()).on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(5, p.symbol("c")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)PlanBuilder.expression("ROW(1, 'x')"))), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("1"), (Object)"b", (Object)PlanMatchPattern.expression("'x'"), (Object)"c", (Object)PlanMatchPattern.expression("c")), PlanMatchPattern.values("c")));
    }

    @Test
    public void testReplaceRightJoinWithProject() {
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject()).on(p -> p.join(JoinNode.Type.RIGHT, (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)PlanBuilder.expression("ROW(1, 'x')"))), (PlanNode)p.values(5, p.symbol("c")), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("1"), (Object)"b", (Object)PlanMatchPattern.expression("'x'"), (Object)"c", (Object)PlanMatchPattern.expression("c")), PlanMatchPattern.values("c")));
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject()).on(p -> p.join(JoinNode.Type.RIGHT, (PlanNode)p.values(5, p.symbol("c")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)PlanBuilder.expression("ROW(1, 'x')"))), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("1"), (Object)"b", (Object)PlanMatchPattern.expression("'x'"), (Object)"c", (Object)PlanMatchPattern.expression("c")), PlanMatchPattern.values("c")));
    }

    @Test
    public void testReplaceFullJoinWithProject() {
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject()).on(p -> p.join(JoinNode.Type.FULL, (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)PlanBuilder.expression("ROW(1, 'x')"))), (PlanNode)p.values(5, p.symbol("c")), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("1"), (Object)"b", (Object)PlanMatchPattern.expression("'x'"), (Object)"c", (Object)PlanMatchPattern.expression("c")), PlanMatchPattern.values("c")));
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject()).on(p -> p.join(JoinNode.Type.FULL, (PlanNode)p.values(5, p.symbol("c")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)PlanBuilder.expression("ROW(1, 'x')"))), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("1"), (Object)"b", (Object)PlanMatchPattern.expression("'x'"), (Object)"c", (Object)PlanMatchPattern.expression("c")), PlanMatchPattern.values("c")));
    }

    @Test
    public void testRemoveOutputDuplicates() {
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)PlanBuilder.expression("ROW(1, 'x')"))), (PlanNode)p.values(5, p.symbol("c")), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b"), (Object)p.symbol("a"), (Object)p.symbol("b")), (List<Symbol>)ImmutableList.of((Object)p.symbol("c"), (Object)p.symbol("c")), Optional.empty())).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("1"), (Object)"b", (Object)PlanMatchPattern.expression("'x'"), (Object)"c", (Object)PlanMatchPattern.expression("c")), PlanMatchPattern.values("c")));
    }

    @Test
    public void testNonDeterministicValues() {
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<Expression>)ImmutableList.of((Object)PlanBuilder.expression("ROW(rand())"))), (PlanNode)p.values(5, p.symbol("b")), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("rand()"), (Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.values("b")));
    }
}

