/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.TableHandle;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.plugin.tpch.TpchTableHandle;
import io.trino.plugin.tpch.TpchTransactionHandle;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedSingleRowSubqueryToProject;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Expression;
import io.trino.testing.TestingHandles;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestTransformCorrelatedSingleRowSubqueryToProject
extends BaseRuleTest {
    public TestTransformCorrelatedSingleRowSubqueryToProject() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedSingleRowSubqueryToProject()).on(p -> p.values(p.symbol("a"))).doesNotFire();
    }

    @Test
    public void testRewrite() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedSingleRowSubqueryToProject()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("l_nationkey")), (PlanNode)p.tableScan(new TableHandle(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorTableHandle)new TpchTableHandle("tiny", "nation", 0.01), (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE), (List<Symbol>)ImmutableList.of((Object)p.symbol("l_nationkey")), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("l_nationkey"), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT))), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("l_expr2"), (Expression)PlanBuilder.expression("l_nationkey + 1")), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"l_expr2", (Object)PlanMatchPattern.expression("l_nationkey + 1"), (Object)"l_nationkey", (Object)PlanMatchPattern.expression("l_nationkey")), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"l_nationkey", (Object)"nationkey"))));
    }

    @Test
    public void testDoesNotFireWithEmptyValuesNode() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedSingleRowSubqueryToProject()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (PlanNode)p.values(p.symbol("a")), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }
}

