/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.cost.CachingTableStatsProvider;
import io.trino.cost.TableStatsProvider;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.AbstractMockMetadata;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableMetadata;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.optimizations.BeginTableWrite;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.function.Function;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestBeginTableWrite {
    @Test
    public void testValidDelete() {
        Assertions.assertThatCode(() -> this.applyOptimization(p -> p.tableDelete(new SchemaTableName("sch", "tab"), (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of((Object)p.symbol("rowId")), true), p.symbol("rowId", (Type)BigintType.BIGINT)))).doesNotThrowAnyException();
    }

    @Test
    public void testValidUpdate() {
        Assertions.assertThatCode(() -> this.applyOptimization(p -> p.tableUpdate(new SchemaTableName("sch", "tab"), (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of((Object)p.symbol("columnToBeUpdated")), true), p.symbol("rowId", (Type)BigintType.BIGINT), (List<Symbol>)ImmutableList.of((Object)p.symbol("columnToBeUpdated"))))).doesNotThrowAnyException();
    }

    @Test
    public void testDeleteWithNonDeletableTableScan() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.applyOptimization(p -> p.tableDelete(new SchemaTableName("sch", "tab"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of(), false), (PlanNode)p.limit(1L, (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of((Object)p.symbol("rowId")), true)), new JoinNode.EquiJoinClause[0]), p.symbol("rowId", (Type)BigintType.BIGINT)))).isInstanceOf(IllegalArgumentException.class)).hasMessage("TableScanNode should be an updatable target");
    }

    @Test
    public void testUpdateWithNonUpdatableTableScan() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.applyOptimization(p -> p.tableUpdate(new SchemaTableName("sch", "tab"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of(), false), (PlanNode)p.limit(1L, (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of((Object)p.symbol("columnToBeUpdated"), (Object)p.symbol("rowId")), true)), new JoinNode.EquiJoinClause[0]), p.symbol("rowId", (Type)BigintType.BIGINT), (List<Symbol>)ImmutableList.of((Object)p.symbol("columnToBeUpdated"))))).isInstanceOf(IllegalArgumentException.class)).hasMessage("TableScanNode should be an updatable target");
    }

    @Test
    public void testDeleteWithInvalidNode() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.applyOptimization(p -> p.tableDelete(new SchemaTableName("sch", "tab"), (PlanNode)p.distinctLimit(10L, (List<Symbol>)ImmutableList.of((Object)p.symbol("rowId")), (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), true)), p.symbol("rowId", (Type)BigintType.BIGINT)))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid descendant for DeleteNode or UpdateNode: io.trino.sql.planner.plan.DistinctLimitNode");
    }

    @Test
    public void testUpdateWithInvalidNode() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.applyOptimization(p -> p.tableUpdate(new SchemaTableName("sch", "tab"), (PlanNode)p.distinctLimit(10L, (List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("rowId")), (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), true)), p.symbol("rowId", (Type)BigintType.BIGINT), (List<Symbol>)ImmutableList.of((Object)p.symbol("columnToBeUpdated"))))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid descendant for DeleteNode or UpdateNode: io.trino.sql.planner.plan.DistinctLimitNode");
    }

    private void applyOptimization(Function<PlanBuilder, PlanNode> planProvider) {
        MockMetadata metadata = new MockMetadata();
        Session session = TestingSession.testSessionBuilder().build();
        new BeginTableWrite((Metadata)metadata, FunctionManager.createTestingFunctionManager()).optimize(planProvider.apply(new PlanBuilder(new PlanNodeIdAllocator(), metadata, session)), session, TypeProvider.empty(), new SymbolAllocator(), new PlanNodeIdAllocator(), WarningCollector.NOOP, (TableStatsProvider)new CachingTableStatsProvider((Metadata)metadata, session));
    }

    private static class MockMetadata
    extends AbstractMockMetadata {
        private MockMetadata() {
        }

        @Override
        public TableHandle beginDelete(Session session, TableHandle tableHandle) {
            return tableHandle;
        }

        @Override
        public TableHandle beginUpdate(Session session, TableHandle tableHandle, List<ColumnHandle> updatedColumns) {
            return tableHandle;
        }

        @Override
        public TableMetadata getTableMetadata(Session session, TableHandle tableHandle) {
            return new TableMetadata(tableHandle.getCatalogHandle().getCatalogName(), new ConnectorTableMetadata(new SchemaTableName("sch", "tab"), (List)ImmutableList.of()));
        }
    }
}

