/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.spi.connector.SortOrder;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.tree.FunctionCall;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestWindow
extends BasePlanTest {
    @Test
    public void testWindow() {
        this.assertDistributedPlan("SELECT rank() OVER (PARTITION BY orderkey) FROM orders", PlanMatchPattern.anyTree(PlanMatchPattern.window(pattern -> pattern.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"orderkey"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction(PlanMatchPattern.functionCall("rank", Optional.empty(), (List<String>)ImmutableList.of())), PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))))));
        this.assertDistributedPlan("SELECT row_number() OVER (PARTITION BY orderkey) FROM orders", PlanMatchPattern.anyTree(PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of((Object)"orderkey")), PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))))));
        this.assertDistributedPlan("SELECT orderkey FROM (SELECT orderkey, row_number() OVER (PARTITION BY orderkey ORDER BY custkey) n FROM orders) WHERE n = 1", PlanMatchPattern.anyTree(PlanMatchPattern.topNRanking(pattern -> pattern.specification((List<String>)ImmutableList.of((Object)"orderkey"), (List<String>)ImmutableList.of((Object)"custkey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"custkey", (Object)SortOrder.ASC_NULLS_LAST)), PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"custkey", (Object)"custkey"))))));
        this.assertDistributedPlan("SELECT rank() OVER (PARTITION BY orderstatus) FROM orders", PlanMatchPattern.anyTree(PlanMatchPattern.window(pattern -> pattern.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"orderstatus"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction(PlanMatchPattern.functionCall("rank", Optional.empty(), (List<String>)ImmutableList.of())), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus"))))))));
        this.assertDistributedPlan("SELECT row_number() OVER (PARTITION BY orderstatus) FROM orders", PlanMatchPattern.anyTree(PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of((Object)"orderstatus")), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus"))))))));
        this.assertDistributedPlan("SELECT orderstatus FROM (SELECT orderstatus, row_number() OVER (PARTITION BY orderstatus ORDER BY custkey) n FROM orders) WHERE n = 1", PlanMatchPattern.anyTree(PlanMatchPattern.topNRanking(pattern -> pattern.specification((List<String>)ImmutableList.of((Object)"orderstatus"), (List<String>)ImmutableList.of((Object)"custkey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"custkey", (Object)SortOrder.ASC_NULLS_LAST)).partial(false), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.topNRanking(topNRanking -> topNRanking.specification((List<String>)ImmutableList.of((Object)"orderstatus"), (List<String>)ImmutableList.of((Object)"custkey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"custkey", (Object)SortOrder.ASC_NULLS_LAST)).partial(true), PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus", (Object)"custkey", (Object)"custkey")))))))));
    }

    @Test
    public void testWindowAfterJoin() {
        Session disableCbo = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_distribution_type", JoinNode.DistributionType.PARTITIONED.name()).setSystemProperty("join_reordering_strategy", OptimizerConfig.JoinReorderingStrategy.ELIMINATE_CROSS_JOINS.name()).build();
        this.assertDistributedPlan("SELECT rank() OVER (PARTITION BY o.orderstatus, o.orderkey) FROM orders o JOIN lineitem l ON o.orderstatus = l.linestatus", disableCbo, PlanMatchPattern.anyTree(PlanMatchPattern.window(pattern -> pattern.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"orderstatus", (Object)"orderkey"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction(PlanMatchPattern.functionCall("rank", Optional.empty(), (List<String>)ImmutableList.of())), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.project(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("orderstatus", "linestatus")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus", (Object)"orderkey", (Object)"orderkey")))), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"linestatus", (Object)"linestatus")))))))))));
        this.assertDistributedPlan("SELECT rank() OVER (PARTITION BY o.orderkey) FROM orders o JOIN lineitem l ON o.orderstatus = l.linestatus", disableCbo, PlanMatchPattern.anyTree(PlanMatchPattern.window(pattern -> pattern.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"orderkey"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction(PlanMatchPattern.functionCall("rank", Optional.empty(), (List<String>)ImmutableList.of())), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("orderstatus", "linestatus")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus", (Object)"orderkey", (Object)"orderkey")))), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"linestatus", (Object)"linestatus"))))))))))));
        Session broadcastJoin = Session.builder((Session)disableCbo).setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.BROADCAST.name()).build();
        this.assertDistributedPlan("SELECT rank() OVER (PARTITION BY o.custkey) FROM orders o JOIN lineitem l ON o.orderstatus = l.linestatus", broadcastJoin, PlanMatchPattern.anyTree(PlanMatchPattern.window(pattern -> pattern.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"custkey"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction(PlanMatchPattern.functionCall("rank", Optional.empty(), (List<String>)ImmutableList.of())), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.project(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("orderstatus", "linestatus")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus", (Object)"custkey", (Object)"custkey"))), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPLICATE, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"linestatus", (Object)"linestatus"))))))))))));
    }

    @Test
    public void testWindowAfterAggregation() {
        this.assertDistributedPlan("SELECT rank() OVER (PARTITION BY custkey) FROM orders GROUP BY custkey", PlanMatchPattern.anyTree(PlanMatchPattern.window(pattern -> pattern.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"custkey"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction(PlanMatchPattern.functionCall("rank", Optional.empty(), (List<String>)ImmutableList.of())), PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("custkey"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.project(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey")))))))))));
        this.assertDistributedPlan("SELECT rank() OVER (partition by custkey) FROM (SELECT shippriority, custkey, sum(totalprice) FROM orders GROUP BY shippriority, custkey)", PlanMatchPattern.anyTree(PlanMatchPattern.window(pattern -> pattern.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"custkey"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction(PlanMatchPattern.functionCall("rank", Optional.empty(), (List<String>)ImmutableList.of())), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("shippriority", "custkey"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"shippriority", (Object)"shippriority"))))))))))));
    }
}

