/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestExpressions {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testBooleanExpressionInCase() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CASE 1 IS NULL WHEN true THEN 10 ELSE 20 END")))).matches("VALUES 20");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CASE 1 IS NOT NULL WHEN true THEN 10 ELSE 20 END")))).matches("VALUES 10");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CASE 1 BETWEEN 0 AND 2 WHEN true THEN 10 ELSE 20 END")))).matches("VALUES 10");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CASE 1 NOT BETWEEN 0 AND 2 WHEN true THEN 10 ELSE 20 END")))).matches("VALUES 20");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CASE 1 IN (1, 2) WHEN true THEN 10 ELSE 20 END")))).matches("VALUES 10");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CASE 1 NOT IN (1, 2) WHEN true THEN 10 ELSE 20 END")))).matches("VALUES 20");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CASE 1 = 1 WHEN true THEN 10 ELSE 20 END")))).matches("VALUES 10");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CASE 1 = 2 WHEN true THEN 10 ELSE 20 END")))).matches("VALUES 20");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CASE 1 < 2 WHEN true THEN 10 ELSE 20 END")))).matches("VALUES 10");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CASE 1 > 2 WHEN true THEN 10 ELSE 20 END")))).matches("VALUES 20");
    }

    @Test
    public void testInShortCircuit() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT IF(3 IN (2, 4, 3, 5 / 0), 1e0, x + x) FROM (VALUES rand()) t(x)")))).matches("VALUES 1e0");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT 3 IN (2, 4, 3, 5 / 0)")).hasMessage("Division by zero");
    }

    @Test
    public void testInlineNullBind() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT try(k) FROM (SELECT null) t(k)")))).matches("VALUES null");
    }
}

