/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.io.BaseEncoding;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestJsonObjectFunction {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testCreateEmptyObject() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_object()")))).matches("VALUES VARCHAR '{}'");
    }

    @Test
    public void testArgumentPassingConventions() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_object('X' : 'Y')")))).matches("VALUES VARCHAR '{\"X\":\"Y\"}'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_object(KEY 'X' VALUE 'Y')")))).matches("VALUES VARCHAR '{\"X\":\"Y\"}'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_object('X' VALUE 'Y')")))).matches("VALUES VARCHAR '{\"X\":\"Y\"}'");
    }

    @Test
    public void testMultipleMembers() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_object('key_1' : 1, 'key_2' : 2)")))).matches("VALUES VARCHAR '{\"key_2\":2,\"key_1\":1}'");
    }

    @Test
    public void testNullKey() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("SELECT json_object(CAST(null AS varchar) : 1)")).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT).hasMessage("null value passed for JSON object key to JSON_OBJECT function");
    }

    @Test
    public void testNullValue() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_object('key' : null NULL ON NULL)")))).matches("VALUES VARCHAR '{\"key\":null}'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_object('key' : null)")))).matches("VALUES VARCHAR '{\"key\":null}'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_object('key' : null ABSENT ON NULL)")))).matches("VALUES VARCHAR '{}'");
    }

    @Test
    public void testDuplicateKey() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("SELECT json_object('key' : 1, 'key' : 2 WITHOUT UNIQUE KEYS)")).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED).hasMessage("cannot construct a JSON object with duplicate key");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("SELECT json_object('key' : 1, 'key' : 2)")).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED).hasMessage("cannot construct a JSON object with duplicate key");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("SELECT json_object('key' : 1, 'key' : 2 WITH UNIQUE KEYS)")).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT).hasMessage("duplicate key passed to JSON_OBJECT function");
    }

    @Test
    public void testValueWithFormat() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_object('key' : '[ 1, true, \"a\", null ]' FORMAT JSON)")))).matches("VALUES VARCHAR '{\"key\":[1,true,\"a\",null]}'");
        byte[] bytes = "{\"a\" : 1}".getBytes(StandardCharsets.UTF_16LE);
        String varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_object('key' : " + varbinaryLiteral + " FORMAT JSON ENCODING UTF16)")))).matches("VALUES VARCHAR '{\"key\":{\"a\":1}}'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("SELECT json_object('key' : '[...' FORMAT JSON)")).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.JSON_INPUT_CONVERSION_ERROR);
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_object('key' : '{\"a\" : 1, \"a\" : 1}' FORMAT JSON)")))).matches("VALUES VARCHAR '{\"key\":{\"a\":1}}'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_object('key' : '{\"a\" : 1, \"a\" : 1}' FORMAT JSON WITHOUT UNIQUE KEYS)")))).matches("VALUES VARCHAR '{\"key\":{\"a\":1}}'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("SELECT json_object('key' : '{\"a\" : 1, \"a\" : 1}' FORMAT JSON WITH UNIQUE KEYS)")).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED).hasMessage("line 1:8: WITH UNIQUE KEYS behavior is not supported for JSON_OBJECT function when input expression has FORMAT");
    }

    @Test
    public void testValueTypes() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_object('key' : 1e0)")))).matches("VALUES VARCHAR '{\"key\":1.0}'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_object('key' : UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59')")))).matches("VALUES VARCHAR '{\"key\":\"12151fd2-7586-11e9-8f9e-2a86e4085a59\"}'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_object('key' : DATE '2001-01-31')")))).matches("VALUES VARCHAR '{\"key\":\"2001-01-31\"}'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("SELECT json_object('key' : (approx_set(1)))")).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED);
    }

    @Test
    public void testJsonReturningFunctionAsValue() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_object('key' : json_object('a' : 1))")))).matches("VALUES VARCHAR '{\"key\":{\"a\":1}}'");
    }

    @Test
    public void testSubqueries() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_object((SELECT 'key') : (SELECT 1))")))).matches("VALUES VARCHAR '{\"key\":1}'");
    }

    @Test
    public void testOutputFormat() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_object('key' : 1)")))).matches("VALUES VARCHAR '{\"key\":1}'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_object('key' : 1 RETURNING varchar)")))).matches("VALUES VARCHAR '{\"key\":1}'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_object('key' : 1 RETURNING varchar FORMAT JSON)")))).matches("VALUES VARCHAR '{\"key\":1}'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_object('key' : 1 RETURNING varchar(100))")))).matches("VALUES CAST('{\"key\":1}' AS varchar(100))");
        String output = "{\"key\":1}";
        byte[] bytes = output.getBytes(StandardCharsets.UTF_8);
        String varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_object('key' : 1 RETURNING varbinary FORMAT JSON ENCODING UTF8)")))).matches("VALUES " + varbinaryLiteral);
        bytes = output.getBytes(StandardCharsets.UTF_16LE);
        varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_object('key' : 1 RETURNING varbinary FORMAT JSON ENCODING UTF16)")))).matches("VALUES " + varbinaryLiteral);
        bytes = output.getBytes(Charset.forName("UTF_32LE"));
        varbinaryLiteral = "X'" + BaseEncoding.base16().encode(bytes) + "'";
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT json_object('key' : 1 RETURNING varbinary FORMAT JSON ENCODING UTF32)")))).matches("VALUES " + varbinaryLiteral);
    }
}

