/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.airlift.slice.Slice;
import io.trino.FeaturesConfig;
import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.Type;
import io.trino.testing.DateTimeTestingUtils;
import io.trino.type.JsonType;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestArrayOperatorsLegacy
extends AbstractTestFunctions {
    public TestArrayOperatorsLegacy() {
        super(new FeaturesConfig().setLegacyRowToJsonCast(true));
    }

    @BeforeClass
    public void setUp() {
        this.registerScalar(this.getClass());
    }

    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="json")
    public static Slice uncheckedToJson(@SqlType(value="varchar(x)") Slice slice) {
        return slice;
    }

    @Test
    public void testArrayToJson() {
        this.assertFunction("cast(cast (null AS ARRAY(BIGINT)) AS JSON)", (Type)JsonType.JSON, null);
        this.assertFunction("cast(ARRAY[] AS JSON)", (Type)JsonType.JSON, "[]");
        this.assertFunction("cast(ARRAY[null, null] AS JSON)", (Type)JsonType.JSON, "[null,null]");
        this.assertFunction("cast(ARRAY[true, false, null] AS JSON)", (Type)JsonType.JSON, "[true,false,null]");
        this.assertFunction("cast(cast(ARRAY[1, 2, null] AS ARRAY(TINYINT)) AS JSON)", (Type)JsonType.JSON, "[1,2,null]");
        this.assertFunction("cast(cast(ARRAY[12345, -12345, null] AS ARRAY(SMALLINT)) AS JSON)", (Type)JsonType.JSON, "[12345,-12345,null]");
        this.assertFunction("cast(cast(ARRAY[123456789, -123456789, null] AS ARRAY(INTEGER)) AS JSON)", (Type)JsonType.JSON, "[123456789,-123456789,null]");
        this.assertFunction("cast(cast(ARRAY[1234567890123456789, -1234567890123456789, null] AS ARRAY(BIGINT)) AS JSON)", (Type)JsonType.JSON, "[1234567890123456789,-1234567890123456789,null]");
        this.assertFunction("CAST(CAST(ARRAY[3.14E0, nan(), infinity(), -infinity(), null] AS ARRAY(REAL)) AS JSON)", (Type)JsonType.JSON, "[3.14,\"NaN\",\"Infinity\",\"-Infinity\",null]");
        this.assertFunction("CAST(ARRAY[3.14E0, 1e-323, 1e308, nan(), infinity(), -infinity(), null] AS JSON)", (Type)JsonType.JSON, "[3.14,1.0E-323,1.0E308,\"NaN\",\"Infinity\",\"-Infinity\",null]");
        this.assertFunction("CAST(ARRAY[DECIMAL '3.14', null] AS JSON)", (Type)JsonType.JSON, "[3.14,null]");
        this.assertFunction("CAST(ARRAY[DECIMAL '12345678901234567890.123456789012345678', null] AS JSON)", (Type)JsonType.JSON, "[12345678901234567890.123456789012345678,null]");
        this.assertFunction("cast(ARRAY['a', 'bb', null] AS JSON)", (Type)JsonType.JSON, "[\"a\",\"bb\",null]");
        this.assertFunction("cast(ARRAY[JSON '123', JSON '3.14', JSON 'false', JSON '\"abc\"', JSON '[1, \"a\", null]', JSON '{\"a\": 1, \"b\": \"str\", \"c\": null}', JSON 'null', null] AS JSON)", (Type)JsonType.JSON, "[123,3.14,false,\"abc\",[1,\"a\",null],{\"a\":1,\"b\":\"str\",\"c\":null},null,null]");
        this.assertFunction("CAST(ARRAY[TIMESTAMP '1970-01-01 00:00:01', null] AS JSON)", (Type)JsonType.JSON, String.format("[\"%s\",null]", DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0)));
        this.assertFunction("CAST(ARRAY[DATE '2001-08-22', DATE '2001-08-23', null] AS JSON)", (Type)JsonType.JSON, "[\"2001-08-22\",\"2001-08-23\",null]");
        this.assertFunction("cast(ARRAY[ARRAY[1, 2], ARRAY[3, null], ARRAY[], ARRAY[null, null], null] AS JSON)", (Type)JsonType.JSON, "[[1,2],[3,null],[],[null,null],null]");
        this.assertFunction("cast(ARRAY[MAP(ARRAY['b', 'a'], ARRAY[2, 1]), MAP(ARRAY['three', 'none'], ARRAY[3, null]), MAP(), MAP(ARRAY['h2', 'h1'], ARRAY[null, null]), null] AS JSON)", (Type)JsonType.JSON, "[{\"a\":1,\"b\":2},{\"none\":null,\"three\":3},{},{\"h1\":null,\"h2\":null},null]");
        this.assertFunction("cast(ARRAY[ROW(1, 2), ROW(3, CAST(null AS INTEGER)), CAST(ROW(null, null) AS ROW(INTEGER, INTEGER)), null] AS JSON)", (Type)JsonType.JSON, "[[1,2],[3,null],[null,null],null]");
        this.assertFunction("CAST(ARRAY [12345.12345, 12345.12345, 3.0] AS JSON)", (Type)JsonType.JSON, "[12345.12345,12345.12345,3.00000]");
        this.assertFunction("CAST(ARRAY [123456789012345678901234567890.87654321, 123456789012345678901234567890.12345678] AS JSON)", (Type)JsonType.JSON, "[123456789012345678901234567890.87654321,123456789012345678901234567890.12345678]");
    }
}

