/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.base.Throwables;
import io.airlift.slice.Slice;
import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.CastDependency;
import io.trino.spi.function.Convention;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestCastDependencies
extends AbstractTestFunctions {
    @BeforeClass
    public void setUp() {
        this.registerParametricScalar(CastVarcharToInteger.class);
        this.registerParametricScalar(CastAnyToVarchar.class);
        this.registerParametricScalar(CastAnyFromVarchar.class);
    }

    @Test
    public void testConventionDependencies() {
        this.assertFunction("cast_varchar_to_integer('11')", (Type)IntegerType.INTEGER, 11);
        this.assertFunction("cast_any_to_varchar(BIGINT '11')", (Type)VarcharType.VARCHAR, "11");
        this.assertFunction("cast_any_to_varchar(DATE '2005-05-05')", (Type)VarcharType.VARCHAR, "2005-05-05");
        this.assertFunction("cast_any_from_varchar(DATE '2005-05-05', '2005-05-05')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast_any_from_varchar(BIGINT '11', '12')", (Type)BooleanType.BOOLEAN, false);
    }

    @ScalarFunction(value="cast_varchar_to_integer")
    public static class CastVarcharToInteger {
        @SqlType(value="integer")
        public static long castVarcharToInteger(@CastDependency(fromType="varchar", toType="integer", convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle cast, @SqlType(value="varchar") Slice value) {
            try {
                return cast.invokeExact(value);
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, TrinoException.class);
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
    }

    @ScalarFunction(value="cast_any_to_varchar")
    public static class CastAnyToVarchar {
        @TypeParameter(value="V")
        @SqlType(value="varchar")
        public static Slice castAnyToVarchar(@CastDependency(fromType="V", toType="varchar", convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle cast, @SqlType(value="V") long value) {
            try {
                return cast.invokeExact(value);
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, TrinoException.class);
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
    }

    @ScalarFunction(value="cast_any_from_varchar")
    public static class CastAnyFromVarchar {
        @TypeParameter(value="V")
        @SqlType(value="boolean")
        public static boolean castAnyFromVarchar(@CastDependency(fromType="varchar", toType="V", convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle cast, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"V", "V"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equals, @SqlType(value="V") long left, @SqlType(value="varchar") Slice right) {
            try {
                long rightLong = cast.invokeExact(right);
                return equals.invokeExact(left, rightLong);
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, TrinoException.class);
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
    }
}

