/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.SqlDecimal;
import org.testng.annotations.Test;

public class TestDecimalParametricType
extends AbstractTestFunctions {
    @Test
    public void decimalIsCreatedWithPrecisionAndScaleDefined() {
        this.assertDecimalFunction("CAST(1 AS DECIMAL(2, 0))", SqlDecimal.decimal((String)"01", (DecimalType)DecimalType.createDecimalType((int)2, (int)0)));
        this.assertDecimalFunction("CAST(0.01 AS DECIMAL(2, 2))", SqlDecimal.decimal((String)".01", (DecimalType)DecimalType.createDecimalType((int)2, (int)2)));
        this.assertDecimalFunction("CAST(0.02 AS DECIMAL(10, 10))", SqlDecimal.decimal((String)".0200000000", (DecimalType)DecimalType.createDecimalType((int)10, (int)10)));
        this.assertDecimalFunction("CAST(0.02 AS DECIMAL(10, 8))", SqlDecimal.decimal((String)"00.02000000", (DecimalType)DecimalType.createDecimalType((int)10, (int)8)));
    }

    @Test
    public void decimalIsCreatedWithOnlyPrecisionDefined() {
        this.assertDecimalFunction("CAST(1 AS DECIMAL(2))", SqlDecimal.decimal((String)"01", (DecimalType)DecimalType.createDecimalType((int)2)));
        this.assertDecimalFunction("CAST(-22 AS DECIMAL(3))", SqlDecimal.decimal((String)"-022", (DecimalType)DecimalType.createDecimalType((int)3)));
        this.assertDecimalFunction("CAST(31.41 AS DECIMAL(4))", SqlDecimal.decimal((String)"0031", (DecimalType)DecimalType.createDecimalType((int)4)));
    }

    @Test
    public void decimalIsCreatedWithoutParameters() {
        this.assertDecimalFunction("CAST(1 AS DECIMAL)", SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("CAST(-22 AS DECIMAL)", SqlDecimal.decimal((String)"-22", (DecimalType)DecimalType.createDecimalType((int)38)));
        this.assertDecimalFunction("CAST(31.41 AS DECIMAL)", SqlDecimal.decimal((String)"31", (DecimalType)DecimalType.createDecimalType((int)38)));
    }

    @Test
    public void creatingDecimalRoundsValueProperly() {
        this.assertDecimalFunction("CAST(0.022 AS DECIMAL(4, 2))", SqlDecimal.decimal((String)"00.02", (DecimalType)DecimalType.createDecimalType((int)4, (int)2)));
        this.assertDecimalFunction("CAST(0.025 AS DECIMAL(4, 2))", SqlDecimal.decimal((String)"00.03", (DecimalType)DecimalType.createDecimalType((int)4, (int)2)));
        this.assertDecimalFunction("CAST(32.01 AS DECIMAL(3, 1))", SqlDecimal.decimal((String)"32.0", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        this.assertDecimalFunction("CAST(32.06 AS DECIMAL(3, 1))", SqlDecimal.decimal((String)"32.1", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        this.assertDecimalFunction("CAST(32.1 AS DECIMAL(3, 0))", SqlDecimal.decimal((String)"032", (DecimalType)DecimalType.createDecimalType((int)3)));
        this.assertDecimalFunction("CAST(32.5 AS DECIMAL(3, 0))", SqlDecimal.decimal((String)"033", (DecimalType)DecimalType.createDecimalType((int)3)));
        this.assertDecimalFunction("CAST(-0.022 AS DECIMAL(4, 2))", SqlDecimal.decimal((String)"-00.02", (DecimalType)DecimalType.createDecimalType((int)4, (int)2)));
        this.assertDecimalFunction("CAST(-0.025 AS DECIMAL(4, 2))", SqlDecimal.decimal((String)"-00.03", (DecimalType)DecimalType.createDecimalType((int)4, (int)2)));
    }

    @Test
    public void decimalIsNotCreatedWhenScaleExceedsPrecision() {
        this.assertInvalidFunction("CAST(1 AS DECIMAL(1,2))", "DECIMAL scale must be in range [0, precision (1)]: 2");
        this.assertInvalidFunction("CAST(-22 AS DECIMAL(20,21))", "DECIMAL scale must be in range [0, precision (20)]: 21");
        this.assertInvalidFunction("CAST(31.41 AS DECIMAL(0,1))", "DECIMAL precision must be in range [1, 38]: 0");
    }

    @Test
    public void decimalWithZeroLengthCannotBeCreated() {
        this.assertInvalidFunction("CAST(1 AS DECIMAL(0,0))", "DECIMAL precision must be in range [1, 38]: 0");
        this.assertInvalidFunction("CAST(0 AS DECIMAL(0,0))", "DECIMAL precision must be in range [1, 38]: 0");
        this.assertInvalidFunction("CAST(1 AS DECIMAL(0))", "DECIMAL precision must be in range [1, 38]: 0");
        this.assertInvalidFunction("CAST(0 AS DECIMAL(0))", "DECIMAL precision must be in range [1, 38]: 0");
    }
}

