/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import org.testng.annotations.Test;

public class TestVarcharOperators
extends AbstractTestFunctions {
    @Test
    public void testLiteral() {
        this.assertFunction("'foo'", (Type)VarcharType.createVarcharType((int)3), "foo");
        this.assertFunction("'bar'", (Type)VarcharType.createVarcharType((int)3), "bar");
        this.assertFunction("''", (Type)VarcharType.createVarcharType((int)0), "");
    }

    @Test
    public void testTypeConstructor() {
        this.assertFunction("VARCHAR 'foo'", (Type)VarcharType.VARCHAR, "foo");
        this.assertFunction("VARCHAR 'bar'", (Type)VarcharType.VARCHAR, "bar");
        this.assertFunction("VARCHAR ''", (Type)VarcharType.VARCHAR, "");
    }

    @Test
    public void testAdd() {
        this.assertFunction("'foo' || 'foo'", (Type)VarcharType.VARCHAR, "foofoo");
        this.assertFunction("'foo' || 'bar'", (Type)VarcharType.VARCHAR, "foobar");
        this.assertFunction("'bar' || 'foo'", (Type)VarcharType.VARCHAR, "barfoo");
        this.assertFunction("'bar' || 'bar'", (Type)VarcharType.VARCHAR, "barbar");
        this.assertFunction("'bar' || 'barbaz'", (Type)VarcharType.VARCHAR, "barbarbaz");
    }

    @Test
    public void testEqual() {
        this.assertFunction("'foo' = 'foo'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'foo' = 'bar'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'bar' = 'foo'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'bar' = 'bar'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testNotEqual() {
        this.assertFunction("'foo' <> 'foo'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'foo' <> 'bar'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'bar' <> 'foo'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'bar' <> 'bar'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThan() {
        this.assertFunction("'foo' < 'foo'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'foo' < 'bar'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'bar' < 'foo'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'bar' < 'bar'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThanOrEqual() {
        this.assertFunction("'foo' <= 'foo'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'foo' <= 'bar'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'bar' <= 'foo'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'bar' <= 'bar'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testGreaterThan() {
        this.assertFunction("'foo' > 'foo'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'foo' > 'bar'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'bar' > 'foo'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'bar' > 'bar'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.assertFunction("'foo' >= 'foo'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'foo' >= 'bar'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'bar' >= 'foo'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'bar' >= 'bar'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testBetween() {
        this.assertFunction("'foo' BETWEEN 'foo' AND 'foo'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'foo' BETWEEN 'foo' AND 'bar'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'foo' BETWEEN 'bar' AND 'foo'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'foo' BETWEEN 'bar' AND 'bar'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'bar' BETWEEN 'foo' AND 'foo'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'bar' BETWEEN 'foo' AND 'bar'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'bar' BETWEEN 'bar' AND 'foo'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'bar' BETWEEN 'bar' AND 'bar'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testIsDistinctFrom() {
        this.assertFunction("CAST(NULL AS VARCHAR) IS DISTINCT FROM CAST(NULL AS VARCHAR)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'foo' IS DISTINCT FROM 'foo'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("'foo' IS DISTINCT FROM 'fo0'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("NULL IS DISTINCT FROM 'foo'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("'foo' IS DISTINCT FROM NULL", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "cast(null as varchar)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "'foo'", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "cast(123456 as varchar)", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "cast(12345.0123 as varchar)", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "cast(true as varchar)", (Type)BooleanType.BOOLEAN, false);
    }
}

