/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.type.AbstractTestType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestVarcharType
extends AbstractTestType {
    public TestVarcharType() {
        super((Type)VarcharType.VARCHAR, String.class, TestVarcharType.createTestBlock());
    }

    public static Block createTestBlock() {
        BlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 15);
        VarcharType.VARCHAR.writeString(blockBuilder, "apple");
        VarcharType.VARCHAR.writeString(blockBuilder, "apple");
        VarcharType.VARCHAR.writeString(blockBuilder, "apple");
        VarcharType.VARCHAR.writeString(blockBuilder, "banana");
        VarcharType.VARCHAR.writeString(blockBuilder, "banana");
        VarcharType.VARCHAR.writeString(blockBuilder, "banana");
        VarcharType.VARCHAR.writeString(blockBuilder, "banana");
        VarcharType.VARCHAR.writeString(blockBuilder, "banana");
        VarcharType.VARCHAR.writeString(blockBuilder, "cherry");
        VarcharType.VARCHAR.writeString(blockBuilder, "cherry");
        VarcharType.VARCHAR.writeString(blockBuilder, "date");
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        return Slices.utf8Slice((String)(((Slice)value).toStringUtf8() + "_"));
    }

    @Test
    public void testRange() {
        VarcharType type = VarcharType.createVarcharType((int)5);
        Type.Range range = (Type.Range)type.getRange().get();
        String expectedMax = new StringBuilder().appendCodePoint(0x10FFFF).appendCodePoint(0x10FFFF).appendCodePoint(0x10FFFF).appendCodePoint(0x10FFFF).appendCodePoint(0x10FFFF).toString();
        Assert.assertEquals((Object)Slices.utf8Slice((String)""), (Object)range.getMin());
        Assert.assertEquals((Object)Slices.utf8Slice((String)expectedMax), (Object)range.getMax());
    }
}

