/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.operator.InterpretedHashGenerator;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.type.BlockTypeOperators;
import java.util.List;

public final class TypeTestUtils {
    private static final BlockTypeOperators TYPE_OPERATOR_FACTORY = new BlockTypeOperators(new TypeOperators());

    private TypeTestUtils() {
    }

    public static Block getHashBlock(List<? extends Type> hashTypes, Block ... hashBlocks) {
        Preconditions.checkArgument((hashTypes.size() == hashBlocks.length ? 1 : 0) != 0);
        InterpretedHashGenerator hashGenerator = InterpretedHashGenerator.createPositionalWithTypes((List)ImmutableList.copyOf(hashTypes), (BlockTypeOperators)TYPE_OPERATOR_FACTORY);
        int positionCount = hashBlocks[0].getPositionCount();
        BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(positionCount);
        Page page = new Page(hashBlocks);
        for (int i = 0; i < positionCount; ++i) {
            BigintType.BIGINT.writeLong(builder, hashGenerator.hashPosition(i, page));
        }
        return builder.build();
    }

    public static Page getHashPage(Page page, List<? extends Type> types, List<Integer> hashChannels) {
        ImmutableList.Builder hashTypes = ImmutableList.builder();
        Block[] hashBlocks = new Block[hashChannels.size()];
        int hashBlockIndex = 0;
        for (int channel : hashChannels) {
            hashTypes.add((Object)types.get(channel));
            hashBlocks[hashBlockIndex++] = page.getBlock(channel);
        }
        return page.appendColumn(TypeTestUtils.getHashBlock((List<? extends Type>)hashTypes.build(), hashBlocks));
    }
}

