/*
 * Decompiled with CFR 0.152.
 */
package io.trino;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.CatalogHandle;
import io.trino.metadata.SessionPropertyManager;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.TimeZoneKey;
import java.time.Instant;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class FullConnectorSession
implements ConnectorSession {
    private final Session session;
    private final ConnectorIdentity identity;
    private final Map<String, String> properties;
    private final CatalogHandle catalogHandle;
    private final String catalogName;
    private final SessionPropertyManager sessionPropertyManager;

    public FullConnectorSession(Session session, ConnectorIdentity identity) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.properties = null;
        this.catalogHandle = null;
        this.catalogName = null;
        this.sessionPropertyManager = null;
    }

    public FullConnectorSession(Session session, ConnectorIdentity identity, Map<String, String> properties, CatalogHandle catalogHandle, String catalogName, SessionPropertyManager sessionPropertyManager) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties is null"));
        this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
    }

    public Session getSession() {
        return this.session;
    }

    public String getQueryId() {
        return this.session.getQueryId().toString();
    }

    public Optional<String> getSource() {
        return this.session.getSource();
    }

    public ConnectorIdentity getIdentity() {
        return this.identity;
    }

    public TimeZoneKey getTimeZoneKey() {
        return this.session.getTimeZoneKey();
    }

    public Locale getLocale() {
        return this.session.getLocale();
    }

    public Instant getStart() {
        return this.session.getStart();
    }

    public Optional<String> getTraceToken() {
        return this.session.getTraceToken();
    }

    public <T> T getProperty(String propertyName, Class<T> type) {
        if (this.properties == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Unknown session property: %s.%s", this.catalogName, propertyName));
        }
        return this.sessionPropertyManager.decodeCatalogPropertyValue(this.catalogHandle, this.catalogName, propertyName, this.properties.get(propertyName), type);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.getQueryId()).add("user", (Object)this.getUser()).add("source", this.getSource().orElse(null)).add("traceToken", this.getTraceToken().orElse(null)).add("timeZoneKey", (Object)this.getTimeZoneKey()).add("locale", (Object)this.getLocale()).add("start", (Object)this.getStart()).add("properties", this.properties).omitNullValues().toString();
    }
}

