/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public final class CatalogHandle {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(CatalogHandle.class).instanceSize());
    private static final String INFORMATION_SCHEMA_CONNECTOR_PREFIX = "$info_schema@";
    private static final String SYSTEM_TABLES_CONNECTOR_PREFIX = "$system@";
    private final String id;
    private final CatalogHandleType type;
    private final CatalogHandle rootCatalogHandle;

    public static CatalogHandle createRootCatalogHandle(String catalogName) {
        return new CatalogHandle(CatalogHandleType.NORMAL, catalogName);
    }

    public static CatalogHandle createInformationSchemaCatalogHandle(CatalogHandle catalogHandle) {
        return new CatalogHandle(CatalogHandleType.INFORMATION_SCHEMA, catalogHandle.getCatalogName());
    }

    public static CatalogHandle createSystemTablesCatalogHandle(CatalogHandle catalogHandle) {
        return new CatalogHandle(CatalogHandleType.SYSTEM, catalogHandle.getCatalogName());
    }

    @JsonCreator
    public static CatalogHandle fromId(String id) {
        if (id.startsWith(SYSTEM_TABLES_CONNECTOR_PREFIX)) {
            return new CatalogHandle(CatalogHandleType.SYSTEM, id.substring(SYSTEM_TABLES_CONNECTOR_PREFIX.length()));
        }
        if (id.startsWith(INFORMATION_SCHEMA_CONNECTOR_PREFIX)) {
            return new CatalogHandle(CatalogHandleType.INFORMATION_SCHEMA, id.substring(INFORMATION_SCHEMA_CONNECTOR_PREFIX.length()));
        }
        return new CatalogHandle(CatalogHandleType.NORMAL, id);
    }

    private CatalogHandle(CatalogHandleType type, String catalogName) {
        this.type = Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Preconditions.checkArgument((!catalogName.isEmpty() ? 1 : 0) != 0, (Object)"catalogName is empty");
        Preconditions.checkArgument((!catalogName.startsWith(INFORMATION_SCHEMA_CONNECTOR_PREFIX) && !catalogName.startsWith(SYSTEM_TABLES_CONNECTOR_PREFIX) ? 1 : 0) != 0, (String)"Catalog name is an internal name: %s", (Object)catalogName);
        switch (type) {
            case NORMAL: {
                this.id = catalogName;
                this.rootCatalogHandle = this;
                break;
            }
            case INFORMATION_SCHEMA: {
                this.id = INFORMATION_SCHEMA_CONNECTOR_PREFIX + catalogName;
                this.rootCatalogHandle = new CatalogHandle(CatalogHandleType.NORMAL, catalogName);
                break;
            }
            case SYSTEM: {
                this.id = SYSTEM_TABLES_CONNECTOR_PREFIX + catalogName;
                this.rootCatalogHandle = new CatalogHandle(CatalogHandleType.NORMAL, catalogName);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + type);
            }
        }
    }

    @JsonValue
    public String getId() {
        return this.id;
    }

    public String getCatalogName() {
        return this.rootCatalogHandle.id;
    }

    public CatalogHandleType getType() {
        return this.type;
    }

    public CatalogHandle getRootCatalogHandle() {
        return this.rootCatalogHandle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogHandle that = (CatalogHandle)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.id;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.id) + (this.rootCatalogHandle == this ? 0L : this.rootCatalogHandle.getRetainedSizeInBytes());
    }

    public static enum CatalogHandleType {
        NORMAL(false),
        INFORMATION_SCHEMA(true),
        SYSTEM(true);

        private final boolean internal;

        private CatalogHandleType(boolean internal) {
            this.internal = internal;
        }

        public boolean isInternal() {
            return this.internal;
        }
    }
}

