/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.airlift.log.Logger;
import io.trino.connector.CatalogHandle;
import io.trino.metadata.CatalogMetadata;
import io.trino.metadata.CatalogProcedures;
import io.trino.metadata.CatalogTableFunctions;
import io.trino.metadata.CatalogTableProcedures;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.connector.ConnectorIndexProvider;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.function.FunctionProvider;
import io.trino.spi.ptf.ArgumentSpecification;
import io.trino.spi.ptf.ConnectorTableFunction;
import io.trino.spi.ptf.ReturnTypeSpecification;
import io.trino.spi.ptf.TableArgumentSpecification;
import io.trino.spi.session.PropertyMetadata;
import io.trino.split.RecordPageSourceProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class ConnectorServices {
    private static final Logger log = Logger.get(ConnectorServices.class);
    private final CatalogHandle catalogHandle;
    private final Connector connector;
    private final Runnable afterShutdown;
    private final Set<SystemTable> systemTables;
    private final CatalogProcedures procedures;
    private final CatalogTableProcedures tableProcedures;
    private final Optional<FunctionProvider> functionProvider;
    private final CatalogTableFunctions tableFunctions;
    private final Optional<ConnectorSplitManager> splitManager;
    private final Optional<ConnectorPageSourceProvider> pageSourceProvider;
    private final Optional<ConnectorPageSinkProvider> pageSinkProvider;
    private final Optional<ConnectorIndexProvider> indexProvider;
    private final Optional<ConnectorNodePartitioningProvider> partitioningProvider;
    private final Optional<ConnectorAccessControl> accessControl;
    private final List<EventListener> eventListeners;
    private final Map<String, PropertyMetadata<?>> sessionProperties;
    private final Map<String, PropertyMetadata<?>> tableProperties;
    private final Map<String, PropertyMetadata<?>> materializedViewProperties;
    private final Map<String, PropertyMetadata<?>> schemaProperties;
    private final Map<String, PropertyMetadata<?>> columnProperties;
    private final Map<String, PropertyMetadata<?>> analyzeProperties;
    private final Set<ConnectorCapabilities> capabilities;
    private final AtomicBoolean shutdown = new AtomicBoolean();

    public ConnectorServices(CatalogHandle catalogHandle, Connector connector, Runnable afterShutdown) {
        this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        this.connector = Objects.requireNonNull(connector, "connector is null");
        this.afterShutdown = Objects.requireNonNull(afterShutdown, "afterShutdown is null");
        Set systemTables = connector.getSystemTables();
        Objects.requireNonNull(systemTables, String.format("Connector '%s' returned a null system tables set", catalogHandle));
        this.systemTables = ImmutableSet.copyOf((Collection)systemTables);
        Set procedures = connector.getProcedures();
        Objects.requireNonNull(procedures, String.format("Connector '%s' returned a null procedures set", catalogHandle));
        this.procedures = new CatalogProcedures(procedures);
        Set tableProcedures = connector.getTableProcedures();
        Objects.requireNonNull(procedures, String.format("Connector '%s' returned a null table procedures set", catalogHandle));
        this.tableProcedures = new CatalogTableProcedures(tableProcedures);
        this.functionProvider = Objects.requireNonNull(connector.getFunctionProvider(), String.format("Connector '%s' returned a null function provider", catalogHandle));
        Set tableFunctions = connector.getTableFunctions();
        Objects.requireNonNull(tableFunctions, String.format("Connector '%s' returned a null table functions set", catalogHandle));
        this.tableFunctions = new CatalogTableFunctions(tableFunctions);
        tableFunctions.forEach(ConnectorServices::validateTableFunction);
        ConnectorSplitManager splitManager = null;
        try {
            splitManager = connector.getSplitManager();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.splitManager = Optional.ofNullable(splitManager);
        ConnectorPageSourceProvider connectorPageSourceProvider = null;
        try {
            connectorPageSourceProvider = connector.getPageSourceProvider();
            Objects.requireNonNull(connectorPageSourceProvider, String.format("Connector '%s' returned a null page source provider", catalogHandle));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            ConnectorRecordSetProvider connectorRecordSetProvider = connector.getRecordSetProvider();
            Objects.requireNonNull(connectorRecordSetProvider, String.format("Connector '%s' returned a null record set provider", catalogHandle));
            Verify.verify((connectorPageSourceProvider == null ? 1 : 0) != 0, (String)"Connector '%s' returned both page source and record set providers", (Object)catalogHandle);
            connectorPageSourceProvider = new RecordPageSourceProvider(connectorRecordSetProvider);
        }
        catch (UnsupportedOperationException connectorRecordSetProvider) {
            // empty catch block
        }
        this.pageSourceProvider = Optional.ofNullable(connectorPageSourceProvider);
        ConnectorPageSinkProvider connectorPageSinkProvider = null;
        try {
            connectorPageSinkProvider = connector.getPageSinkProvider();
            Objects.requireNonNull(connectorPageSinkProvider, String.format("Connector '%s' returned a null page sink provider", catalogHandle));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.pageSinkProvider = Optional.ofNullable(connectorPageSinkProvider);
        ConnectorIndexProvider indexProvider = null;
        try {
            indexProvider = connector.getIndexProvider();
            Objects.requireNonNull(indexProvider, String.format("Connector '%s' returned a null index provider", catalogHandle));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.indexProvider = Optional.ofNullable(indexProvider);
        ConnectorNodePartitioningProvider partitioningProvider = null;
        try {
            partitioningProvider = connector.getNodePartitioningProvider();
            Objects.requireNonNull(partitioningProvider, String.format("Connector '%s' returned a null partitioning provider", catalogHandle));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.partitioningProvider = Optional.ofNullable(partitioningProvider);
        ConnectorAccessControl accessControl = null;
        try {
            accessControl = connector.getAccessControl();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.accessControl = Optional.ofNullable(accessControl);
        Iterable eventListeners = connector.getEventListeners();
        Objects.requireNonNull(eventListeners, String.format("Connector '%s' returned a null event listeners iterable", eventListeners));
        this.eventListeners = ImmutableList.copyOf((Iterable)eventListeners);
        List sessionProperties = connector.getSessionProperties();
        Objects.requireNonNull(sessionProperties, String.format("Connector '%s' returned a null system properties set", catalogHandle));
        this.sessionProperties = Maps.uniqueIndex((Iterable)sessionProperties, PropertyMetadata::getName);
        List tableProperties = connector.getTableProperties();
        Objects.requireNonNull(tableProperties, String.format("Connector '%s' returned a null table properties set", catalogHandle));
        this.tableProperties = Maps.uniqueIndex((Iterable)tableProperties, PropertyMetadata::getName);
        List materializedViewProperties = connector.getMaterializedViewProperties();
        Objects.requireNonNull(materializedViewProperties, String.format("Connector '%s' returned a null materialized view properties set", catalogHandle));
        this.materializedViewProperties = Maps.uniqueIndex((Iterable)materializedViewProperties, PropertyMetadata::getName);
        List schemaProperties = connector.getSchemaProperties();
        Objects.requireNonNull(schemaProperties, String.format("Connector '%s' returned a null schema properties set", catalogHandle));
        this.schemaProperties = Maps.uniqueIndex((Iterable)schemaProperties, PropertyMetadata::getName);
        List columnProperties = connector.getColumnProperties();
        Objects.requireNonNull(columnProperties, String.format("Connector '%s' returned a null column properties set", catalogHandle));
        this.columnProperties = Maps.uniqueIndex((Iterable)columnProperties, PropertyMetadata::getName);
        List analyzeProperties = connector.getAnalyzeProperties();
        Objects.requireNonNull(analyzeProperties, String.format("Connector '%s' returned a null analyze properties set", catalogHandle));
        this.analyzeProperties = Maps.uniqueIndex((Iterable)analyzeProperties, PropertyMetadata::getName);
        Set capabilities = connector.getCapabilities();
        Objects.requireNonNull(capabilities, String.format("Connector '%s' returned a null capabilities set", catalogHandle));
        this.capabilities = capabilities;
    }

    public CatalogHandle getCatalogHandle() {
        return this.catalogHandle;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public Set<SystemTable> getSystemTables() {
        return this.systemTables;
    }

    public CatalogProcedures getProcedures() {
        return this.procedures;
    }

    public CatalogTableProcedures getTableProcedures() {
        return this.tableProcedures;
    }

    public FunctionProvider getFunctionProvider() {
        Preconditions.checkArgument((boolean)this.functionProvider.isPresent(), (String)"Connector '%s' does not have functions", (Object)this.catalogHandle);
        return this.functionProvider.get();
    }

    public CatalogTableFunctions getTableFunctions() {
        return this.tableFunctions;
    }

    public Optional<ConnectorSplitManager> getSplitManager() {
        return this.splitManager;
    }

    public Optional<ConnectorPageSourceProvider> getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public Optional<ConnectorPageSinkProvider> getPageSinkProvider() {
        return this.pageSinkProvider;
    }

    public Optional<ConnectorIndexProvider> getIndexProvider() {
        return this.indexProvider;
    }

    public Optional<ConnectorNodePartitioningProvider> getPartitioningProvider() {
        return this.partitioningProvider;
    }

    public CatalogMetadata.SecurityManagement getSecurityManagement() {
        return this.accessControl.isPresent() ? CatalogMetadata.SecurityManagement.CONNECTOR : CatalogMetadata.SecurityManagement.SYSTEM;
    }

    public Optional<ConnectorAccessControl> getAccessControl() {
        return this.accessControl;
    }

    public List<EventListener> getEventListeners() {
        return this.eventListeners;
    }

    public Map<String, PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public Map<String, PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public Map<String, PropertyMetadata<?>> getMaterializedViewProperties() {
        return this.materializedViewProperties;
    }

    public Map<String, PropertyMetadata<?>> getColumnProperties() {
        return this.columnProperties;
    }

    public Map<String, PropertyMetadata<?>> getSchemaProperties() {
        return this.schemaProperties;
    }

    public Map<String, PropertyMetadata<?>> getAnalyzeProperties() {
        return this.analyzeProperties;
    }

    public Set<ConnectorCapabilities> getCapabilities() {
        return this.capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.shutdown.compareAndSet(false, true)) {
            return;
        }
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.connector.getClass().getClassLoader());){
            this.connector.shutdown();
        }
        catch (Throwable t) {
            log.error(t, "Error shutting down catalog: %s", new Object[]{this.catalogHandle});
        }
        finally {
            this.afterShutdown.run();
        }
    }

    private static void validateTableFunction(ConnectorTableFunction tableFunction) {
        Objects.requireNonNull(tableFunction, "tableFunction is null");
        Objects.requireNonNull(tableFunction.getName(), "table function name is null");
        Objects.requireNonNull(tableFunction.getSchema(), "table function schema name is null");
        Objects.requireNonNull(tableFunction.getArguments(), "table function arguments is null");
        Objects.requireNonNull(tableFunction.getReturnTypeSpecification(), "table function returnTypeSpecification is null");
        Preconditions.checkArgument((!tableFunction.getName().isEmpty() ? 1 : 0) != 0, (Object)"table function name is empty");
        Preconditions.checkArgument((!tableFunction.getSchema().isEmpty() ? 1 : 0) != 0, (Object)"table function schema name is empty");
        HashSet<String> argumentNames = new HashSet<String>();
        for (ArgumentSpecification specification : tableFunction.getArguments()) {
            if (argumentNames.add(specification.getName())) continue;
            throw new IllegalArgumentException("duplicate argument name: " + specification.getName());
        }
        long tableArgumentsWithRowSemantics = tableFunction.getArguments().stream().filter(TableArgumentSpecification.class::isInstance).map(TableArgumentSpecification.class::cast).filter(TableArgumentSpecification::isRowSemantics).count();
        Preconditions.checkArgument((tableArgumentsWithRowSemantics <= 1L ? 1 : 0) != 0, (Object)"more than one table argument with row semantics");
        ReturnTypeSpecification returnTypeSpecification = tableFunction.getReturnTypeSpecification();
        if (returnTypeSpecification instanceof ReturnTypeSpecification.DescribedTable) {
            ReturnTypeSpecification.DescribedTable describedTable = (ReturnTypeSpecification.DescribedTable)returnTypeSpecification;
            Preconditions.checkArgument((boolean)describedTable.getDescriptor().isTyped(), (Object)"field types missing in returned type specification");
        }
    }
}

