/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.TableHandle;
import io.trino.metadata.ViewColumn;
import io.trino.metadata.ViewDefinition;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ColumnHandle;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Comment;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class CommentTask
implements DataDefinitionTask<Comment> {
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public CommentTask(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "COMMENT";
    }

    @Override
    public ListenableFuture<Void> execute(Comment statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        if (statement.getType() == Comment.Type.TABLE) {
            this.commentOnTable(statement, session);
        } else if (statement.getType() == Comment.Type.VIEW) {
            this.commentOnView(statement, session);
        } else if (statement.getType() == Comment.Type.COLUMN) {
            this.commentOnColumn(statement, session);
        } else {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Unsupported comment type: %s", statement.getType());
        }
        return Futures.immediateVoidFuture();
    }

    private void commentOnTable(Comment statement, Session session) {
        QualifiedObjectName originalTableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
        if (this.metadata.isMaterializedView(session, originalTableName)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist, but a materialized view with that name exists. Setting comments on materialized views is unsupported.", originalTableName);
        }
        if (this.metadata.isView(session, originalTableName)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%1$s' does not exist, but a view with that name exists. Did you mean COMMENT ON VIEW %1$s IS ...?", originalTableName);
        }
        RedirectionAwareTableHandle redirectionAwareTableHandle = this.metadata.getRedirectionAwareTableHandle(session, originalTableName);
        if (redirectionAwareTableHandle.getTableHandle().isEmpty()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table does not exist: %s", originalTableName);
        }
        this.accessControl.checkCanSetTableComment(session.toSecurityContext(), redirectionAwareTableHandle.getRedirectedTableName().orElse(originalTableName));
        TableHandle tableHandle = redirectionAwareTableHandle.getTableHandle().get();
        this.metadata.setTableComment(session, tableHandle, statement.getComment());
    }

    private void commentOnView(Comment statement, Session session) {
        QualifiedObjectName viewName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
        if (this.metadata.getView(session, viewName).isEmpty()) {
            Object exceptionMessage = String.format("View '%s' does not exist", viewName);
            if (this.metadata.getMaterializedView(session, viewName).isPresent()) {
                exceptionMessage = (String)exceptionMessage + ", but a materialized view with that name exists. Setting comments on materialized views is unsupported.";
            } else if (this.metadata.getTableHandle(session, viewName).isPresent()) {
                exceptionMessage = (String)exceptionMessage + ", but a table with that name exists. Did you mean COMMENT ON TABLE " + viewName + " IS ...?";
            }
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, (String)exceptionMessage, new Object[0]);
        }
        this.accessControl.checkCanSetViewComment(session.toSecurityContext(), viewName);
        this.metadata.setViewComment(session, viewName, statement.getComment());
    }

    private void commentOnColumn(Comment statement, Session session) {
        QualifiedName prefix = (QualifiedName)statement.getName().getPrefix().orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_TABLE, (Node)statement, "Table must be specified", new Object[0]));
        QualifiedObjectName originalObjectName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, prefix);
        if (this.metadata.isView(session, originalObjectName)) {
            String columnName = statement.getName().getSuffix();
            ViewDefinition viewDefinition = this.metadata.getView(session, originalObjectName).get();
            ViewColumn viewColumn = viewDefinition.getColumns().stream().filter(column -> column.getName().equals(columnName)).findAny().orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)statement, "Column does not exist: " + columnName, new Object[0]));
            this.accessControl.checkCanSetColumnComment(session.toSecurityContext(), originalObjectName);
            this.metadata.setViewColumnComment(session, originalObjectName, viewColumn.getName(), statement.getComment());
        } else {
            if (this.metadata.isMaterializedView(session, originalObjectName)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Setting comments on the columns of materialized views is unsupported", new Object[0]);
            }
            RedirectionAwareTableHandle redirectionAwareTableHandle = this.metadata.getRedirectionAwareTableHandle(session, originalObjectName);
            if (redirectionAwareTableHandle.getTableHandle().isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table does not exist: " + originalObjectName, new Object[0]);
            }
            TableHandle tableHandle = redirectionAwareTableHandle.getTableHandle().get();
            String columnName = statement.getName().getSuffix();
            Map<String, ColumnHandle> columnHandles = this.metadata.getColumnHandles(session, tableHandle);
            if (!columnHandles.containsKey(columnName)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)statement, "Column does not exist: " + columnName, new Object[0]);
            }
            this.accessControl.checkCanSetColumnComment(session.toSecurityContext(), redirectionAwareTableHandle.getRedirectedTableName().orElse(originalObjectName));
            this.metadata.setColumnComment(session, tableHandle, columnHandles.get(columnName), statement.getComment());
        }
    }
}

