/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Preconditions;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import io.trino.operator.RetryPolicy;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"query.max-pending-splits-per-node", "query.queue-config-file", "experimental.big-query-initial-hash-partitions", "experimental.max-concurrent-big-queries", "experimental.max-queued-big-queries", "query-manager.initialization-required-workers", "query-manager.initialization-timeout", "query.remote-task.max-consecutive-error-count"})
public class QueryManagerConfig {
    public static final long AVAILABLE_HEAP_MEMORY = Runtime.getRuntime().maxMemory();
    private int scheduleSplitBatchSize = 1000;
    private int minScheduleSplitBatchSize = 100;
    private int maxConcurrentQueries = 1000;
    private int maxQueuedQueries = 5000;
    private int hashPartitionCount = 100;
    private Duration minQueryExpireAge = new Duration(15.0, TimeUnit.MINUTES);
    private int maxQueryHistory = 100;
    private int maxQueryLength = 1000000;
    private int maxStageCount = 150;
    private int stageCountWarningThreshold = 50;
    private Duration clientTimeout = new Duration(5.0, TimeUnit.MINUTES);
    private int queryManagerExecutorPoolSize = 5;
    private int queryExecutorPoolSize = 1000;
    private Duration remoteTaskMaxErrorDuration = new Duration(5.0, TimeUnit.MINUTES);
    private int remoteTaskMaxCallbackThreads = 1000;
    private String queryExecutionPolicy = "phased";
    private Duration queryMaxRunTime = new Duration(100.0, TimeUnit.DAYS);
    private Duration queryMaxExecutionTime = new Duration(100.0, TimeUnit.DAYS);
    private Duration queryMaxPlanningTime = new Duration(10.0, TimeUnit.MINUTES);
    private Duration queryMaxCpuTime = new Duration(1.0E9, TimeUnit.DAYS);
    private Optional<DataSize> queryMaxScanPhysicalBytes = Optional.empty();
    private int requiredWorkers = 1;
    private Duration requiredWorkersMaxWait = new Duration(5.0, TimeUnit.MINUTES);
    private RetryPolicy retryPolicy = RetryPolicy.NONE;
    private int queryRetryAttempts = 4;
    private int taskRetryAttemptsPerTask = 4;
    private int taskRetryAttemptsOverall = Integer.MAX_VALUE;
    private Duration retryInitialDelay = new Duration(10.0, TimeUnit.SECONDS);
    private Duration retryMaxDelay = new Duration(1.0, TimeUnit.MINUTES);
    private double retryDelayScaleFactor = 2.0;
    private int maxTasksWaitingForNodePerStage = 5;
    private DataSize faultTolerantExecutionTargetTaskInputSize = DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private int faultTolerantExecutionMinTaskSplitCount = 16;
    private int faultTolerantExecutionTargetTaskSplitCount = 64;
    private int faultTolerantExecutionMaxTaskSplitCount = 256;
    private DataSize faultTolerantExecutionTaskDescriptorStorageMaxMemory = DataSize.ofBytes((long)Math.round((double)AVAILABLE_HEAP_MEMORY * 0.15));
    private int faultTolerantExecutionPartitionCount = 50;
    private boolean faultTolerantPreserveInputPartitionsInWriteStage = true;
    private boolean faultTolerantExecutionEventDrivenSchedulerEnabled = true;

    @Min(value=1L)
    public @Min(value=1L) int getScheduleSplitBatchSize() {
        return this.scheduleSplitBatchSize;
    }

    @Config(value="query.schedule-split-batch-size")
    public QueryManagerConfig setScheduleSplitBatchSize(int scheduleSplitBatchSize) {
        this.scheduleSplitBatchSize = scheduleSplitBatchSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMinScheduleSplitBatchSize() {
        return this.minScheduleSplitBatchSize;
    }

    @Config(value="query.min-schedule-split-batch-size")
    public QueryManagerConfig setMinScheduleSplitBatchSize(int minScheduleSplitBatchSize) {
        this.minScheduleSplitBatchSize = minScheduleSplitBatchSize;
        return this;
    }

    @Deprecated
    @Min(value=1L)
    public @Min(value=1L) int getMaxConcurrentQueries() {
        return this.maxConcurrentQueries;
    }

    @Deprecated
    @Config(value="query.max-concurrent-queries")
    public QueryManagerConfig setMaxConcurrentQueries(int maxConcurrentQueries) {
        this.maxConcurrentQueries = maxConcurrentQueries;
        return this;
    }

    @Deprecated
    @Min(value=1L)
    public @Min(value=1L) int getMaxQueuedQueries() {
        return this.maxQueuedQueries;
    }

    @Deprecated
    @Config(value="query.max-queued-queries")
    public QueryManagerConfig setMaxQueuedQueries(int maxQueuedQueries) {
        this.maxQueuedQueries = maxQueuedQueries;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getHashPartitionCount() {
        return this.hashPartitionCount;
    }

    @Config(value="query.hash-partition-count")
    @LegacyConfig(value={"query.initial-hash-partitions"})
    @ConfigDescription(value="Number of partitions for distributed joins and aggregations")
    public QueryManagerConfig setHashPartitionCount(int hashPartitionCount) {
        this.hashPartitionCount = hashPartitionCount;
        return this;
    }

    @NotNull
    public Duration getMinQueryExpireAge() {
        return this.minQueryExpireAge;
    }

    @LegacyConfig(value={"query.max-age"})
    @Config(value="query.min-expire-age")
    public QueryManagerConfig setMinQueryExpireAge(Duration minQueryExpireAge) {
        this.minQueryExpireAge = minQueryExpireAge;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMaxQueryHistory() {
        return this.maxQueryHistory;
    }

    @Config(value="query.max-history")
    public QueryManagerConfig setMaxQueryHistory(int maxQueryHistory) {
        this.maxQueryHistory = maxQueryHistory;
        return this;
    }

    @Min(value=0L)
    @Max(value=1000000000L)
    public @Min(value=0L) @Max(value=1000000000L) int getMaxQueryLength() {
        return this.maxQueryLength;
    }

    @Config(value="query.max-length")
    public QueryManagerConfig setMaxQueryLength(int maxQueryLength) {
        this.maxQueryLength = maxQueryLength;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxStageCount() {
        return this.maxStageCount;
    }

    @Config(value="query.max-stage-count")
    public QueryManagerConfig setMaxStageCount(int maxStageCount) {
        this.maxStageCount = maxStageCount;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getStageCountWarningThreshold() {
        return this.stageCountWarningThreshold;
    }

    @Config(value="query.stage-count-warning-threshold")
    @ConfigDescription(value="Emit a warning when stage count exceeds this threshold")
    public QueryManagerConfig setStageCountWarningThreshold(int stageCountWarningThreshold) {
        this.stageCountWarningThreshold = stageCountWarningThreshold;
        return this;
    }

    @MinDuration(value="5s")
    @NotNull
    public @MinDuration(value="5s") @NotNull Duration getClientTimeout() {
        return this.clientTimeout;
    }

    @Config(value="query.client.timeout")
    public QueryManagerConfig setClientTimeout(Duration clientTimeout) {
        this.clientTimeout = clientTimeout;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getQueryManagerExecutorPoolSize() {
        return this.queryManagerExecutorPoolSize;
    }

    @Config(value="query.manager-executor-pool-size")
    public QueryManagerConfig setQueryManagerExecutorPoolSize(int queryManagerExecutorPoolSize) {
        this.queryManagerExecutorPoolSize = queryManagerExecutorPoolSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getQueryExecutorPoolSize() {
        return this.queryExecutorPoolSize;
    }

    @Config(value="query.executor-pool-size")
    public QueryManagerConfig setQueryExecutorPoolSize(int queryExecutorPoolSize) {
        this.queryExecutorPoolSize = queryExecutorPoolSize;
        return this;
    }

    @Deprecated
    public Duration getRemoteTaskMinErrorDuration() {
        return this.remoteTaskMaxErrorDuration;
    }

    @Deprecated
    @Config(value="query.remote-task.min-error-duration")
    public QueryManagerConfig setRemoteTaskMinErrorDuration(Duration remoteTaskMinErrorDuration) {
        return this;
    }

    @NotNull
    @MinDuration(value="1s")
    public @NotNull @MinDuration(value="1s") Duration getRemoteTaskMaxErrorDuration() {
        return this.remoteTaskMaxErrorDuration;
    }

    @Config(value="query.remote-task.max-error-duration")
    public QueryManagerConfig setRemoteTaskMaxErrorDuration(Duration remoteTaskMaxErrorDuration) {
        this.remoteTaskMaxErrorDuration = remoteTaskMaxErrorDuration;
        return this;
    }

    @NotNull
    public Duration getQueryMaxRunTime() {
        return this.queryMaxRunTime;
    }

    @Config(value="query.max-run-time")
    public QueryManagerConfig setQueryMaxRunTime(Duration queryMaxRunTime) {
        this.queryMaxRunTime = queryMaxRunTime;
        return this;
    }

    @NotNull
    public Duration getQueryMaxExecutionTime() {
        return this.queryMaxExecutionTime;
    }

    @Config(value="query.max-execution-time")
    public QueryManagerConfig setQueryMaxExecutionTime(Duration queryMaxExecutionTime) {
        this.queryMaxExecutionTime = queryMaxExecutionTime;
        return this;
    }

    @NotNull
    public Duration getQueryMaxPlanningTime() {
        return this.queryMaxPlanningTime;
    }

    @Config(value="query.max-planning-time")
    public QueryManagerConfig setQueryMaxPlanningTime(Duration queryMaxPlanningTime) {
        this.queryMaxPlanningTime = queryMaxPlanningTime;
        return this;
    }

    @NotNull
    @MinDuration(value="1ns")
    public @NotNull @MinDuration(value="1ns") Duration getQueryMaxCpuTime() {
        return this.queryMaxCpuTime;
    }

    @Config(value="query.max-cpu-time")
    public QueryManagerConfig setQueryMaxCpuTime(Duration queryMaxCpuTime) {
        this.queryMaxCpuTime = queryMaxCpuTime;
        return this;
    }

    @NotNull
    public Optional<DataSize> getQueryMaxScanPhysicalBytes() {
        return this.queryMaxScanPhysicalBytes;
    }

    @Config(value="query.max-scan-physical-bytes")
    public QueryManagerConfig setQueryMaxScanPhysicalBytes(DataSize queryMaxScanPhysicalBytes) {
        this.queryMaxScanPhysicalBytes = Optional.ofNullable(queryMaxScanPhysicalBytes);
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getRemoteTaskMaxCallbackThreads() {
        return this.remoteTaskMaxCallbackThreads;
    }

    @Config(value="query.remote-task.max-callback-threads")
    public QueryManagerConfig setRemoteTaskMaxCallbackThreads(int remoteTaskMaxCallbackThreads) {
        this.remoteTaskMaxCallbackThreads = remoteTaskMaxCallbackThreads;
        return this;
    }

    @NotNull
    public String getQueryExecutionPolicy() {
        return this.queryExecutionPolicy;
    }

    @Config(value="query.execution-policy")
    public QueryManagerConfig setQueryExecutionPolicy(String queryExecutionPolicy) {
        this.queryExecutionPolicy = queryExecutionPolicy;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getRequiredWorkers() {
        return this.requiredWorkers;
    }

    @Config(value="query-manager.required-workers")
    @ConfigDescription(value="Minimum number of active workers that must be available before a query will start")
    public QueryManagerConfig setRequiredWorkers(int requiredWorkers) {
        this.requiredWorkers = requiredWorkers;
        return this;
    }

    @NotNull
    public Duration getRequiredWorkersMaxWait() {
        return this.requiredWorkersMaxWait;
    }

    @Config(value="query-manager.required-workers-max-wait")
    @ConfigDescription(value="Maximum time to wait for minimum number of workers before the query is failed")
    public QueryManagerConfig setRequiredWorkersMaxWait(Duration requiredWorkersMaxWait) {
        this.requiredWorkersMaxWait = requiredWorkersMaxWait;
        return this;
    }

    @NotNull
    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    @Config(value="retry-policy")
    public QueryManagerConfig setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getQueryRetryAttempts() {
        return this.queryRetryAttempts;
    }

    @Config(value="query-retry-attempts")
    @LegacyConfig(value={"retry-attempts"})
    public QueryManagerConfig setQueryRetryAttempts(int queryRetryAttempts) {
        this.queryRetryAttempts = queryRetryAttempts;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getTaskRetryAttemptsOverall() {
        return this.taskRetryAttemptsOverall;
    }

    @Config(value="task-retry-attempts-overall")
    public QueryManagerConfig setTaskRetryAttemptsOverall(int taskRetryAttemptsOverall) {
        this.taskRetryAttemptsOverall = taskRetryAttemptsOverall;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getTaskRetryAttemptsPerTask() {
        return this.taskRetryAttemptsPerTask;
    }

    @Config(value="task-retry-attempts-per-task")
    public QueryManagerConfig setTaskRetryAttemptsPerTask(int taskRetryAttemptsPerTask) {
        this.taskRetryAttemptsPerTask = taskRetryAttemptsPerTask;
        return this;
    }

    @NotNull
    public Duration getRetryInitialDelay() {
        return this.retryInitialDelay;
    }

    @Config(value="retry-initial-delay")
    @ConfigDescription(value="Initial delay before initiating a retry attempt. Delay increases exponentially for each subsequent attempt up to 'retry_max_delay'")
    public QueryManagerConfig setRetryInitialDelay(Duration retryInitialDelay) {
        this.retryInitialDelay = retryInitialDelay;
        return this;
    }

    @NotNull
    public Duration getRetryMaxDelay() {
        return this.retryMaxDelay;
    }

    @Config(value="retry-max-delay")
    @ConfigDescription(value="Maximum delay before initiating a retry attempt. Delay increases exponentially for each subsequent attempt starting from 'retry_initial_delay'")
    public QueryManagerConfig setRetryMaxDelay(Duration retryMaxDelay) {
        this.retryMaxDelay = retryMaxDelay;
        return this;
    }

    @NotNull
    public double getRetryDelayScaleFactor() {
        return this.retryDelayScaleFactor;
    }

    @Config(value="retry-delay-scale-factor")
    @ConfigDescription(value="Factor by which retry delay is scaled on subsequent failures")
    public QueryManagerConfig setRetryDelayScaleFactor(double retryDelayScaleFactor) {
        Preconditions.checkArgument((retryDelayScaleFactor >= 1.0 ? 1 : 0) != 0, (Object)"retry-delay-scale-factor must be greater or equal to 1");
        this.retryDelayScaleFactor = retryDelayScaleFactor;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxTasksWaitingForNodePerStage() {
        return this.maxTasksWaitingForNodePerStage;
    }

    @Config(value="max-tasks-waiting-for-node-per-stage")
    @ConfigDescription(value="Maximum possible number of tasks waiting for node allocation per stage before scheduling of new tasks for stage is paused")
    public QueryManagerConfig setMaxTasksWaitingForNodePerStage(int maxTasksWaitingForNodePerStage) {
        this.maxTasksWaitingForNodePerStage = maxTasksWaitingForNodePerStage;
        return this;
    }

    @NotNull
    public DataSize getFaultTolerantExecutionTargetTaskInputSize() {
        return this.faultTolerantExecutionTargetTaskInputSize;
    }

    @Config(value="fault-tolerant-execution-target-task-input-size")
    @ConfigDescription(value="Target size in bytes of all task inputs for a single fault tolerant task")
    public QueryManagerConfig setFaultTolerantExecutionTargetTaskInputSize(DataSize faultTolerantExecutionTargetTaskInputSize) {
        this.faultTolerantExecutionTargetTaskInputSize = faultTolerantExecutionTargetTaskInputSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getFaultTolerantExecutionMinTaskSplitCount() {
        return this.faultTolerantExecutionMinTaskSplitCount;
    }

    @Config(value="fault-tolerant-execution-min-task-split-count")
    @ConfigDescription(value="Minimal number of splits for a single fault tolerant task (count based)")
    public QueryManagerConfig setFaultTolerantExecutionMinTaskSplitCount(int faultTolerantExecutionMinTaskSplitCount) {
        this.faultTolerantExecutionMinTaskSplitCount = faultTolerantExecutionMinTaskSplitCount;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getFaultTolerantExecutionTargetTaskSplitCount() {
        return this.faultTolerantExecutionTargetTaskSplitCount;
    }

    @Config(value="fault-tolerant-execution-target-task-split-count")
    @ConfigDescription(value="Target number of splits for a single fault tolerant task (split weight aware)")
    public QueryManagerConfig setFaultTolerantExecutionTargetTaskSplitCount(int faultTolerantExecutionTargetTaskSplitCount) {
        this.faultTolerantExecutionTargetTaskSplitCount = faultTolerantExecutionTargetTaskSplitCount;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getFaultTolerantExecutionMaxTaskSplitCount() {
        return this.faultTolerantExecutionMaxTaskSplitCount;
    }

    @Config(value="fault-tolerant-execution-max-task-split-count")
    @ConfigDescription(value="Maximal number of splits for a single fault tolerant task (count based)")
    public QueryManagerConfig setFaultTolerantExecutionMaxTaskSplitCount(int faultTolerantExecutionMaxTaskSplitCount) {
        this.faultTolerantExecutionMaxTaskSplitCount = faultTolerantExecutionMaxTaskSplitCount;
        return this;
    }

    @NotNull
    public DataSize getFaultTolerantExecutionTaskDescriptorStorageMaxMemory() {
        return this.faultTolerantExecutionTaskDescriptorStorageMaxMemory;
    }

    @Config(value="fault-tolerant-execution-task-descriptor-storage-max-memory")
    @ConfigDescription(value="Maximum amount of memory to be used to store task descriptors for fault tolerant queries on coordinator")
    public QueryManagerConfig setFaultTolerantExecutionTaskDescriptorStorageMaxMemory(DataSize faultTolerantExecutionTaskDescriptorStorageMaxMemory) {
        this.faultTolerantExecutionTaskDescriptorStorageMaxMemory = faultTolerantExecutionTaskDescriptorStorageMaxMemory;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getFaultTolerantExecutionPartitionCount() {
        return this.faultTolerantExecutionPartitionCount;
    }

    @Config(value="fault-tolerant-execution-partition-count")
    @ConfigDescription(value="Number of partitions for distributed joins and aggregations executed with fault tolerant execution enabled")
    public QueryManagerConfig setFaultTolerantExecutionPartitionCount(int faultTolerantExecutionPartitionCount) {
        this.faultTolerantExecutionPartitionCount = faultTolerantExecutionPartitionCount;
        return this;
    }

    public boolean getFaultTolerantPreserveInputPartitionsInWriteStage() {
        return this.faultTolerantPreserveInputPartitionsInWriteStage;
    }

    @Config(value="fault-tolerant-execution-preserve-input-partitions-in-write-stage")
    @ConfigDescription(value="Ensure single task reads single hash partitioned input partition for stages which write table data")
    public QueryManagerConfig setFaultTolerantPreserveInputPartitionsInWriteStage(boolean faultTolerantPreserveInputPartitionsInWriteStage) {
        this.faultTolerantPreserveInputPartitionsInWriteStage = faultTolerantPreserveInputPartitionsInWriteStage;
        return this;
    }

    public boolean isFaultTolerantExecutionEventDrivenSchedulerEnabled() {
        return this.faultTolerantExecutionEventDrivenSchedulerEnabled;
    }

    @Config(value="experimental.fault-tolerant-execution-event-driven-scheduler-enabled")
    public QueryManagerConfig setFaultTolerantExecutionEventDrivenSchedulerEnabled(boolean faultTolerantExecutionEventDrivenSchedulerEnabled) {
        this.faultTolerantExecutionEventDrivenSchedulerEnabled = faultTolerantExecutionEventDrivenSchedulerEnabled;
        return this;
    }
}

