/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.executor;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import io.trino.execution.SplitConcurrencyController;
import io.trino.execution.TaskId;
import io.trino.execution.executor.MultilevelSplitQueue;
import io.trino.execution.executor.PrioritizedSplitRunner;
import io.trino.execution.executor.Priority;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.DoubleSupplier;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class TaskHandle {
    private final TaskId taskId;
    protected final DoubleSupplier utilizationSupplier;
    @GuardedBy(value="this")
    protected final Queue<PrioritizedSplitRunner> queuedLeafSplits = new ArrayDeque<PrioritizedSplitRunner>(10);
    @GuardedBy(value="this")
    protected final List<PrioritizedSplitRunner> runningLeafSplits = new ArrayList<PrioritizedSplitRunner>(10);
    @GuardedBy(value="this")
    protected final List<PrioritizedSplitRunner> runningIntermediateSplits = new ArrayList<PrioritizedSplitRunner>(10);
    @GuardedBy(value="this")
    protected long scheduledNanos;
    @GuardedBy(value="this")
    private boolean destroyed;
    @GuardedBy(value="this")
    protected final SplitConcurrencyController concurrencyController;
    private final AtomicInteger nextSplitId = new AtomicInteger();
    protected final AtomicReference<Priority> priority = new AtomicReference<Priority>(new Priority(0, 0L));
    private final MultilevelSplitQueue splitQueue;
    private final OptionalInt maxDriversPerTask;

    public TaskHandle(TaskId taskId, MultilevelSplitQueue splitQueue, DoubleSupplier utilizationSupplier, int initialSplitConcurrency, Duration splitConcurrencyAdjustFrequency, OptionalInt maxDriversPerTask) {
        this.taskId = Objects.requireNonNull(taskId, "taskId is null");
        this.splitQueue = Objects.requireNonNull(splitQueue, "splitQueue is null");
        this.utilizationSupplier = Objects.requireNonNull(utilizationSupplier, "utilizationSupplier is null");
        this.maxDriversPerTask = Objects.requireNonNull(maxDriversPerTask, "maxDriversPerTask is null");
        this.concurrencyController = new SplitConcurrencyController(initialSplitConcurrency, Objects.requireNonNull(splitConcurrencyAdjustFrequency, "splitConcurrencyAdjustFrequency is null"));
    }

    public synchronized Priority addScheduledNanos(long durationNanos) {
        this.concurrencyController.update(durationNanos, this.utilizationSupplier.getAsDouble(), this.runningLeafSplits.size());
        this.scheduledNanos += durationNanos;
        Priority newPriority = this.splitQueue.updatePriority(this.priority.get(), durationNanos, this.scheduledNanos);
        this.priority.set(newPriority);
        return newPriority;
    }

    public synchronized Priority resetLevelPriority() {
        long levelMinPriority = this.splitQueue.getLevelMinPriority(this.priority.get().getLevel(), this.scheduledNanos);
        if (this.priority.get().getLevelPriority() < levelMinPriority) {
            Priority newPriority = new Priority(this.priority.get().getLevel(), levelMinPriority);
            this.priority.set(newPriority);
            return newPriority;
        }
        return this.priority.get();
    }

    public synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    public Priority getPriority() {
        return this.priority.get();
    }

    public TaskId getTaskId() {
        return this.taskId;
    }

    public OptionalInt getMaxDriversPerTask() {
        return this.maxDriversPerTask;
    }

    public synchronized List<PrioritizedSplitRunner> destroy() {
        this.destroyed = true;
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.runningIntermediateSplits.size() + this.runningLeafSplits.size() + this.queuedLeafSplits.size()));
        builder.addAll(this.runningIntermediateSplits);
        builder.addAll(this.runningLeafSplits);
        builder.addAll(this.queuedLeafSplits);
        this.runningIntermediateSplits.clear();
        this.runningLeafSplits.clear();
        this.queuedLeafSplits.clear();
        return builder.build();
    }

    public synchronized void enqueueSplit(PrioritizedSplitRunner split) {
        Preconditions.checkState((!this.destroyed ? 1 : 0) != 0, (Object)"Cannot add split to destroyed task handle");
        this.queuedLeafSplits.add(split);
    }

    public synchronized void recordIntermediateSplit(PrioritizedSplitRunner split) {
        Preconditions.checkState((!this.destroyed ? 1 : 0) != 0, (Object)"Cannot add split to destroyed task handle");
        this.runningIntermediateSplits.add(split);
    }

    synchronized int getRunningLeafSplits() {
        return this.runningLeafSplits.size();
    }

    public synchronized long getScheduledNanos() {
        return this.scheduledNanos;
    }

    public synchronized PrioritizedSplitRunner pollNextSplit() {
        if (this.destroyed) {
            return null;
        }
        if (this.runningLeafSplits.size() >= this.concurrencyController.getTargetConcurrency()) {
            return null;
        }
        PrioritizedSplitRunner split = this.queuedLeafSplits.poll();
        if (split != null) {
            this.runningLeafSplits.add(split);
        }
        return split;
    }

    public synchronized void splitComplete(PrioritizedSplitRunner split) {
        this.concurrencyController.splitFinished(split.getScheduledNanos(), this.utilizationSupplier.getAsDouble(), this.runningLeafSplits.size());
        this.runningIntermediateSplits.remove(split);
        this.runningLeafSplits.remove(split);
    }

    public int getNextSplitId() {
        return this.nextSplitId.getAndIncrement();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("taskId", (Object)this.taskId).toString();
    }
}

