/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.execution.scheduler.BucketNodeMap;
import io.trino.execution.scheduler.FaultTolerantPartitioningScheme;
import io.trino.metadata.InternalNode;
import io.trino.sql.planner.MergePartitioningHandle;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.SystemPartitioningHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FaultTolerantPartitioningSchemeFactory {
    private final NodePartitioningManager nodePartitioningManager;
    private final Session session;
    private final int partitionCount;
    private final Map<PartitioningHandle, FaultTolerantPartitioningScheme> cache = new HashMap<PartitioningHandle, FaultTolerantPartitioningScheme>();

    public FaultTolerantPartitioningSchemeFactory(NodePartitioningManager nodePartitioningManager, Session session, int partitionCount) {
        this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.partitionCount = partitionCount;
    }

    public FaultTolerantPartitioningScheme get(PartitioningHandle handle) {
        return this.cache.computeIfAbsent(handle, this::create);
    }

    private FaultTolerantPartitioningScheme create(PartitioningHandle partitioningHandle) {
        if (partitioningHandle.equals(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION)) {
            return new FaultTolerantPartitioningScheme(this.partitionCount, Optional.of(IntStream.range(0, this.partitionCount).toArray()), Optional.empty(), Optional.empty());
        }
        if (partitioningHandle.getCatalogHandle().isPresent() || partitioningHandle.getConnectorHandle() instanceof MergePartitioningHandle) {
            BucketNodeMap bucketNodeMap = this.nodePartitioningManager.getNodePartitioningMap(this.session, partitioningHandle).asBucketNodeMap();
            int bucketCount = bucketNodeMap.getBucketCount();
            int[] bucketToPartition = new int[bucketCount];
            HashMap<InternalNode, Integer> nodeToPartition = new HashMap<InternalNode, Integer>();
            ArrayList<InternalNode> partitionToNodeMap = new ArrayList<InternalNode>();
            for (int bucket = 0; bucket < bucketCount; ++bucket) {
                InternalNode node = bucketNodeMap.getAssignedNode(bucket);
                Integer partitionId = (Integer)nodeToPartition.get(node);
                if (partitionId == null) {
                    partitionId = partitionToNodeMap.size();
                    nodeToPartition.put(node, partitionId);
                    partitionToNodeMap.add(node);
                }
                bucketToPartition[bucket] = partitionId;
            }
            return new FaultTolerantPartitioningScheme(partitionToNodeMap.size(), Optional.of(bucketToPartition), Optional.of(bucketNodeMap.getSplitToBucketFunction()), Optional.of(ImmutableList.copyOf(partitionToNodeMap)));
        }
        return new FaultTolerantPartitioningScheme(1, Optional.empty(), Optional.empty(), Optional.empty());
    }
}

