/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.primitives.ImmutableLongArray;
import java.util.Collection;
import java.util.Objects;

public class OutputDataSizeEstimate {
    private final ImmutableLongArray partitionDataSizes;

    public OutputDataSizeEstimate(ImmutableLongArray partitionDataSizes) {
        this.partitionDataSizes = Objects.requireNonNull(partitionDataSizes, "partitionDataSizes is null");
    }

    public long getPartitionSizeInBytes(int partitionId) {
        return this.partitionDataSizes.get(partitionId);
    }

    public static OutputDataSizeEstimate merge(Collection<OutputDataSizeEstimate> estimates) {
        int partitionCount = OutputDataSizeEstimate.getPartitionCount(estimates);
        long[] merged = new long[partitionCount];
        for (OutputDataSizeEstimate estimate : estimates) {
            for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
                int n = partitionId;
                merged[n] = merged[n] + estimate.getPartitionSizeInBytes(partitionId);
            }
        }
        return new OutputDataSizeEstimate(ImmutableLongArray.copyOf((long[])merged));
    }

    private static int getPartitionCount(Collection<OutputDataSizeEstimate> estimates) {
        int[] partitionCounts = estimates.stream().mapToInt(estimate -> estimate.partitionDataSizes.length()).distinct().toArray();
        Preconditions.checkArgument((partitionCounts.length <= 1 ? 1 : 0) != 0, (Object)"partition count is expected to match");
        if (partitionCounts.length == 0) {
            return 0;
        }
        return partitionCounts[0];
    }
}

