/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.json.ir.IrJsonPathVisitor;
import io.trino.json.ir.IrPathNode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import java.util.Objects;
import java.util.Optional;

public class IrArithmeticBinary
extends IrPathNode {
    private final Operator operator;
    private final IrPathNode left;
    private final IrPathNode right;

    @JsonCreator
    public IrArithmeticBinary(@JsonProperty(value="operator") Operator operator, @JsonProperty(value="left") IrPathNode left, @JsonProperty(value="right") IrPathNode right, @JsonProperty(value="type") Optional<Type> resultType) {
        super(resultType);
        this.operator = Objects.requireNonNull(operator, "operator is null");
        this.left = Objects.requireNonNull(left, "left is null");
        this.right = Objects.requireNonNull(right, "right is null");
    }

    @Override
    protected <R, C> R accept(IrJsonPathVisitor<R, C> visitor, C context) {
        return visitor.visitIrArithmeticBinary(this, context);
    }

    @JsonProperty
    public Operator getOperator() {
        return this.operator;
    }

    @JsonProperty
    public IrPathNode getLeft() {
        return this.left;
    }

    @JsonProperty
    public IrPathNode getRight() {
        return this.right;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IrArithmeticBinary other = (IrArithmeticBinary)obj;
        return this.operator == other.operator && Objects.equals(this.left, other.left) && Objects.equals(this.right, other.right);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.left, this.right});
    }

    public static enum Operator {
        ADD(OperatorType.ADD),
        SUBTRACT(OperatorType.SUBTRACT),
        MULTIPLY(OperatorType.MULTIPLY),
        DIVIDE(OperatorType.DIVIDE),
        MODULUS(OperatorType.MODULUS);

        private final OperatorType type;

        private Operator(OperatorType type) {
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public OperatorType getType() {
            return this.type;
        }
    }
}

